<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "builder".
 *
 * @property int $id
 * @property string $name
 * @property string $address
 * @property int $mobile_no
 * @property string $email
 * @property int $projects_id
 * @property int $status
 * @property string $commission
 * @property int $sole_selling 0-no,1-yes,3 - refernce purpose
 * @property string|null $brief
 * @property string|null $logo
 * @property string|null $file_type
 * @property int $saleprosys
 * @property string $created_on
 * @property string $modified_on
 */
class Builder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'builder';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'address', 'mobile_no', 'email', 'projects_id', 'status', 'commission', 'created_on', 'modified_on'], 'required'],
            [['mobile_no', 'projects_id', 'status', 'sole_selling', 'saleprosys'], 'integer'],
            [['brief'], 'string'],
            [['created_on', 'modified_on'], 'safe'],
            [['name', 'address', 'commission'], 'string', 'max' => 150],
            [['email', 'logo'], 'string', 'max' => 100],
            [['file_type'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'mobile_no' => 'Mobile No',
            'email' => 'Email',
            'projects_id' => 'Projects ID',
            'status' => 'Status',
            'commission' => 'Commission',
            'sole_selling' => 'Sole Selling',
            'brief' => 'Brief',
            'logo' => 'Logo',
            'file_type' => 'File Type',
            'saleprosys' => 'Saleprosys',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
        ];
    }
}
