<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "channelpartner".
 *
 * @property int $id
 * @property string $name
 * @property string $cp_code
 * @property string $rera_number
 * @property string $pan_number
 * @property string $feedback
 * @property int $imp
 * @property string $follow_up
 * @property string $meeting_time
 * @property int $contact
 * @property string $company_name
 * @property int $company_type 1- individual,2-company
 * @property string $address
 * @property string|null $location_id
 * @property int $alt_number
 * @property string $email_id
 * @property string $company_experience
 * @property string $website
 * @property int $status
 * @property int $crm
 * @property int|null $added_by 1->Saleprosys,2->CP from App,3->SM,4->CRM
 * @property string|null $approval_update_on
 * @property int|null $approved_by
 * @property string $created_on
 * @property string $modified_on
 * @property int $created_by
 * @property int $modified_by
 * @property int $mgmt
 * @property string|null $location_subtype_id
 * @property int $rm
 * @property int $app_features
 */
class Channelpartner extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'channelpartner';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'rera_number', 'pan_number', 'contact', 'company_name', 'address', 'location_id'], 'required'],
            [['feedback'], 'string'],
            [['imp', 'contact', 'company_type', 'nature_business', 'alt_number', 'status', 'crm', 'added_by', 'approved_by', 'created_by', 'modified_by', 'mgmt', 'rm', 'app_features', 'market_category'], 'integer'],
            [['follow_up', 'meeting_time', 'approval_update_on', 'created_on', 'modified_on', 'location_subtype_id', 'location_id', 'market_category'], 'safe'],
            //[['name', 'company_name', 'email_id', 'company_experience'], 'string', 'max' => 150],
            //[['cp_code', 'website'], 'string', 'max' => 120],
            //[['rera_number', 'pan_number', 'gstin'], 'string', 'max' => 200],
            //[['address'], 'string', 'max' => 200],
            //[['location_id'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'cp_code' => 'Cp Code',
            'rera_number' => 'Rera Number',
            'pan_number' => 'Pan Number',
            'gstin' => 'GST',
            'nature_business' => 'Nature of Business',
            'feedback' => 'Feedback',
            'imp' => 'Imp',
            'follow_up' => 'Follow Up',
            'meeting_time' => 'Meeting Time',
            'contact' => 'Contact',
            'company_name' => 'Company Name',
            'company_type' => 'Company Type',
            'address' => 'Address',
            'location_id' => 'Location ID',
            'alt_number' => 'Alt Number',
            'email_id' => 'Email ID',
            'company_experience' => 'Company Experience',
            'website' => 'Website',
            'status' => 'Status',
            'crm' => 'Crm',
            'added_by' => 'Added By',
            'approval_update_on' => 'Approval Update On',
            'approved_by' => 'Approved By',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'created_by' => 'Created By',
            'modified_by' => 'Modified By',
            'mgmt' => 'Only For Management',
            'location_subtype_id' => 'Location Subtype',
            'rm' => 'Relationship Manager',
            'app_features' => 'App Features',
            'market_category' => 'Market Category'
        ];
    }
}
