<?php

namespace app\models;

use DateTime;
use Yii;
use yii\db\Expression;

class Common extends \yii\db\ActiveRecord
{
    public $role = array('1' => 'Team Lead', '2' => 'Manager', '3' => 'Executive');
    public $customer_type = array('1' => 'Hot', '2' => 'Warm', '3' => 'Cold');
    public $ref_status = array('1' => 'In Progress', '2' => 'Confirmed', '3' => 'Expired', '4' => 'Already Installed', '5' => 'Already referred by another CP');
    public $lead_status = array('1' => 'Interested', '2' => 'Not Interested', '3' => 'Plan Dropped', '4' => 'Plan Postponed', '5' => 'Not Reachable/Ringing', '6' => 'Not Searching/Disconnected');
    public $tag_status = array('0' => 'In Progress', '1' => 'Visited', '2' => 'Not Visited', '3' => 'Clashed', '4' => 'Booked', '5' => 'Lead Dead', '6' => 'Registered', '7' => 'Lead Rejected');

    public $status = array('1' => 'Active', '2' => 'Pending', '0' => 'InActive');
    public $cp_company_type = array('1' => 'Sole Proprietorship', '2' => 'Partnership', '3' => 'Private Limited', '4' => 'Public Limited', '5' => 'Individual');
    public $cp_nature_business = array('1' => 'Residential Sales', '2' => 'Commercial Sales', '3' => 'Land sourcing for Developers', '4' => 'Agricultural Land Sales', '5' => 'Industrial Sales', '6' => 'Project Consultancy');
    public $project_status = array('1' => 'Completed', '2' => 'Ongoing', '3' => 'Launching');
    public $project_segment = array('1' => 'Affordable', '2' => 'Luxury', '3' => 'Ultra Luxury', '4' => 'Value');
    public $project_type = array('1' => 'New Project', '2' => 'Exclusive Project', '3' => 'Trending Project', '4' => 'Ready to move Project', '5' => 'Under construction Project', '6' => 'Upcoming Project');
    public $flat_type_id = array('6' => '1 RK', '1' => '1 BHK', '2' => '1.5 BHK', '3' => '2 BHK', '4' => '3 BHK', '5' => '4 BHK', '7' => '5 BHK', '8' => '6 BHK+');
    public $flat_property_type = array('1' => 'Flat', '2' => 'Office Space', '3' => 'Shop', '4' => 'Bungalow', '5' => 'Plot');
    public $tagging_done = array('0' => 'False', '1' => 'True');
    public $month = array('1' => 'January', '2' => 'February', '3' => 'March', '4' => 'April', '5' => 'May', '6' => 'June', '7' => 'July', '8' => 'August', '9' => 'September', '10' => 'October', '11' => 'November', '12' => 'December');

    public $ticket_issue_type = array(1 => 'CP Registration', 2 => 'Login', 3 => 'Profile Changes', 4 => 'Leads', 5 => 'Tagging', 6 => 'Others', 7 => 'CP Connect');
    public $ticket_status = array(1 => 'Received', 2 => 'In Progress', 3 => 'Resolved');
    public $post_status = array(0 => 'In Progress', 1 => 'Verified', 2 => 'Expired', 3 => 'Blocked', 4 => 'Deal Closed');
    public $post_post_for = array(1 => 'Sales', 2 => 'Rental');
    public $post_type = array(1 => 'Buyer', 2 => 'Seller');
    public $post_rental_type = array(1 => 'Owner', 2 => 'Tenant');
    public $lead_type_arr = array(1 => 'Facebook', 2 => 'Portals', 3 => 'Social Media', 4 => 'Others');
    public $notify_type = array(1 => 'Tagging', 2 => 'Offer', 3 => 'Project', 4 => 'Announcement', 5 => 'Lead', 6 => 'CP Connect');
    public $market_category = array('1' => 'All', '2' => 'Under Construction & New Projects', '3' => 'Resale & Rental');
    public $package_history_type = array('1' => 'Payment', '2' => 'Referral');
    public $order_status = array('1' => 'In Progress', '2' => 'Payment Successful');


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'snse_admin';
    }

    public function getloggeduser($smcp_obj)
    {
        $loggedUser = null;
        if (!empty($smcp_obj)) {
            $loggedUser['sm_cp_id'] = $smcp_obj->sm_cp_id;
            if (!empty($smcp_obj->channelpartner_id)) {
                //show package details


                //get package details of cp user
                $package_name = "Silver";
                $package_expiry = null;
                if (!empty($smcp_obj->mobile_view_expiry) && $smcp_obj->mobile_view_expiry != "0000-00-00") {
                    $package_expiry = date('d M Y', strtotime($smcp_obj->mobile_view_expiry));
                }


                //below features list
                $view_posting_cp = true;
                //$search_exclusive_posting = false;

                if ($smcp_obj->package_id == 6) {
                    //no expiry for silver package
                    $package_expiry = null;
                } else {

                    $get_package_details = $this->getpackage($smcp_obj->package_id);
                    if (!empty($get_package_details)) {
                        if (isset($get_package_details['name'])) {
                            $package_name = $get_package_details['name'];
                        }
                        if (isset($get_package_details['view_posting_cp'])) {
                            if ($get_package_details['view_posting_cp'] == 1) {
                                //$view_posting_cp = true;
                            }
                        }
                    }
                }
                $loggedUser['subscriptionName'] = $package_name;
                $loggedUser['subscriptionExpiry'] = $package_expiry;
                $loggedUser['viewPostingCp'] = $view_posting_cp;


                $loggedUser['channelpartner_id'] = $smcp_obj->channelpartner_id;
                $loggedUser['user_type'] = '1';
                $loggedUser['builder_id'] = null;
            }
            if (!empty($smcp_obj->builder_id)) {
                $loggedUser['builder_id'] = $smcp_obj->builder_id;

                if ($smcp_obj->staff_type == 1) {
                    $loggedUser['user_type'] = '2';
                } else {
                    $loggedUser['user_type'] = '3';
                }

                $loggedUser['channelpartner_id'] = null;
            }
            $loggedUser['name'] = $smcp_obj->name;
            $loggedUser['email'] = $smcp_obj->email;
            $loggedUser['contact'] = $smcp_obj->contact;

            $loggedUser['role'] = $this->role[$smcp_obj->role];

            if (!empty($smcp_obj->location_id)) {
                $location_arr = Location::findAll([
                    'status' => 1
                ]);
                foreach ($location_arr as $location_arr_val) {
                    $locations[$location_arr_val->id] = $location_arr_val->name;
                }

                $loc_seperated = $smcp_obj->location_id;
                $loggedUser['location_ids'] = $loc_seperated;
                $get_loc_set = explode(",", $loggedUser['location_ids']);
                $loc_final_val = '';
                foreach ($get_loc_set as $get_loc_set_val) {
                    if (isset($locations[$get_loc_set_val])) {
                        if (empty($loc_final_val)) {
                            $loc_final_val = $locations[$get_loc_set_val];
                        } else {
                            $loc_final_val .= ", " . $locations[$get_loc_set_val];
                        }
                    }
                }
                $loggedUser['location_id'] = $loc_final_val;
            } else {
                $loggedUser['location_id'] = null;
                $loggedUser['location_ids'] = null;
            }

            if (!empty($smcp_obj->location_subtype_id)) {
                $location_subtype_arr = LocationSubtype::findAll([
                    'status' => 1
                ]);
                foreach ($location_subtype_arr as $location_subtype_arr_val) {
                    $location_subtype[$location_subtype_arr_val->id] = $location_subtype_arr_val->name;
                }

                $loc_subtype_seperated = $smcp_obj->location_subtype_id;
                $loggedUser['location_subtype_ids'] = $loc_subtype_seperated;
                $get_loc_subtype_set = explode(",", $loggedUser['location_subtype_ids']);
                $loc_subtype_final_val = '';
                foreach ($get_loc_subtype_set as $get_loc_subtype_set_val) {
                    if (isset($location_subtype[$get_loc_subtype_set_val])) {
                        if (empty($loc_subtype_final_val)) {
                            $loc_subtype_final_val = $location_subtype[$get_loc_subtype_set_val];
                        } else {
                            $loc_subtype_final_val .= ", " . $location_subtype[$get_loc_subtype_set_val];
                        }
                    }
                }
                $loggedUser['location_subtype_id'] = $loc_subtype_final_val;
            } else {
                $loggedUser['location_subtype_id'] = null;
                $loggedUser['location_subtype_ids'] = null;
            }

            $loggedUser['status'] = $this->status[$smcp_obj->status];
            $loggedUser['created_on'] = $smcp_obj->created_on;
            $loggedUser['modified_on'] = $smcp_obj->modified_on;
        }
        return $loggedUser;
    }

    public function getmanagers($smcp_obj)
    {
        $members = null;
        if (!empty($smcp_obj) && $smcp_obj->role == 1) {
            $members['team_lead']['sm_cp_id'] = $smcp_obj->sm_cp_id;
            $members['team_lead']['name'] = $smcp_obj->name;
            $smData = (new \yii\db\Query())
                ->select('sm_cp1.sm_cp_id,sm_cp1.name')
                ->from('sm_cp sm_cp1')
                ->where('sm_cp1.parent_id="' . $smcp_obj->sm_cp_id . '" AND sm_cp1.status=1 AND sm_cp1.role=2 AND sm_cp1.is_deleted=0 ')->createCommand()
                ->queryAll();
            if (!empty($smData)) {
                $count = 0;
                foreach ($smData as $smData_k => $smData_v) {
                    $members['managers'][$count] = $smData_v;
                    $count++;
                }
            } else {
                $members['managers'] = null;
            }
        }
        return $members;
    }

    public function getpackage($package_id)
    {
        $package_info = array();
        $package_data = Package::find()->where(['id' => $package_id])->one();
        if (!empty($package_data)) {
            $package_info = $package_data->toArray();

            //get package values
            $config_data = json_decode($package_info['config_values']);
            if (!empty($config_data)) {
                foreach ($config_data as $config_data_k => $config_data_v) {
                    $package_info[$config_data_k] = $config_data_v;
                }
            }
        }
        return $package_info;
    }




    public function getcp($cp_id)
    {
        $Channelpartner = null;
        $cp_data = Channelpartner::find()->select('id,name,email_id,rera_number,pan_number,contact,company_name,address,location_id,location_subtype_id,company_type,gstin,nature_business,website,status,created_on,modified_on,rm,market_category')->where(['id' => $cp_id])->one();
        if (!empty($cp_data)) {

            $location_arr = Location::findAll([
                'status' => 1
            ]);
            foreach ($location_arr as $location_arr_val) {
                $locations[$location_arr_val->id] = $location_arr_val->name;
            }
            $location_subtype_arr = LocationSubtype::findAll([
                'status' => 1
            ]);
            foreach ($location_subtype_arr as $location_subtype_arr_val) {
                $location_subtype[$location_subtype_arr_val->id] = $location_subtype_arr_val->name;
            }
            $Channelpartner = $cp_data->toArray();

            if (!empty($Channelpartner['location_id'])) {
                $loc_seperated = $Channelpartner['location_id'];
                $Channelpartner['location_ids'] = $loc_seperated;
                $get_loc_set = explode(",", $Channelpartner['location_id']);
                $loc_final_val = '';
                foreach ($get_loc_set as $get_loc_set_val) {
                    if (isset($locations[$get_loc_set_val])) {
                        if (empty($loc_final_val)) {
                            $loc_final_val = $locations[$get_loc_set_val];
                        } else {
                            $loc_final_val .= ", " . $locations[$get_loc_set_val];
                        }
                    }
                }
                $Channelpartner['location_id'] = $loc_final_val;
            } else {
                $Channelpartner['location_id'] = null;
                $Channelpartner['location_ids'] = null;
            }

            if (!empty($Channelpartner['location_subtype_id'])) {
                $loc_subtype_seperated = $Channelpartner['location_subtype_id'];
                $Channelpartner['location_subtype_ids'] = $loc_subtype_seperated;
                $get_loc_subtype_set = explode(",", $Channelpartner['location_subtype_id']);
                $loc_subtype_final_val = '';
                foreach ($get_loc_subtype_set as $get_loc_subtype_set_val) {
                    if (isset($location_subtype[$get_loc_subtype_set_val])) {
                        if (empty($loc_subtype_final_val)) {
                            $loc_subtype_final_val = $location_subtype[$get_loc_subtype_set_val];
                        } else {
                            $loc_subtype_final_val .= ", " . $location_subtype[$get_loc_subtype_set_val];
                        }
                    }
                }
                $Channelpartner['location_subtype_id'] = $loc_subtype_final_val;
            } else {
                $Channelpartner['location_subtype_id'] = null;
                $Channelpartner['location_subtype_ids'] = null;
            }

            if (!empty($Channelpartner['company_type'])) {
                $Channelpartner['company_type'] = $this->cp_company_type[$Channelpartner['company_type']];
            }
            if (!empty($Channelpartner['nature_business'])) {

                $natureStr = "";
                $get_nature_arr = explode(",", $Channelpartner['nature_business']);
                if (count($get_nature_arr) == 1) {
                    $natureStr = $this->cp_nature_business[$get_nature_arr[0]];
                } else {
                    foreach ($get_nature_arr as $get_nature_arr_val) {
                        if (!empty($natureStr)) {
                            $natureStr .= ",";
                        }
                        $natureStr .= $this->cp_nature_business[$get_nature_arr_val];
                    }
                }
                $Channelpartner['nature_business'] = $natureStr;

                /* $Channelpartner['nature_business'] = $this->cp_nature_business[$Channelpartner['nature_business']]; */
            }
            $Channelpartner['status'] = $this->status[$Channelpartner['status']];

            if (!empty($Channelpartner['market_category'])) {
                $Channelpartner['market_category_txt'] = $this->market_category[$Channelpartner['market_category']];
            }

            if (!empty($Channelpartner['rm'])) {
                //get rm name
                $get_rm_data = $this->getrmofcp($cp_id);
                if (!empty($get_rm_data)) {
                    $Channelpartner['rm_name'] = $get_rm_data['name'];
                    $Channelpartner['rm_contact'] = $get_rm_data['contact'];
                }
            }
        }
        return $Channelpartner;
    }

    public function getrmofcp($cp_id)
    {
        $rm_arr = array();
        $cp_data = Channelpartner::find()->select('rm')->where(['id' => $cp_id])->one();
        if (!empty($cp_data)) {
            $rm_id = $cp_data->rm;
            if (!empty($rm_id)) {
                /* $user_data = Admin::find()->select('staff_id')->where(['id' => $rm_id])->one();
                $staff_id = $user_data->staff_id; */
                //if (!empty($staff_id)) {
                $staff_data = Staff::find()->select('name,staff_contact')->where(['id' => $rm_id])->one();
                if (!empty($staff_data)) {
                    $staff_name = $staff_data->name;
                    $rm_arr['id'] = $rm_id;
                    $rm_arr['name'] = $staff_name;
                    $rm_arr['contact'] = $staff_data->staff_contact;
                }
                //}
            }
        }
        return $rm_arr;
    }


    public function getbuilder($builder_id)
    {
        $builder = null;
        $builder_data = Builder::find()->select('id,name,email,address,mobile_no,status,created_on,modified_on')->where(['id' => $builder_id])->one();
        if (!empty($builder_data)) {

            $builder = $builder_data->toArray();
            $builder['status'] = $this->status[$builder['status']];
        }
        return $builder;
    }

    public function get_nearby_loc($loc_id)
    {
        $loc_ids = $loc_id;

        $loc_data = Location::find()->select('near_locs')->where(['id' => $loc_id])->one();
        if (!empty($loc_data)) {

            $loc_data_arr = $loc_data->toArray();
            if (!empty($loc_data_arr['near_locs'])) {
                $loc_ids = $loc_data_arr['near_locs'];
            }
        }
        return $loc_ids;
    }


    public function getbookmarkedpost($sm_cp_id)
    {
        $posting = null;
        $posting_arr = PostingBookmark::findAll([
            'sm_cp_id' => $sm_cp_id
        ]);
        if (!empty($posting_arr)) {
            foreach ($posting_arr as $posting_arr_val) {
                $posting[] = $posting_arr_val->posting_id;
            }
        }
        return $posting;
    }

    public function getspampost($sm_cp_id)
    {
        $posting = null;
        $posting_arr = CpCustomersFlatsSpam::findAll([
            'sm_cp_id' => $sm_cp_id
        ]);
        if (!empty($posting_arr)) {
            foreach ($posting_arr as $posting_arr_val) {
                $posting[] = $posting_arr_val->post_id;
            }
        }
        return $posting;
    }

    public function getmembersapiold($sm_cp_id)
    {
        $members = null;
        $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id])->one();
        if (!empty($sm_cp_data)) {
            if ($sm_cp_data->status == 1 || $sm_cp_data->status == 2) {

                if ($sm_cp_data->status == 1) {
                    $smData = (new \yii\db\Query())
                        ->select('sm_cp1.sm_cp_id,sm_cp1.name,sm_cp1.email,sm_cp1.contact,sm_cp1.role,sm_cp1.parent_id,sm_cp1.status,sm_cp1.created_on,sm_cp1.modified_on')
                        ->from('sm_cp sm_cp1')
                        ->leftJoin('sm_cp sm_cp2', 'sm_cp1.parent_id=sm_cp2.sm_cp_id')
                        ->leftJoin('sm_cp sm_cp3', 'sm_cp2.parent_id=sm_cp3.sm_cp_id')
                        ->where('((' . $sm_cp_id . ' in (sm_cp1.parent_id,sm_cp2.parent_id, sm_cp3.parent_id)) AND sm_cp1.sm_cp_id!=' . $sm_cp_id . ')')->createCommand()
                        ->queryAll();
                    if (!empty($smData)) {
                        $count = 0;
                        foreach ($smData as $smData_k => $smData_v) {
                            $members[$count] = $smData_v;
                            $members[$count]['role'] = $this->role[$smData_v['role']];
                            $get_parent = $this->getparentapi($smData_v['parent_id']);
                            $members[$count]['parent_id'] = ($get_parent) ? $get_parent->name : '';
                            $members[$count]['status'] = $this->status[$smData_v['status']];
                            $count++;
                        }
                    }
                } elseif ($sm_cp_data->status == 2) {
                    $smData = (new \yii\db\Query())
                        ->select('sm_cp1.sm_cp_id,sm_cp1.name,sm_cp1.email,sm_cp1.contact,sm_cp1.role,sm_cp1.parent_id,sm_cp1.status,sm_cp1.created_on,sm_cp1.modified_on')
                        ->from('sm_cp sm_cp1')
                        ->leftJoin('sm_cp sm_cp2', 'sm_cp1.parent_id=sm_cp2.sm_cp_id')
                        ->where('((' . $sm_cp_id . ' in (sm_cp1.parent_id,sm_cp2.parent_id)) AND sm_cp1.sm_cp_id!=' . $sm_cp_id . ')')->createCommand()
                        ->queryAll();
                    if (!empty($smData)) {
                        $count = 0;
                        foreach ($smData as $smData_k => $smData_v) {
                            $members[$count] = $smData_v;
                            $members[$count]['role'] = $this->role[$smData_v['role']];
                            $get_parent = $this->getparentapi($smData_v['parent_id']);
                            $members[$count]['parent_id'] = ($get_parent) ? $get_parent->name : '';
                            $members[$count]['status'] = $this->status[$smData_v['status']];
                            $count++;
                        }
                    }
                }
            }
        }
        return $members;
    }

    public function getteamunderapi($sm_cp_id)
    {
        $members = null;
        $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0])->one();
        if (!empty($sm_cp_data)) {
            $smData = (new \yii\db\Query())
                ->select('sm_cp1.sm_cp_id,sm_cp1.name,sm_cp1.email,sm_cp1.contact,sm_cp1.role,sm_cp1.parent_id,sm_cp1.status,sm_cp1.created_on,sm_cp1.modified_on,sm_cp1.builder_id,sm_cp1.channelpartner_id,sm_cp1.staff_type,sm_cp1.login_at,sm_cp1.is_logged,sm_cp1.logout_at')
                ->from('sm_cp sm_cp1')
                ->where('sm_cp1.parent_id="' . $sm_cp_id . '" AND sm_cp1.is_deleted=0 ')->createCommand()
                ->queryAll();
            if (!empty($smData)) {
                $count = 0;
                foreach ($smData as $smData_k => $smData_v) {
                    $members[$count] = $smData_v;
                    $members[$count]['role'] = $this->role[$smData_v['role']];
                    $members[$count]['roleId'] = $smData_v['role'];
                    $get_parent = $this->getparentapi($smData_v['parent_id']);
                    $members[$count]['parent_id'] = $smData_v['parent_id'];
                    $members[$count]['parent_id_name'] = ($get_parent) ? $get_parent->name : '';
                    $members[$count]['status'] = $this->status[$smData_v['status']];

                    //get current status
                    $members[$count]['current_status'] = "";
                    $last_login = $smData_v['login_at'];
                    $is_logged = $smData_v['is_logged'];
                    $logout_at = $smData_v['logout_at'];

                    $members[$count]['current_status'] = 1;
                    $members[$count]['current_status_txt'] = 'Logged IN';
                    if (!empty($is_logged)) {
                        $members[$count]['current_status_txt'] = 'Logged IN';
                        $members[$count]['current_status'] = 1;
                    } else {
                        if (!empty($logout_at) && !empty($last_login)) {
                            $members[$count]['current_status_txt'] = 'Logout At - ' . date('d M Y h:i:s A', strtotime($logout_at));
                            $members[$count]['current_status'] = 2;
                        } else {
                            $members[$count]['current_status_txt'] = 'Not Logged';
                            $members[$count]['current_status'] = 3;
                        }
                    }

                    if (!empty($smData_v['builder_id'])) {
                        if ($smData_v['staff_type'] == 1) {
                            $members[$count]['user_type'] = '2';
                        } else {
                            $members[$count]['user_type'] = '3';
                        }
                    }
                    if (!empty($smData_v['channelpartner_id'])) {
                        $members[$count]['user_type'] = '1';
                    }
                    if ($smData_v['role'] == 2) {
                        $members[$count]['executiveList'] = $this->getteamunderapi($smData_v['sm_cp_id']);
                    }
                    //get list of each executive under manager
                    $count++;
                }
            }
        }
        return $members;
    }

    public function getmembersapi($sm_cp_id)
    {
        $members = null;
        $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0])->one();
        if (!empty($sm_cp_data)) {
            if ($sm_cp_data->role == 1 || $sm_cp_data->role == 2) {
                if ($sm_cp_data->role == 1) {
                    $members['managersList'] = $this->getteamunderapi($sm_cp_id);
                } elseif ($sm_cp_data->role == 2) {
                    $members['executiveList'] = $this->getteamunderapi($sm_cp_id);
                }
            }
        }
        return $members;
    }

    public function getsinglesmcpapi($sm_cp_id)
    {
        $member = null;

        $smData = (new \yii\db\Query())
            ->select('sm_cp1.sm_cp_id,sm_cp1.name,sm_cp1.email,sm_cp1.contact,sm_cp1.role,sm_cp1.parent_id,sm_cp1.status,sm_cp1.created_on,sm_cp1.modified_on,sm_cp1.builder_id,sm_cp1.channelpartner_id,sm_cp1.staff_type')
            ->from('sm_cp sm_cp1')
            ->where(' sm_cp1.sm_cp_id="' . $sm_cp_id . '" AND sm_cp1.is_deleted=0')->createCommand()
            ->queryAll();
        if (!empty($smData)) {
            $member = $smData[0];
            $member['role'] = $this->role[$member['role']];
            $get_parent = $this->getparentapi($member['parent_id']);
            $member['parent_id'] = $member['parent_id'];
            $member['parent_id_name'] = ($get_parent) ? $get_parent->name : '';
            $member['status'] = $this->status[$member['status']];
            if (!empty($member['builder_id'])) {
                if ($member['staff_type'] == 1) {
                    $member['user_type'] = '2';
                } else {
                    $member['user_type'] = '3';
                }
            }
            if (!empty($member['channelpartner_id'])) {
                $member['user_type'] = '1';
            }
        }
        return $member;
    }

    public function getleader($sm_cp_id)
    {
        $get_leader = array();
        $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0])->one();
        if (!empty($sm_cp_data)) {
            if ($sm_cp_data->role == 1) {
                $get_leader = $sm_cp_data;
            } else {
                if (!empty($sm_cp_data->builder_id)) {
                    $get_leader = SmCp::find()->where(['builder_id' => $sm_cp_data->builder_id, 'is_deleted' => 0, 'role' => 1])->one();
                } else {
                    $get_leader = SmCp::find()->where(['channelpartner_id' => $sm_cp_data->channelpartner_id, 'is_deleted' => 0, 'role' => 1])->one();
                }
            }
        }
        return $get_leader;
    }

    public function getaccessmembers($sm_cp_id)
    {
        $members = null;
        $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0])->one();
        if (!empty($sm_cp_data)) {
            if ($sm_cp_data->role == 1 || $sm_cp_data->role == 2) {

                if ($sm_cp_data->role == 1) {
                    $smData = (new \yii\db\Query())
                        ->select('sm_cp1.sm_cp_id')
                        ->from('sm_cp sm_cp1')
                        ->leftJoin('sm_cp sm_cp2', 'sm_cp1.parent_id=sm_cp2.sm_cp_id AND sm_cp2.is_deleted=0')
                        ->leftJoin('sm_cp sm_cp3', 'sm_cp2.parent_id=sm_cp3.sm_cp_id AND sm_cp3.is_deleted=0')
                        ->where('((' . $sm_cp_id . ' in (sm_cp1.parent_id,sm_cp2.parent_id, sm_cp3.parent_id)) AND sm_cp1.sm_cp_id!=' . $sm_cp_id . ') AND sm_cp1.is_deleted=0')->createCommand()
                        ->queryAll();
                    if (!empty($smData)) {
                        $count = 0;
                        foreach ($smData as $smData_k => $smData_v) {
                            $members[] = $smData_v['sm_cp_id'];
                        }
                    }
                } elseif ($sm_cp_data->role == 2) {
                    $smData = (new \yii\db\Query())
                        ->select('sm_cp1.sm_cp_id')
                        ->from('sm_cp sm_cp1')
                        ->leftJoin('sm_cp sm_cp2', 'sm_cp1.parent_id=sm_cp2.sm_cp_id AND sm_cp2.is_deleted=0')
                        ->where('((' . $sm_cp_id . ' in (sm_cp1.parent_id,sm_cp2.parent_id)) AND sm_cp1.sm_cp_id!=' . $sm_cp_id . ') AND sm_cp1.is_deleted=0')->createCommand()
                        ->queryAll();
                    if (!empty($smData)) {
                        $count = 0;
                        foreach ($smData as $smData_k => $smData_v) {
                            $members[] = $smData_v['sm_cp_id'];
                        }
                    }
                }
            }
        }
        return $members;
    }

    public function getaccessmemberswithname($sm_cp_id)
    {
        $members = null;
        $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0])->one();
        if (!empty($sm_cp_data)) {
            $members[0]['sm_cp_id'] = $sm_cp_id;
            $members[0]['name'] = $sm_cp_data->name;
            if ($sm_cp_data->role == 1 || $sm_cp_data->role == 2) {

                if ($sm_cp_data->role == 1) {
                    $smData = (new \yii\db\Query())
                        ->select('sm_cp1.sm_cp_id,sm_cp1.name')
                        ->from('sm_cp sm_cp1')
                        ->leftJoin('sm_cp sm_cp2', 'sm_cp1.parent_id=sm_cp2.sm_cp_id AND sm_cp2.is_deleted=0')
                        ->leftJoin('sm_cp sm_cp3', 'sm_cp2.parent_id=sm_cp3.sm_cp_id AND sm_cp3.is_deleted=0')
                        ->where('((' . $sm_cp_id . ' in (sm_cp1.parent_id,sm_cp2.parent_id, sm_cp3.parent_id)) AND sm_cp1.sm_cp_id!=' . $sm_cp_id . ') AND sm_cp1.is_deleted=0')->createCommand()
                        ->queryAll();
                    if (!empty($smData)) {
                        $count = 1;
                        foreach ($smData as $smData_k => $smData_v) {
                            $members[$count]['sm_cp_id'] = $smData_v['sm_cp_id'];
                            $members[$count]['name'] = $smData_v['name'];
                            $count++;
                        }
                    }
                } elseif ($sm_cp_data->role == 2) {
                    $smData = (new \yii\db\Query())
                        ->select('sm_cp1.sm_cp_id')
                        ->from('sm_cp sm_cp1')
                        ->leftJoin('sm_cp sm_cp2', 'sm_cp1.parent_id=sm_cp2.sm_cp_id AND sm_cp2.is_deleted=0')
                        ->where('((' . $sm_cp_id . ' in (sm_cp1.parent_id,sm_cp2.parent_id)) AND sm_cp1.sm_cp_id!=' . $sm_cp_id . ') AND sm_cp1.is_deleted=0')->createCommand()
                        ->queryAll();
                    if (!empty($smData)) {
                        $count = 1;
                        foreach ($smData as $smData_k => $smData_v) {
                            $members[$count]['sm_cp_id'] = $smData_v['sm_cp_id'];
                            $members[$count]['name'] = $smData_v['name'];
                            $count++;
                        }
                    }
                }
            }

            /* $members[$count + 1]['sm_cp_id'] = $sm_cp_id;
            $members[$count + 1]['name'] = $sm_cp_data->name; */
        }
        return $members;
    }

    public function getpackages($get_user, $get_type = 2)
    {
        //$get_type = 2:CP,1:SM
        $current_package_info = null;
        $previous_package_info = null;

        $get_free_package = 4;

        if (!empty($get_user->package_id)) {
            $current_package_info['subscription_id'] = (string) $get_user->package_id;
            $get_package_details = $this->getpackage($get_user->package_id);
            if (!empty($get_package_details)) {
                if (isset($get_package_details['name'])) {
                    $package_name = $get_package_details['name'];
                    $current_package_info['subscription_name'] = $package_name;
                }
            }
            if (!empty($get_user->mobile_view_expiry) && $get_user->mobile_view_expiry != "0000-00-00") {
                $current_package_info['subscription_expiry'] = $get_user->mobile_view_expiry;
            } else {
                $current_package_info['subscription_expiry'] = null;
            }
        }
        if (!empty($get_user->previous_package_id)) {
            $previous_package_info['subscription_id'] = (string) $get_user->previous_package_id;
            $get_prev_package_details = $this->getpackage($get_user->previous_package_id);
            if (!empty($get_prev_package_details)) {
                if (isset($get_prev_package_details['name'])) {
                    $prev_package_name = $get_prev_package_details['name'];
                    $previous_package_info['subscription_name'] = $prev_package_name;
                }
            }
            if (!empty($get_user->previous_expiry) && $get_user->previous_expiry != "0000-00-00") {
                $previous_package_info['subscription_expiry'] = $get_user->previous_expiry;
            } else {
                $previous_package_info['subscription_expiry'] = null;
            }
        }



        $package_arr = null;
        $package = null;

        $where_sql = 'type="' . $get_type . '" AND status=1 AND id!=5';

        $sort_text = 'amountpermonth ASC';


        $package_query = (new \yii\db\Query())
            ->select('id,name,description,amountpermonth')
            ->from('package')
            ->where($where_sql)
            ->orderBy($sort_text);
        $package_count = $package_query->count();

        $package_data = $package_query->createCommand()->queryAll();

        $key_arr = ["Unlimited Resale Posting", "Unlimited Rental Posting", "Unlimited Developer Connect", "Lead Management", "Team Empowerment", "5 Limited Matching Contact", "Unlimited Matching Contact", "Dedicated RM", "1500 SMS & Whatsapp for CP Activation", "Offers with Notification"];

        if (!empty($package_data)) {
            $gen_count = 0;
            $proj_count = 0;

            foreach ($package_data as $package_data_key => $package_data_val) {

                $package[$package_data_key] = $package_data_val;

                $package_cost = intval($package_data_val['amountpermonth']);
                //divide description
                $get_pack_desc = $package_data_val['description'];
                if (!empty($get_pack_desc)) {
                    $get_pack_desc_arr = explode("#", $get_pack_desc);
                }
                $package_facts = [];

                if (!empty($get_pack_desc_arr)) {
                    foreach ($get_pack_desc_arr as $get_pack_desc_arr_k => $get_pack_desc_arr_val) {
                        if (!empty(trim($get_pack_desc_arr_val))) {
                            $get_pack_desc_arr_val = trim($get_pack_desc_arr_val, "\r\n");
                            $package_facts[] = $get_pack_desc_arr_val;
                        }
                    }
                }

                $package_facts_display = [];
                $f_count = 0;
                foreach ($key_arr as $key_arr_val) {
                    $package_facts_display[$f_count]['name'] = $key_arr_val;
                    if (in_array($key_arr_val, $package_facts)) {
                        $package_facts_display[$f_count]['isAvailable'] = true;
                    } else {
                        $package_facts_display[$f_count]['isAvailable'] = false;
                    }
                    $f_count++;
                }


                //$mon_arr = [1, 3, 6, 12];
                if ($package_data_val['id'] != 6) {
                    $mon_arr[1] = 5;
                    $mon_arr[3] = 10;
                    $mon_arr[6] = 15;
                    $mon_arr[12] = 40;
                } else {
                    $mon_arr[1] = 0;
                    $mon_arr[3] = 5;
                    $mon_arr[6] = 7;
                    $mon_arr[12] = 30;
                }
                //40% changed on 15-12-25

                /* echo "<pre>";
                print_r($package_facts);
                exit; */
                $isactive = false;
                if ($current_package_info['subscription_id'] == $package_data_val['id']) {
                    $isactive = true;
                }
                if ($current_package_info['subscription_id'] == 5 && $package_data_val['id'] == 7) {
                    $isactive = true;
                }
                $package[$package_data_key]['isActive'] = $isactive;


                $package[$package_data_key]['keyBenefits'] = $package_facts_display;
                $option_arr = [];
                $s_count = 0;
                foreach ($mon_arr as $mon_arr_key => $mon_arr_val) {
                    $mon_count = $mon_arr_key;
                    $mon_percent = $mon_arr_val;
                    $option_arr[$s_count]["months"] = $mon_count;
                    $total_price = intval($mon_count * $package_cost);
                    $option_arr[$s_count]["totalAmount"] = $total_price;
                    $offeramount = $total_price;
                    //calculate offer amount
                    $originalPrice = $total_price;
                    $discountPercent = $mon_percent;
                    if (!empty($discountPercent)) {
                        $discountAmount = ($originalPrice * $discountPercent) / 100;
                        $finalPrice = $originalPrice - $discountAmount;
                        $offeramount = intval($finalPrice);
                    }
                    $option_arr[$s_count]["offerAmount"] = $offeramount;
                    $option_arr[$s_count]["savedAmount"] = $discountAmount;
                    if (empty($offeramount)) {
                        $discountPercent = 0;
                    }
                    $option_arr[$s_count]["discountPercent"] = $discountPercent;
                    $s_count++;
                }

                //For free package not show amount
                if ($package_data_val['id'] != $get_free_package) {
                    $package[$package_data_key]['options'] = $option_arr;
                }
            }
        }

        $package_arr['current_subscription'] = $current_package_info;
        $package_arr['previous_subscription'] = $previous_package_info;
        $package_arr['subscription'] = $package;

        $get_campaign_content_arr = null;
        $get_campaign_content_data = PackageBanners::find()->select('banner,name')->where(['status' => 1])->asArray()->all();
        if (!empty($get_campaign_content_data)) {
            $c_count = 0;
            foreach ($get_campaign_content_data as $get_campaign_content_data_val) {
                $get_campaign_content_arr[$c_count]['title'] = $get_campaign_content_data_val['name'];
                $get_campaign_content_arr[$c_count]['image'] = \Yii::$app->params['web_path'] . 'files/packages/' . $get_campaign_content_data_val['banner'];
                $c_count++;
            }
        }
        $package_arr['banners'] = $get_campaign_content_arr;





        return $package_arr;
    }

    public function getpackagehistory($sm_cp_id, $querydata = array())
    {
        $package_arr = null;
        $package = null;

        $package_type = (!empty($querydata['type']) ? trim($querydata['type']) : '');
        $package_plantype = (!empty($querydata['plantype']) ? trim($querydata['plantype']) : '1');

        $where_sql = 'sm_cp_id="' . $sm_cp_id . '"';
        if (!empty($package_type)) {
            $where_sql .= " AND type IN(" . $package_type . ")";
        }
        $today_date = date('Y-m-d');
        if ($package_plantype == 1) {
            //1-present
            $where_sql .= " AND start_date <= CURDATE() AND end_date >= CURDATE()";
        } else if ($package_plantype == 2) {
            //2-future
            $where_sql .= " AND start_date >= CURDATE() AND end_date > CURDATE()";
        } else if ($package_plantype == 3) {
            //3-past
            $where_sql .= " AND start_date < CURDATE() AND end_date < CURDATE()";
        }

        $sort_text = 'id DESC';


        $package_query = (new \yii\db\Query())
            ->select('ph.id,ph.months,ph.start_date,ph.end_date,ph.created_on,ph.type,p.name as package_name')
            ->from('package_history ph')
            ->leftJoin('package p', 'ph.package_id=p.id')
            ->where($where_sql)
            ->orderBy($sort_text);


        $package_data = $package_query->createCommand()->queryAll();

        if (!empty($package_data)) {
            $gen_count = 0;
            $proj_count = 0;

            foreach ($package_data as $package_data_key => $package_data_val) {

                $package[$package_data_key] = $package_data_val;

                $package[$package_data_key]['typeText'] = $this->package_history_type[$package[$package_data_key]['type']];
            }
        }

        $package_arr['packageHistory'] = $package;

        return $package_arr;
    }

    public function getorders($sm_cp_id, $querydata = array())
    {
        $order_arr = null;
        $order = null;
        $common_model = new Common();

        $order_start_date = (!empty($querydata['start_date']) ? trim($querydata['start_date']) : '');
        $order_end_date = (!empty($querydata['end_date']) ? trim($querydata['end_date']) : '');

        $where_sql = 'sm_cp_id IN(' . $sm_cp_id . ')';
        if (!empty($order_start_date)) {

            /* $order_start_date_d = DateTime::createFromFormat("d-m-Y", $order_start_date);
            $order_start_date_final = $order_start_date_d->format("Y-m-d"); */

            $where_sql .= ' AND o.created_on>="' . $order_start_date . '"';
        }
        if (!empty($order_end_date)) {

            /* $order_end_date_d = DateTime::createFromFormat("d-m-Y", $order_end_date);
            $order_end_date_final = $order_end_date_d->format("Y-m-d"); */
            $where_sql .= ' AND o.created_on<="' . $order_end_date . '"';
        }

        $sort_text = 'order_id DESC';


        $package_query = (new \yii\db\Query())
            ->select('o.order_id,o.order_code,o.package_amount,o.month,o.total_amount,o.discount_amount,o.final_amount,o.status,p.name as package_name,o.created_on')
            ->from('package_order o')
            ->leftJoin('package p', 'o.package_id=p.id')
            ->where($where_sql)
            ->orderBy($sort_text);


        $package_data = $package_query->createCommand()->queryAll();

        if (!empty($package_data)) {

            foreach ($package_data as $package_data_key => $package_data_val) {

                $order[$package_data_key] = $package_data_val;

                $order[$package_data_key]['statusText'] = $this->order_status[$order[$package_data_key]['status']];

                $get_order_id = $order[$package_data_key]['order_id'];

                /* Invoice::find()
                    ->where("FIND_IN_SET(:id, order_ids)")
                    ->addParams([':id' => $id])
                    ->one(); */

                //get invoice link
                $get_invoice_data = Invoice::find()->where(['order_ids' => $get_order_id])->one();
                if (!empty($get_invoice_data)) {
                    $get_invoice_id = $get_invoice_data->id;
                    $getid = $common_model->encryptId($get_invoice_id);

                    //live
                    $link = "https://smcp.cpbroadcast.com/smcp/apps/backend/web/index.php?r=packageorder/invoice&id=" . $getid;
                    
                    /*
                    //dev
                    $link = "https://devsmcp.cpbroadcast.com/smcp/apps/backend/web/index.php?r=packageorder/invoice&id=" . $getid; 
                    */
		    /*
                    //local
                    $link = "http://localhost/saleprosys/apps/backend/web/index.php?r=packageorder/invoice&id=" . $getid;
                    */
		    $order[$package_data_key]['invoice'] = $link;
                }
            }
        }

        $order_arr['order'] = $order;

        return $order_arr;
    }

    public function getorderdetail($id, $sm_cp_id)
    {
        $order_arr = null;
        $order = null;

        $common_model = new Common();

        $where_sql = 'sm_cp_id IN(' . $sm_cp_id . ')';
        $where_sql .= ' AND o.order_id="' . $id . '"';

        $sort_text = 'order_id DESC';


        $package_query = (new \yii\db\Query())
            ->select('o.order_id,o.order_code,o.package_amount,o.month,o.total_amount,o.discount_amount,o.final_amount,o.status,p.name as package_name,o.created_on,o.sm_cp_id')
            ->from('package_order o')
            ->leftJoin('package p', 'o.package_id=p.id')
            ->where($where_sql)
            ->orderBy($sort_text);


        $package_data = $package_query->createCommand()->queryAll();

        if (!empty($package_data)) {

            foreach ($package_data as $package_data_key => $package_data_val) {

                $order[$package_data_key] = $package_data_val;

                $order[$package_data_key]['statusText'] = $this->order_status[$order[$package_data_key]['status']];


                $get_order_id = $order[$package_data_key]['order_id'];

                /* Invoice::find()
                    ->where("FIND_IN_SET(:id, order_ids)")
                    ->addParams([':id' => $id])
                    ->one(); */

                //get invoice link
                $get_invoice_data = Invoice::find()->where(['order_ids' => $get_order_id])->one();
                if (!empty($get_invoice_data)) {
                    $get_invoice_id = $get_invoice_data->id;
                    $getid = $common_model->encryptId($get_invoice_id);

                    //live
                    $link = "https://smcp.cpbroadcast.com/smcp/apps/backend/web/index.php?r=packageorder/invoice&id=" . $getid;
                    
                    /*
                    //dev
                    $link = "https://devsmcp.cpbroadcast.com/smcp/apps/backend/web/index.php?r=packageorder/invoice&id=" . $getid; 
                    */
		    /*
                    //local
                    $link = "http://localhost/saleprosys/apps/backend/web/index.php?r=packageorder/invoice&id=" . $getid;
                    */
		    $order[$package_data_key]['invoice'] = $link;
                }


                //get user details
                $getusertxt = $order[$package_data_key]['sm_cp_id'];

                $userinfo = null;
                $userData = (new \yii\db\Query())
                    ->select('sm.sm_cp_id,sm.name,sm.contact')
                    ->from('sm_cp sm')
                    ->where('sm.sm_cp_id IN(' . $getusertxt . ')')->createCommand()
                    ->queryAll();

                if (!empty($userData)) {
                    $s_count = 0;
                    foreach ($userData as $userData_val) {
                        $userinfo[$s_count]['name'] = $userData_val['name'];
                        $userinfo[$s_count]['contact'] = $userData_val['contact'];
                        $s_count++;
                    }
                }

                $order[$package_data_key]['userinfo'] = $userinfo;

                //pending from here-------------------------------
                //peyment details
                $paymentinfo = null;
                $paymentData = (new \yii\db\Query())
                    ->select('op.payment_mode,op.cheque_number,op.client_bank_name,op.branch_name,op.date_of_payment_received,op.payment_received,op.receipt_serial_no,op.status')
                    ->from('package_order_payment op')
                    ->leftJoin('invoice i', 'op.invoice_id=i.id')
                    ->where('i.order_ids IN(' . $id . ')')->createCommand()
                    ->queryAll();

                if (!empty($paymentData)) {
                    $s_count = 0;
                    $payment_mode_arr = array('2' => 'Cheque', '3' => 'Online Transfer(RTGS/IMPS/UPI)');
                    $payment_status_arr = array('1' => 'Payment Successful', '2' => 'Payment Failed');
                    foreach ($paymentData as $paymentData_val) {
                        $paymentinfo[$s_count]['payment_mode'] = $paymentData_val['payment_mode'];
                        $paymentinfo[$s_count]['payment_mode_text'] = $payment_mode_arr[$paymentData_val['payment_mode']];
                        $paymentinfo[$s_count]['cheque_number'] = null;
                        if ($paymentData_val['payment_mode'] == 2) {
                            $paymentinfo[$s_count]['cheque_number'] = $paymentData_val['cheque_number'];
                        }
                        if ($paymentData_val['payment_mode'] == 3) {
                            $paymentinfo[$s_count]['receipt_serial_no'] = $paymentData_val['receipt_serial_no'];
                        }
                        $paymentinfo[$s_count]['client_bank_name'] = $paymentData_val['client_bank_name'];
                        $paymentinfo[$s_count]['branch_name'] = $paymentData_val['branch_name'];
                        $paymentinfo[$s_count]['date_of_payment_received'] = date('d-m-Y', strtotime($paymentData_val['date_of_payment_received']));
                        $paymentinfo[$s_count]['payment_received'] = $paymentData_val['payment_received'];
                        $paymentinfo[$s_count]['status'] = $paymentData_val['status'];
                        $paymentinfo[$s_count]['status_text'] = $payment_status_arr[$paymentData_val['status']];


                        $s_count++;
                    }
                }

                $order[$package_data_key]['paymentinfo'] = $paymentinfo;
            }
        }

        $order_arr['order'] = $order[0];

        return $order_arr;
    }


    public function getnotification($sm_cp_id, $querydata)
    {
        $notification_arr = null;
        $notification = null;

        if (!empty($querydata)) {

            $notify_status = (!empty($querydata['status']) ? trim($querydata['status']) : '');


            $notify_start_date = (!empty($querydata['start_date']) ? trim($querydata['start_date']) : '');
            $notify_end_date = (!empty($querydata['end_date']) ? trim($querydata['end_date']) : '');
        }

        $get_project_id = (isset($querydata['project_id']) ? trim($querydata['project_id']) : '');
        $notify_type = (!empty($querydata['type']) ? trim($querydata['type']) : '');

        $notify_type_arr = array_filter(explode(',', $notify_type)); // convert to array
        $notify_type_arr = array_map('trim', $notify_type_arr);           // clean spacing

        //$notify_type_arr = explode(",", $notify_type);
        /* echo "<pre>";
        print_r($notify_type_arr); */


        if (in_array($notify_type_arr, [6]) && count($notify_type_arr) == 1) {
            $get_project_id = "";
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'notification_list.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = 'notification_list.status NOT IN(1) AND notification_list.sm_cp_id="' . $sm_cp_id . '" AND nm.notify_type !=5 ';
        if (!empty($notify_status)) {
            $where_sql .= ' AND notification_list.status IN(' . $notify_status . ')';
        }
        if (!empty($notify_type)) {
            //$where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';

            if (in_array('4', $notify_type_arr)) {

                if (count($notify_type_arr) == 1) {
                    $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                } else {
                    if (!empty($get_project_id)) {
                        // echo "11";
                        $updated_notify_type = str_replace("4", "", $notify_type);
                        $updated_notify_type = trim($updated_notify_type, ',');
                        $where_sql .= ' AND ((nm.notify_type IN(' . $updated_notify_type . ') AND notification_list.project_id IN(' . $get_project_id . ')) OR (nm.notify_type IN(4)))';
                    } else {
                        $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                    }
                }
            } else {
                if (!empty($get_project_id)) {
                    $where_sql .= ' AND notification_list.project_id IN(' . $get_project_id . ')';
                    $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                } else {
                    $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                }
            }



            /* if (in_array($notify_type_arr, [4]) && count($notify_type_arr) > 1) {
                echo "1";
                $updated_notify_type = str_replace("4", "", $notify_type);
                $updated_notify_type = trim($updated_notify_type, ',');
                if (!empty($get_project_id)) {
                    echo "11";
                    $where_sql .= ' AND ((nm.notify_type IN(' . $updated_notify_type . ') AND notification_list.project_id IN(' . $get_project_id . ')) OR (nm.notify_type IN(4)))';
                } else {
                    echo "12";
                    $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                }
            } else if (!in_array($notify_type_arr, [4, 6]) && count($notify_type_arr) >= 1) {
                echo "2";
                if (!empty($get_project_id)) {
                    echo "21";
                    $where_sql .= ' AND notification_list.project_id IN(' . $get_project_id . ')';
                    $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                } else {
                    echo "22";
                    $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
                }
            } else if (in_array($notify_type_arr, [4, 6]) && count($notify_type_arr) == 1) {
                echo "3";
                $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
            } */
        } else {
            $where_sql .= ' AND nm.notify_type NOT IN(6)';
        }


        if (!empty($notify_start_date)) {
            $where_sql .= ' AND notification_list.modified_on>="' . $notify_start_date . '"';
        }
        if (!empty($notify_end_date)) {
            $where_sql .= ' AND notification_list.modified_on<="' . $notify_end_date . '"';
        }
        /* if (!empty($get_project_id)) {
            $where_sql .= ' AND notification_list.project_id IN(' . $get_project_id . ')';
        } */

        /* echo $where_sql;
        exit; */

        $sort_text = $order_name . ' ' . $order_type;


        $notify_query = (new \yii\db\Query())
            ->select('notification_list.id,notification_list.title,notification_list.message,notification_list.link,notification_list.modified_on,notification_list.sent_on,notification_list.status,notification_list.read_on,notification_list.project_id,p.name as projectname,nm.notify_type,ns.attachment,ns.project_id as notifyproject,nm.info')
            ->from('notification_list')
            ->leftJoin("projects as p", 'notification_list.project_id = p.id')
            ->leftJoin("notification_master as nm", 'notification_list.notification_id = nm.id')
            ->leftJoin("notifications as ns", 'nm.notify_id=ns.id')
            ->where($where_sql)
            ->orderBy($sort_text);
        $notify_count = $notify_query->count();

        $notify_data = $notify_query->limit($page_count)->offset($offset)->createCommand()->queryAll();

        if (!empty($notify_data)) {
            $gen_count = 0;
            $proj_count = 0;

            foreach ($notify_data as $notify_data_key => $notify_data_val) {

                $notification[$notify_data_key] = $notify_data_val;
                $notification[$notify_data_key]['received_on'] = date('d M Y h:i A', strtotime($notify_data_val['sent_on']));
                if ($notify_data_val['status'] == 2) {
                    $notification[$notify_data_key]['statusText'] = 'Unread';
                    $notification[$notify_data_key]['read_on'] = null;
                } else if ($notify_data_val['status'] == 3) {
                    $notification[$notify_data_key]['statusText'] = 'Read';
                    $notification[$notify_data_key]['read_on'] = date('d M Y h:i A', strtotime($notify_data_val['read_on']));
                }
                $notification[$notify_data_key]['notify_type_text'] = $this->notify_type[$notify_data_val['notify_type']];

                $notification[$notify_data_key]['project_id'] = null;
                $notification[$notify_data_key]['project_name'] = null;
                if (!empty($notify_data_val['project_id'])) {
                    $proj_id = $notify_data_val['project_id'];
                    $proj_name = $notify_data_val['projectname'];
                    $notification[$notify_data_key]['project_id'] = $proj_id;
                    $notification[$notify_data_key]['project_name'] = $proj_name;
                }

                $imageUrl = null;
                $project_id = $notify_data_val['project_id'];
                $attachment = $notify_data_val['attachment'];
                $notifyproject = $notify_data_val['notifyproject'];
                $notify_type = $notify_data_val['notify_type'];

                $info = $notify_data_val['info'];
                $info_arr = json_decode($info);

                //no image sending for offer
                if ($notify_type == 1) {
                    //For tagging
                    //get banner
                    $getbanner = SnseBanner::findOne([
                        'projects_id' => $project_id,
                        'status' => 1
                    ]);
                    if (!empty($getbanner)) {
                        $imageUrl = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                    }
                } else if ($notify_type == 3) {
                    //For project
                    if (!empty($attachment)) {
                        $imageUrl = \Yii::$app->params['web_path'] . "files/notification/" . $attachment;
                    } else {

                        //get banner
                        $getbanner = SnseBanner::findOne([
                            'projects_id' => $notifyproject,
                            'status' => 1
                        ]);
                        if (!empty($getbanner)) {
                            $imageUrl = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                        }
                    }
                } else if ($notify_type == 4) {
                    //For announcement
                    if (!empty($attachment)) {
                        $imageUrl = \Yii::$app->params['web_path'] . "files/notification/" . $attachment;
                    }
                } else if ($notify_type == 2) {
                    //For offers
                    //get banner
                    if (isset($info_arr->id) && !empty($info_arr->id)) {
                        $schedule_id = $info_arr->id;
                        $getbanner = MarketingCampaignContent::findOne([
                            'schedule_id' => $schedule_id
                        ]);
                        if (!empty($getbanner)) {
                            $imageUrl = \Yii::$app->params['web_path'] . "files/marketing/" . $getbanner->content;
                        }
                    }
                }
                $notification[$notify_data_key]['imageUrl'] = $imageUrl;
            }
        }

        $sourcing = null;
        $sourcingbyrole = null;
        $final_sourcing = null;
        if (!empty($get_project_id)) {

            $get_sm_data = $this->getparentapi($sm_cp_id);
            $cp_id = $get_sm_data->channelpartner_id;
            if (!empty($cp_id)) {
                $get_connect_sm = $this->getsmofcp($cp_id);
                //get sourcing
                $sourcingData = (new \yii\db\Query())
                    ->select('sm.sm_cp_id,sm.name,sm.role,sm.contact')
                    ->from('sm_projects sp')
                    ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id')
                    ->where('FIND_IN_SET("' . (int) $get_project_id . '",projects_id) AND sp.status=1 AND sm.status=1 AND sm.staff_type=1 AND sm.is_deleted=0')->groupBy('sp.sm_cp_id')->createCommand()
                    ->queryAll();

                if (!empty($sourcingData)) {
                    $s_count = 0;
                    foreach ($sourcingData as $sourcingData_val) {
                        if (!empty($get_connect_sm)) {
                            if (in_array($sourcingData_val['sm_cp_id'], $get_connect_sm)) {
                                $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                                $s_count++;
                            }
                        }
                    }

                    //Show executive first, then manager then Leader
                    /* if (isset($sourcingbyrole[3])) {
                    $final_sourcing[0] = $sourcingbyrole[3];
                } else if (isset($sourcingbyrole[2])) {
                    $final_sourcing[0] = $sourcingbyrole[2];
                } else if (isset($sourcingbyrole[1])) {
                    $final_sourcing[0] = $sourcingbyrole[1];
                } */
                    $final_sourcing = $sourcing;
                }
            }
        }
        $notification_arr['sourcing'] = $final_sourcing;




        //pagination code start
        $pgdata['page'] = $page;
        //$pgdata['content_count'] = $proj_count * 5;     //added for testing
        $pgdata['content_count'] = $notify_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end

        $notification_arr['notification'] = $notification;
        $notification_arr['pagination'] = $pagination;

        return $notification_arr;
    }



    public function getnotificationproject($sm_cp_id, $querydata)
    {
        $notification_arr = null;
        $notification = null;

        /* if (!empty($querydata)) {

            $notify_status = (!empty($querydata['status']) ? trim($querydata['status']) : '');
            $notify_type = (!empty($querydata['type']) ? trim($querydata['type']) : '');

            $notify_start_date = (!empty($querydata['start_date']) ? trim($querydata['start_date']) : '');
            $notify_end_date = (!empty($querydata['end_date']) ? trim($querydata['end_date']) : '');
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'notification_list.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC'); */


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = 'notification_list.status NOT IN(1) AND notification_list.success=1 AND notification_list.sm_cp_id="' . $sm_cp_id . '" AND nm.notify_type !=5 AND notification_list.project_id IS NOT NULL ';
        /* if (!empty($notify_status)) {
            $where_sql .= ' AND notification_list.status IN(' . $notify_status . ')';
        }
        if (!empty($notify_type)) {
            $where_sql .= ' AND nm.notify_type IN(' . $notify_type . ')';
        }

        if (!empty($notify_start_date)) {
            $where_sql .= ' AND notification_list.modified_on>="' . $notify_start_date . '"';
        }
        if (!empty($notify_end_date)) {
            $where_sql .= ' AND notification_list.modified_on<="' . $notify_end_date . '"';
        } */

        $sort_text = 'last_time DESC';


        $notify_query = (new \yii\db\Query())
            ->select('notification_list.project_id,p.name as projectname,b.name as builder_name,b.logo as builder_logoval, MAX(notification_list.created_on) as last_time')
            ->from('notification_list')
            ->leftJoin("projects as p", 'notification_list.project_id = p.id')
            ->leftJoin("builder as b", 'p.builder_id = b.id')
            ->leftJoin("notification_master as nm", 'notification_list.notification_id = nm.id')
            ->leftJoin("notifications as ns", 'nm.notify_id=ns.id')
            ->where($where_sql)
            ->orderBy($sort_text)->groupBy('notification_list.project_id');
        $notify_count = $notify_query->count();

        $notify_data = $notify_query->limit($page_count)->offset($offset)->createCommand()->queryAll();

        if (!empty($notify_data)) {
            $gen_count = 0;
            $proj_count = 0;

            foreach ($notify_data as $notify_data_key => $notify_data_val) {

                $notification[$notify_data_key] = $notify_data_val;

                $get_project = $notify_data_val['project_id'];
                $formgetdata['project_id'] = $get_project;
                $get_count = $this->getnotificationcount($sm_cp_id, $formgetdata);
                //get unread message count
                $notification[$notify_data_key]['unread_count'] = $get_count;

                //get last message
                $get_last_message = $this->getlatestmessage($sm_cp_id, $formgetdata);
                if (!empty($get_last_message)) {
                    $notification[$notify_data_key]['last_msg_time'] = $get_last_message['created_on'];
                    $html_message = preg_replace('/\s+/', ' ', trim($get_last_message['message']));
                    $notification[$notify_data_key]['last_message'] = $html_message;
                } else {
                    $notification[$notify_data_key]['last_msg_time'] = null;
                    $notification[$notify_data_key]['last_message'] = null;
                }

                //get banner
                $getbanner = SnseBanner::findOne([
                    'projects_id' => $get_project,
                    'status' => 1
                ]);
                if (!empty($getbanner)) {
                    $notification[$notify_data_key]['banner'] = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                } else {
                    $notification[$notify_data_key]['banner'] = null;
                }

                if (!empty($notify_data_val['builder_logoval'])) {
                    $notification[$notify_data_key]['builder_logo'] = \Yii::$app->params['web_path'] . "project-img/" . $notify_data_val['builder_logoval'];
                } else {
                    $notification[$notify_data_key]['builder_logo'] = null;
                }


                $sourcing = null;
                $sourcingbyrole = null;
                $final_sourcing = null;
                if (!empty($get_project)) {

                    $get_sm_data = $this->getparentapi($sm_cp_id);
                    $cp_id = $get_sm_data->channelpartner_id;
                    if (!empty($cp_id)) {
                        $get_connect_sm = $this->getsmofcp($cp_id);
                        //get sourcing
                        $sourcingData = (new \yii\db\Query())
                            ->select('sm.sm_cp_id,sm.name,sm.role,sm.contact')
                            ->from('sm_projects sp')
                            ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id')
                            ->where('FIND_IN_SET("' . (int) $get_project . '",projects_id) AND sp.status=1 AND sm.status=1 AND sm.staff_type=1 AND sm.is_deleted=0')->groupBy('sp.sm_cp_id')->createCommand()
                            ->queryAll();

                        if (!empty($sourcingData)) {
                            $s_count = 0;
                            foreach ($sourcingData as $sourcingData_val) {
                                if (!empty($get_connect_sm)) {
                                    if (in_array($sourcingData_val['sm_cp_id'], $get_connect_sm)) {
                                        $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                        $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                        $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                        $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                        $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                                        $s_count++;
                                    }
                                }
                            }

                            //Show executive first, then manager then Leader
                            /* if (isset($sourcingbyrole[3])) {
                                $final_sourcing[0] = $sourcingbyrole[3];
                            } else if (isset($sourcingbyrole[2])) {
                                $final_sourcing[0] = $sourcingbyrole[2];
                            } else if (isset($sourcingbyrole[1])) {
                                $final_sourcing[0] = $sourcingbyrole[1];
                            } */
                            $final_sourcing = $sourcing;
                        }
                    }
                }
                $notification[$notify_data_key]['sourcing'] = $final_sourcing;
            }
        }

        //pagination code start
        $pgdata['page'] = $page;
        //$pgdata['content_count'] = $proj_count * 5;     //added for testing
        $pgdata['content_count'] = $notify_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end

        $notification_arr['notification'] = $notification;
        $notification_arr['pagination'] = $pagination;

        return $notification_arr;
    }

    public function getnotificationcount($sm_cp_id, $querydata)
    {
        $notify_type = 1; //Default CP Broadcast unread count
        if (!empty($querydata['type'])) {
            $notify_type = $querydata['type'];
        }


        $notify_count = 0;

        $where_sql = 'notification_list.status IN(2) AND notification_list.success=1 AND notification_list.sm_cp_id="' . $sm_cp_id . '" AND nm.notify_type !=5 ';

        if (!empty($querydata['project_id'])) {
            $get_proj = $querydata['project_id'];
            $where_sql .= ' AND notification_list.project_id="' . $get_proj . '"';
        }

        if ($notify_type == 1) {
            $where_sql .= ' AND nm.notify_type NOT IN(6)';
        } else if ($notify_type == 2) {
            $where_sql .= ' AND nm.notify_type IN(6)';
        }

        $notify_query = (new \yii\db\Query())
            ->select('notification_list.id,notification_list.title,notification_list.message,notification_list.link,notification_list.modified_on,notification_list.status,notification_list.read_on,notification_list.project_id,p.name as projectname,nm.notify_type,ns.attachment,ns.project_id as notifyproject')
            ->from('notification_list')
            ->leftJoin("projects as p", 'notification_list.project_id = p.id')
            ->leftJoin("notification_master as nm", 'notification_list.notification_id = nm.id')
            ->leftJoin("notifications as ns", 'nm.notify_id=ns.id')
            ->where($where_sql);
        $notify_count = $notify_query->count();

        return $notify_count;
    }

    public function getlatestmessage($sm_cp_id, $querydata)
    {
        $notify_type = 1; //Default CP Broadcast unread count
        if (!empty($querydata['type'])) {
            $notify_type = $querydata['type'];
        }

        $notification = array();

        $where_sql = 'notification_list.success=1 AND notification_list.sm_cp_id="' . $sm_cp_id . '" AND nm.notify_type !=5 ';

        if (!empty($querydata['project_id'])) {
            $get_proj = $querydata['project_id'];
            $where_sql .= ' AND notification_list.project_id="' . $get_proj . '"';
        }

        if ($notify_type == 1) {
            $where_sql .= ' AND nm.notify_type NOT IN(6)';
        } else if ($notify_type == 2) {
            $where_sql .= ' AND nm.notify_type IN(6)';
        }

        $notify_query = (new \yii\db\Query())
            ->select('notification_list.message,notification_list.created_on')
            ->from('notification_list')
            ->leftJoin("projects as p", 'notification_list.project_id = p.id')
            ->leftJoin("notification_master as nm", 'notification_list.notification_id = nm.id')
            ->leftJoin("notifications as ns", 'nm.notify_id=ns.id')
            ->where($where_sql)
            ->orderBy("notification_list.id DESC");
        $notify_data = $notify_query->limit(1)->offset(0)->createCommand()->queryAll();

        if (!empty($notify_data)) {


            foreach ($notify_data as $notify_data_key => $notify_data_val) {
                $notification['message'] = $notify_data_val['message'];
                $notification['created_on'] = $notify_data_val['created_on'];
            }
        }

        return $notification;
    }



    public function getnotificationdetail($id)
    {
        $notification_arr = null;
        $notification = null;

        $where_sql = 'notification_list.status NOT IN(1) AND notification_list.success=1 AND notification_list.id="' . $id . '" AND nm.notify_type !=5 ';



        $notify_query = (new \yii\db\Query())
            ->select('notification_list.id,notification_list.title,notification_list.message,notification_list.link,notification_list.modified_on,notification_list.sent_on,notification_list.status,notification_list.read_on,notification_list.project_id,p.name as projectname,nm.notify_type,ns.attachment,ns.project_id as notifyproject,nm.info')
            ->from('notification_list')
            ->leftJoin("projects as p", 'notification_list.project_id = p.id')
            ->leftJoin("notification_master as nm", 'notification_list.notification_id = nm.id')
            ->leftJoin("notifications as ns", 'nm.notify_id=ns.id')
            ->where($where_sql);


        $notify_data = $notify_query->createCommand()->queryAll();

        if (!empty($notify_data)) {
            $gen_count = 0;
            $proj_count = 0;

            foreach ($notify_data as $notify_data_key => $notify_data_val) {

                $notification[$notify_data_key] = $notify_data_val;
                $notification[$notify_data_key]['received_on'] = date('d M Y H:i A', strtotime($notify_data_val['sent_on']));
                if ($notify_data_val['status'] == 2) {
                    $notification[$notify_data_key]['statusText'] = 'Unread';
                    $notification[$notify_data_key]['read_on'] = null;
                } else if ($notify_data_val['status'] == 3) {
                    $notification[$notify_data_key]['statusText'] = 'Read';
                    $notification[$notify_data_key]['read_on'] = date('d M Y H:i A', strtotime($notify_data_val['read_on']));
                }
                $notification[$notify_data_key]['notify_type_text'] = $this->notify_type[$notify_data_val['notify_type']];

                $notification[$notify_data_key]['project_id'] = null;
                $notification[$notify_data_key]['project_name'] = null;
                if (!empty($notify_data_val['project_id'])) {
                    $proj_id = $notify_data_val['project_id'];
                    $proj_name = $notify_data_val['projectname'];
                    $notification[$notify_data_key]['project_id'] = $proj_id;
                    $notification[$notify_data_key]['project_name'] = $proj_name;
                }

                $imageUrl = null;
                $project_id = $notify_data_val['project_id'];
                $attachment = $notify_data_val['attachment'];
                $notifyproject = $notify_data_val['notifyproject'];
                $notify_type = $notify_data_val['notify_type'];

                $info = !empty($notify_data_val['info']) ? $notify_data_val['info'] : "";
                if (!empty($info)) {
                    $info_arr = json_decode($info);
                }


                //no image sending for offer
                if ($notify_type == 1) {
                    //For tagging
                    //get banner
                    $getbanner = SnseBanner::findOne([
                        'projects_id' => $project_id,
                        'status' => 1
                    ]);
                    if (!empty($getbanner)) {
                        $imageUrl = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                    }
                    if (isset($info_arr->id) && !empty($info_arr->id)) {
                        $tag_id = $info_arr->id;
                        $landingurl = "/taggingResult";
                        $landingvalue = $tag_id;
                        $notification[$notify_data_key]['landingUrl'] = $landingurl;
                        $notification[$notify_data_key]['landingValue'] = $landingvalue;
                    }
                } else if ($notify_type == 3) {
                    //For project
                    if (!empty($attachment)) {
                        $imageUrl = \Yii::$app->params['web_path'] . "files/notification/" . $attachment;
                    } else {

                        //get banner
                        $getbanner = SnseBanner::findOne([
                            'projects_id' => $notifyproject,
                            'status' => 1
                        ]);
                        if (!empty($getbanner)) {
                            $imageUrl = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                        }
                    }
                    $proj_id = $project_id;
                    $landingurl = "/projectDetails";
                    $landingvalue = $proj_id;
                    $notification[$notify_data_key]['landingUrl'] = $landingurl;
                    $notification[$notify_data_key]['landingValue'] = $landingvalue;
                } else if ($notify_type == 4) {
                    //For announcement
                    if (!empty($attachment)) {
                        $imageUrl = \Yii::$app->params['web_path'] . "files/notification/" . $attachment;
                    }
                    $landingurl = "/notificationPanel";
                    $landingvalue = 1;
                    $notification[$notify_data_key]['landingUrl'] = $landingurl;
                    $notification[$notify_data_key]['landingValue'] = $landingvalue;
                } else if ($notify_type == 2) {
                    //for offer
                    $landingurl = "/offerList";
                    $landingvalue = 1;
                    $notification[$notify_data_key]['landingUrl'] = $landingurl;
                    $notification[$notify_data_key]['landingValue'] = $landingvalue;
                } else if ($notify_type == 6) {
                    //for posting
                    if (isset($info_arr->id) && !empty($info_arr->id)) {
                        $post_id = $info_arr->id;
                        $cpconnectmodelData = CpCustomersFlats::findOne([
                            'id' => $post_id
                        ]);
                        if (!empty($cpconnectmodelData)) {
                            if ($cpconnectmodelData->post_for == 1) {
                                $landingurl = "/resaleResult";
                                $landingvalue = $post_id;
                            } else if ($cpconnectmodelData->post_for == 2) {
                                $landingurl = "/rentalResult";
                                $landingvalue = $post_id;
                            }
                            $notification[$notify_data_key]['landingUrl'] = $landingurl;
                            $notification[$notify_data_key]['landingValue'] = $landingvalue;
                        }
                    }
                }
                $notification[$notify_data_key]['imageUrl'] = $imageUrl;
            }
        }
        $notification_arr['notification'] = $notification;

        return $notification_arr;
    }



    public function getparentapi($sm_cp_id)
    {
        if (!empty($sm_cp_id)) {
            $sm_cp_data = SmCp::find()->where(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0])->one();
            return $sm_cp_data;
        }
        return false;
    }

    public function getsmofcp($cp_id)
    {
        $sm_arr = null;
        if (!empty($cp_id)) {
            $smcp_arr = SmCpNetwork::findAll([
                'status' => 1,
                'channelpartner_id' => $cp_id
            ]);
            if (!empty($smcp_arr)) {
                foreach ($smcp_arr as $smcp_arr_val) {
                    $sm_arr[] = $smcp_arr_val->sm_cp_id;
                }
            }
        }
        return $sm_arr;
    }

    public function getbuilderofcp($cp_id)
    {
        $builder_arr = null;
        $get_sm = $this->getsmofcp($cp_id);
        if (!empty($get_sm)) {
            $get_sm_txt = implode(",", $get_sm);
            $getbuilder = SmCp::findAll(array('sm_cp_id' => $get_sm, 'is_deleted' => 0));
            if (!empty($getbuilder)) {
                foreach ($getbuilder as $getbuilder_val) {
                    $builder_arr[] = $getbuilder_val->builder_id;
                }
            }
        }
        return $builder_arr;
    }

    public function getsmcpteam($id, $type = 1)
    {
        $team_arr = null;
        //type 1 for cp 2 for builder
        if (!empty($id)) {
            if ($type == 1) {
                $get_team = SmCp::findAll(array('channelpartner_id' => $id, 'status' => 1, 'is_deleted' => 0));
            } else {
                $get_team = SmCp::findAll(array('builder_id' => $id, 'status' => 1, 'is_deleted' => 0));
            }

            if (!empty($get_team)) {
                foreach ($get_team as $get_team_val) {
                    $team_arr[] = $get_team_val->sm_cp_id;
                }
            }
        }
        return $team_arr;
    }


    public function getlocfromsubtype($loc_subtype_id, $show_names = false)
    {
        $loc_arr = null;
        if (!empty($loc_subtype_id)) {

            $location_arr = (new \yii\db\Query())
                ->select('id,name')
                ->from('location')
                ->where('subtype_id IN(' . $loc_subtype_id . ') AND status=1')
                ->orderBy('name ASC')->createCommand()
                ->queryAll();

            if (!empty($location_arr)) {
                if ($show_names) {
                    foreach ($location_arr as $location_arr_v) {
                        $loc_arr[$location_arr_v['id']] = $location_arr_v['name'];
                    }
                } else {
                    foreach ($location_arr as $location_arr_v) {
                        $loc_arr[] = (int) $location_arr_v['id'];
                    }
                }
            }
        }
        return $loc_arr;
    }


    public function getbookmarkprojects($sm_cp_id)
    {
        $proj = null;
        $getbookmark = SmCpBookmark::findAll([
            'sm_cp_id' => $sm_cp_id,
        ]);
        if (!empty($getbookmark)) {
            foreach ($getbookmark as $getbookmark_val) {
                $proj[] = $getbookmark_val->projects_id;
            }
        }
        return $proj;
    }

    public function getsmofproject($project_id)
    {
        //get sourcing
        $sourcingData = (new \yii\db\Query())
            ->select('sm.sm_cp_id')
            ->from('sm_projects sp')
            ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id')
            ->where('FIND_IN_SET("' . (int) $project_id . '",projects_id) AND sp.status=1 AND sm.staff_type=1 AND sm.is_deleted=0')->groupBy('sp.sm_cp_id')->createCommand()
            ->queryAll();
        $sourcing = null;
        if (!empty($sourcingData)) {
            $s_count = 0;
            foreach ($sourcingData as $sourcingData_val) {
                $sourcing[$s_count] = $sourcingData_val['sm_cp_id'];
                $s_count++;
            }
        }
        return $sourcing;
    }

    public function getprojofmultism($sm_arr)
    {
        $proj_arr = null;
        if (!empty($sm_arr)) {
            $smcp_arr = SmProjects::findAll([
                'status' => 1,
                'sm_cp_id' => $sm_arr
            ]);
            $proj_txt = '';
            foreach ($smcp_arr as $smcp_arr_val) {
                if (!empty($smcp_arr_val->projects_id)) {
                    if ($proj_txt == '') {
                        $proj_txt = $smcp_arr_val->projects_id;
                    } else {
                        $proj_txt .= "," . $smcp_arr_val->projects_id;
                    }
                }
                /* $temp_arr = explode(",", $proj_arr_val->projects_id);
                array_push($proj_arr, $temp_arr); */
            }
            if (!empty($proj_txt)) {
                $proj_arr = array_unique(explode(",", $proj_txt));
            }
        }
        return $proj_arr;
    }

    public function checkcpprojaccess($cp_id, $id)
    {
        $access = false;
        $get_sm = $this->getsmofcp($cp_id);
        if (!empty($get_sm)) {
            $get_proj = $this->getprojofmultism($get_sm);
            if (!empty($get_proj)) {
                if (in_array($id, $get_proj)) {
                    $access = true;
                }
            }
        }
        return $access;
    }

    public function checkcpprojaccessbysm($sm_cp_id, $id)
    {
        $access = false;
        $get_sm[0] = $sm_cp_id;
        if (!empty($get_sm)) {
            $get_proj = $this->getprojofmultism($get_sm);
            if (!empty($get_proj)) {
                if (in_array($id, $get_proj)) {
                    $access = true;
                }
            }
        }
        return $access;
    }

    public function checkcpleadaccess($sm_cp_id, $id)
    {
        $access = false;
        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $get_lead_data = Leadmaster::find()->where(['id' => $id, 'is_deleted' => 0])->one();
        if (!empty($get_lead_data)) {
            $created_by = $get_lead_data->created_by;
            if (in_array($created_by, $get_members)) {
                $access = true;
            }
        }

        return $access;
    }

    public function checkcptagaccess($sm_cp_id, $id, $type = "cp")
    {
        $access = false;
        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $get_tag_data = Taggingmaster::find()->where(['id' => $id, 'is_deleted' => 0])->one();
        if (!empty($get_tag_data)) {
            if ($type == 'cp') {
                $created_by = $get_tag_data->created_by;
                if (in_array($created_by, $get_members)) {
                    $access = true;
                }
            } else if ($type == 'sm') {
                $created_by = $get_tag_data->sm_cp_id;
                if (in_array($created_by, $get_members)) {
                    $access = true;
                }
            } else {
                //for staff
                $get_project = $get_tag_data->project_id;
                $access = $this->checkcpprojaccessbysm($sm_cp_id, $get_project);
            }
        }

        return $access;
    }

    public function checkreferaccess($sm_cp_id, $id)
    {
        $access = false;
        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $get_refer_data = CpRefer::find()->where(['id' => $id])->one();
        if (!empty($get_refer_data)) {

            $created_by = $get_refer_data->sm_cp_id;
            if (in_array($created_by, $get_members)) {
                $access = true;
            }
        }

        return $access;
    }

    public function checkconnectaccess($sm_cp_id, $id)
    {
        $access = false;
        //team cannot access others postings
        //$get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $get_connect_data = CpCustomersFlats::find()->where(['id' => $id])->one();
        if (!empty($get_connect_data)) {

            $created_by = $get_connect_data->sm_cp_id;
            if (in_array($created_by, $get_members)) {
                $access = true;
            }
        }

        return $access;
    }

    public function getamenities()
    {
        $amenities_arr = null;
        $amenitiesData = (new \yii\db\Query())
            ->select('am.id,am.name,am.icon')
            ->from('amenities am')
            ->createCommand()
            ->queryAll();
        $amenities = null;
        if (!empty($amenitiesData)) {
            foreach ($amenitiesData as $amenitiesData_key => $amenitiesData_val) {
                $amenities[$amenitiesData_key] = $amenitiesData_val;
                if (!empty($amenitiesData_val['icon'])) {
                    $amenities[$amenitiesData_key]['icon'] = \Yii::$app->params['upload_amenities_path'] . $amenitiesData_val['icon'];
                }
            }
        }
        $amenities_arr['amenities'] = $amenities;
        return $amenities_arr;
    }

    public function getguidelines()
    {
        $guidelines_arr = null;
        $guideData = (new \yii\db\Query())
            ->select('am.id,am.name,am.filename')
            ->from('guidelinesmaster am')
            ->createCommand()
            ->queryAll();
        $guide = null;
        if (!empty($guideData)) {
            foreach ($guideData as $guideData_key => $guideData_val) {
                $guide[$guideData_key] = $guideData_val;
                if (!empty($guideData_val['filename'])) {
                    $guide[$guideData_key]['filename'] = \Yii::$app->params['upload_guidelines_path'] . $guideData_val['filename'];
                }
            }
        }
        $guidelines_arr['guidelines'] = $guide;
        return $guidelines_arr;
    }

    public function getprojectlistapi($get_user, $querydata, $list_type = '')
    {
        $cp_id = $get_user->channelpartner_id;
        $builder_id = $get_user->builder_id;
        $user_role = $get_user->role;
        $get_sm_cp_id = $get_user->sm_cp_id;
        $is_mgmt = $get_user->mgmt;
        $get_staff_type = $get_user->staff_type;

        $cp_location = '';
        if (!empty($cp_id)) {
            $cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
            if (!empty($cp_data)) {
                $cp_location = $get_user->location_id;
                $is_mgmt = $cp_data->mgmt;
            }
        }

        $sm_cp_id = $get_user->sm_cp_id;
        $project_arr = null;
        if (empty($list_type)) {
            $pagination = null;
            $proj_count = 0;
        }
        $project = null;
        $show_project = true;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        $get_sm = [];
        if (!empty($cp_id)) {
            $get_sm = $this->getsmofcp($cp_id);
            if (empty($get_sm)) {
                //$show_project = false;
            }
        }
        if (!empty($builder_id)) {
            $get_sm[] = $get_sm_cp_id;
        }
        /* echo "<pre>";
        print_r($get_sm);
        exit; */



        if ($show_project) {
            $get_proj = [];
            if (!empty($get_sm)) {
                $get_proj = $this->getprojofmultism($get_sm);
            }
            /* echo "<pre>";
            print_r($get_proj);
            exit; */
            //if (!empty($get_proj)) {
            //pending from here
            $get_proj_txt = '-1';
            if (!empty($get_proj)) {
                $get_proj_txt = implode(",", $get_proj);
            }
            if (!empty($querydata)) {

                $proj_name = (!empty($querydata['name']) ? trim($querydata['name']) : '');
                $proj_type = (!empty($querydata['type']) ? trim($querydata['type']) : '');
                if (empty($builder_id)) {
                    $proj_builder_id = (!empty($querydata['builder_id']) ? trim($querydata['builder_id']) : '');
                } else {
                    $proj_builder_id = $builder_id;
                }
                $proj_min_price = (!empty($querydata['min_price']) ? trim($querydata['min_price']) : '');
                $proj_max_price = (!empty($querydata['max_price']) ? trim($querydata['max_price']) : '');
                $proj_config = (!empty($querydata['config']) ? trim($querydata['config']) : '');
                if (empty($builder_id)) {
                    if ($is_mgmt) {
                    } else {
                        $proj_sm_id = (!empty($querydata['sm_id']) ? trim($querydata['sm_id']) : '');
                        if (!empty($proj_sm_id)) {
                            $sel_sm_arr[0] = $proj_sm_id;
                            $get_proj_sm = $this->getprojofmultism($sel_sm_arr);
                            if (!empty($get_proj_sm)) {
                                $get_proj_txt = implode(",", $get_proj_sm);
                            } else {
                                $get_proj_txt = "-1";
                            }
                        }
                    }
                } else {
                    if (empty($get_proj_txt)) {
                        $get_proj_txt = "-1";
                    }
                }

                $proj_property_type = (!empty($querydata['property_type']) ? trim($querydata['property_type']) : '');
                $proj_amenities = (!empty($querydata['amenities']) ? trim($querydata['amenities']) : '');


                /* $proj_location_id = (!empty($querydata['location_id']) ? implode(",", $querydata['location_id']) : []); */
                $proj_location_id = (!empty($querydata['location_id']) ? trim($querydata['location_id']) : '');
                $proj_location_subtype_id = (!empty($querydata['location_subtype_id']) ? trim($querydata['location_subtype_id']) : '');
            }

            $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'projects.id');
            $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


            $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
            $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
            if ($page == 1) {
                $offset = 0;
            } else {
                $offset = (($page - 1) * $page_count);
            }

            if (!empty($cp_id)) {
                $where_sql = ' projects.status=2 AND b.status=1';
            }
            if (!empty($builder_id)) {
                $where_sql = ' projects.status IN(1,2) AND b.status=1';
            }

            //$where_sql = ' projects.status=1 AND b.status=1';
            if ($is_mgmt) {
                $where_sql .= ' AND projects.builder_id IN(3)';
            } else {

                if (!empty($builder_id) && in_array($builder_id, [3]) && $get_staff_type == 2) {
                    $where_sql .= ' AND projects.builder_id="' . $builder_id . '"';
                } else if (!empty($builder_id) && $user_role == 1) {
                    //leader will have access to all projects
                    $where_sql .= ' AND projects.builder_id="' . $builder_id . '"';
                } else {
                    if (!empty($builder_id)) {
                        $where_sql .= ' AND projects.id IN(' . $get_proj_txt . ')';
                    }
                    //show all projects to CP
                    //$where_sql .= ' AND projects.id IN(' . $get_proj_txt . ')';
                    if (!empty($proj_builder_id)) {
                        $where_sql .= ' AND projects.builder_id="' . $proj_builder_id . '"';
                    }
                }
            }


            if (!empty($proj_name)) {
                $where_sql .= ' AND projects.name like "%' . $proj_name . '%"';
            }

            if (!empty($proj_type)) {
                //$where_sql .= ' AND projects.type="' . $proj_type . '"';
                $where_sql .= ' AND FIND_IN_SET("' . (int) $proj_type . '",projects.type)';
            }
            if (!empty($proj_min_price)) {
                $where_sql .= ' AND m.low_price>=' . $proj_min_price . '';
            }
            if (!empty($proj_max_price)) {
                $where_sql .= ' AND m.low_price<=' . $proj_max_price . '';
            }
            if (!empty($proj_config)) {
                $proj_config_arr = explode(",", $proj_config);
                if (count($proj_config_arr) == 1) {
                    $where_sql .= ' AND FIND_IN_SET("' . (int) $proj_config . '",f.flat_types)';
                } else {
                    $where_sql .= ' AND (';
                    $get_count_config = count($proj_config_arr);
                    $icheck = 1;
                    foreach ($proj_config_arr as $proj_config_arr_val) {
                        $where_sql .= ' FIND_IN_SET("' . (int) $proj_config_arr_val . '",f.flat_types)';
                        if ($icheck != $get_count_config) {
                            $where_sql .= ' OR ';
                        }
                        $icheck++;
                    }
                    $where_sql .= '  )';
                }
            }
            if (!empty($proj_property_type)) {
                $proj_property_type_arr = explode(",", $proj_property_type);
                if (count($proj_property_type_arr) == 1) {
                    $where_sql .= ' AND FIND_IN_SET("' . (int) $proj_property_type . '",fp.flat_property_types)';
                } else {
                    $where_sql .= ' AND (';
                    $get_type_count_config = count($proj_property_type_arr);
                    $icheck_type = 1;
                    foreach ($proj_property_type_arr as $proj_property_type_arr_val) {
                        $where_sql .= ' FIND_IN_SET("' . (int) $proj_property_type_arr_val . '",fp.flat_property_types)';
                        if ($icheck_type != $get_type_count_config) {
                            $where_sql .= ' OR ';
                        }
                        $icheck_type++;
                    }
                    $where_sql .= '  )';
                }
            }

            if (!empty($proj_amenities)) {
                $proj_amenities_arr = explode(",", $proj_amenities);
                if (count($proj_amenities_arr) == 1) {
                    $where_sql .= ' AND FIND_IN_SET("' . (int) $proj_amenities . '",projects.amenities)';
                } else {
                    $where_sql .= ' AND (';
                    $get_count_am = count($proj_amenities_arr);
                    $icheck_am = 1;
                    foreach ($proj_amenities_arr as $proj_amenities_arr_val) {
                        $where_sql .= ' FIND_IN_SET("' . (int) $proj_amenities_arr_val . '",projects.amenities)';
                        if ($icheck_am != $get_count_am) {
                            $where_sql .= ' OR ';
                        }
                        $icheck_am++;
                    }
                    $where_sql .= '  )';
                }
            }

            if (!empty($proj_location_id) || !empty($proj_location_subtype_id)) {
                if (!empty($proj_location_subtype_id) && empty($proj_location_id)) {
                    //get loc array
                    $get_loc_arr = $this->getlocfromsubtype($proj_location_subtype_id);
                    if (!empty($get_loc_arr)) {
                        $get_loc_arr_txt = implode(",", $get_loc_arr);
                        $where_sql .= ' AND projects.location_id IN(' . $get_loc_arr_txt . ')';
                    }
                } else {
                    if (!empty($proj_location_id)) {
                        $where_sql .= ' AND projects.location_id IN(' . $proj_location_id . ')';
                    }
                }
            }
            if (isset($querydata['possession']) && $querydata['possession'] == 'true') {
                $where_sql .= ' AND projects.possession_date<"' . date('Y-m-d') . '"';
            } else if (isset($querydata['possession']) && $querydata['possession'] == 'false') {
                $where_sql .= ' AND projects.possession_date>"' . date('Y-m-d') . '"';
            }


            if (empty($list_type)) {

                if (!empty($cp_location)) {
                    //$sort_text = new Expression("FIELD(projects.location_id, " . $cp_location . ") DESC");
                    //$sort_text = $order_name . ' ' . $order_type;
                    $sort_text = "projects.rank DESC,projects.created_on DESC";
                } else {
                    $sort_text = $order_name . ' ' . $order_type;
                }

                $proj_query = (new \yii\db\Query())
                    ->select('projects.id,projects.name,projects.offer,projects.site_address,projects.possession_date,projects.builder_id,projects.logo_name,projects.type,projects.flat_configuration,projects.project_segment,projects.created_on,m.low_price,ml.total_low_price,f.flat_types,fp.flat_property_types,projects.latlong,projects.whatsapp_brief,projects.location_id,loc.name as location,projects.whatsapp_top,projects.whatsapp_middle,projects.whatsapp_bottom,projects.rera_no,projects.amenities,projects.connectivity,projects.tc,projects.api_show_price,projects.website_address,b.name as builder_name,b.logo as builder_logoval,projects.description_app,projects.signification_app,projects.project_description,projects.signification,projects.show_carpet')
                    ->from('projects')
                    ->leftJoin("(select MIN(base_price) as low_price,projects_id from flat WHERE status=1  group by projects_id ) m", 'm.projects_id=projects.id ')
                    ->leftJoin("(select MIN(total_charge) as total_low_price,projects_id from flat WHERE status=1 group by projects_id ) ml", 'ml.projects_id=projects.id ')
                    /* ->leftJoin("(select sdp.name as primary_banner,sdp.projects_id from snse_dooits_photo sdp where sdp.default=2 group by sdp.projects_id ) sp", 'sp.projects_id=projects.id') */
                    ->leftJoin("(select GROUP_CONCAT(flat_type_id) as flat_types,projects_id from flat WHERE status=1 GROUP by projects_id ) f", 'f.projects_id=projects.id')
                    ->leftJoin("location as loc", 'projects.location_id = loc.id')
                    ->leftJoin("builder as b", 'projects.builder_id = b.id')
                    ->leftJoin("(select GROUP_CONCAT(property_type) as flat_property_types,projects_id from flat WHERE status=1 GROUP by projects_id ) fp", 'fp.projects_id=projects.id')
                    ->where($where_sql)
                    ->orderBy($sort_text);
                $proj_count = $proj_query->count();
                /* echo $proj_count;
                exit; */
                $proj_data = $proj_query->limit($page_count)->offset($offset)->createCommand()
                    /* ->getRawsql();
                echo $proj_data;
                exit; */
                    ->queryAll();
            } else {
                $proj_query = (new \yii\db\Query())
                    ->select('projects.id,projects.name,projects.whatsapp_brief,projects.api_show_price,projects.show_carpet')
                    ->from('projects')
                    ->leftJoin("(select MIN(base_price) as low_price,projects_id from flat WHERE status=1  group by projects_id ) m", 'm.projects_id=projects.id')
                    ->leftJoin("(select GROUP_CONCAT(flat_type_id) as flat_types,projects_id from flat WHERE status=1 GROUP by projects_id ) f", 'f.projects_id=projects.id')
                    ->leftJoin("(select GROUP_CONCAT(property_type) as flat_property_types,projects_id from flat WHERE status=1 GROUP by projects_id ) fp", 'fp.projects_id=projects.id')
                    ->leftJoin("builder as b", 'projects.builder_id = b.id')
                    ->where($where_sql)
                    ->orderBy($order_name . ' ' . $order_type);

                $proj_data = $proj_query->createCommand()
                    ->queryAll();
            }

            /* echo "<pre>";
                print_r($proj_data);
                exit; */
            if (!empty($proj_data)) {
                //$check_proj_count = 0;      //added for testing
                //$check_multi_count = 1;     //added for testing
                //while ($check_multi_count < 6) {    //added for testing
                foreach ($proj_data as $proj_data_key => $proj_data_val) {
                    //$proj_data_key = $check_proj_count;     //added for testing
                    $project[$proj_data_key] = $proj_data_val;

                    if (empty($list_type)) {

                        //get banner
                        $getbanner = SnseBanner::findOne([
                            'projects_id' => $proj_data_val['id'],
                            'status' => 1
                        ]);
                        if (!empty($getbanner)) {
                            $project[$proj_data_key]['banner'] = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                        } else {
                            $project[$proj_data_key]['banner'] = null;
                        }

                        if (!empty($proj_data_val['offer'])) {
                            $project[$proj_data_key]['offer'] = $proj_data_val['offer'];
                        } else {
                            $project[$proj_data_key]['offer'] = null;
                        }

                        if (!empty($proj_data_val['builder_logoval'])) {
                            $project[$proj_data_key]['builder_logo'] = \Yii::$app->params['web_path'] . "project-img/" . $proj_data_val['builder_logoval'];
                        } else {
                            $project[$proj_data_key]['builder_logo'] = null;
                        }


                        if (!empty($proj_data_val['possession_date']) && $proj_data_val['possession_date'] != '0000-00-00') {
                            $project[$proj_data_key]['possession_date'] = $proj_data_val['possession_date'];
                        } else {
                            $project[$proj_data_key]['possession_date'] = null;
                        }

                        /* if (!empty($proj_data_val['primary_banner'])) {
                                $project[$proj_data_key]['banner'] = \Yii::$app->params['upload_file_path'] . $proj_data_val['primary_banner'];
                                } */
                        $builder_data = Builder::find()->select('name')->where(['id' => $proj_data_val['builder_id']])->one();
                        if (!empty($builder_data)) {
                            $project[$proj_data_key]['builder'] = $builder_data->name;
                        } else {
                            $project[$proj_data_key]['builder'] = '';
                        }

                        if (!empty($proj_data_val['type'])) {
                            $proj_type = explode(",", $proj_data_val['type']);
                            $proj_type_txt = '';
                            foreach ($proj_type as $proj_type_val) {
                                if (empty($proj_type_txt)) {
                                    $proj_type_txt = $this->project_type[$proj_type_val];
                                } else {
                                    $proj_type_txt .= "," . $this->project_type[$proj_type_val];
                                }
                            }
                            $project[$proj_data_key]['type'] = $proj_type_txt;
                        }

                        if ($proj_data_val['api_show_price'] == 1) {
                            $project[$proj_data_key]['price'] = $proj_data_val['low_price'];
                        } else if ($proj_data_val['api_show_price'] == 2) {
                            $project[$proj_data_key]['price'] = $proj_data_val['total_low_price'];
                        } else if ($proj_data_val['api_show_price'] == 3) {
                            $project[$proj_data_key]['price'] = $proj_data_val['total_low_price'];
                        } else {
                            $project[$proj_data_key]['price'] = $proj_data_val['low_price'];
                        }

                        $project[$proj_data_key]['priceinwords'] = $this->AmountInWords($project[$proj_data_key]['price']);


                        if (!empty($proj_data_val['project_segment'])) {
                            $project[$proj_data_key]['project_segment'] = $this->project_segment[$proj_data_val['project_segment']];
                        }

                        $project[$proj_data_key]['bookmark'] = 'false';
                        $getbookmark = SmCpBookmark::findOne([
                            'sm_cp_id' => $sm_cp_id,
                            'projects_id' => $proj_data_val['id'],
                        ]);
                        if (!empty($getbookmark)) {
                            $project[$proj_data_key]['bookmark'] = 'true';
                        }
                    }

                    //get sourcing
                    $sourcingData = (new \yii\db\Query())
                        ->select('sm.sm_cp_id,sm.name,sm.role,sm.contact')
                        ->from('sm_projects sp')
                        ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id')
                        ->where('FIND_IN_SET("' . (int) $proj_data_val['id'] . '",projects_id) AND sp.status=1 AND sm.staff_type=1 AND sm.status=1 AND sm.is_deleted=0')->groupBy('sp.sm_cp_id')->createCommand()
                        ->queryAll();
                    $sourcing = null;
                    $sourcingbyrole = null;
                    $final_sourcing = null;
                    if (!empty($sourcingData)) {
                        $s_count = 0;
                        foreach ($sourcingData as $sourcingData_val) {
                            //add comment in live when all project list is shown 
                            //if (in_array($sourcingData_val['sm_cp_id'], $get_sm)) {
                            $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                            $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                            $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                            $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                            $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                            $s_count++;
                            //}
                        }
                        //Show executive first, then manager then Leader
                        if (isset($sourcingbyrole[3])) {
                            $final_sourcing[0] = $sourcingbyrole[3];
                        } else if (isset($sourcingbyrole[2])) {
                            $final_sourcing[0] = $sourcingbyrole[2];
                        } else if (isset($sourcingbyrole[1])) {
                            $final_sourcing[0] = $sourcingbyrole[1];
                        }

                        $project[$proj_data_key]['sourcing'] = $final_sourcing;
                    }

                    //Show SM connected
                    if (!empty($cp_id)) {
                        $sm_connected = 'false';
                        if (!empty($get_proj)) {
                            if (in_array($proj_data_val['id'], $get_proj)) {
                                $sm_connected = 'true';
                            }
                        }
                        $project[$proj_data_key]['sm_connected'] = $sm_connected;
                    } else {
                        $project[$proj_data_key]['sm_connected'] = 'true';
                    }




                    //get base price of lowest flat
                    $flatData = (new \yii\db\Query())
                        ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge,flat.balconies')
                        ->from('flat')
                        ->where('flat.projects_id="' . $proj_data_val['id'] . '" AND flat.status=1')
                        ->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                        ->queryAll();

                    $lowest_flat_base_price = "";
                    $lowest_flat_total_price = "";
                    if (!empty($flatData)) {
                        $flat_type_list_arr = [];
                        $flat_count = 1;
                        foreach ($flatData as $flatData_v) {
                            $flat_type_list_arr[] = (int) $flatData_v['flat_type_id'];
                            if (empty($lowest_flat_base_price)) {
                                if ($flatData_v['property_type'] == 1) {
                                    $lowest_flat_base_price = $flatData_v['base_price'];
                                    $lowest_flat_total_price = $flatData_v['total_charge'];
                                }
                            }
                            $flat_count++;
                        }
                        $flat_type_list_arr = array_unique($flat_type_list_arr);
                        $final_flat_type = [];
                        foreach ($flat_type_list_arr as $flat_type_list_arr_val) {
                            if (in_array($flat_type_list_arr_val, array_keys($this->flat_type_id))) {
                                $final_flat_type[$flat_type_list_arr_val] = $this->flat_type_id[$flat_type_list_arr_val];
                            }
                        }
                        $project[$proj_data_key]['flat_type'] = $final_flat_type;
                    }

                    if (!empty($lowest_flat_base_price)) {
                        if ($proj_data_val['api_show_price'] == 1) {
                            $project[$proj_data_key]['price'] = $lowest_flat_base_price;
                        } else if ($proj_data_val['api_show_price'] == 2) {
                            $project[$proj_data_key]['price'] = $lowest_flat_total_price;
                        } else if ($proj_data_val['api_show_price'] == 3) {
                            $project[$proj_data_key]['price'] = $lowest_flat_total_price;
                        } else {
                            $project[$proj_data_key]['price'] = $lowest_flat_base_price;
                        }

                        $project[$proj_data_key]['priceinwords'] = $this->AmountInWords($project[$proj_data_key]['price']);
                    }

                    //updating lat long
                    $project[$proj_data_key]['lat'] = null;
                    $project[$proj_data_key]['long'] = null;
                    if (!empty($project[$proj_data_key]['latlong'])) {
                        $getlat_long = explode(",", $project[$proj_data_key]['latlong']);
                        $project[$proj_data_key]['lat'] = !(empty($getlat_long[0])) ? trim($getlat_long[0]) : "";
                        $project[$proj_data_key]['long'] = !empty($getlat_long[1]) ? trim($getlat_long[1]) : "";
                    }

                    /* if (!empty($proj_data_key['whatsapp_brief'])) {
                        $get_whatsapp_brief = trim(preg_replace('/\s+/', ' ', $proj_data_key['whatsapp_brief']));
                        $project[$proj_data_key]['whatsapp_brief'] = $get_whatsapp_brief;
                    } */

                    if (empty($list_type)) {
                        //whatsapp brief start---------
                        $get_whatsapp_brief = "";
                        //$set_br = "\n\n";
                        $set_br = PHP_EOL;
                        $projname = "*" . $project[$proj_data_key]['name'] . "*" . $set_br . $set_br;
                        $whatsapptop =  $project[$proj_data_key]['whatsapp_top'];
                        if (!empty($whatsapptop)) {
                            $whatsapptop = $whatsapptop . $set_br . $set_br;
                        }
                        $flat_txt = '';
                        if (!empty($flatData)) {
                            $flat_txt .= "*Configurations*" . $set_br;

                            foreach ($flatData as $flatData_val) {
                                $get_sp_flat_type_id = !empty($flatData_val['flat_type_id']) ? $flatData_val['flat_type_id'] : "";

                                $balcony_txt = "";
                                if (!empty($flatData_val['balconies'])) {
                                    $balcony_txt = " & " . $flatData_val['balconies'] . " BAL";
                                }

                                $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] . $balcony_txt : "";

                                $get_carpet_txt = "";
                                if ($proj_data_val['show_carpet'] == 1) {
                                    $get_carpet_txt = " - " . $flatData_val['carpet_area'] . " Carpet";
                                }



                                if ($proj_data_val['api_show_price'] == 1) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards" . $set_br;
                                } else if ($proj_data_val['api_show_price'] == 2) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . $set_br;
                                } else if ($proj_data_val['api_show_price'] == 3) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . $set_br;
                                }
                            }
                        }
                        $config = $flat_txt;
                        $rera = "*RERA Number - " .  $project[$proj_data_key]['rera_no'] . "*";


                        //get amenities
                        $amenities_txt = "";
                        $amenity_list = "";
                        if (!empty($project[$proj_data_key]['amenities'])) {
                            $amenitiesData = (new \yii\db\Query())
                                ->select('name')
                                ->from('amenities')
                                ->where("id IN(" . $project[$proj_data_key]['amenities'] . ") AND status=1")->createCommand()
                                ->queryAll();


                            if (!empty($amenitiesData)) {
                                foreach ($amenitiesData as $amenitiesData_val) {
                                    $amenities_txt .= $amenitiesData_val['name'] . $set_br;
                                }
                            }
                            if (!empty($amenities_txt)) {
                                $amenity_list = "*Modern Amenities*" . $set_br . $amenities_txt;
                            }
                        }

                        $whatsappmiddle = $project[$proj_data_key]['whatsapp_middle'];
                        if (!empty($whatsappmiddle)) {
                            $whatsappmiddle = $whatsappmiddle . $set_br;
                        }
                        $connectivity = "*Connectivity*" . $set_br . $project[$proj_data_key]['connectivity'];
                        $whatsappbottom = $project[$proj_data_key]['whatsapp_bottom'];
                        $get_whatsapp_brief = $projname . $whatsapptop . $config . $set_br . $rera . $set_br . $set_br . $amenity_list . $set_br . $connectivity  . $set_br . $whatsappmiddle  . $set_br . $whatsappbottom;
                        //$get_whatsapp_brief = $projname . $whatsapptop;
                        //$get_whatsapp_brief = trim(preg_replace('/\s+/', ' ', $get_whatsapp_brief));
                        $get_whatsapp_brief = trim($get_whatsapp_brief);
                        $project[$proj_data_key]['whatsapp_brief'] = $get_whatsapp_brief;
                        //whatsapp brief end---------
                    }

                    //sharing start
                    $project_share = null;
                    $proj_desc = null;
                    if (!empty($proj_data_val['description_app'])) {
                        $proj_desc = $proj_data_val['description_app'] . PHP_EOL;
                    } else if (!empty($proj_data_val['project_description'])) {
                        $proj_desc = $proj_data_val['project_description'] . PHP_EOL;
                    }
                    $proj_flat_details = null;


                    $flatData = (new \yii\db\Query())
                        ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge,flat.balconies')
                        ->from('flat')
                        ->where('flat.projects_id="' . $proj_data_val['id'] . '" AND flat.status=1 AND flat.property_type=1')
                        ->orderBy('flat.total_charge ASC')->createCommand()
                        //->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                        ->queryAll();

                    $flat_txt = '';
                    if (!empty($flatData)) {
                        $flat_txt .= "*Configurations*" . PHP_EOL;

                        foreach ($flatData as $flatData_val) {

                            $balcony_txt = "";
                            if (!empty($flatData_val['balconies'])) {
                                $balcony_txt = " & " . $flatData_val['balconies'] . " BAL";
                            }

                            $get_carpet_txt = "";
                            if ($proj_data_val['show_carpet'] == 1) {
                                $get_carpet_txt = " - " . $flatData_val['carpet_area'] . " Carpet";
                            }

                            $get_sp_flat_type_id = !empty($flatData_val['flat_type_id']) ? $flatData_val['flat_type_id'] : "";
                            $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] . $balcony_txt : "";


                            if ($proj_data_val['api_show_price'] == 1) {

                                $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards" . PHP_EOL;
                            } else if ($proj_data_val['api_show_price'] == 2) {

                                $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . PHP_EOL;
                            } else if ($proj_data_val['api_show_price'] == 3) {

                                $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . PHP_EOL;
                            }
                        }
                    }


                    $proj_flat_details = $flat_txt;

                    $proj_commercial_details = null;


                    $shopData = (new \yii\db\Query())
                        ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge')
                        ->from('flat')
                        ->where('flat.projects_id="' . $proj_data_val['id'] . '" AND flat.status=1 AND flat.property_type!=1')
                        ->orderBy('flat.total_charge ASC')->createCommand()
                        //->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                        ->queryAll();

                    $shop_txt = '';
                    if (!empty($shopData)) {
                        $shop_txt .= "*Configurations*" . PHP_EOL;

                        foreach ($shopData as $shopData_val) {
                            $get_sp_flat_type_id = !empty($shopData_val['flat_type_id']) ? $shopData_val['flat_type_id'] : "";
                            $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $shopData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] : "";

                            $get_carpet_txt = "";
                            if ($proj_data_val['show_carpet'] == 1) {
                                $get_carpet_txt = " - " . $shopData_val['carpet_area'] . " Carpet";
                            }

                            if ($proj_data_val['api_show_price'] == 1) {

                                $shop_txt .= "* " . $this->flat_property_type[$shopData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($shopData_val['base_price']) . "* Onwards" . PHP_EOL;
                            } else if ($proj_data_val['api_show_price'] == 2) {

                                $shop_txt .= "* " . $this->flat_property_type[$shopData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", All Inclusive Price -" . $this->AmountInWords($shopData_val['total_charge']) . "" . PHP_EOL;
                            } else if ($proj_data_val['api_show_price'] == 3) {

                                $shop_txt .= "* " . $this->flat_property_type[$shopData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($shopData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($shopData_val['total_charge']) . "" . PHP_EOL;
                            }
                        }
                    }

                    $proj_commercial_details = $shop_txt;

                    //$proj_commercial_details = $project['commercial_details'] . PHP_EOL;

                    $proj_connectivity = null;
                    if (!empty($proj_data_val['connectivity'])) {
                        $proj_connectivity = nl2br($proj_data_val['connectivity']) . PHP_EOL;
                    }
                    $proj_signification = null;
                    if (!empty($proj_data_val['signification_app'])) {
                        $proj_signification = $proj_data_val['signification_app'] . PHP_EOL;
                    } else if (!empty($proj_data_val['signification'])) {
                        $proj_signification = $proj_data_val['signification'] . PHP_EOL;
                    }

                    $share_count = 0;
                    if (!empty($proj_desc)) {
                        $project_share[$share_count]['title'] = "Details";
                        $project_share[$share_count]['content'] =  PHP_EOL . "*Project Details*" . PHP_EOL . "\r\n" . nl2br($proj_desc) . PHP_EOL;
                        $share_count++;
                    }
                    if (!empty($proj_flat_details)) {
                        $project_share[$share_count]['title'] = "Flat Details";
                        $project_share[$share_count]['content'] =  PHP_EOL . "*Flat Details*" . "\r\n" . nl2br($proj_flat_details) . PHP_EOL;
                        $share_count++;
                    }
                    if (!empty($proj_commercial_details)) {
                        $project_share[$share_count]['title'] = "Commercial Details";
                        $project_share[$share_count]['content'] =  PHP_EOL . "*Commercial Details*" . "\r\n" . nl2br($proj_commercial_details) . PHP_EOL;
                        $share_count++;
                    }
                    if (!empty($proj_connectivity)) {
                        $project_share[$share_count]['title'] = "Connectivity";
                        $project_share[$share_count]['content'] = "\r\n" . PHP_EOL . "*Connectivity*" . "\r\n" . PHP_EOL . $proj_connectivity . PHP_EOL;
                        $share_count++;
                    }
                    if (!empty($proj_signification)) {
                        $project_share[$share_count]['title'] = "Features";
                        $project_share[$share_count]['content'] = PHP_EOL . "\r\n" . "*Features*" . "\r\n" . PHP_EOL . nl2br($proj_signification) . PHP_EOL;
                        $share_count++;
                    }



                    if (!empty($amenity_list)) {
                        $project_share[$share_count]['title'] = "Amenities";
                        $project_share[$share_count]['content'] = PHP_EOL . "\r\n" . "*Amenities*" . "\r\n" . PHP_EOL . nl2br($amenity_list) . PHP_EOL;
                    }


                    $project[$proj_data_key]['project_share'] = $project_share;




                    if (empty($list_type)) {
                        unset($project[$proj_data_key]['logo_name'], $project[$proj_data_key]['low_price'], $project[$proj_data_key]['builder_id'], $project[$proj_data_key]['flat_types'], $project[$proj_data_key]['flat_property_types'],  $project[$proj_data_key]['latlong']);
                    }

                    //$check_proj_count++;    //added for testing
                }
                //$check_multi_count++;       //added for testing
                //}       //added for testing
            }

            /* echo "<pre>";
                print_r($project);
                exit; */

            if (empty($list_type)) {
                //pagination code start
                $pgdata['page'] = $page;
                //$pgdata['content_count'] = $proj_count * 5;     //added for testing
                $pgdata['content_count'] = $proj_count;
                $pgdata['page_count'] = $page_count;
                $pagination = $this->getpagination($pgdata);
                //pagination code end
            }

            /* echo "<pre>";
                print_r($project);
                exit; */
            //}
        }

        $project_arr['project'] = $project;
        if (empty($list_type)) {
            $project_arr['pagination'] = $pagination;
            $project_arr['total_count'] = $proj_count;
        }

        return $project_arr;
    }

    public function getprojectlistbookmarkapi($get_user, $querydata)
    {
        $cp_id = $get_user->channelpartner_id;
        $builder_id = $get_user->builder_id;
        $sm_cp_id = $get_user->sm_cp_id;
        $project_arr = null;
        $pagination = null;
        $project = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        if (!empty($cp_id)) {
            $get_sm = $this->getsmofcp($cp_id);
        } else {
            $get_sm[] = $sm_cp_id;
        }
        if (!empty($get_sm)) {
            $get_proj_sm = $this->getprojofmultism($get_sm);

            $get_proj_book = $this->getbookmarkprojects($sm_cp_id);
            $get_proj = [];
            if (!empty($get_proj_book)) {
                $get_proj = array_intersect($get_proj_book, $get_proj_sm);
            }

            if (!empty($get_proj)) {
                //pending from here
                $get_proj_txt = implode(",", $get_proj);
                if (!empty($querydata)) {
                    $proj_name = (!empty($querydata['name']) ? trim($querydata['name']) : '');
                    $proj_type = (!empty($querydata['type']) ? trim($querydata['type']) : '');
                    $proj_builder_id = (!empty($querydata['builder_id']) ? trim($querydata['builder_id']) : '');
                    $proj_min_price = (!empty($querydata['min_price']) ? trim($querydata['min_price']) : '');
                    $proj_max_price = (!empty($querydata['max_price']) ? trim($querydata['max_price']) : '');
                    $proj_config = (!empty($querydata['config']) ? trim($querydata['config']) : '');
                    /* $proj_location_id = (!empty($querydata['location_id']) ? implode(",", $querydata['location_id']) : []); */
                    $proj_location_id = (!empty($querydata['location_id']) ? trim($querydata['location_id']) : '');
                }

                $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'projects.name');
                $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'ASC');


                $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
                $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
                if ($page == 1) {
                    $offset = 0;
                } else {
                    $offset = (($page - 1) * $page_count);
                }

                if (!empty($cp_id)) {
                    $where_sql = 'projects.id IN(' . $get_proj_txt . ') AND projects.status=2 ';
                }
                if (!empty($builder_id)) {
                    $where_sql = 'projects.id IN(' . $get_proj_txt . ') AND projects.status IN(1,2) ';
                }

                //$where_sql = 'projects.id IN(' . $get_proj_txt . ') AND projects.status=1 ';
                if (!empty($proj_name)) {
                    $where_sql .= ' AND projects.name like "%' . $proj_name . '%"';
                }
                if (!empty($proj_type)) {
                    $where_sql .= ' AND projects.type="' . $proj_type . '"';
                }
                if (!empty($proj_builder_id)) {
                    $where_sql .= ' AND projects.builder_id="' . $proj_builder_id . '"';
                }
                if (!empty($proj_min_price)) {
                    $where_sql .= ' AND m.low_price>=' . $proj_min_price . '';
                }
                if (!empty($proj_max_price)) {
                    $where_sql .= ' AND m.low_price<=' . $proj_max_price . '';
                }
                if (!empty($proj_config)) {
                    $where_sql .= ' AND FIND_IN_SET("' . (int) $proj_config . '",f.flat_types)';
                }
                if (!empty($proj_location_id)) {
                    $where_sql .= ' AND projects.location_id IN(' . $proj_location_id . ')';
                }
                if (isset($querydata['possession']) && $querydata['possession'] == 'true') {
                    $where_sql .= ' AND projects.possession_date<"' . date('Y-m-d') . '"';
                } else if (isset($querydata['possession']) && $querydata['possession'] == 'false') {
                    $where_sql .= ' AND projects.possession_date>"' . date('Y-m-d') . '"';
                }



                $proj_query = (new \yii\db\Query())
                    ->select('projects.id,projects.name,projects.offer,projects.site_address,projects.possession_date,projects.builder_id,projects.logo_name,projects.type,projects.flat_configuration,projects.project_segment,projects.created_on,m.low_price,ml.total_low_price,f.flat_types,fp.flat_property_types,projects.latlong,projects.whatsapp_brief,projects.location_id,loc.name as location,projects.whatsapp_top,projects.whatsapp_middle,projects.whatsapp_bottom,projects.rera_no,projects.amenities,projects.connectivity,projects.tc,projects.api_show_price,projects.website_address,b.name as builder_name,b.logo as builder_logoval,projects.description_app,projects.signification_app,projects.project_description,projects.signification,projects.show_carpet')
                    ->from('projects')
                    ->leftJoin("(select MIN(base_price) as low_price,projects_id from flat WHERE status=1  group by projects_id ) m", 'm.projects_id=projects.id')
                    ->leftJoin("(select MIN(total_charge) as total_low_price,projects_id from flat WHERE status=1 group by projects_id ) ml", 'ml.projects_id=projects.id ')
                    /* ->leftJoin("(select sdp.name as primary_banner,sdp.projects_id from snse_dooits_photo sdp where sdp.default=2 group by sdp.projects_id ) sp", 'sp.projects_id=projects.id') */
                    ->leftJoin("(select GROUP_CONCAT(flat_type_id) as flat_types,projects_id from flat WHERE status=1 GROUP by projects_id ) f", 'f.projects_id=projects.id')
                    ->leftJoin("location as loc", 'projects.location_id = loc.id')
                    ->leftJoin("builder as b", 'projects.builder_id = b.id')
                    ->leftJoin("(select GROUP_CONCAT(property_type) as flat_property_types,projects_id from flat WHERE status=1 GROUP by projects_id ) fp", 'fp.projects_id=projects.id')
                    ->where($where_sql)
                    ->orderBy($order_name . ' ' . $order_type);
                $proj_count = $proj_query->count();
                /* echo $proj_count;
                exit; */
                $proj_data = $proj_query->limit($page_count)->offset($offset)->createCommand()
                    /* ->getRawsql();
                echo $proj_data;
                exit; */
                    ->queryAll();

                if (!empty($proj_data)) {
                    foreach ($proj_data as $proj_data_key => $proj_data_val) {
                        $project[$proj_data_key] = $proj_data_val;

                        if (!empty($proj_data_val['offer'])) {
                            $project[$proj_data_key]['offer'] = $proj_data_val['offer'];
                        } else {
                            $project[$proj_data_key]['offer'] = null;
                        }

                        //get banner
                        $getbanner = SnseBanner::findOne([
                            'projects_id' => $proj_data_val['id'],
                            'status' => 1
                        ]);
                        if (!empty($getbanner)) {
                            $project[$proj_data_key]['banner'] = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner->name;
                        } else {
                            $project[$proj_data_key]['banner'] = null;
                        }

                        if (!empty($proj_data_val['builder_logoval'])) {
                            $project[$proj_data_key]['builder_logo'] = \Yii::$app->params['web_path'] . "project-img/" . $proj_data_val['builder_logoval'];
                        } else {
                            $project[$proj_data_key]['builder_logo'] = null;
                        }


                        if (!empty($proj_data_val['possession_date']) && $proj_data_val['possession_date'] != '0000-00-00') {
                            $project[$proj_data_key]['possession_date'] = $proj_data_val['possession_date'];
                        } else {
                            $project[$proj_data_key]['possession_date'] = null;
                        }


                        /* if (!empty($proj_data_val['primary_banner'])) {
                            $project[$proj_data_key]['banner'] = \Yii::$app->params['upload_file_path'] . $proj_data_val['primary_banner'];
                        } */
                        $builder_data = Builder::find()->select('name')->where(['id' => $proj_data_val['builder_id']])->one();
                        if (!empty($builder_data)) {
                            $project[$proj_data_key]['builder'] = $builder_data->name;
                        } else {
                            $project[$proj_data_key]['builder'] = '';
                        }

                        if (!empty($proj_data_val['type'])) {
                            $proj_type = explode(",", $proj_data_val['type']);
                            $proj_type_txt = '';
                            foreach ($proj_type as $proj_type_val) {
                                if (empty($proj_type_txt)) {
                                    $proj_type_txt = $this->project_type[$proj_type_val];
                                } else {
                                    $proj_type_txt .= "," . $this->project_type[$proj_type_val];
                                }
                            }
                            $project[$proj_data_key]['type'] = $proj_type_txt;
                        }
                        /*  if (!empty($proj_data_val['low_price'])) {
                            $project[$proj_data_key]['price'] = $proj_data_val['low_price'];
                            $project[$proj_data_key]['priceinwords'] = $this->AmountInWords($proj_data_val['low_price']);
                        } */

                        if ($proj_data_val['api_show_price'] == 1) {
                            $project[$proj_data_key]['price'] = $proj_data_val['low_price'];
                        } else if ($proj_data_val['api_show_price'] == 2) {
                            $project[$proj_data_key]['price'] = $proj_data_val['total_low_price'];
                        } else if ($proj_data_val['api_show_price'] == 3) {
                            $project[$proj_data_key]['price'] = $proj_data_val['total_low_price'];
                        } else {
                            $project[$proj_data_key]['price'] = $proj_data_val['low_price'];
                        }

                        $project[$proj_data_key]['priceinwords'] = $this->AmountInWords($project[$proj_data_key]['price']);


                        if (!empty($proj_data_val['project_segment'])) {
                            $project[$proj_data_key]['project_segment'] = $this->project_segment[$proj_data_val['project_segment']];
                        }


                        //get sourcing
                        $sourcingData = (new \yii\db\Query())
                            ->select('sm.sm_cp_id,sm.name,sm.role,sm.contact')
                            ->from('sm_projects sp')
                            ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id')
                            ->where('FIND_IN_SET("' . (int) $proj_data_val['id'] . '",projects_id) AND sp.status=1 AND sm.staff_type=1 AND sm.status=1 AND sm.is_deleted=0')->groupBy('sp.sm_cp_id')->createCommand()
                            ->queryAll();
                        /* $sourcing = null;
                        if (!empty($sourcingData)) {
                            $s_count = 0;
                            foreach ($sourcingData as $sourcingData_val) {
                                $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                $s_count++;
                            }
                            $project[$proj_data_key]['sourcing'] = $sourcing;
                        } */

                        $sourcing = null;
                        $sourcingbyrole = null;
                        $final_sourcing = null;
                        if (!empty($sourcingData)) {
                            $s_count = 0;
                            foreach ($sourcingData as $sourcingData_val) {
                                if (in_array($sourcingData_val['sm_cp_id'], $get_sm)) {
                                    $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                    $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                    $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                    $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                    $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                                    $s_count++;
                                }
                            }
                            //Show executive first, then manager then Leader
                            if (isset($sourcingbyrole[3])) {
                                $final_sourcing[0] = $sourcingbyrole[3];
                            } else if (isset($sourcingbyrole[2])) {
                                $final_sourcing[0] = $sourcingbyrole[2];
                            } else if (isset($sourcingbyrole[1])) {
                                $final_sourcing[0] = $sourcingbyrole[1];
                            }

                            $project[$proj_data_key]['sourcing'] = $final_sourcing;
                        }

                        //Show SM connected
                        if (!empty($cp_id)) {
                            $sm_connected = 'false';
                            if (!empty($get_proj)) {
                                if (in_array($proj_data_val['id'], $get_proj)) {
                                    $sm_connected = 'true';
                                }
                            }
                            $project[$proj_data_key]['sm_connected'] = $sm_connected;
                        } else {
                            $project[$proj_data_key]['sm_connected'] = 'true';
                        }




                        //get base price of lowest flat
                        $flatData = (new \yii\db\Query())
                            ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge,flat.balconies')
                            ->from('flat')
                            ->where('flat.projects_id="' . $proj_data_val['id'] . '" AND flat.status=1')
                            ->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                            ->queryAll();

                        $lowest_flat_base_price = "";
                        $lowest_flat_total_price = "";
                        if (!empty($flatData)) {
                            $flat_type_list_arr = [];
                            $flat_count = 1;
                            foreach ($flatData as $flatData_v) {
                                $flat_type_list_arr[] = (int) $flatData_v['flat_type_id'];
                                if (empty($lowest_flat_base_price)) {
                                    if ($flatData_v['property_type'] == 1) {
                                        $lowest_flat_base_price = $flatData_v['base_price'];
                                        $lowest_flat_total_price = $flatData_v['total_charge'];
                                    }
                                }
                                $flat_count++;
                            }
                            $flat_type_list_arr = array_unique($flat_type_list_arr);
                            $final_flat_type = [];
                            foreach ($flat_type_list_arr as $flat_type_list_arr_val) {
                                if (in_array($flat_type_list_arr_val, array_keys($this->flat_type_id))) {
                                    $final_flat_type[$flat_type_list_arr_val] = $this->flat_type_id[$flat_type_list_arr_val];
                                }
                            }
                            $project[$proj_data_key]['flat_type'] = $final_flat_type;
                        }

                        if (!empty($lowest_flat_base_price)) {
                            if ($proj_data_val['api_show_price'] == 1) {
                                $project[$proj_data_key]['price'] = $lowest_flat_base_price;
                            } else if ($proj_data_val['api_show_price'] == 2) {
                                $project[$proj_data_key]['price'] = $lowest_flat_total_price;
                            } else if ($proj_data_val['api_show_price'] == 3) {
                                $project[$proj_data_key]['price'] = $lowest_flat_total_price;
                            } else {
                                $project[$proj_data_key]['price'] = $lowest_flat_base_price;
                            }

                            $project[$proj_data_key]['priceinwords'] = $this->AmountInWords($project[$proj_data_key]['price']);
                        }


                        //updating lat long
                        $project[$proj_data_key]['lat'] = null;
                        $project[$proj_data_key]['long'] = null;
                        if (!empty($project[$proj_data_key]['latlong'])) {
                            $getlat_long = explode(",", $project[$proj_data_key]['latlong']);
                            $project[$proj_data_key]['lat'] = !(empty($getlat_long[0])) ? trim($getlat_long[0]) : "";
                            $project[$proj_data_key]['long'] = !empty($getlat_long[1]) ? trim($getlat_long[1]) : "";
                        }

                        /* if (!empty($proj_data_key['whatsapp_brief'])) {
                            $get_whatsapp_brief = trim(preg_replace('/\s+/', ' ', $proj_data_key['whatsapp_brief']));
                            $project[$proj_data_key]['whatsapp_brief'] = $get_whatsapp_brief;
                        } */



                        //whatsapp brief start---------
                        $get_whatsapp_brief = "";
                        //$set_br = "\n\n";
                        $set_br = PHP_EOL;
                        $projname = "*" . $project[$proj_data_key]['name'] . "*" . $set_br . $set_br;
                        $whatsapptop =  $project[$proj_data_key]['whatsapp_top'];
                        if (!empty($whatsapptop)) {
                            $whatsapptop = $whatsapptop . $set_br . $set_br;
                        }
                        $flat_txt = '';
                        /* if (!empty($flatData)) {
                            $flat_txt .= "*Configurations*" . $set_br;

                            foreach ($flatData as $flatData_val) {
                                $get_sp_flat_type_id = !empty($flatData_val['flat_type_id']) ? $flatData_val['flat_type_id'] : "";
                                $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] : "";

                                $flat_txt .= $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . " - " . $flatData_val['carpet_area'] . " Carpet, Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards" . $set_br;
                            }
                        } */
                        if (!empty($flatData)) {
                            $flat_txt .= "*Configurations*" . $set_br;

                            foreach ($flatData as $flatData_val) {
                                $get_sp_flat_type_id = !empty($flatData_val['flat_type_id']) ? $flatData_val['flat_type_id'] : "";

                                $balcony_txt = "";
                                if (!empty($flatData_val['balconies'])) {
                                    $balcony_txt = " & " . $flatData_val['balconies'] . " BAL";
                                }

                                $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] . $balcony_txt : "";

                                $get_carpet_txt = "";
                                if ($proj_data_val['show_carpet'] == 1) {
                                    $get_carpet_txt = " - " . $flatData_val['carpet_area'] . " Carpet";
                                }

                                if ($proj_data_val['api_show_price'] == 1) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text .  $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards" . $set_br;
                                } else if ($proj_data_val['api_show_price'] == 2) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text .  $get_carpet_txt . ", All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . $set_br;
                                } else if ($proj_data_val['api_show_price'] == 3) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text .  $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . $set_br;
                                }
                            }
                        }
                        $config = $flat_txt;
                        $rera = "*RERA Number - " .  $project[$proj_data_key]['rera_no'] . "*";


                        //get amenities
                        $amenities_txt = "";
                        $amenity_list = "";
                        if (!empty($project[$proj_data_key]['amenities'])) {
                            $amenitiesData = (new \yii\db\Query())
                                ->select('name')
                                ->from('amenities')
                                ->where("id IN(" . $project[$proj_data_key]['amenities'] . ") AND status=1")->createCommand()
                                ->queryAll();


                            if (!empty($amenitiesData)) {
                                foreach ($amenitiesData as $amenitiesData_val) {
                                    $amenities_txt .= $amenitiesData_val['name'] . $set_br;
                                }
                            }
                            if (!empty($amenities_txt)) {
                                $amenity_list = "*Modern Amenities*" . $set_br . $amenities_txt;
                            }
                        }

                        $whatsappmiddle = $project[$proj_data_key]['whatsapp_middle'];
                        if (!empty($whatsappmiddle)) {
                            $whatsappmiddle = $whatsappmiddle . $set_br;
                        }
                        $connectivity = "*Connectivity*" . $set_br . $project[$proj_data_key]['connectivity'];
                        $whatsappbottom = $project[$proj_data_key]['whatsapp_bottom'];
                        $get_whatsapp_brief = $projname . $whatsapptop . $config . $set_br . $rera . $set_br . $set_br . $amenity_list . $set_br . $connectivity  . $set_br . $whatsappmiddle  . $set_br . $whatsappbottom;
                        //$get_whatsapp_brief = $projname . $whatsapptop;
                        //$get_whatsapp_brief = trim(preg_replace('/\s+/', ' ', $get_whatsapp_brief));
                        $get_whatsapp_brief = trim($get_whatsapp_brief);
                        $project[$proj_data_key]['whatsapp_brief'] = $get_whatsapp_brief;
                        //whatsapp brief end---------



                        //sharing start
                        $project_share = null;
                        $proj_desc = null;
                        if (!empty($proj_data_val['description_app'])) {
                            $proj_desc = $proj_data_val['description_app'] . PHP_EOL;
                        } else if (!empty($proj_data_val['project_description'])) {
                            $proj_desc = $proj_data_val['project_description'] . PHP_EOL;
                        }
                        $proj_flat_details = null;


                        $flatData = (new \yii\db\Query())
                            ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge,flat.balconies')
                            ->from('flat')
                            ->where('flat.projects_id="' . $proj_data_val['id'] . '" AND flat.status=1 AND flat.property_type=1')
                            ->orderBy('flat.total_charge ASC')->createCommand()
                            //->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                            ->queryAll();

                        $flat_txt = '';
                        if (!empty($flatData)) {
                            $flat_txt .= "*Configurations*" . PHP_EOL;

                            foreach ($flatData as $flatData_val) {

                                $balcony_txt = "";
                                if (!empty($flatData_val['balconies'])) {
                                    $balcony_txt = " & " . $flatData_val['balconies'] . " BAL";
                                }

                                $get_carpet_txt = "";
                                if ($proj_data_val['show_carpet'] == 1) {
                                    $get_carpet_txt = " - " . $flatData_val['carpet_area'] . " Carpet";
                                }

                                $get_sp_flat_type_id = !empty($flatData_val['flat_type_id']) ? $flatData_val['flat_type_id'] : "";
                                $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] . $balcony_txt : "";


                                if ($proj_data_val['api_show_price'] == 1) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards" . PHP_EOL;
                                } else if ($proj_data_val['api_show_price'] == 2) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . PHP_EOL;
                                } else if ($proj_data_val['api_show_price'] == 3) {

                                    $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . PHP_EOL;
                                }
                            }
                        }


                        $proj_flat_details = $flat_txt;

                        $proj_commercial_details = null;


                        $shopData = (new \yii\db\Query())
                            ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge')
                            ->from('flat')
                            ->where('flat.projects_id="' . $proj_data_val['id'] . '" AND flat.status=1 AND flat.property_type!=1')
                            ->orderBy('flat.total_charge ASC')->createCommand()
                            //->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                            ->queryAll();

                        $shop_txt = '';
                        if (!empty($shopData)) {
                            $shop_txt .= "*Configurations*" . PHP_EOL;

                            foreach ($shopData as $shopData_val) {
                                $get_sp_flat_type_id = !empty($shopData_val['flat_type_id']) ? $shopData_val['flat_type_id'] : "";
                                $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $shopData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] : "";

                                $get_carpet_txt = "";
                                if ($proj_data_val['show_carpet'] == 1) {
                                    $get_carpet_txt = " - " . $shopData_val['carpet_area'] . " Carpet";
                                }

                                if ($proj_data_val['api_show_price'] == 1) {

                                    $shop_txt .= "* " . $this->flat_property_type[$shopData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($shopData_val['base_price']) . "* Onwards" . PHP_EOL;
                                } else if ($proj_data_val['api_show_price'] == 2) {

                                    $shop_txt .= "* " . $this->flat_property_type[$shopData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", All Inclusive Price -" . $this->AmountInWords($shopData_val['total_charge']) . "" . PHP_EOL;
                                } else if ($proj_data_val['api_show_price'] == 3) {

                                    $shop_txt .= "* " . $this->flat_property_type[$shopData_val['property_type']] . " " . $get_sp_flat_type_text . $get_carpet_txt . ", Price -" . $this->AmountInWords($shopData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($shopData_val['total_charge']) . "" . PHP_EOL;
                                }
                            }
                        }

                        $proj_commercial_details = $shop_txt;

                        //$proj_commercial_details = $project['commercial_details'] . PHP_EOL;

                        $proj_connectivity = null;
                        if (!empty($proj_data_val['connectivity'])) {
                            $proj_connectivity = nl2br($proj_data_val['connectivity']) . PHP_EOL;
                        }
                        $proj_signification = null;
                        if (!empty($proj_data_val['signification_app'])) {
                            $proj_signification = $proj_data_val['signification_app'] . PHP_EOL;
                        } else if (!empty($proj_data_val['signification'])) {
                            $proj_signification = $proj_data_val['signification'] . PHP_EOL;
                        }

                        $share_count = 0;
                        if (!empty($proj_desc)) {
                            $project_share[$share_count]['title'] = "Details";
                            $project_share[$share_count]['content'] =  PHP_EOL . "*Project Details*" . PHP_EOL . "\r\n" . nl2br($proj_desc) . PHP_EOL;
                            $share_count++;
                        }
                        if (!empty($proj_flat_details)) {
                            $project_share[$share_count]['title'] = "Flat Details";
                            $project_share[$share_count]['content'] =  PHP_EOL . "*Flat Details*" . "\r\n" . nl2br($proj_flat_details) . PHP_EOL;
                            $share_count++;
                        }
                        if (!empty($proj_commercial_details)) {
                            $project_share[$share_count]['title'] = "Commercial Details";
                            $project_share[$share_count]['content'] =  PHP_EOL . "*Commercial Details*" . "\r\n" . nl2br($proj_commercial_details) . PHP_EOL;
                            $share_count++;
                        }
                        if (!empty($proj_connectivity)) {
                            $project_share[$share_count]['title'] = "Connectivity";
                            $project_share[$share_count]['content'] = "\r\n" . PHP_EOL . "*Connectivity*" . "\r\n" . PHP_EOL . $proj_connectivity . PHP_EOL;
                            $share_count++;
                        }
                        if (!empty($proj_signification)) {
                            $project_share[$share_count]['title'] = "Features";
                            $project_share[$share_count]['content'] = PHP_EOL . "\r\n" . "*Features*" . "\r\n" . PHP_EOL . nl2br($proj_signification) . PHP_EOL;
                            $share_count++;
                        }



                        if (!empty($amenity_list)) {
                            $project_share[$share_count]['title'] = "Amenities";
                            $project_share[$share_count]['content'] = PHP_EOL . "\r\n" . "*Amenities*" . "\r\n" . PHP_EOL . nl2br($amenity_list) . PHP_EOL;
                        }


                        $project[$proj_data_key]['project_share'] = $project_share;

                        $project[$proj_data_key]['bookmark'] = 'true';

                        unset($project[$proj_data_key]['logo_name'], $project[$proj_data_key]['low_price'], $project[$proj_data_key]['builder_id'], $project[$proj_data_key]['flat_types']);
                    }
                }

                //pagination code start
                $pgdata['page'] = $page;
                $pgdata['content_count'] = $proj_count;
                $pgdata['page_count'] = $page_count;
                $pagination = $this->getpagination($pgdata);
                //pagination code end

                /* echo "<pre>";
                print_r($project);
                exit; */
            }
        }


        $project_arr['project'] = $project;
        $project_arr['pagination'] = $pagination;

        return $project_arr;
    }

    public function getpagination($data_arr)
    {
        $pagination = null;
        $page = intval($data_arr['page']);
        $content_count = intval($data_arr['content_count']);
        $page_count = intval($data_arr['page_count']);

        $total_pages = floor($content_count / $page_count);
        if (($content_count % $page_count) != 0) {
            $total_pages = $total_pages + 1;
        }
        if ($total_pages > 1) {

            $pagination['current_page'] = $page;
            $pagination['total_count'] = $content_count;

            //page link
            $current_page_link = Yii::$app->request->hostInfo . Yii::$app->request->url;
            $txtcheck   = 'page=';
            if ($page < $total_pages) {
                $next_page = $page + 1;
                /* if (str_contains($current_page_link, $txtcheck)) {
                    $next_page = str_replace("page=" . $page, "page=" . $page + 1, $current_page_link);
                } else {
                    $next_page = $current_page_link . "&page=" . $page + 1;
                } */
                $pagination['next_page'] = $next_page;
            }
            if ($page - 1) {
                $previous_page = $page - 1;
                /* if (str_contains($current_page_link, $txtcheck)) {
                    $previous_page = str_replace("page=" . $page, "page=" . $page - 1, $current_page_link);
                } */
                $pagination['previous_page'] = $previous_page;
            }
            $pagination['total_page'] = $total_pages;
        }
        return $pagination;
    }



    public function getprojectapi($proj_id, $sm_cp_id)
    {
        $project_arr = null;
        $project = null;
        $proj_data = Projects::find()->select('id,name,builder_id,offer,logo_name,type,location_id,site_address,sale_address,project_description,signification,connectivity,website_address,rera_no,approved_by,no_of_tower,possession_date,flat_configuration,structure,pdf_upload,project_status,project_segment,launch_date,google_map,google_link,status,created_on,modified_on,amenities,latlong,whatsapp_brief,tc,api_show_price,description_app,signification_app,show_carpet')->where(['id' => $proj_id])->one();
        if (!empty($proj_data)) {

            $location_arr = Location::findAll([
                'status' => 1
            ]);
            foreach ($location_arr as $location_arr_val) {
                $locations[$location_arr_val->id] = $location_arr_val->name;
            }
            $project = $proj_data->toArray();

            if (!empty($project['location_id'])) {
                $get_loc = $project['location_id'];
                $get_loc_name = "";
                if (isset($locations[$get_loc])) {
                    $get_loc_name = $locations[$get_loc];
                }

                $project['location_id'] = $get_loc_name;
            } else {
                $project['location_id'] = '';
            }

            $project_offer = $project['offer'];
            if (!empty($project_offer)) {
                $project['offer'] = $project_offer;
            } else {
                $project['offer'] = null;
            }

            $builder_data = Builder::find()->select('name')->where(['id' => $project['builder_id']])->one();
            if (!empty($builder_data)) {
                $project['builder'] = $builder_data->name;
            } else {
                $project['builder'] = '';
            }

            //get banner
            $getbanner = SnseBanner::findAll([
                'projects_id' => $proj_id,
                'status' => 1
            ]);
            if (!empty($getbanner)) {
                foreach ($getbanner as $getbanner_val) {
                    $project['banner'][] = \Yii::$app->params['web_path'] . "files/banner/orig/" . $getbanner_val->name;
                }
            } else {
                $project['banner'] = null;
            }

            if (!empty($project['possession_date']) && $project['possession_date'] != '0000-00-00') {
                $project['possession_date'] = $project['possession_date'];
            } else {
                $project['possession_date'] = null;
            }

            /*  if (!empty($project['logo_name'])) {
                $project['banner'] = \Yii::$app->params['upload_file_path'] . $project['logo_name'];
            } */
            if (!empty($project['type'])) {
                $proj_type = explode(",", $project['type']);
                $proj_type_txt = '';
                foreach ($proj_type as $proj_type_val) {
                    if (empty($proj_type_txt)) {
                        $proj_type_txt = $this->project_type[$proj_type_val];
                    } else {
                        $proj_type_txt .= "," . $this->project_type[$proj_type_val];
                    }
                }
                $project['type'] = $proj_type_txt;
            }

            $project_share = null;


            $project['flat_details'] = null;
            //get base price of lowest flat
            $flatData = (new \yii\db\Query())
                ->select('flat.base_price,flat.flat_type_id,flat.carpet_area,flat.total_charge,flat.property_type,flat.balconies')
                ->from('flat')
                ->where('flat.projects_id="' . $proj_id . '" AND flat.status=1 AND flat.property_type =1')
                ->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                ->queryAll();
            /*  echo "<pre>";
            print_r($flatData);
            exit; */
            if (!empty($flatData)) {

                if ($project['api_show_price'] == 1) {
                    $flat_th_head = '<th style="border: 1px solid black;width: 30% !important;">Price*</th>';
                } else if ($project['api_show_price'] == 2) {
                    $flat_th_head = '<th style="border: 1px solid black;width: 30% !important;">All Inclusive Price</th>';
                } else if ($project['api_show_price'] == 3) {
                    $flat_th_head = '<th style="border: 1px solid black;width: 15% !important;">Price*</th><th style="border: 1px solid black;width: 15% !important;">All Inclusive Price</th>';
                }

                $carpet_th_head = "";
                if ($project['show_carpet'] == 1) {
                    $carpet_th_head = '<th style="border: 1px solid black;width: 15% !important;">Carpet Area</th>';
                }

                $flat_details_txt = '<table style="border: 1px solid black;"><tr style="border: 1px solid black;width: 100% !important;"><th style="border: 1px solid black;width: 10% !important;">Property Type</th><th style="border: 1px solid black;width: 15% !important;">Config</th>' . $carpet_th_head . $flat_th_head . '</tr>';
                foreach ($flatData as $flatData_v) {
                    $get_sp_flat_type_id = !empty($flatData_v['flat_type_id']) ? $flatData_v['flat_type_id'] : "";

                    $balcony_txt = "";
                    if (!empty($flatData_v['balconies'])) {
                        $balcony_txt = " & " . $flatData_v['balconies'] . " BAL";
                    }

                    $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_v['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] . $balcony_txt : '';

                    if ($project['api_show_price'] == 1) {
                        $flat_td_body = '<td style="border: 1px solid black;"> ' . $this->AmountInWords($flatData_v['base_price']) . ' Onwards</td>';
                    } else if ($project['api_show_price'] == 2) {
                        $flat_td_body = '<td style="border: 1px solid black;"> ' . $this->AmountInWords($flatData_v['total_charge']) . '</td>';
                    } else if ($project['api_show_price'] == 3) {
                        $flat_td_body = '<td style="border: 1px solid black;"> ' . $this->AmountInWords($flatData_v['base_price']) . ' Onwards</td><td style="border: 1px solid black;"> ' . $this->AmountInWords($flatData_v['total_charge']) . '</td>';
                    }

                    $carpet_body = "";
                    if ($project['show_carpet'] == 1) {
                        $carpet_body = '<td style="border: 1px solid black;">' . $flatData_v['carpet_area'] . '</td>';
                    }


                    $flat_details_txt .= '<tr style="border: 1px solid black;"><td style="border: 1px solid black;">' . $this->flat_property_type[$flatData_v['property_type']] . '</td><td style="border: 1px solid black;">' . $get_sp_flat_type_text . '</td>' . $carpet_body . $flat_td_body . '</tr>';
                }
                $flat_details_txt .= '</table>';
                $project['flat_details'] = $flat_details_txt;
                if ($project['api_show_price'] == 1) {
                    $project['price'] = $flatData[0]['base_price'];
                } else if ($project['api_show_price'] == 2) {
                    $project['price'] = $flatData[0]['total_charge'];
                } else if ($project['api_show_price'] == 3) {
                    $project['price'] = $flatData[0]['total_charge'];
                }
                $project['priceinwords'] = $this->AmountInWords($project['price']);

                $flat_type_list_arr = [];
                foreach ($flatData as $flatData_v) {
                    if (!empty($flatData_v['flat_type_id'])) {
                        $flat_type_list_arr[] = (int) $flatData_v['flat_type_id'];
                    }
                }
                $flat_type_list_arr = array_unique($flat_type_list_arr);
                //$project['flat_type_id'] = $flat_type_list_arr;
                $final_flat_type = [];
                $fcount = 0;
                foreach ($flat_type_list_arr as $flat_type_list_arr_val) {
                    /* if (in_array($flat_type_list_arr_val, array_keys($this->flat_type_id))) {
                        $final_flat_type[$flat_type_list_arr_val] = $this->flat_type_id[$flat_type_list_arr_val];
                    } */
                    //$final_flat_type[] = $flat_type_list_arr_val;
                    $final_flat_type[$fcount]["id"] = $flat_type_list_arr_val;
                    $final_flat_type[$fcount]["configuration"] = $this->flat_type_id[$flat_type_list_arr_val];
                    $fcount++;
                }
                $project['flat_type_id'] = $final_flat_type;
                //$project['flat_type'] = $final_flat_type;
            }

            /* echo "<pre>";
            print_r($project);
            exit; */

            $project['connectivity'] = nl2br($project['connectivity']);

            //commercial details
            $project['commercial_details'] = null;
            //get base price of lowest flat
            $officeData = (new \yii\db\Query())
                ->select('flat.base_price,flat.flat_type_id,flat.carpet_area,flat.total_charge,flat.property_type,flat.balconies')
                ->from('flat')
                ->where('flat.projects_id="' . $proj_id . '" AND flat.status=1 AND flat.property_type !=1')
                ->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                ->queryAll();

            if (!empty($officeData)) {

                if ($project['api_show_price'] == 1) {
                    $office_th_head = '<th style="border: 1px solid black;width: 30% !important;">Price*</th>';
                } else if ($project['api_show_price'] == 2) {
                    $office_th_head = '<th style="border: 1px solid black;width: 30% !important;">All Inclusive Price</th>';
                } else if ($project['api_show_price'] == 3) {
                    $office_th_head = '<th style="border: 1px solid black;width: 15% !important;">Price*</th><th style="border: 1px solid black;width: 15% !important;">All Inclusive Price</th>';
                }

                $carpet_th_head = "";
                if ($project['show_carpet'] == 1) {
                    $carpet_th_head = '<th style="border: 1px solid black;width: 20%;">Carpet Area</th>';
                }

                $office_details_txt = '<table style="border: 1px solid black;"><tr style="border: 1px solid black;"><th style="border: 1px solid black;width: 20%;">Property Type</th>' . $carpet_th_head . $office_th_head . '</tr>';
                foreach ($officeData as $officeData_v) {

                    if ($project['api_show_price'] == 1) {
                        $office_td_body = '<td style="border: 1px solid black;"> ' . $this->AmountInWords($officeData_v['base_price']) . ' Onwards</td>';
                    } else if ($project['api_show_price'] == 2) {
                        $office_td_body = '<td style="border: 1px solid black;"> ' . $this->AmountInWords($officeData_v['total_charge']) . '</td>';
                    } else if ($project['api_show_price'] == 3) {
                        $office_td_body = '<td style="border: 1px solid black;"> ' . $this->AmountInWords($officeData_v['base_price']) . ' Onwards</td><td style="border: 1px solid black;"> ' . $this->AmountInWords($officeData_v['total_charge']) . '</td>';
                    }

                    $carpet_body = "";
                    if ($project['show_carpet'] == 1) {
                        $carpet_body = '<td style="border: 1px solid black;">' . $officeData_v['carpet_area'] . '</td>';
                    }


                    $office_details_txt .= '<tr style="border: 1px solid black;"><td style="border: 1px solid black;">' . $this->flat_property_type[$officeData_v['property_type']] . '</td>' . $carpet_body . $office_td_body . '</tr>';
                }
                $office_details_txt .= '</table>';
                $project['commercial_details'] = $office_details_txt;
            }

            if (!empty($project['pdf_upload'])) {
                $project['pdf'] = \Yii::$app->params['upload_file_path'] . $project['pdf_upload'];
            }
            /* if (!empty($project['project_status'])) {
                $project['project_status'] = $this->project_status[$project['project_status']];
            } */
            if (!empty($project['project_segment'])) {
                $project['project_segment'] = $this->project_segment[$project['project_segment']];
            }

            $proj_desc = null;
            if (!empty($project['description_app'])) {
                $proj_desc = $project['description_app'] . PHP_EOL;
            } else if (!empty($project['project_description'])) {
                $proj_desc = $project['project_description'] . PHP_EOL;
            }
            $proj_flat_details = null;
            if (!empty($project['flat_details'])) {

                /* $flatData = (new \yii\db\Query())
                    ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge')
                    ->from('flat')
                    ->where('flat.projects_id="' . $project['id'] . '" AND flat.status=1 AND flat.property_type=1')
                    ->orderBy('flat.total_charge ASC')->createCommand()
                    //->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                    ->queryAll(); */

                $flat_txt = '';
                if (!empty($flatData)) {
                    $flat_txt .= "*Configurations*" . PHP_EOL;

                    foreach ($flatData as $flatData_val) {
                        $get_sp_flat_type_id = !empty($flatData_val['flat_type_id']) ? $flatData_val['flat_type_id'] : "";

                        $balcony_txt = "";
                        if (!empty($flatData_val['balconies'])) {
                            $balcony_txt = " & " . $flatData_val['balconies'] . " BAL";
                        }

                        $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $flatData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] . $balcony_txt : "";

                        $carpet_body = "";
                        if ($project['show_carpet'] == 1) {
                            $carpet_body = " - " . $flatData_val['carpet_area'] . " Carpet";
                        }



                        if ($project['api_show_price'] == 1) {

                            $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $carpet_body . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards" . PHP_EOL;
                        } else if ($project['api_show_price'] == 2) {

                            $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $carpet_body . ", All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . PHP_EOL;
                        } else if ($project['api_show_price'] == 3) {

                            $flat_txt .= "* " . $this->flat_property_type[$flatData_val['property_type']] . " " . $get_sp_flat_type_text . $carpet_body . ", Price -" . $this->AmountInWords($flatData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($flatData_val['total_charge']) . "" . PHP_EOL;
                        }
                    }
                }


                $proj_flat_details = $flat_txt;
            }
            $proj_commercial_details = null;
            if (!empty($project['commercial_details'])) {

                /* $shopData = (new \yii\db\Query())
                    ->select('flat.flat_type_id,flat.property_type,flat.carpet_area,flat.base_price,flat.total_charge')
                    ->from('flat')
                    ->where('flat.projects_id="' . $project['id'] . '" AND flat.status=1 AND flat.property_type!=1')
                    ->orderBy('flat.total_charge ASC')->createCommand()
                    //->orderBy('flat.property_type ASC, flat.total_charge ASC')->createCommand()
                    ->queryAll(); */

                $shop_txt = '';
                if (!empty($officeData)) {
                    $shop_txt .= PHP_EOL . "*Configurations*" . PHP_EOL;

                    foreach ($officeData as $officeData_val) {
                        $get_sp_flat_type_id = !empty($officeData_val['flat_type_id']) ? $officeData_val['flat_type_id'] : "";
                        $get_sp_flat_type_text = !empty($get_sp_flat_type_id) && $officeData_val['property_type'] == 1 ? $this->flat_type_id[$get_sp_flat_type_id] : "";

                        $carpet_body = "";
                        if ($project['show_carpet'] == 1) {
                            $carpet_body = " - " . $officeData_val['carpet_area'] . " Carpet";
                        }

                        if ($project['api_show_price'] == 1) {

                            $shop_txt .= "* " . $this->flat_property_type[$officeData_val['property_type']] . " " . $get_sp_flat_type_text . $carpet_body . ", Price -" . $this->AmountInWords($officeData_val['base_price']) . "* Onwards" . PHP_EOL;
                        } else if ($project['api_show_price'] == 2) {

                            $shop_txt .= "* " . $this->flat_property_type[$officeData_val['property_type']] . " " . $get_sp_flat_type_text . $carpet_body . ", All Inclusive Price -" . $this->AmountInWords($officeData_val['total_charge']) . "" . PHP_EOL;
                        } else if ($project['api_show_price'] == 3) {

                            $shop_txt .= "* " . $this->flat_property_type[$officeData_val['property_type']] . " " . $get_sp_flat_type_text . $carpet_body . ", Price -" . $this->AmountInWords($officeData_val['base_price']) . "* Onwards, All Inclusive Price -" . $this->AmountInWords($officeData_val['total_charge']) . "" . PHP_EOL;
                        }
                    }
                }

                $proj_commercial_details = $shop_txt;

                //$proj_commercial_details = $project['commercial_details'] . PHP_EOL;
            }
            $proj_connectivity = null;
            if (!empty($project['connectivity'])) {
                $proj_connectivity = $project['connectivity'] . PHP_EOL;
            }
            $proj_signification = null;
            if (!empty($project['signification_app'])) {
                $proj_signification = $project['signification_app'] . PHP_EOL;
            } else if (!empty($project['signification'])) {
                $proj_signification = $project['signification'] . PHP_EOL;
            }

            $share_count = 0;
            if (!empty($proj_desc)) {
                $project_share[$share_count]['title'] = "Details";
                $project_share[$share_count]['content'] = PHP_EOL . "*Project Details*" . PHP_EOL . "\r\n" . nl2br($proj_desc) . PHP_EOL;
                $share_count++;
            }
            if (!empty($proj_flat_details)) {
                $project_share[$share_count]['title'] = "Flat Details";
                $project_share[$share_count]['content'] = PHP_EOL . "*Flat Details*" . "\r\n" . nl2br($proj_flat_details) . PHP_EOL;
                $share_count++;
            }
            if (!empty($proj_commercial_details)) {
                $project_share[$share_count]['title'] = "Commercial Details";
                $project_share[$share_count]['content'] = PHP_EOL . "*Commercial Details*" . "\r\n" . nl2br($proj_commercial_details) . PHP_EOL;
                $share_count++;
            }
            if (!empty($proj_connectivity)) {
                $project_share[$share_count]['title'] = "Connectivity";
                $project_share[$share_count]['content'] = "\r\n" . PHP_EOL . "*Connectivity*" . "\r\n" . PHP_EOL . $proj_connectivity . PHP_EOL;
                $share_count++;
            }
            if (!empty($proj_signification)) {
                $project_share[$share_count]['title'] = "Features";
                $project_share[$share_count]['content'] = PHP_EOL . "\r\n" . "*Features*" . "\r\n" . PHP_EOL . nl2br($proj_signification) . PHP_EOL;
                $share_count++;
            }




            //get bookmark
            $getbookmark = SmCpBookmark::findOne([
                'sm_cp_id' => $sm_cp_id,
                'projects_id' => $proj_id,
            ]);
            if (!empty($getbookmark)) {
                $project['bookmark'] = true;
            } else {
                $project['bookmark'] = false;
            }

            $proj_amenities = $project['amenities'];

            //updating lat long
            $project['lat'] = null;
            $project['long'] = null;
            if (!empty($project['latlong'])) {
                $getlat_long = explode(",", $project['latlong']);
                $project['lat'] = trim($getlat_long[0]);
                $project['long'] = trim($getlat_long[1]);
            }

            /* if (!empty($project['whatsapp_brief'])) {
                $get_whatsapp_brief = trim(preg_replace('/\s+/', ' ', $project['whatsapp_brief']));
                $project['whatsapp_brief'] = $get_whatsapp_brief;
            } */
            $project['whatsapp_brief'] = null;


            unset($project['amenities'], $project['builder_id'], $project['logo_name'], $project['latlong']);

            //get collateral
            $collateralData = (new \yii\db\Query())
                ->select('sphoto.docs_name,sphoto.name,sphoto.photo_category')
                ->from('snse_dooits_photo as sphoto')
                ->where('sphoto.projects_id="' . $proj_id . '" AND sphoto.status=1')->createCommand()
                ->queryAll();

            $collateral = null;
            if (!empty($collateralData)) {
                $col_count = 0;

                foreach ($collateralData as $collateralData_val) {
                    if ($collateralData_val['docs_name'] != 6) {
                        $collateral[$col_count]['docs_name'] = $collateralData_val['docs_name'];
                        $get_file_name = $collateralData_val['name'];
                        $get_file_name = preg_replace('/\s+/', '', $get_file_name);
                        $collateral[$col_count]['save_name'] = $get_file_name;
                        $collateral[$col_count]['type'] = pathinfo($get_file_name, PATHINFO_EXTENSION);
                        $collateral[$col_count]['docs_link'] = \Yii::$app->params['upload_file_path'] . rawurlencode($collateralData_val['name']);
                        $col_count++;
                    }
                }
                //showing gallery data in collateral for download
                foreach ($collateralData as $collateralData_val) {
                    if ($collateralData_val['docs_name'] == 6) {
                        $collateral[$col_count]['docs_name'] = $collateralData_val['docs_name'];
                        $get_file_name = $collateralData_val['name'];
                        $get_file_name = preg_replace('/\s+/', '', $get_file_name);
                        $collateral[$col_count]['save_name'] = $get_file_name;
                        $collateral[$col_count]['type'] = pathinfo($get_file_name, PATHINFO_EXTENSION);
                        $collateral[$col_count]['docs_link'] = \Yii::$app->params['upload_file_path'] . rawurlencode($collateralData_val['name']);
                        $col_count++;
                    }
                }
            }
            //get amenities
            $amenities = null;
            $amenities_txt = null;
            if (!empty($proj_amenities)) {
                $amenitiesData = (new \yii\db\Query())
                    ->select('name,icon')
                    ->from('amenities')
                    ->where('id IN(' . $proj_amenities . ') AND status=1 ')->createCommand()
                    ->queryAll();

                if (!empty($amenitiesData)) {
                    $amn_count = 0;
                    $amenities_txt .=  PHP_EOL;
                    foreach ($amenitiesData as $amenitiesData_val) {
                        $amenities[$amn_count]['name'] = $amenitiesData_val['name'];
                        $amenities[$amn_count]['icon'] = (!empty($amenitiesData_val['icon'])) ? \Yii::$app->params['upload_amenities_path'] . $amenitiesData_val['icon'] : '';
                        $amn_count++;
                        if (empty($amenities_txt)) {
                            $amenities_txt .= "- " . $amenitiesData_val['name'];
                        } else {
                            $amenities_txt .=  PHP_EOL . "- " . $amenitiesData_val['name'];
                        }
                    }
                }
            }
            if (!empty($amenities_txt)) {
                $amenities_txt = $amenities_txt . PHP_EOL;
            }
            if (!empty($amenities_txt)) {
                $project_share[$share_count]['title'] = "Amenities";
                $project_share[$share_count]['content'] = PHP_EOL . "\r\n" . "*Amenities*" . "\r\n" . PHP_EOL . nl2br($amenities_txt) . PHP_EOL;
            }

            //get gallery
            $galleryData = (new \yii\db\Query())
                ->select('sphoto.docs_name,sphoto.name')
                ->from('snse_dooits_photo as sphoto')
                ->where('sphoto.projects_id="' . $proj_id . '" AND sphoto.photo_category=6 AND sphoto.status=1 ')->createCommand()
                ->queryAll();
            $gallery = null;
            $gal_count = 0;
            if (!empty($galleryData)) {
                foreach ($galleryData as $galleryData_val) {
                    $gallery[$gal_count]['docs_name'] = $galleryData_val['docs_name'];
                    $gallery[$gal_count]['docs_link'] = \Yii::$app->params['upload_file_path'] . rawurlencode($galleryData_val['name']);
                    $gal_count++;
                }
            }

            //show offer image in gallery for that project
            $offerData = (new \yii\db\Query())
                ->select('mcc.content,marketing_schedule.brief')
                ->from('marketing_campaign_content as mcc')
                ->leftJoin("marketing_schedule", 'mcc.schedule_id=marketing_schedule.id')
                ->leftJoin("marketing_campaign", 'marketing_schedule.campaign_id=marketing_campaign.id')
                ->where('marketing_campaign.project_id="' . $proj_id . '" AND DATE("' . date('Y-m-d') . '") BETWEEN marketing_campaign.start_date AND marketing_campaign.end_date ')->createCommand()
                ->queryAll();

            if (!empty($offerData)) {
                foreach ($offerData as $offerData_val) {
                    $gallery[$gal_count]['docs_name'] = $offerData_val['brief'];
                    $gallery[$gal_count]['docs_link'] = \Yii::$app->params['web_path'] . 'files/marketing/' . rawurlencode($offerData_val['content']);
                    $gal_count++;
                }
            }
            $sourcing = null;
            $sourcingbyrole = null;
            $final_sourcing = null;

            $get_sm_data = $this->getparentapi($sm_cp_id);
            $cp_id = $get_sm_data->channelpartner_id;
            if (!empty($cp_id)) {
                $get_connect_sm = $this->getsmofcp($cp_id);

                //get sourcing
                $sourcingData = (new \yii\db\Query())
                    ->select('sm.sm_cp_id,sm.name,sm.role,sm.contact')
                    ->from('sm_projects sp')
                    ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id')
                    ->where('FIND_IN_SET("' . (int) $proj_id . '",projects_id) AND sp.status=1 AND sm.status=1 AND sm.staff_type=1 AND sm.is_deleted=0')->groupBy('sp.sm_cp_id')->createCommand()
                    ->queryAll();

                if (!empty($sourcingData)) {
                    $s_count = 0;
                    foreach ($sourcingData as $sourcingData_val) {
                        if (!empty($get_connect_sm)) {
                            if (in_array($sourcingData_val['sm_cp_id'], $get_connect_sm)) {
                                $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                                $s_count++;
                            }
                        }
                    }

                    //Show executive first, then manager then Leader
                    /* if (isset($sourcingbyrole[3])) {
                    $final_sourcing[0] = $sourcingbyrole[3];
                } else if (isset($sourcingbyrole[2])) {
                    $final_sourcing[0] = $sourcingbyrole[2];
                } else if (isset($sourcingbyrole[1])) {
                    $final_sourcing[0] = $sourcingbyrole[1];
                } */
                    $final_sourcing = $sourcing;
                }
            }
        }
        $project_arr['project'] = $project;
        $project_arr['collateral'] = $collateral;
        $project_arr['amenities'] = $amenities;
        $project_arr['gallery'] = $gallery;
        $project_arr['sourcing'] = $final_sourcing;

        $project_arr['project_share'] = $project_share;

        return $project_arr;
    }

    public function getpbuilderapi($builder_id)
    {
        $builder_arr = null;
        $builder = null;
        $builder_data = Builder::find()->select('id,name,logo,brief,created_on,modified_on')->where(['id' => $builder_id, 'status' => 1])->one();
        if (!empty($builder_data)) {

            $builder = $builder_data->toArray();

            if (!empty($builder['logo'])) {

                $builder['logo'] = \Yii::$app->params['upload_file_path'] . "" . $builder['logo'];
            } else {
                $builder['logo'] = null;
            }
        }
        $builder_arr['builder'] = $builder;



        return $builder_arr;
    }

    public function getleadapi($l_id, $lead_data, $show_feed = '')
    {
        $lead_arr = null;
        $lead = null;
        if (empty($lead_data)) {
            $lead_data = Leadmaster::find()->select('id,lead_id,name,contact,email,flat_type_id,budget,customer_type,followup_date,status,tagging,created_by,created_on,modified_by,modified_on,carpet,location_id,flat_property_type,lead_type,followup_time')->where(['id' => $l_id, 'is_deleted' => 0])->one();
            $lead = $lead_data->toArray();
        } else {
            $lead = $lead_data->toArray();
            unset($lead['cp_id'], $lead['created_from'], $lead['is_deleted']);
        }
        if (!empty($lead_data)) {
            $lead['id'] = (string) $lead['id'];

            $lead['budgetinwords'] = null;
            if (!empty($lead['budget'])) {
                $lead['budget'] = (string) $lead['budget'];
                $lead['budgetinwords'] = $this->AmountInWords($lead['budget']);
            } else {
                $lead['budget'] = null;
            }

            if (!empty($lead['customer_type'])) {
                $lead['customer_type'] = $this->customer_type[$lead['customer_type']];
            } else {
                $lead['customer_type'] = null;
            }
            if (!empty($lead['status'])) {
                $lead['status'] = $this->lead_status[$lead['status']];
            }

            //carpet
            if (!empty($lead['carpet'])) {
                $lead['carpet'] = (string) $lead['carpet'];
            } else {
                $lead['carpet'] = null;
            }

            //location
            $lead['location_text'] = null;
            if (!empty($lead['location_id'])) {
                //location
                $locationData = (new \yii\db\Query())
                    ->select('t.id,t.name')
                    ->from('location t')
                    ->where("t.id IN(" . $lead['location_id'] . ") AND t.status=1")->createCommand()
                    ->queryAll();
                $loc_arr = null;
                if (!empty($locationData)) {
                    foreach ($locationData as $locationData_val) {
                        $loc_arr[] = $locationData_val['name'];
                    }
                    $lead['location_text'] = implode(",", $loc_arr);
                }
            }
            //flat type
            $lead['flat_property_type_text'] = null;
            if (!empty($lead['flat_property_type'])) {
                $lead['flat_property_type_text'] = $this->flat_property_type[$lead['flat_property_type']];
            } else {
                $lead['flat_property_type_text'] = null;
            }
            if (!isset($lead['flat_property_type']) || empty($lead['flat_property_type'])) {
                $lead['flat_property_type'] = 1;
            }
            if ($lead['flat_property_type'] == 1) {
                if (!empty($lead['flat_type_id'])) {
                    $lead['flat_type_id'] = (string) $lead['flat_type_id'];
                    $lead['flat_type_text'] = $this->flat_type_id[$lead['flat_type_id']];
                } else {
                    $lead['flat_type_id'] = null;
                }
            } else {
                $lead['flat_type_id'] = null;
            }

            //lead type
            if (!empty($lead['lead_type'])) {
                $lead['lead_type_text'] = $this->lead_type_arr[$lead['lead_type']];
            } else {
                $lead['lead_type_text'] = null;
            }



            /*  if (!empty($lead['tagging'])) {
                $lead['tagging'] = 'true';
            } else {
                $lead['tagging'] = 'false';
            } */
            //$lead['tag_count'] = "0";
            /* if ($lead['tagging'] == 'true') {
                $tag_query = (new \yii\db\Query())
                    ->select('id')
                    ->from('taggingmaster')
                    ->where("taggingmaster.lead_id='" . $l_id . "'");
                $tag_count = $tag_query->count();
                $lead['tag_count'] = $tag_count;
            } */

            //get tag details if any
            $tagData = (new \yii\db\Query())
                ->select('t.id,t.appointment_date,p.name')
                ->from('taggingmaster t')
                ->leftJoin("projects as p", 't.project_id = p.id')
                ->where("t.lead_id='" . $l_id . "' AND t.is_deleted=0")->createCommand()
                ->queryAll();
            $tag_arr = null;
            $t_count = 0;
            if (!empty($tagData)) {
                foreach ($tagData as $tagData_val) {
                    $tag_arr[$t_count]['id'] = $tagData_val['id'];
                    $tag_arr[$t_count]['tagging_date'] = $tagData_val['appointment_date'];
                    $tag_arr[$t_count]['project'] = $tagData_val['name'];
                    $t_count++;
                }
            }

            $lead['tag_count'] = $t_count;
            $lead['tagging'] = 'False';
            $lead['tag_data'] = $tag_arr;
            if (!empty($t_count)) {
                $lead['tagging'] = 'True';
            }



            if (!empty($lead['created_by'])) {
                $created_by_model = SmCp::find()->where(['sm_cp_id' => $lead['created_by'], 'is_deleted' => 0])->one();
                $lead['created_by'] = $created_by_model->name;
            } else {
                $lead['created_by'] = null;
            }
            if (!empty($lead['modified_by'])) {
                $modified_by_model = SmCp::find()->where(['sm_cp_id' => $lead['modified_by']])->one();
                $lead['modified_by'] = $modified_by_model->name;
            } else {
                $lead['modified_by'] = null;
            }

            $lead_arr['lead'] = $lead;
            if (!empty($show_feed)) {
                //get lead feedback
                $feedData = (new \yii\db\Query())
                    ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                    ->from('lead_feedback fd')
                    ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id')
                    ->where('fd.lead_id="' . $l_id . '"')
                    ->orderBy('fd.id DESC')
                    ->limit(5)
                    ->createCommand()
                    ->queryAll();
                $feedback = null;
                if (!empty($feedData)) {
                    $f_count = 0;
                    foreach ($feedData as $feedData_val) {
                        //$feedback[$f_count]['id'] = $feedData_val['id'];
                        $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                        $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                        //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                        $feedback[$f_count]['created_by'] = $feedData_val['name'];
                        //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                        $f_count++;
                    }
                }
                $lead_arr['lead']['feedback'] = $feedback;
            }

            $lead_arr['flat_type'] = $this->flat_type_id;
            $lead_arr['customer_type'] = $this->customer_type;
            $lead_arr['status'] = $this->lead_status;
            $lead_arr['tagging'] = $this->tagging_done;
        }
        return $lead_arr;
    }

    public function getleadshortapi($l_id, $lead_data, $show_feed = '')
    {
        $lead_arr = null;
        $lead = null;
        if (empty($lead_data)) {
            $lead_data = Leadmaster::find()->select('id,lead_id,name,contact,email,flat_type_id,budget,customer_type,followup_date,followup_time,status,tagging,created_by,created_on,modified_by,modified_on,carpet,location_id,flat_property_type,lead_type')->where(['id' => $l_id, 'is_deleted' => 0])->one();
            $lead = $lead_data->toArray();
        } else {
            $lead = $lead_data->toArray();
            unset($lead['cp_id'], $lead['created_from']);
        }
        /* echo "<pre>";
        print_r($lead);
        exit; */
        if (!empty($lead_data)) {
            $lead['id'] = (string) $lead['id'];
            /* $lead['flat_type_text'] = null;
            if (!empty($lead['flat_type_id'])) {
                $lead['flat_type_id'] = (string) $lead['flat_type_id'];
                $lead['flat_type_text'] = $this->flat_type_id[$lead['flat_type_id']];
            } else {
                $lead['flat_type_id'] = null;
            } */
            $lead['budgetinwords'] = null;
            if (!empty($lead['budget'])) {
                $lead['budget'] = (string) $lead['budget'];
                $lead['budgetinwords'] = $this->AmountInWords($lead['budget']);
            } else {
                $lead['budget'] = null;
            }

            if (!empty($lead['customer_type'])) {
                $lead['customer_type'] = $this->customer_type[$lead['customer_type']];
            } else {
                $lead['customer_type'] = null;
            }
            if (!empty($lead['status'])) {
                $lead['status'] = $this->lead_status[$lead['status']];
            }


            //carpet
            if (!empty($lead['carpet'])) {
                $lead['carpet'] = (string) $lead['carpet'];
            } else {
                $lead['carpet'] = null;
            }

            //location
            $lead['location_text'] = null;
            if (!empty($lead['location_id'])) {
                //location
                $locationData = (new \yii\db\Query())
                    ->select('t.id,t.name')
                    ->from('location t')
                    ->where("t.id IN(" . $lead['location_id'] . ") AND t.status=1")->createCommand()
                    ->queryAll();
                $loc_arr = null;
                if (!empty($locationData)) {
                    foreach ($locationData as $locationData_val) {
                        $loc_arr[] = $locationData_val['name'];
                    }
                    $lead['location_text'] = implode(",", $loc_arr);
                }
            }
            //flat type
            $lead['flat_property_type_text'] = null;
            if (!isset($lead['flat_property_type']) || empty($lead['flat_property_type'])) {
                $lead['flat_property_type'] = 1;
            }
            if (!empty($lead['flat_property_type'])) {
                $lead['flat_property_type_text'] = $this->flat_property_type[$lead['flat_property_type']];
            } else {
                $lead['flat_property_type_text'] = null;
            }

            if ($lead['flat_property_type'] == 1) {
                if (!empty($lead['flat_type_id'])) {
                    $lead['flat_type_id'] = (string) $lead['flat_type_id'];
                    $lead['flat_type_text'] = $this->flat_type_id[$lead['flat_type_id']];
                } else {
                    $lead['flat_type_id'] = null;
                }
            } else {
                $lead['flat_type_id'] = null;
            }

            //lead type
            if (!empty($lead['lead_type'])) {
                $lead['lead_type_text'] = $this->lead_type_arr[$lead['lead_type']];
            } else {
                $lead['lead_type_text'] = null;
            }


            /* if (!empty($lead['tagging'])) {
                $lead['tagging'] = 'true';
            } else {
                $lead['tagging'] = 'false';
            }
            $lead['tag_count'] = "0";
            if ($lead['tagging'] == 'true') {
                $tag_query = (new \yii\db\Query())
                    ->select('id')
                    ->from('taggingmaster')
                    ->where("taggingmaster.lead_id='" . $l_id . "'");
                $tag_count = $tag_query->count();
                $lead['tag_count'] = $tag_count;
            } */

            //get tag details if any
            $tagData = (new \yii\db\Query())
                ->select('t.id,t.appointment_date,p.name')
                ->from('taggingmaster t')
                ->leftJoin("projects as p", 't.project_id = p.id')
                ->where("t.lead_id='" . $l_id . "' AND t.is_deleted=0")->createCommand()
                ->queryAll();
            $tag_arr = null;
            $t_count = 0;
            if (!empty($tagData)) {
                foreach ($tagData as $tagData_val) {
                    $tag_arr[$t_count]['id'] = $tagData_val['id'];
                    $tag_arr[$t_count]['tagging_date'] = $tagData_val['appointment_date'];
                    $tag_arr[$t_count]['project'] = $tagData_val['name'];
                    $t_count++;
                }
            }

            $lead['tag_count'] = $t_count;
            $lead['tagging'] = 'False';
            //$lead['tag_data'] = $tag_arr;
            if (!empty($t_count)) {
                $lead['tagging'] = 'True';
            }




            if (!empty($lead['created_by'])) {
                $created_by_model = SmCp::find()->where(['sm_cp_id' => $lead['created_by'], 'is_deleted' => 0])->one();
                $lead['created_by'] = $created_by_model->name;
            } else {
                $lead['created_by'] = null;
            }
            if (!empty($lead['modified_by'])) {
                $modified_by_model = SmCp::find()->where(['sm_cp_id' => $lead['modified_by']])->one();
                $lead['modified_by'] = $modified_by_model->name;
            } else {
                $lead['created_by'] = null;
            }

            $lead_arr['lead'] = $lead;
            if (!empty($show_feed)) {
                //get lead feedback
                $feedData = (new \yii\db\Query())
                    ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                    ->from('lead_feedback fd')
                    ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id')
                    ->where('fd.lead_id="' . $l_id . '"')
                    ->orderBy('fd.id DESC')
                    ->limit(5)
                    ->createCommand()
                    ->queryAll();
                $feedback = null;
                if (!empty($feedData)) {
                    $f_count = 0;
                    foreach ($feedData as $feedData_val) {
                        //$feedback[$f_count]['id'] = $feedData_val['id'];
                        $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                        $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                        //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                        $feedback[$f_count]['created_by'] = $feedData_val['name'];
                        //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                        $f_count++;
                    }
                }
                $lead_arr['lead']['feedback'] = $feedback;
            }

            /* $lead_arr['flat_type'] = $this->flat_type_id;
            $lead_arr['customer_type'] = $this->customer_type;
            $lead_arr['status'] = $this->lead_status;
            $lead_arr['tagging'] = $this->tagging_done; */
        }
        return $lead_arr;
    }

    public function gettagapi($tag_id, $tag_data, $show_feed = '')
    {
        $tag_arr = null;
        $tag = null;
        if (empty($tag_data)) {
            $tag_data = Taggingmaster::find()->select('id,lead_id,tagging_id,tag_name,tag_phone,tag_email,flat_type_id,sm_cp_id,project_id,budget,customer_type,appointment_date,appointment_time,status,created_by,created_on,modified_by,modified_on,visit_notvisit_clash_date,lead_convert_date,lead_dead_date,lead_registered_date,retag_limit,tag_code,cp_id,visited_by,booked_by,registered_by,is_cancelled,cancelled_by,cancelled_on,flat_property_type')->where(['id' => $tag_id, 'is_deleted' => 0])->one();
            $tag = $tag_data->toArray();
        } else {
            $tag = $tag_data->toArray();
            unset($tag['is_deleted'], $tag['deleted_on'], $tag['deleted_by'], $tag['created_from'], $tag['is_accepted']);
        }

        if (!empty($tag_data)) {

            $lead_data = Leadmaster::find()->select('id,lead_id,name,flat_property_type,flat_type_id')->where(['id' => $tag['lead_id'], 'is_deleted' => 0])->one();
            if (!empty($lead_data)) {
                $tag['lead_id'] = $lead_data->lead_id;
            }
            $tag['id'] = (string) $tag['id'];
            if (!empty($tag['tag_name'])) {
                $tag['name'] = $tag['tag_name'];
                //unset($tag['tag_name']);
            }
            if (!empty($tag['tag_phone'])) {
                $tag['contact'] = $tag['tag_phone'];
                unset($tag['tag_phone']);
            }
            if (!empty($tag['tag_email'])) {
                $tag['email'] = $tag['tag_email'];
                unset($tag['tag_email']);
            } else {
                $tag['email'] = null;
            }
            $tag['flat_type_id'] = null;
            $tag['flat_type_text'] = null;
            $tag['flat_property_type'] = null;
            $tag['flat_property_type_text'] = null;
            if (!empty($lead_data)) {
                if (!empty($lead_data->flat_property_type)) {
                    $tag['flat_property_type'] = (string) $lead_data->flat_property_type;
                    $tag['flat_property_type_text'] = (string) $this->flat_property_type[$lead_data->flat_property_type];
                }

                if (!empty($lead_data->flat_property_type)) {
                    if ($lead_data->flat_property_type == 1) {

                        if (!empty($lead_data->flat_type_id)) {
                            $tag['flat_type_id'] = (string) $lead_data->flat_type_id;
                            $tag['flat_type_text'] = $this->flat_type_id[$lead_data->flat_type_id];
                        }
                    }
                }
            } else {
                if (!empty($tag['flat_property_type'])) {
                    $tag['flat_property_type'] = (string) $tag['flat_property_type'];
                    $tag['flat_property_type_text'] = (string) $this->flat_property_type[$tag['flat_property_type']];
                }

                if (!empty($tag['flat_property_type'])) {
                    if ($tag['flat_property_type'] == 1) {

                        if (!empty($tag['flat_type_id'])) {
                            $tag['flat_type_id'] = (string) $tag['flat_type_id'];
                            $tag['flat_type_text'] = $this->flat_type_id[$tag['flat_type_id']];
                        }
                    }
                }
            }

            $tag['budgetinwords'] = null;
            if (!empty($tag['budget'])) {
                $tag['budget'] = (string) $tag['budget'];
                $tag['budgetinwords'] = $this->AmountInWords($tag['budget']);
            } else {
                $tag['budget'] = null;
            }



            $tag_limit_set = isset($tag['retag_limit']) ? intval($tag['retag_limit']) : 0;
            $tag_available = intval(\Yii::$app->params['RETAG_MAX']) - $tag_limit_set;
            $tag['retag_attempt_left'] = (string) $tag_available;


            if (!empty($tag['customer_type'])) {
                $tag['customer_type'] = $this->customer_type[$tag['customer_type']];
            } else {
                $tag['customer_type'] = null;
            }
            if (!empty($tag['status'])) {
                $tag['statusText'] = $this->tag_status[$tag['status']];

                if ($tag['status'] == 1) {
                    $tag['visited_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 2) {
                    $tag['not_visited_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 3) {
                    $tag['clashed_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 7) {
                    $tag['rejected_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 4) {
                    $tag['booked_on'] = $tag['lead_convert_date'];
                } else if ($tag['status'] == 5) {
                    $tag['lead_dead_on'] = $tag['lead_dead_date'];
                } else if ($tag['status'] == 6) {
                    $tag['registered_on'] = $tag['lead_registered_date'];
                }
                $tag['last_updated_by'] = null;
                if (!empty($tag['visited_by'])) {
                    $visit_staff_model = SmCp::find()->where(['sm_cp_id' => $tag['visited_by']])->one();
                    $tag['visited_staff'] = !empty($visit_staff_model->name) ? $visit_staff_model->name : "";
                    $tag['last_updated_by'] = !empty($visit_staff_model->name) ? $visit_staff_model->name : "";
                }
                if (!empty($tag['booked_by'])) {
                    $book_staff_model = SmCp::find()->where(['sm_cp_id' => $tag['booked_by']])->one();
                    $tag['booked_staff'] = !empty($book_staff_model->name) ? $book_staff_model->name : "";
                    $tag['last_updated_by'] = !empty($book_staff_model->name) ? $book_staff_model->name : "";
                }
                if (!empty($tag['registered_by'])) {
                    $reg_staff_model = SmCp::find()->where(['sm_cp_id' => $tag['registered_by']])->one();
                    $tag['reg_staff'] = !empty($reg_staff_model->name) ? $reg_staff_model->name : "";
                    $tag['last_updated_by'] = !empty($reg_staff_model->name) ? $reg_staff_model->name : "";
                }
                /* if ($tag['statusText'] == 'Visited') {
                    $tag['visited_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['statusText'] == 'Clashed') {
                    $tag['clash_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['statusText'] == 'Lead Converted') {
                    $tag['lead_convert_on'] = $tag['lead_convert_date'];
                } else if ($tag['statusText'] == 'Lead Dead') {
                    $tag['lead_dead_on'] = $tag['lead_dead_date'];
                } else if ($tag['statusText'] == 'Lead Registered') {
                    $tag['lead_registered_on'] = $tag['lead_registered_date'];
                } */
            } else {
                $tag['statusText'] = 'In Progress';
            }
            unset($tag['visit_notvisit_clash_date'], $tag['lead_convert_date'], $tag['lead_dead_date'], $tag['lead_registered_date']);

            if (!empty($tag['project_id'])) {
                $project_model = Projects::find()->where(['id' => $tag['project_id']])->one();
                $tag['project_id'] = $project_model->name;
            }

            if (!empty($tag['cp_id'])) {
                $cp_model = Channelpartner::find()->where(['id' => $tag['cp_id']])->one();
                $tag['cp_company_name'] = $cp_model->company_name;
                //to be commented later
                $tag['cp_name'] = $cp_model->company_name;
            }

            if (!empty($tag['sm_cp_id'])) {
                $sourcing_model = SmCp::find()->where(['sm_cp_id' => $tag['sm_cp_id']])->one();
                $tag['sourcing_id'] = $sourcing_model->name;
                $get_sm_contact = $sourcing_model->contact;
                unset($tag['sm_cp_id']);
            }



            if (!empty($tag['created_by'])) {
                $created_by_model = SmCp::find()->where(['sm_cp_id' => $tag['created_by']])->one();
                $tag['created_by'] = $created_by_model->name;
                //To be uncommented later
                //$tag['cp_name'] = $created_by_model->name;
                $tag['cp_contact'] = $created_by_model->contact;
            } else {
                $tag['created_by'] = null;
            }

            if (!empty($tag['status']) && in_array($tag['status'], [4, 6])) {
                if (!empty($tag['is_cancelled'])) {
                    $cancelled_staff_model = SmCp::find()->where(['sm_cp_id' => $tag['cancelled_by']])->one();
                    $tag['booking_cancelled'] = "Yes";
                    $tag['cancelled_staff'] = !empty($cancelled_staff_model->name) ? $cancelled_staff_model->name : "";
                } else {
                    $tag['booking_cancelled'] = "No";
                }
            }

            /*  if (!empty($tag['modified_by'])) {
                $modified_by_model = SmCp::find()->where(['sm_cp_id' => $tag['modified_by']])->one();
                $tag['modified_by'] = !empty($modified_by_model->name) ? $modified_by_model->name : null;
            } else {
                $tag['modified_by'] = null;
            } */
            /* var_dump($tag);
            exit; */



            $tag['tag_code_content'] = null;
            if (!empty($tag['tag_code'])) {


                $get_cp_name = !empty($created_by_model) ? $created_by_model->name : "";
                $get_cp_contact = !empty($created_by_model) ? $created_by_model->contact : "";

                $tag_code_content = "Hello Sir," . PHP_EOL . "Your appointment has been scheduled at " . $project_model->name . "." . PHP_EOL . "Please Showcase appointment code *" . $tag['tag_code'] . "* at reception once you arrive." . PHP_EOL . PHP_EOL . "*SALES OFFICE ADDRESS:* " . PHP_EOL . $project_model->sale_address . "" . PHP_EOL . PHP_EOL .  "In case of any help required to reach the project, you can contact *" . $get_cp_name . "* on *" . $get_cp_contact . "*." . PHP_EOL . PHP_EOL . "Regards,";

                /* $tag_code_content = "Hello Sir," . PHP_EOL . " Your appointment has been scheduled at " . $project_model->name . "" . PHP_EOL . " Please Showcase appointment code *" . $tag['tag_code'] . "* at reception once you arrive." . PHP_EOL . PHP_EOL . "*ADITYARAJ SALES OFFICE ADDRESS:* " . PHP_EOL . $project_model->sale_address . "" . PHP_EOL . PHP_EOL . " In case of any help required to reach the project, you can contact *" . $get_cp_name . "* on *" . $get_cp_contact . "*" . PHP_EOL . PHP_EOL . " Regards,"; */
                //$tag_code_content = trim(preg_replace('/\s+/', ' ', $tag_code_content));
                $tag['tag_code_content'] = $tag_code_content;
            }

            $tag_arr['tagging'] = $tag;
            if (!empty($show_feed)) {
                //get lead feedback
                $feedData = (new \yii\db\Query())
                    ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                    ->from('tagging_feedback fd')
                    ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id')
                    ->where('fd.tagging_id="' . $tag_id . '"')
                    ->orderBy('fd.id DESC')
                    ->limit(5)  //show last 5 feedback
                    ->createCommand()
                    ->queryAll();
                $feedback = null;
                if (!empty($feedData)) {
                    $f_count = 0;
                    foreach ($feedData as $feedData_val) {
                        //$feedback[$f_count]['id'] = $feedData_val['id'];
                        $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                        $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                        //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                        $feedback[$f_count]['created_by'] = $feedData_val['name'];
                        //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                        $f_count++;
                    }
                }
                $tag_arr['tagging']['feedback'] = $feedback;
            }

            if (!empty($show_feed)) {
                $tag_arr['flat_type'] = $this->flat_type_id;
                $tag_arr['customer_type'] = $this->customer_type;
                $tag_arr['status'] = $this->tag_status;
            }
        }
        return $tag_arr;
    }

    public function getfeedbackapi($tag_id, $type = 1)
    {
        $feedback_arr = null;
        if ($type == 1) {
            $feedData = (new \yii\db\Query())
                ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                ->from('tagging_feedback fd')
                ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id')
                ->where('fd.tagging_id="' . $tag_id . '"')
                ->orderBy('fd.id DESC')
                //->limit(5)  //show last 5 feedback
                ->createCommand()
                ->queryAll();
        } else if ($type == 2) {
            $feedData = (new \yii\db\Query())
                ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                ->from('lead_feedback fd')
                ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id')
                ->where('fd.lead_id="' . $tag_id . '"')
                ->orderBy('fd.id DESC')
                //->limit(5)  //show last 5 feedback
                ->createCommand()
                ->queryAll();
        }

        $feedback = null;
        if (!empty($feedData)) {
            $f_count = 0;
            foreach ($feedData as $feedData_val) {
                //$feedback[$f_count]['id'] = $feedData_val['id'];
                $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                $feedback[$f_count]['created_by'] = $feedData_val['name'];
                //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                $f_count++;
            }
        }
        $feedback_arr['feedback'] = $feedback;

        return $feedback_arr;
    }

    public function getpost($post_id, $post_data, $self_post = false)
    {
        $post_arr = null;
        $post = null;
        if (empty($post_data)) {
            $post_data = CpCustomersFlats::find()->select('id,post_id,title,description,sm_cp_id,type,location_id,budget,flat_type_id,carpet,created_on,modified_on,status,all_count,location_count,budget_count,combine_count,view_count,flat_property_type,message,post_for,deposit,monthly_rent,landmark,rental_type')->where(['id' => $post_id])->one();
            $post = $post_data->toArray();
        } else {
            $post = $post_data->toArray();
        }

        if (!empty($post_data)) {

            $post['post_for_text'] = $this->post_post_for[$post['post_for']];
            if ($post['post_for'] == 1) {
                if ($post['type'] == 1) {
                    $post['type'] = 1;
                    $post['type_text'] = $this->post_type[$post['type']];
                } else {
                    $post['type'] = 2;
                    $post['type_text'] = $this->post_type[$post['type']];
                }
            } else {
                if ($post['rental_type'] == 1) {
                    $post['rental_type'] = 1;
                    $post['rental_type_text'] = $this->post_rental_type[$post['rental_type']];
                } else {
                    $post['rental_type'] = 2;
                    $post['rental_type_text'] = $this->post_rental_type[$post['rental_type']];
                }
            }

            $post['flat_property_type_text'] = null;
            if (!empty($post['flat_property_type'])) {
                $post['flat_property_type_text'] = $this->flat_property_type[$post['flat_property_type']];
            } else {
                $post['flat_property_type_text'] = null;
            }
            if (!isset($post['flat_property_type']) || empty($post['flat_property_type'])) {
                $post['flat_property_type'] = 1;
            }
            if ($post['flat_property_type'] == 1) {
                if (!empty($post['flat_type_id'])) {
                    $post['flat_type_id'] = (string) $post['flat_type_id'];
                    $post['flat_type_text'] = $this->flat_type_id[$post['flat_type_id']];
                } else {
                    $post['flat_type_id'] = null;
                }
            } else {
                $post['flat_type_id'] = null;
            }





            /* $post['flat_type_text'] = null;
            if (!empty($post['flat_type_id'])) {
                $post['flat_type_id'] = (string) $post['flat_type_id'];
                $post['flat_type_text'] = $this->flat_type_id[$post['flat_type_id']];
            } else {
                $post['flat_type_id'] = null;
            } */


            if ($post['post_for'] == 1) {
                $post['budgetinwords'] = null;
                if (!empty($post['budget'])) {
                    $post['budget'] = (string) $post['budget'];
                    $post['budgetinwords'] = $this->AmountInWords($post['budget']);
                } else {
                    $post['budget'] = null;
                }
            } else {
                $post['depositinwords'] = null;
                $post['monthly_rentinwords'] = null;
                if (!empty($post['deposit'])) {
                    $post['deposit'] = (string) $post['deposit'];
                    $post['depositinwords'] = $this->AmountInWords($post['deposit']);
                } else {
                    $post['deposit'] = null;
                }
                if (!empty($post['monthly_rent'])) {
                    $post['monthly_rent'] = (string) $post['monthly_rent'];
                    $post['monthly_rentinwords'] = $this->AmountInWords($post['monthly_rent']);
                } else {
                    $post['monthly_rent'] = null;
                }
            }

            if (!empty($post['location_id'])) {
                $loc_model = Location::find()->where(['id' => $post['location_id'], 'status' => '1'])->one();
                $post['location_name'] = $loc_model->name;
            }

            if ($post['status'] != "") {
                $post['statusText'] = $this->post_status[$post['status']];
            } else {
                $post['statusText'] = 'In Progress';
            }

            //if ($post['status'] != 0) {
            if (in_array($post['status'], [1, 2, 4])) {
                $post['message'] = null;
            }

            $post['fulledit'] = false;
            $post['onlybudgetstatusedit'] = false;
            if ($self_post) {
                if (in_array($post['status'], [0, 3])) {
                    $post['fulledit'] = true;
                } else if (in_array($post['status'], [1])) {
                    $post['onlybudgetstatusedit'] = true;
                }
            }


            if (!empty($post['sm_cp_id'])) {

                $smcp_model = SmCp::find()->where(['sm_cp_id' => $post['sm_cp_id'], 'is_deleted' => 0])->one();
                $post['cp_name'] = $smcp_model->name;
                $get_cp_contact = $smcp_model->contact;
                $post['cp_contact'] = $get_cp_contact;
                $cp_id = $smcp_model->channelpartner_id;

                $cp_model = Channelpartner::find()->where(['id' => $cp_id])->one();
                $post['cp_company_name'] = $cp_model->company_name;
            }

            $get_post_content_arr = null;

            $get_post_content_data = PostingContent::find()->select('content')->where(['post_id' => $post['id']])->asArray()->all();
            if (!empty($get_post_content_data)) {
                $c_count = 0;
                foreach ($get_post_content_data as $get_post_content_data_val) {
                    $get_post_content_arr[$c_count]['link'] = \Yii::$app->params['web_path'] . 'files/posting/' . $get_post_content_data_val['content'];
                    $c_count++;
                }
            }
            $post['content'] = $get_post_content_arr;

            $get_type = 0;
            $get_rental_type = 0;
            if ($post['post_for'] == 1) {
                if ($post['type'] == 1) {
                    $get_type = 2;
                } else {
                    $get_type = 1;
                }
            } else {

                if ($post['rental_type'] == 1) {
                    $get_rental_type = 2;
                } else {
                    $get_rental_type = 1;
                }
            }
            $show_count = false;
            if ($self_post) {
                $show_count = true;
            }
            if ($post['status'] != 1) {
                $show_count = false;
            }

            if ($show_count) {
                $combine_count = "0";
                $location_count = "0";
                $budget_count = "0";
                $all_count = "0";
                if (!empty($post['status']) && $post['status'] == 1) {
                    $combine_arr = [];
                    $combine_arr['post_for'] = $post['post_for'];
                    $combine_arr['type'] = $get_type;
                    $combine_arr['budget'] = $post['budget'];
                    $combine_arr['rental_type'] = $get_rental_type;
                    $combine_arr['monthly_rent'] = $post['monthly_rent'];

                    $combine_arr['flat_type_id'] = $post['flat_type_id'];
                    $combine_arr['flat_property_type'] = $post['flat_property_type'];
                    $combine_arr['carpet'] = $post['carpet'];
                    $combine_arr['location_id'] = $post['location_id'];
                    $all_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 1);
                    $location_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 2);
                    $budget_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 3);
                    $combine_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 4);
                }
                $post['combine_count'] = $combine_count;
                $post['location_count'] = $location_count;
                if ($post['post_for'] == 1) {
                    $post['budget_count'] = $budget_count;
                } else {
                    $post['rent_count'] = $budget_count;
                }
                $post['all_count'] = $all_count;
            }

            //$post['contacted'] = false;
            if (!$self_post) {
                $post['viewed'] = false;
                $flatcontact_data = CpCustomersFlatsView::find()->where('post_id="' . $post_id . '" AND sm_cp_id="' . $post['sm_cp_id'] . '"  ')->orderBy(['created_on' => SORT_DESC])->one();
                if (!empty($flatcontact_data)) {
                    $post['viewed'] = true;
                } else {
                    $post['cp_name'] = null;
                    $post['cp_contact'] = null;
                    $post['cp_company_name'] = null;
                }
            }

            /* if ($self_post) {
                $post_view_data = $this->getpostinglimit($post_id, $post['sm_cp_id']);
                if (!empty($post_view_data)) {
                    $post['stat']['view_count'] = (string) $post_view_data['view_count'];
                    $post['stat']['limit_count'] = (string) $post_view_data['limit_count'];
                    $post['stat']['available_count'] = (string) $post_view_data['available_count'];
                    $post['stat']['others_view_count'] = (string) $post_view_data['others_view_count'];
                }
            } */




            unset($post['modified_by']);

            $postarr = $this->convert_to_str($post);

            $post_arr['post'] = $postarr;
        }
        return $post_arr;
    }

    public function getfinalpostcount($post_id)
    {
        $post = null;

        $post_data = CpCustomersFlats::find()->select('id,title,description,sm_cp_id,type,location_id,budget,flat_type_id,flat_property_type,carpet,created_on,modified_on,status,post_for,deposit,monthly_rent,landmark,rental_type')->where(['id' => $post_id])->one();
        $post = $post_data->toArray();


        if (!empty($post_data)) {

            $post['post_for_text'] = $this->post_post_for[$post['post_for']];
            if ($post['post_for'] == 1) {
                if ($post['type'] == 1) {
                    $post['type'] = 1;
                    $post['type_text'] = $this->post_type[$post['type']];
                } else {
                    $post['type'] = 2;
                    $post['type_text'] = $this->post_type[$post['type']];
                }
            } else {
                if ($post['rental_type'] == 1) {
                    $post['rental_type'] = 1;
                    $post['rental_type_text'] = $this->post_rental_type[$post['rental_type']];
                } else {
                    $post['rental_type'] = 2;
                    $post['rental_type_text'] = $this->post_rental_type[$post['rental_type']];
                }
            }

            /* $post['flat_type_text'] = null;
            if (!empty($post['flat_type_id'])) {
                $post['flat_type_id'] = (string) $post['flat_type_id'];
                $post['flat_type_text'] = $this->flat_type_id[$post['flat_type_id']];
            } else {
                $post['flat_type_id'] = null;
            } */


            $post['flat_property_type_text'] = null;
            if (!empty($post['flat_property_type'])) {
                $post['flat_property_type_text'] = $this->flat_property_type[$post['flat_property_type']];
            } else {
                $post['flat_property_type_text'] = null;
            }
            if (empty($post['flat_property_type'])) {
                $post['flat_property_type'] = 1;
            }
            if ($post['flat_property_type'] == 1) {
                if (!empty($post['flat_type_id'])) {
                    $post['flat_type_id'] = (string) $post['flat_type_id'];
                    $post['flat_type_text'] = $this->flat_type_id[$post['flat_type_id']];
                } else {
                    $post['flat_type_id'] = null;
                }
            } else {
                $post['flat_type_id'] = null;
            }


            if ($post['post_for'] == 1) {
                $post['budgetinwords'] = null;
                if (!empty($post['budget'])) {
                    $post['budget'] = (string) $post['budget'];
                    $post['budgetinwords'] = $this->AmountInWords($post['budget']);
                } else {
                    $post['budget'] = null;
                }
            } else {
                $post['depositinwords'] = null;
                $post['monthly_rentinwords'] = null;
                if (!empty($post['deposit'])) {
                    $post['deposit'] = (string) $post['deposit'];
                    $post['depositinwords'] = $this->AmountInWords($post['deposit']);
                } else {
                    $post['deposit'] = null;
                }
                if (!empty($post['monthly_rent'])) {
                    $post['monthly_rent'] = (string) $post['monthly_rent'];
                    $post['monthly_rentinwords'] = $this->AmountInWords($post['monthly_rent']);
                } else {
                    $post['monthly_rent'] = null;
                }
            }




            if (!empty($post['location_id'])) {
                $loc_model = Location::find()->where(['id' => $post['location_id'], 'status' => '1'])->one();
                $post['location_name'] = $loc_model->name;
            }

            if ($post['status'] != "") {
                $post['statusText'] = $this->post_status[$post['status']];
            } else {
                $post['statusText'] = 'In Progress';
            }

            if (!empty($post['sm_cp_id'])) {

                $smcp_model = SmCp::find()->where(['sm_cp_id' => $post['sm_cp_id'], 'is_deleted' => 0])->one();
                $post['cp_name'] = $smcp_model->name;
                $get_cp_contact = $smcp_model->contact;
                $post['cp_contact'] = $get_cp_contact;
                $cp_id = $smcp_model->channelpartner_id;

                $cp_model = Channelpartner::find()->where(['id' => $cp_id])->one();
                $post['cp_company_name'] = $cp_model->company_name;
            }

            $get_post_content_arr = null;
            $get_post_content_data = PostingContent::find()->select('content')->where(['post_id' => $post['id']])->asArray()->all();
            if (!empty($get_post_content_data)) {
                $c_count = 0;
                foreach ($get_post_content_data as $get_post_content_data_val) {
                    $get_post_content_arr[$c_count]['link'] = \Yii::$app->params['web_path'] . 'files/posting/' . $get_post_content_data_val['content'];
                    $c_count++;
                }
                $post['content'] = $get_post_content_arr;
            }

            /* if ($post['type'] == 1) {
                $get_type = 2;
            } else {
                $get_type = 1;
            } */

            $get_type = 0;
            $get_rental_type = 0;
            if ($post['post_for'] == 1) {
                if ($post['type'] == 1) {
                    $get_type = 2;
                } else {
                    $get_type = 1;
                }
            } else {

                if ($post['rental_type'] == 1) {
                    $get_rental_type = 2;
                } else {
                    $get_rental_type = 1;
                }
            }


            $combine_count = "0";
            $location_count = "0";
            $budget_count = "0";
            $all_count = "0";
            if (!empty($post['status']) && $post['status'] == 1) {
                $combine_arr = [];
                $combine_arr['post_for'] = $post['post_for'];
                $combine_arr['type'] = $get_type;
                $combine_arr['budget'] = $post['budget'];
                $combine_arr['rental_type'] = $get_rental_type;
                $combine_arr['monthly_rent'] = $post['monthly_rent'];

                $combine_arr['flat_type_id'] = $post['flat_type_id'];
                $combine_arr['flat_property_type'] = $post['flat_property_type'];
                $combine_arr['carpet'] = $post['carpet'];
                $combine_arr['location_id'] = $post['location_id'];
                $all_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 1);
                $location_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 2);
                $budget_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 3);
                $combine_count = $this->getpostcount($combine_arr, $post['sm_cp_id'], 4);
            }
            $post['combine_count'] = $combine_count;
            $post['location_count'] = $location_count;
            if ($post['post_for'] == 1) {
                $post['budget_count'] = $budget_count;
            } else {
                $post['rent_count'] = $budget_count;
            }
            $post['all_count'] = $all_count;

            $post['view_count'] = 0;

            //get view count
            $viewData = (new \yii\db\Query())
                ->select('count(v.id) as view_count')
                ->from('cp_customers_flats_view v')
                ->where('v.post_id="' . $post_id . '"')->createCommand()
                ->queryAll();

            if (!empty($viewData)) {
                foreach ($viewData as $viewData_val) {
                    $post['view_count'] = intval($viewData_val['view_count']);
                }
            }
        }
        return $post;
    }

    //convert array to string
    function convert_to_str($arr)
    {
        $strarr = $arr;
        if (!empty($arr)) {
            $strarr = array_map(function ($value) {
                if ($value != "" && !is_array($value) && !is_bool($value)) {
                    return (string) $value;
                } else if ($value == "" || $value == null) {
                    return null;
                } else {
                    return $value;
                }
            }, $arr);
        }
        return $strarr;
    }

    public function get_insight($querydata)
    {
        $insight = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */

        if (!empty($querydata)) {
            $location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
            $location_subtype_id = (!empty($querydata['location_subtype_id']) ? $querydata['location_subtype_id'] : '');
            $get_loc_txt = "";
            if (!empty($location_subtype_id) && empty($location_id)) {
                $get_loc_arr = $this->getlocfromsubtype($location_subtype_id, true);
                if (!empty($get_loc_arr)) {
                    $insight_arr = $get_loc_arr;
                    $locids = [];
                    foreach ($insight_arr as $insight_k => $insight_v) {
                        $locids[] = $insight_k;
                        $insight[$insight_k]['name'] = $insight_v;
                    }
                    $get_loc_txt = implode(",", $locids);
                }
            } else {
                $location_arr = (new \yii\db\Query())
                    ->select('id,name')
                    ->from('location')
                    ->where('id IN(' . $location_id . ')')
                    ->orderBy('name ASC')->createCommand()
                    ->queryAll();

                if (!empty($location_arr)) {

                    foreach ($location_arr as $location_arr_v) {
                        $loc_arr[$location_arr_v['id']] = $location_arr_v['name'];
                    }
                    $insight_arr = $loc_arr;
                    $locids = [];
                    foreach ($insight_arr as $insight_k => $insight_v) {
                        $locids[] = $insight_k;
                        $insight[$insight_k]['name'] = $insight_v;
                    }
                    $get_loc_txt = implode(",", $locids);
                }
            }




            //count of resale flats
            $resaleData = (new \yii\db\Query())
                ->select('count(id) as view_count,location_id')
                ->from('cp_customers_flats')
                ->where('type=2 AND post_for=1 AND flat_property_type=1 AND location_id IN(' . $get_loc_txt . ') AND status=1')
                ->groupBy('location_id')
                ->createCommand()
                ->queryAll();

            if (!empty($resaleData)) {
                foreach ($resaleData as $resaleData_val) {
                    $resale_count = intval($resaleData_val['view_count']);
                    $loc = $resaleData_val['location_id'];

                    $insight[$loc]['resale_flats'] = $resale_count;
                }
            }

            //count of rental flats
            $rentalData = (new \yii\db\Query())
                ->select('count(id) as view_count,location_id')
                ->from('cp_customers_flats')
                ->where('rental_type=1 AND post_for=2 AND status=1 AND flat_property_type=1 AND location_id IN(' . $get_loc_txt . ')')
                ->groupBy('location_id')
                ->createCommand()
                ->queryAll();

            if (!empty($rentalData)) {
                foreach ($rentalData as $rentalData_val) {
                    $rental_count = intval($rentalData_val['view_count']);
                    $loc = $rentalData_val['location_id'];

                    $insight[$loc]['rental_flats'] = $rental_count;
                }
            }


            //count of underconstruction flats
            $flatData = (new \yii\db\Query())
                ->select('count(f.id) as view_count,location_id')
                ->from('flat f')
                ->leftJoin('projects p', 'f.projects_id=p.id')
                ->where('p.status=1 AND f.status=1 AND f.property_type=1 AND p.location_id IN(' . $get_loc_txt . ')')
                ->groupBy('p.location_id')
                ->createCommand()
                ->queryAll();

            if (!empty($flatData)) {
                foreach ($flatData as $flatData_val) {
                    $flat_count = intval($flatData_val['view_count']);
                    $loc = $flatData_val['location_id'];
                    $insight[$loc]['construction_flats'] = $flat_count;
                }
            }

            foreach ($insight as $insight_k => $insight_v) {
                if (!isset($insight[$insight_k]['resale_flats'])) {
                    $insight[$insight_k]['resale_flats'] = 0;
                }
                if (!isset($insight[$insight_k]['rental_flats'])) {
                    $insight[$insight_k]['rental_flats'] = 0;
                }
                if (!isset($insight[$insight_k]['construction_flats'])) {
                    $insight[$insight_k]['construction_flats'] = 0;
                }
            }
        }


        return $insight;
    }

    public function getmypost($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        //check if view access or not
        $view_posting_cp = true;

        $get_package_details = $this->getpackage($get_user->package_id);
        if (!empty($get_package_details)) {
            if (isset($get_package_details['view_posting_cp'])) {
                if ($get_package_details['view_posting_cp'] == 1) {
                    //$view_posting_cp = true;
                }
            }
        }

        $post_arr = null;

        $post = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';

        //No need to show team postings
        //$get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;

        $get_members_txt = implode(",", $get_members);

        $post_status = "";
        $get_orderby = "cs.id";
        $post_post_for = 1;
        if (!empty($querydata)) {
            $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
            $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
            $post_post_id = (!empty($querydata['post_id']) ? $querydata['post_id'] : '');
            $post_id = (!empty($querydata['id']) ? $querydata['id'] : '');
            $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
            $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
            $post_location_subtype_id = (!empty($querydata['location_subtype_id']) ? $querydata['location_subtype_id'] : '');

            $post_flat_type_id = (!empty($querydata['flat_type_id']) ? trim($querydata['flat_type_id']) : '');
            $post_flat_property_type = (!empty($querydata['flat_property_type']) ? trim($querydata['flat_property_type']) : '');
            $post_search = (!empty($querydata['search']) ? trim($querydata['search']) : '');

            $post_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
            $post_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : '');
            //$post_carpet = (!empty($querydata['carpet']) ? trim($querydata['carpet']) : '');

            $post_start_carpet = (!empty($querydata['min_carpet']) ? trim($querydata['min_carpet']) : '');
            $post_end_carpet = (!empty($querydata['max_carpet']) ? trim($querydata['max_carpet']) : '');

            $post_start_budget = (!empty($querydata['min_price']) ? trim($querydata['min_price']) : '');
            $post_end_budget = (!empty($querydata['max_price']) ? trim($querydata['max_price']) : '');

            $post_start_rent = (!empty($querydata['min_price_rent']) ? trim($querydata['min_price_rent']) : '');
            $post_end_rent = (!empty($querydata['max_price_rent']) ? trim($querydata['max_price_rent']) : '');

            $post_status = (isset($querydata['status']) ? trim($querydata['status']) : '');

            if (!empty($querydata['sort_name'])) {
                $get_sort = trim($querydata['sort_name']);
                if ($get_sort == 'created_on') {
                    $get_orderby = "cs.created_on";
                } elseif ($get_sort == 'budget') {
                    $get_orderby = "cs.budget";
                } elseif ($get_sort == 'rent') {
                    $get_orderby = "cs.monthly_rent";
                } elseif ($get_sort == 'carpet') {
                    $get_orderby = "cs.carpet";
                }
            }
        }

        $bookmark = (isset($querydata['bookmark']) ? trim($querydata['bookmark']) : '');

        $order_name = $get_orderby;
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        if (!empty($bookmark)) {
            $post_list_arr = $this->getbookmarkedpost($sm_cp_id);
            if (!empty($post_list_arr)) {
                $post_list_txt = implode(",", $post_list_arr);
            } else {
                $post_list_txt = "-1";
            }
            $where_sql = 'cs.id IN(' . $post_list_txt . ')  ';
        } else {
            $where_sql = 'cs.sm_cp_id IN(' . $get_members_txt . ')  ';
        }

        $where_sql .= ' AND cs.post_for IN(' . $post_post_for . ')';
        if ($post_post_for == 1) {
            if (!empty($post_type)) {
                $where_sql .= ' AND cs.type IN(' . $post_type . ')';
            }
        } else {
            if (!empty($post_rental_type)) {
                $where_sql .= ' AND cs.rental_type IN(' . $post_rental_type . ')';
            }
        }
        if (!empty($post_location_id) || !empty($post_location_subtype_id)) {
            if (!empty($post_location_subtype_id) && empty($post_location_id)) {
                //get loc array
                $get_loc_arr = $this->getlocfromsubtype($post_location_subtype_id);
                if (!empty($get_loc_arr)) {
                    $get_loc_arr_txt = implode(",", $get_loc_arr);
                    $where_sql .= ' AND cs.location_id IN(' . $get_loc_arr_txt . ')';
                }
            } else {
                if (!empty($post_location_id)) {
                    $where_sql .= ' AND cs.location_id IN (' . $post_location_id . ')';
                }
            }
        }


        if (!empty($post_post_id)) {
            $where_sql .= ' AND cs.post_id like "%' . $post_post_id . '%"';
        }

        if (!empty($post_id)) {
            $where_sql .= ' AND cs.id= "' . $post_id . '"';
        }

        if (!empty($post_search)) {
            $where_sql .= ' AND (cs.title like "%' . $post_search . '%" OR cs.description like "%' . $post_search . '%") ';
        }

        /*  if (!empty($post_carpet)) {
            $low_budget = $post_carpet - 50;
            $max_budget = $post_carpet + 50;
            $where_sql .= ' AND cs.carpet BETWEEN ' . $low_budget . ' AND ' . $max_budget;
        } */

        if (!empty($post_start_carpet)) {
            $where_sql .= ' AND cs.carpet>="' . $post_start_carpet . '"';
        }
        if (!empty($post_end_carpet)) {
            $where_sql .= ' AND cs.carpet<="' . $post_end_carpet . '"';
        }


        if ($post_post_for == 1) {
            //added on 1-7-24
            if (!empty($post_start_budget)) {
                $where_sql .= ' AND cs.budget>="' . $post_start_budget . '"';
            }
            if (!empty($post_end_budget)) {
                $where_sql .= ' AND cs.budget<="' . $post_end_budget . '"';
            }
        } else {
            if (!empty($post_start_rent)) {
                $where_sql .= ' AND cs.monthly_rent>="' . $post_start_rent . '"';
            }
            if (!empty($post_end_rent)) {
                $where_sql .= ' AND cs.monthly_rent<="' . $post_end_rent . '"';
            }
        }
        if (!empty($post_flat_type_id)) {
            $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
        }
        if (!empty($post_flat_property_type)) {
            $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
        }

        if (!empty($post_start_created_on_date)) {
            $where_sql .= ' AND DATE(cs.created_on)>="' . $post_start_created_on_date . '"';
        }
        if (!empty($post_end_created_on_date)) {
            $where_sql .= ' AND DATE(cs.created_on)<="' . $post_end_created_on_date . '"';
        }


        if ($post_status != "") {
            $where_sql .= ' AND cs.status IN(' . $post_status . ')';
        } /* else {
            $where_sql .= ' AND cs.status IN(0,1,2,3)';
        } */
        /* echo $where_sql;
        exit; */

        $post_query = (new \yii\db\Query())
            ->select('cs.sm_cp_id,cs.id,cs.post_id,cs.title,cs.description,cs.type,cs.budget,cs.flat_type_id,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,cs.location_id,l.name as location_name,sm_cp.name as posted_by,s.name as verifiedby,cs.message,cs.post_for,cs.deposit,cs.monthly_rent,cs.landmark,cs.rental_type')
            ->from('cp_customers_flats cs')
            ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
            ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
            ->leftJoin("staff s", 'cs.verified_by=s.id')

            ->where($where_sql)
            ->orderBy($order_name . ' ' . $order_type);
        $post_count = $post_query->count();
        /* echo $proj_count;
                exit; */
        $post_data = $post_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
                echo $proj_data;
                exit; */
            ->queryAll();



        if (!empty($post_data)) {
            foreach ($post_data as $post_data_key => $post_data_val) {
                $post[$post_data_key] = $post_data_val;

                $post[$post_data_key]['post_for_text'] = $this->post_post_for[$post_data_val['post_for']];
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                    unset($post[$post_data_key]['rental_type']);
                } else {
                    $post[$post_data_key]['rental_type_text'] = $this->post_rental_type[$post_data_val['rental_type']];
                    unset($post[$post_data_key]['type']);
                }

                $post[$post_data_key]['flat_property_type_text'] = null;
                if (!empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type_text'] = $this->flat_property_type[$post_data_val['flat_property_type']];
                } else {
                    $post[$post_data_key]['flat_property_type_text'] = null;
                }
                if (!isset($post_data_val['flat_property_type']) || empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type'] = 1;
                }
                if ($post_data_val['flat_property_type'] == 1) {
                    if (!empty($post_data_val['flat_type_id'])) {
                        $post[$post_data_key]['flat_type_id'] = (string) $post_data_val['flat_type_id'];
                        $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                    } else {
                        $post[$post_data_key]['flat_type_id'] = null;
                    }
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                }

                /* $post[$post_data_key]['flat_type_text'] = null;
                if (!empty($post_data_val['flat_type_id'])) {
                    $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                } */

                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budgetinwords'] = null;
                    if (!empty($post_data_val['budget'])) {
                        $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                        $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                    } else {
                        $post[$post_data_key]['budget'] = null;
                    }
                } else {
                    $post[$post_data_key]['depositinwords'] = null;
                    $post[$post_data_key]['monthly_rentinwords'] = null;
                    if (!empty($post_data_val['deposit'])) {
                        $post[$post_data_key]['deposit'] = (string) $post_data_val['deposit'];
                        $post[$post_data_key]['depositinwords'] = $this->AmountInWords($post_data_val['deposit']);
                    } else {
                        $post[$post_data_key]['deposit'] = null;
                    }
                    if (!empty($post_data_val['monthly_rent'])) {
                        $post[$post_data_key]['monthly_rent'] = (string) $post_data_val['monthly_rent'];
                        $post[$post_data_key]['monthly_rentinwords'] = $this->AmountInWords($post_data_val['monthly_rent']);
                    } else {
                        $post[$post_data_key]['monthly_rent'] = null;
                    }
                }


                /* if ($post_data_val['type'] == 1) {
                    $post[$post_data_key]['post_type'] = $this->post_type[$post_data_val['type']];
                } else if ($post_data_val['type'] == 2) {
                    $post[$post_data_key]['post_type'] = "Flat";
                } */


                $post[$post_data_key]['status'] = $post_data_val['status'];
                $post[$post_data_key]['statusText'] = $this->post_status[$post_data_val['status']];

                //Show no message if verified
                if (in_array($post_data_val['status'], [1, 2, 4])) {
                    $post[$post_data_key]['message'] = null;
                }

                $post[$post_data_key]['fulledit'] = false;
                $post[$post_data_key]['onlybudgetstatusedit'] = false;
                if (in_array($post_data_val['status'], [0, 3])) {
                    $post[$post_data_key]['fulledit'] = true;
                } else if (in_array($post_data_val['status'], [1])) {
                    $post[$post_data_key]['onlybudgetstatusedit'] = true;
                }


                //count by location
                //count by carpet
                //count by budget
                //caount by all 3 above
                $get_type = 0;
                $get_rental_type = 0;
                if ($post_data_val['post_for'] == 1) {
                    if ($post_data_val['type'] == 1) {
                        $get_type = 2;
                    } else {
                        $get_type = 1;
                    }
                } else {
                    if ($post_data_val['rental_type'] == 1) {
                        $get_rental_type = 2;
                    } else {
                        $get_rental_type = 1;
                    }
                }


                $post[$post_data_key]['bookmark'] = 'false';
                $getbookmark = PostingBookmark::findOne([
                    'sm_cp_id' => $sm_cp_id,
                    'posting_id' => $post_data_val['id'],
                ]);
                if (!empty($getbookmark)) {
                    $post[$post_data_key]['bookmark'] = 'true';
                }

                $post[$post_data_key]['self_post'] = "0";
                if (in_array($post_data_val['sm_cp_id'], $get_members)) {
                    $post[$post_data_key]['self_post'] = "1";
                }

                //to show contact or not
                $post[$post_data_key]['viewPostingCp'] = $view_posting_cp;

                /* $loc_arr = [];
                $loc_arr['type'] = $get_type;
                $loc_arr['location_id'] = $post_data_val['location_id'];
                $loc_count = $this->getpostcount($loc_arr, $sm_cp_id);
                $post[$post_data_key]['location_count'] = $loc_count;

                $carpet_arr = [];
                $carpet_arr['type'] = $get_type;
                $carpet_arr['carpet'] = $post_data_val['carpet'];
                $carpet_count = $this->getpostcount($carpet_arr, $sm_cp_id);
                $post[$post_data_key]['carpet_count'] = $carpet_count;

                $budget_arr = [];
                $budget_arr['type'] = $get_type;
                $budget_arr['budget'] = $post_data_val['budget'];
                $budget_count = $this->getpostcount($budget_arr, $sm_cp_id);
                $post[$post_data_key]['budget_count'] = $budget_count; */
                $combine_count = "0";
                $location_count = "0";
                $budget_count = "0";
                $all_count = "0";
                if ($post_data_val['status'] == 1) {
                    $combine_arr = [];
                    $combine_arr['post_for'] = $post_data_val['post_for'];
                    $combine_arr['type'] = $get_type;
                    $combine_arr['budget'] = $post_data_val['budget'];

                    $combine_arr['rental_type'] = $get_rental_type;
                    $combine_arr['monthly_rent'] = $post_data_val['monthly_rent'];

                    $combine_arr['flat_type_id'] = $post_data_val['flat_type_id'];
                    $combine_arr['flat_property_type'] = $post_data_val['flat_property_type'];
                    $combine_arr['carpet'] = $post_data_val['carpet'];
                    $combine_arr['location_id'] = $post_data_val['location_id'];

                    $all_count = $this->getpostcount($combine_arr, $sm_cp_id, 1);
                    $location_count = $this->getpostcount($combine_arr, $sm_cp_id, 2);
                    $budget_count = $this->getpostcount($combine_arr, $sm_cp_id, 3);
                    $combine_count = $this->getpostcount($combine_arr, $sm_cp_id, 4);
                }
                $post[$post_data_key]['combine_count'] = $combine_count;
                $post[$post_data_key]['location_count'] = $location_count;
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budget_count'] = $budget_count;
                } else {
                    $post[$post_data_key]['rent_count'] = $budget_count;
                }
                $post[$post_data_key]['all_count'] = $all_count;

                /* $post_view_data = $this->getpostinglimit($post_data_val['id'], $sm_cp_id);
                if (!empty($post_view_data)) {
                    $post[$post_data_key]['stat']['view_count'] = (string) $post_view_data['view_count'];
                    $post[$post_data_key]['stat']['limit_count'] = (string) $post_view_data['limit_count'];
                    $post[$post_data_key]['stat']['available_count'] = (string) $post_view_data['available_count'];
                    $post[$post_data_key]['stat']['others_view_count'] = (string) $post_view_data['others_view_count'];
                } */
            }
        }


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $post_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $post_arr['post'] = $post;
        $tag_arr['pagination'] = $pagination;

        return $post_arr;
    }

    public function getpostcount($querydata, $sm_cp_id, $combine = "")
    {
        //$combine = 1 for all,2-location,3-budget
        $get_count = 0;
        if (!empty($querydata)) {


            $get_members_txt = '';

            /* $get_members = $this->getaccessmembers($sm_cp_id);
            $get_members[] = $sm_cp_id;
            $get_members_txt = implode(",", $get_members); */
            $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
            $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
            $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
            $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
            $post_flat_type_id = (!empty($querydata['flat_type_id']) ? trim($querydata['flat_type_id']) : '');
            $post_flat_property_type = (!empty($querydata['flat_property_type']) ? trim($querydata['flat_property_type']) : '');
            $post_carpet = (!empty($querydata['carpet']) ? trim($querydata['carpet']) : '');
            $post_budget = (!empty($querydata['budget']) ? trim($querydata['budget']) : '');
            $post_monthly_rent = (!empty($querydata['monthly_rent']) ? trim($querydata['monthly_rent']) : '');

            //$where_sql = 'cs.sm_cp_id NOT IN(' . $get_members_txt . ')  ';
            $where_sql = '1 ';


            if ($post_post_for == 1) {
                if (!empty($post_type)) {
                    $where_sql .= ' AND cs.post_for=1 AND cs.type="' . $post_type . '"';
                }
            } else {
                if (!empty($post_rental_type)) {
                    $where_sql .= " AND cs.post_for=2 AND cs.rental_type='" . $post_rental_type . "'";
                }
            }

            if (!empty($post_flat_type_id)) {
                $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
            }

            if (!empty($post_flat_property_type)) {
                $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
            }

            //if (!empty($post_carpet)) {
            $low_carpet = $post_carpet - 50;
            $max_carpet = $post_carpet + 50;
            $where_sql .= ' AND cs.carpet BETWEEN ' . $low_carpet . ' AND ' . $max_carpet;
            //}

            //Not show spam marked posts
            $get_spam_arr = $this->getspampost($sm_cp_id);
            if (!empty($get_spam_arr)) {
                $get_spam_arr_txt = implode(",", $get_spam_arr);
                $where_sql .= ' AND cs.id NOT IN(' . $get_spam_arr_txt . ')';
            }

            //get nearby locations
            $nearby_loc = $this->get_nearby_loc($post_location_id);

            if ($combine == 1) {
                if ($post_post_for == 1) {
                    if (!empty($post_budget)) {
                        $low_budget = $post_budget - 1000000;
                        $max_budget = $post_budget + 1000000;
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . '';
                        $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . ') OR (cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN(' . $nearby_loc . ')))';
                    }
                } else {
                    if (!empty($post_monthly_rent)) {
                        $low_budget = $post_monthly_rent - 5000;
                        $max_budget = $post_monthly_rent + 5000;
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . '';
                        $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . ') OR (cs.monthly_rent BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN(' . $nearby_loc . ')))';
                    }
                }
                /* if (!empty($post_location_id)) {
                    $where_sql .= ' OR cs.location_id IN (' . $post_location_id . '))';
                } */
            } else if ($combine == 2) {

                if (!empty($post_location_id)) {
                    $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . '))';
                }
            } else if ($combine == 3) {
                if ($post_post_for == 1) {
                    if (!empty($post_budget)) {
                        $low_budget = $post_budget - 1000000;
                        $max_budget = $post_budget + 1000000;
                        $where_sql .= ' AND (cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN(' . $nearby_loc . '))';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . ')';
                    }
                } else {
                    if (!empty($post_monthly_rent)) {
                        $low_budget = $post_monthly_rent - 5000;
                        $max_budget = $post_monthly_rent + 5000;
                        $where_sql .= ' AND (cs.monthly_rent BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN(' . $nearby_loc . '))';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . ')';
                    }
                }
            } else if ($combine == 4) {
                if ($post_post_for == 1) {
                    if (!empty($post_budget)) {
                        $low_budget = $post_budget - 1000000;
                        $max_budget = $post_budget + 1000000;
                        $where_sql .= ' AND (cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget . ')';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . ')';
                    }
                } else {
                    if (!empty($post_monthly_rent)) {
                        $low_budget = $post_monthly_rent - 5000;
                        $max_budget = $post_monthly_rent + 5000;
                        $where_sql .= ' AND (cs.monthly_rent BETWEEN ' . $low_budget . ' AND ' . $max_budget . ')';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . ')';
                    }
                }
                if (!empty($post_location_id)) {
                    $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . '))';
                }
            }

            $where_sql .= ' AND cs.status IN(1)';

            //Only for Live
            $where_sql .= ' AND sm_cp.is_test=0';

            //echo $where_sql;
            //exit;

            $post_query = (new \yii\db\Query())
                ->select('cs.id,cs.type,cs.budget,cs.flat_type_id,,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,l.name as location_name,sm_cp.name as posted_by,cp.company_name as firm_name,sm_cp.contact,s.name as verifiedby,cs.landmark')
                ->from('cp_customers_flats cs')
                ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
                ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0 ')
                ->leftJoin("channelpartner cp", 'sm_cp.channelpartner_id=cp.id')
                ->leftJoin("staff s", 'cs.verified_by=s.id')

                ->where($where_sql);
            $get_count = $post_query->count();
        }
        return  $get_count;
    }


    public function getlistpost($get_user, $querydata)
    {
        //This function is not used
        exit;
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        $post_arr = null;

        $post = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';

        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;

        $get_members_txt = implode(",", $get_members);


        if (!empty($querydata)) {
            $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
            $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
            $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
            $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
            $post_flat_type_id = (!empty($querydata['flat_type_id']) ? trim($querydata['flat_type_id']) : '');
            $post_flat_property_type = (!empty($querydata['flat_property_type']) ? trim($querydata['flat_property_type']) : '');

            $post_carpet = (!empty($querydata['carpet']) ? trim($querydata['carpet']) : '');
            $post_budget = (!empty($querydata['budget']) ? trim($querydata['budget']) : '');
        }



        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'cs.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = 'cs.sm_cp_id NOT IN(' . $get_members_txt . ')  ';



        if (!empty($post_type)) {
            $where_sql .= ' AND cs.type="' . $post_type . '"';
        }
        if (!empty($post_location_id)) {
            $where_sql .= ' AND cs.location_id IN (' . $post_location_id . ')';
        }

        if (!empty($post_budget)) {
            $low_budget = $post_budget - 1000000;
            $max_budget = $post_budget + 1000000;
            $where_sql .= ' AND cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget;
        }

        if (!empty($post_carpet)) {
            $low_carpet = $post_carpet - 50;
            $max_carpet = $post_carpet + 50;
            $where_sql .= ' AND cs.carpet BETWEEN ' . $low_carpet . ' AND ' . $max_carpet;
        }

        if (!empty($post_flat_type_id)) {
            $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
        }
        if (!empty($post_flat_property_type)) {
            $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
        }


        $where_sql .= ' AND cs.status IN(1)';

        /* echo $where_sql;
        exit; */

        $post_query = (new \yii\db\Query())
            ->select('cs.id,cs.title,cs.description,cs.type,cs.landmark,cs.budget,cs.flat_type_id,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,l.name as location_name,sm_cp.name as posted_by,cp.company_name as firm_name,sm_cp.contact,s.name as verifiedby')
            ->from('cp_customers_flats cs')
            ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
            ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
            ->leftJoin("channelpartner cp", 'sm_cp.channelpartner_id=cp.id')
            ->leftJoin("staff s", 'cs.verified_by=s.id')

            ->where($where_sql)
            ->orderBy($order_name . ' ' . $order_type);
        $post_count = $post_query->count();
        /* echo $proj_count;
                exit; */
        $post_data = $post_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
                echo $proj_data;
                exit; */
            ->queryAll();



        if (!empty($post_data)) {
            foreach ($post_data as $post_data_key => $post_data_val) {
                $post[$post_data_key] = $post_data_val;

                $post[$post_data_key]['flat_property_type_text'] = null;
                if (!empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type_text'] = $this->flat_property_type[$post_data_val['flat_property_type']];
                } else {
                    $post[$post_data_key]['flat_property_type_text'] = null;
                }
                if (!isset($post_data_val['flat_property_type']) || empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type'] = 1;
                }
                if ($post_data_val['flat_property_type'] == 1) {
                    if (!empty($post_data_val['flat_type_id'])) {
                        $post[$post_data_key]['flat_type_id'] = (string) $post_data_val['flat_type_id'];
                        $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                    } else {
                        $post[$post_data_key]['flat_type_id'] = null;
                    }
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                }

                /* $post[$post_data_key]['flat_type_text'] = null;
                if (!empty($post_data_val['flat_type_id'])) {
                    $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                } */

                $post[$post_data_key]['budgetinwords'] = null;
                if (!empty($post_data_val['budget'])) {
                    $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                    $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                } else {
                    $post[$post_data_key]['budget'] = null;
                }

                $post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                /* if ($post_data_val['type'] == 1) {
                    $post[$post_data_key]['post_type'] = "Customer";
                } else if ($post_data_val['type'] == 2) {
                    $post[$post_data_key]['post_type'] = "Flat";
                } */


                /* $post[$post_data_key]['status'] = $post_data_val['status'];
                $post[$post_data_key]['statusText'] = $this->post_status[$post_data_val['status']]; */
            }
        }


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $post_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $post_arr['post'] = $post;
        $tag_arr['pagination'] = $pagination;

        return $post_arr;
    }

    public function getlistads($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        $is_test = $get_user->is_test;

        $post_arr = null;

        $post = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';

        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;

        $get_members_txt = implode(",", $get_members);

        $post_status = "";
        $get_orderby = "cs.id";
        $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
        //if (!empty($querydata)) {

        $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
        $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
        $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
        $post_flat_type_id = (!empty($querydata['flat_type_id']) ? trim($querydata['flat_type_id']) : '');
        $post_flat_property_type = (!empty($querydata['flat_property_type']) ? trim($querydata['flat_property_type']) : '');
        $post_search = (!empty($querydata['search']) ? trim($querydata['search']) : '');

        $post_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
        $post_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : '');
        //$post_carpet = (!empty($querydata['carpet']) ? trim($querydata['carpet']) : '');

        $post_start_carpet = (!empty($querydata['min_carpet']) ? trim($querydata['min_carpet']) : '');
        $post_end_carpet = (!empty($querydata['max_carpet']) ? trim($querydata['max_carpet']) : '');

        $post_start_budget = (!empty($querydata['min_price']) ? trim($querydata['min_price']) : '');
        $post_end_budget = (!empty($querydata['max_price']) ? trim($querydata['max_price']) : '');

        $post_start_rent = (!empty($querydata['min_price_rent']) ? trim($querydata['min_price_rent']) : '');
        $post_end_rent = (!empty($querydata['max_price_rent']) ? trim($querydata['max_price_rent']) : '');

        if (!empty($querydata['sort_name'])) {
            $get_sort = trim($querydata['sort_name']);
            if ($get_sort == 'created_on') {
                $get_orderby = "cs.created_on";
            } elseif ($get_sort == 'budget') {
                $get_orderby = "cs.budget";
            } elseif ($get_sort == 'rent') {
                $get_orderby = "cs.monthly_rent";
            } elseif ($get_sort == 'carpet') {
                $get_orderby = "cs.carpet";
            }
        }
        //}

        $order_name = $get_orderby;
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = 'cs.posting_type=2 ';

        if ($post_post_for == 1) {
            if (!empty($post_type)) {
                $where_sql .= ' AND cs.type IN(' . $post_type . ')';
            }
        } else {
            if (!empty($post_rental_type)) {
                $where_sql .= ' AND cs.rental_type IN(' . $post_rental_type . ')';
            }
        }
        if (!empty($post_location_id)) {
            $where_sql .= ' AND cs.location_id IN (' . $post_location_id . ')';
        }

        if (!empty($post_search)) {
            $where_sql .= ' AND (cs.title like "%' . $post_search . '%" OR cs.description like "%' . $post_search . '%") ';
        }

        /*  if (!empty($post_carpet)) {
            $low_budget = $post_carpet - 50;
            $max_budget = $post_carpet + 50;
            $where_sql .= ' AND cs.carpet BETWEEN ' . $low_budget . ' AND ' . $max_budget;
        } */

        if (!empty($post_start_carpet)) {
            $where_sql .= ' AND cs.carpet>="' . $post_start_carpet . '"';
        }
        if (!empty($post_end_carpet)) {
            $where_sql .= ' AND cs.carpet<="' . $post_end_carpet . '"';
        }


        //added on 1-7-24
        /* if (!empty($post_start_budget)) {
            $where_sql .= ' AND cs.budget>="' . $post_start_budget . '"';
        }
        if (!empty($post_end_budget)) {
            $where_sql .= ' AND cs.budget<="' . $post_end_budget . '"';
        } */

        if ($post_post_for == 1) {
            //added on 1-7-24
            if (!empty($post_start_budget)) {
                $where_sql .= ' AND cs.budget>="' . $post_start_budget . '"';
            }
            if (!empty($post_end_budget)) {
                $where_sql .= ' AND cs.budget<="' . $post_end_budget . '"';
            }
        } else {
            if (!empty($post_start_rent)) {
                $where_sql .= ' AND cs.monthly_rent>="' . $post_start_rent . '"';
            }
            if (!empty($post_end_rent)) {
                $where_sql .= ' AND cs.monthly_rent<="' . $post_end_rent . '"';
            }
        }


        if (!empty($post_flat_type_id)) {
            $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
        }
        if (!empty($post_flat_property_type)) {
            $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
        }

        if (!empty($post_start_created_on_date)) {
            $where_sql .= ' AND DATE(cs.created_on)>="' . $post_start_created_on_date . '"';
        }
        if (!empty($post_end_created_on_date)) {
            $where_sql .= ' AND DATE(cs.created_on)<="' . $post_end_created_on_date . '"';
        }



        $where_sql .= ' AND cs.status IN(1)';

        if (!$is_test) {
            $where_sql .= ' AND sm_cp.is_test=0';
        }

        /* echo $where_sql;
        exit; */

        $post_query = (new \yii\db\Query())
            ->select('cs.sm_cp_id,cs.id,cs.title,cs.description,cs.type,cs.budget,cs.flat_type_id,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,cs.location_id,l.name as location_name,sm_cp.name as posted_by,s.name as verifiedby,cs.post_for,cs.deposit,cs.monthly_rent,cs.landmark,cs.rental_type')
            ->from('cp_customers_flats cs')
            ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
            ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
            ->leftJoin("staff s", 'cs.verified_by=s.id')

            ->where($where_sql)
            ->orderBy($order_name . ' ' . $order_type);
        $post_count = $post_query->count();
        /* echo $proj_count;
                exit; */
        $post_data = $post_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
                echo $proj_data;
                exit; */
            ->queryAll();



        if (!empty($post_data)) {
            foreach ($post_data as $post_data_key => $post_data_val) {
                $post[$post_data_key] = $post_data_val;

                $post[$post_data_key]['post_for_text'] = $this->post_post_for[$post_data_val['post_for']];
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                    unset($post[$post_data_key]['rental_type']);
                } else {
                    $post[$post_data_key]['rental_type_text'] = $this->post_rental_type[$post_data_val['rental_type']];
                    unset($post[$post_data_key]['type']);
                }


                $post[$post_data_key]['flat_property_type_text'] = null;
                if (!empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type_text'] = $this->flat_property_type[$post_data_val['flat_property_type']];
                } else {
                    $post[$post_data_key]['flat_property_type_text'] = null;
                }
                if (!isset($post_data_val['flat_property_type']) || empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type'] = 1;
                }
                if ($post_data_val['flat_property_type'] == 1) {
                    if (!empty($post_data_val['flat_type_id'])) {
                        $post[$post_data_key]['flat_type_id'] = (string) $post_data_val['flat_type_id'];
                        $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                    } else {
                        $post[$post_data_key]['flat_type_id'] = null;
                    }
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                }


                /* $post[$post_data_key]['flat_type_text'] = null;
                if (!empty($post_data_val['flat_type_id'])) {
                    $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                } */
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budgetinwords'] = null;
                    if (!empty($post_data_val['budget'])) {
                        $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                        $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                    } else {
                        $post[$post_data_key]['budget'] = null;
                    }
                } else {
                    $post[$post_data_key]['depositinwords'] = null;
                    $post[$post_data_key]['monthly_rentinwords'] = null;
                    if (!empty($post_data_val['deposit'])) {
                        $post[$post_data_key]['deposit'] = (string) $post_data_val['deposit'];
                        $post[$post_data_key]['depositinwords'] = $this->AmountInWords($post_data_val['deposit']);
                    } else {
                        $post[$post_data_key]['deposit'] = null;
                    }
                    if (!empty($post_data_val['monthly_rent'])) {
                        $post[$post_data_key]['monthly_rent'] = (string) $post_data_val['monthly_rent'];
                        $post[$post_data_key]['monthly_rentinwords'] = $this->AmountInWords($post_data_val['monthly_rent']);
                    } else {
                        $post[$post_data_key]['monthly_rent'] = null;
                    }
                }

                //$post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                /* if ($post_data_val['type'] == 1) {
                    $post[$post_data_key]['post_type'] = $this->post_type[$post_data_val['type']];
                } else if ($post_data_val['type'] == 2) {
                    $post[$post_data_key]['post_type'] = "Flat";
                } */

                if (!empty($post_data_val['sm_cp_id'])) {

                    $smcp_model = SmCp::find()->where(['sm_cp_id' => $post_data_val['sm_cp_id'], 'is_deleted' => 0])->one();
                    $post[$post_data_key]['cp_name'] = $smcp_model->name;
                    $get_cp_contact = $smcp_model->contact;
                    $post[$post_data_key]['cp_contact'] = $get_cp_contact;
                    $cp_id = $smcp_model->channelpartner_id;

                    $cp_model = Channelpartner::find()->where(['id' => $cp_id])->one();
                    $post[$post_data_key]['cp_company_name'] = $cp_model->company_name;
                }



                $post[$post_data_key]['status'] = $post_data_val['status'];
                $post[$post_data_key]['statusText'] = $this->post_status[$post_data_val['status']];

                $get_post_content_arr = null;
                $get_post_content_data = PostingContent::find()->select('content')->where(['post_id' => $post_data_val['id']])->asArray()->all();
                if (!empty($get_post_content_data)) {
                    $c_count = 0;
                    foreach ($get_post_content_data as $get_post_content_data_val) {
                        $get_post_content_arr[$c_count]['link'] = \Yii::$app->params['web_path'] . 'files/posting/' . $get_post_content_data_val['content'];
                        $c_count++;
                    }
                    $post[$post_data_key]['content'] = $get_post_content_arr;
                }

                $post[$post_data_key]['viewed'] = false;
                $post[$post_data_key]['self_post'] = "0";
                if (!in_array($post_data_val['sm_cp_id'], $get_members)) {
                    //check if posting is viewed by offer
                    $postview_model = CpCustomersFlatsView::find()->where(['sm_cp_id' => $sm_cp_id, 'post_id' => $post_data_val['id']])->one();
                    if (!empty($postview_model)) {
                        $post[$post_data_key]['viewed'] = true;
                        $post[$post_data_key]['viewed_on'] = $postview_model->created_on;
                    }
                } else {
                    $post[$post_data_key]['self_post'] = "1";
                }




                //count by location
                //count by carpet
                //count by budget
                //caount by all 3 above
                /* if ($post_data_val['type'] == 1) {
                    $get_type = 2;
                } else {
                    $get_type = 1;
                } */
                /* $loc_arr = [];
                $loc_arr['type'] = $get_type;
                $loc_arr['location_id'] = $post_data_val['location_id'];
                $loc_count = $this->getpostcount($loc_arr, $sm_cp_id);
                $post[$post_data_key]['location_count'] = $loc_count;

                $carpet_arr = [];
                $carpet_arr['type'] = $get_type;
                $carpet_arr['carpet'] = $post_data_val['carpet'];
                $carpet_count = $this->getpostcount($carpet_arr, $sm_cp_id);
                $post[$post_data_key]['carpet_count'] = $carpet_count;

                $budget_arr = [];
                $budget_arr['type'] = $get_type;
                $budget_arr['budget'] = $post_data_val['budget'];
                $budget_count = $this->getpostcount($budget_arr, $sm_cp_id);
                $post[$post_data_key]['budget_count'] = $budget_count; */
                /* $combine_count = "0";
                $location_count = "0";
                $budget_count = "0";
                if ($post_data_val['status'] == 1) {
                    $combine_arr = [];
                    $combine_arr['type'] = $get_type;
                    $combine_arr['flat_type_id'] = $post_data_val['flat_type_id'];
                    $combine_arr['budget'] = $post_data_val['budget'];
                    $combine_arr['carpet'] = $post_data_val['carpet'];
                    $combine_arr['location_id'] = $post_data_val['location_id'];

                    $combine_count = $this->getpostcount($combine_arr, $sm_cp_id, 1);
                    $location_count = $this->getpostcount($combine_arr, $sm_cp_id, 2);
                    $budget_count = $this->getpostcount($combine_arr, $sm_cp_id, 3);
                }
                $post[$post_data_key]['combine_count'] = $combine_count;
                $post[$post_data_key]['location_count'] = $location_count;
                $post[$post_data_key]['budget_count'] = $budget_count; */
            }
        }


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $post_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $post_arr['post'] = $post;
        $post_arr['pagination'] = $pagination;

        return $post_arr;
    }




    public function getviewedposting($postdata)
    {
        $post_arr = null;
        $postdata_arr = null;
        if ($postdata['viewBy'] == 1) {
            //posting seen by me
            $smcp_arr = CpCustomersFlatsView::findAll([
                'my_post_id' => $postdata['post_id']
            ]);
            if (!empty($smcp_arr)) {
                foreach ($smcp_arr as $smcp_arr_val) {
                    $post_arr['post_id'][] = $smcp_arr_val->post_id;
                    $post_arr[$smcp_arr_val->post_id] = $smcp_arr_val->created_on;
                }
            }
        } elseif ($postdata['viewBy'] == 2) {
            //posting seen by me
            $smcp_arr = CpCustomersFlatsView::findAll([
                'post_id' => $postdata['post_id']
            ]);
            if (!empty($smcp_arr)) {
                foreach ($smcp_arr as $smcp_arr_val) {
                    $post_arr['post_id'][] = $smcp_arr_val->my_post_id;
                    $post_arr[$smcp_arr_val->post_id] = $smcp_arr_val->created_on;
                }
            }
        }
        return $post_arr;
    }

    public function getmypostlist($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        //check if view access or not
        $view_posting_cp = true;

        $get_package_details = $this->getpackage($get_user->package_id);
        if (!empty($get_package_details)) {
            if (isset($get_package_details['view_posting_cp'])) {
                if ($get_package_details['view_posting_cp'] == 1) {
                    //$view_posting_cp = true;
                }
            }
        }

        $post_arr = null;

        $post = null;
        /*  echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';

        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;

        $get_members_txt = implode(",", $get_members);
        $get_orderby = "";

        $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
        $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
        $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
        $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
        $post_flat_type_id = (!empty($querydata['flat_type_id']) ? trim($querydata['flat_type_id']) : '');
        $post_flat_property_type = (!empty($querydata['flat_property_type']) ? trim($querydata['flat_property_type']) : '');
        $post_carpet = (!empty($querydata['carpet']) ? trim($querydata['carpet']) : '');
        $post_budget = (!empty($querydata['budget']) ? trim($querydata['budget']) : '');
        $post_rent = (!empty($querydata['rent']) ? trim($querydata['rent']) : '');
        $post_viewBy = (!empty($querydata['viewBy']) ? trim($querydata['viewBy']) : '');

        if (!empty($querydata['sort_name'])) {
            $get_sort = trim($querydata['sort_name']);
            if ($get_sort == 'created_on') {
                $get_orderby = "cs.created_on";
            } elseif ($get_sort == 'budget') {
                $get_orderby = "cs.budget";
            } elseif ($get_sort == 'rent') {
                $get_orderby = "cs.monthly_rent";
            } elseif ($get_sort == 'carpet') {
                $get_orderby = "cs.carpet";
            }
        }

        $order_name = $get_orderby;
        //$order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'cs.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        //Can see own team posting in results.
        //$where_sql = 'cs.sm_cp_id NOT IN(' . $get_members_txt . ')  ';
        $where_sql = "cs.status IN(1)";

        $where_sql .= ' AND cs.post_for IN(' . $post_post_for . ')';

        if ($post_post_for == 1) {
            if (!empty($post_type)) {
                $where_sql .= ' AND cs.type IN(' . $post_type . ')';
            }
        } else {
            if (!empty($post_rental_type)) {
                $where_sql .= ' AND cs.rental_type IN(' . $post_rental_type . ')';
            }
        }

        //$where_sql .= ' AND cs.type="' . $post_type . '"';

        if (!empty($post_flat_type_id)) {
            $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
        }
        if (!empty($post_flat_property_type)) {
            $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
        }

        if (!empty($post_viewBy)) {
            $pass_data['viewBy'] = $post_viewBy;
            $pass_data['post_id'] = $querydata['post_id'];
            $get_view_post_arr = $this->getviewedposting($pass_data);
            if (!empty($get_view_post_arr)) {
                $post_id_txt = implode(",", $get_view_post_arr['post_id']);
                $where_sql .= ' AND (cs.id IN(' . $post_id_txt . '))';
            }
        } else {

            //get nearby location
            $nearby_loc = $this->get_nearby_loc($post_location_id);

            $low_carpet = $post_carpet - 50;
            $max_carpet = $post_carpet + 50;
            $where_sql .= ' AND (cs.carpet BETWEEN ' . $low_carpet . ' AND ' . $max_carpet . ')';

            if (isset($querydata['searchBy']) && !empty($querydata['searchBy'])) {

                if ($querydata['searchBy'] == 1) {
                    //all
                    if (!empty($post_budget)) {
                        $low_budget = $post_budget - 1000000;
                        $max_budget = $post_budget + 1000000;
                        $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . ') OR (cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN (' . $nearby_loc . ')))';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . '';
                    }
                    if (!empty($post_rent)) {
                        $low_budget = $post_rent - 5000;
                        $max_budget = $post_rent + 5000;
                        $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . ') OR (cs.monthly_rent BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN (' . $nearby_loc . ')))';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . '';
                    }
                    if (!empty($post_location_id)) {
                        //$where_sql .= ' OR cs.location_id IN (' . $post_location_id . '))';
                    }
                } else if ($querydata['searchBy'] == 2) {
                    //location
                    if (!empty($post_location_id)) {
                        $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . '))';
                    }
                } else if ($querydata['searchBy'] == 3) {
                    //budget
                    if (!empty($post_budget)) {
                        $low_budget = $post_budget - 1000000;
                        $max_budget = $post_budget + 1000000;
                        $where_sql .= ' AND (cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN (' . $nearby_loc . '))';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . ')';
                    }
                    if (!empty($post_rent)) {
                        $low_budget = $post_rent - 5000;
                        $max_budget = $post_rent + 5000;
                        $where_sql .= ' AND (cs.monthly_rent BETWEEN ' . $low_budget . ' AND ' . $max_budget . ' AND cs.location_id IN (' . $nearby_loc . '))';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . '';
                    }
                } else if ($querydata['searchBy'] == 4) {
                    //combined
                    if (!empty($post_budget)) {
                        $low_budget = $post_budget - 1000000;
                        $max_budget = $post_budget + 1000000;
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . ')';
                        $where_sql .= ' AND (cs.budget BETWEEN ' . $low_budget . ' AND ' . $max_budget . ')';
                    }
                    if (!empty($post_rent)) {
                        $low_budget = $post_rent - 5000;
                        $max_budget = $post_rent + 5000;
                        $where_sql .= ' AND (cs.monthly_rent BETWEEN ' . $low_budget . ' AND ' . $max_budget . ')';
                        //$where_sql .= ' AND (cs.budget <= ' . $max_budget . '';
                    }
                    if (!empty($post_location_id)) {
                        $where_sql .= ' AND (cs.location_id IN (' . $post_location_id . '))';
                    }
                }
            }
        }

        //Not show spam marked posts
        $get_spam_arr = $this->getspampost($sm_cp_id);
        if (!empty($get_spam_arr)) {
            $get_spam_arr_txt = implode(",", $get_spam_arr);
            $where_sql .= ' AND cs.id NOT IN(' . $get_spam_arr_txt . ')';
        }

        //Only for Live
        $where_sql .= ' AND sm_cp.is_test=0';

        //$where_sql .= ' AND cs.status IN(1)';

        /* echo $where_sql;
        exit; */

        if (empty($order_name)) {
            //$sort_text = new Expression("FIELD(projects.location_id, " . $cp_location . ") DESC");
            //$sort_text = $order_name . ' ' . $order_type;
            $sort_text = "cs.rank DESC,cs.id DESC";
        } else {
            $sort_text = $order_name . ' ' . $order_type;
        }
        //gold and platinum posts on top.
        $sort_text = 'new Expression("CASE WHEN sm_cp.package_id IN (7,8,6) THEN 0 ELSE 1 END, sm_cp.package_id")';

        $post_query = (new \yii\db\Query())
            ->select('cs.id,cs.post_id,cs.title,cs.description,cs.type,cs.budget,cs.flat_type_id,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,cs.location_id,l.name as location_name,sm_cp.name as cp_name,cp.company_name as cp_company_name,sm_cp.contact as cp_contact,s.name as verifiedby,cs.sm_cp_id,cs.post_for,cs.deposit,cs.monthly_rent,cs.landmark,cs.rental_type')
            ->from('cp_customers_flats cs')
            ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
            ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
            ->leftJoin("channelpartner cp", 'sm_cp.channelpartner_id=cp.id')
            ->leftJoin("staff s", 'cs.verified_by=s.id')

            ->where($where_sql)
            //>orderBy($sort_text);
            ->orderBy(new Expression("CASE WHEN sm_cp.package_id IN (7,8,6) THEN 0 ELSE 1 END, sm_cp.package_id"));
        $post_count = $post_query->count();
        /* echo $proj_count;
                exit; */
        $post_data = $post_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
        echo $post_data;
        exit; */
            ->queryAll();



        if (!empty($post_data)) {
            foreach ($post_data as $post_data_key => $post_data_val) {
                $post[$post_data_key] = $post_data_val;
                $post[$post_data_key]['post_id'] = $querydata['post_id'];

                $post[$post_data_key]['post_for_text'] = $this->post_post_for[$post_data_val['post_for']];
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                    unset($post[$post_data_key]['rental_type']);
                } else {
                    $post[$post_data_key]['rental_type_text'] = $this->post_rental_type[$post_data_val['rental_type']];
                    unset($post[$post_data_key]['type']);
                }

                $post[$post_data_key]['flat_property_type_text'] = null;
                if (!empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type_text'] = $this->flat_property_type[$post_data_val['flat_property_type']];
                } else {
                    $post[$post_data_key]['flat_property_type_text'] = null;
                }
                if (!isset($post_data_val['flat_property_type']) || empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type'] = 1;
                }
                if ($post_data_val['flat_property_type'] == 1) {
                    if (!empty($post_data_val['flat_type_id'])) {
                        $post[$post_data_key]['flat_type_id'] = (string) $post_data_val['flat_type_id'];
                        $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                    } else {
                        $post[$post_data_key]['flat_type_id'] = null;
                    }
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                }

                /* $post[$post_data_key]['flat_type_text'] = null;
                if (!empty($post_data_val['flat_type_id'])) {
                    $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                } */

                /* $post[$post_data_key]['budgetinwords'] = null;
                if (!empty($post_data_val['budget'])) {
                    $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                    $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                } else {
                    $post[$post_data_key]['budget'] = null;
                } */

                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budgetinwords'] = null;
                    if (!empty($post_data_val['budget'])) {
                        $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                        $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                    } else {
                        $post[$post_data_key]['budget'] = null;
                    }
                } else {
                    $post[$post_data_key]['depositinwords'] = null;
                    $post[$post_data_key]['monthly_rentinwords'] = null;
                    if (!empty($post_data_val['deposit'])) {
                        $post[$post_data_key]['deposit'] = (string) $post_data_val['deposit'];
                        $post[$post_data_key]['depositinwords'] = $this->AmountInWords($post_data_val['deposit']);
                    } else {
                        $post[$post_data_key]['deposit'] = null;
                    }
                    if (!empty($post_data_val['monthly_rent'])) {
                        $post[$post_data_key]['monthly_rent'] = (string) $post_data_val['monthly_rent'];
                        $post[$post_data_key]['monthly_rentinwords'] = $this->AmountInWords($post_data_val['monthly_rent']);
                    } else {
                        $post[$post_data_key]['monthly_rent'] = null;
                    }
                }


                /* if ($post_data_val['type'] == 1) {
                    $post[$post_data_key]['post_type'] = "Customer";
                } else if ($post_data_val['type'] == 2) {
                    $post[$post_data_key]['post_type'] = "Flat";
                } */

                $post[$post_data_key]['location_match'] = false;
                if ($post_data_val['location_id'] == $post_location_id) {
                    $post[$post_data_key]['location_match'] = true;
                }
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budget_match'] = false;
                    if (isset($low_budget)) {
                        if ($post_data_val['budget'] >= $low_budget && $post_data_val['budget'] <= $max_budget) {
                            $post[$post_data_key]['budget_match'] = true;
                        }
                    }
                } else {
                    $post[$post_data_key]['rent_match'] = false;
                    if (isset($low_budget)) {
                        if ($post_data_val['monthly_rent'] >= $low_budget && $post_data_val['monthly_rent'] <= $max_budget) {
                            $post[$post_data_key]['rent_match'] = true;
                        }
                    }
                }
                /*  $post[$post_data_key]['carpet_match'] = "false";
                if ($post_data_val['carpet'] >= $low_carpet && $post_data_val['carpet'] <= $max_carpet) {
                    $post[$post_data_key]['carpet_match'] = "true";
                } */
                /*  $post[$post_data_key]['viewed_on'] = null;
                if (!empty($post_viewBy)) {
                    if (!empty($get_view_post_arr[$post_data_val['id']])) {
                        $post[$post_data_key]['viewed_on'] = $get_view_post_arr[$post_data_val['id']];
                    }
                } */
                $post[$post_data_key]['self_post'] = "0";
                if (in_array($post_data_val['sm_cp_id'], $get_members)) {
                    $post[$post_data_key]['self_post'] = "1";
                }

                $post[$post_data_key]['bookmark'] = 'false';
                $getbookmark = PostingBookmark::findOne([
                    'sm_cp_id' => $sm_cp_id,
                    'posting_id' => $post_data_val['id'],
                ]);
                if (!empty($getbookmark)) {
                    $post[$post_data_key]['bookmark'] = 'true';
                }


                $post[$post_data_key]['status'] = $post_data_val['status'];
                $post[$post_data_key]['statusText'] = $this->post_status[$post_data_val['status']];

                $post[$post_data_key]['viewPostingCp'] = $view_posting_cp;

                /* $post[$post_data_key]['contacted'] = false;
                //check if posting is viewed
                $postview_model = CpCustomersFlatsView::find()->where(['sm_cp_id' => $sm_cp_id, 'post_id' => $post_data_val['id']])->one();
                if (!empty($postview_model)) {
                    $post[$post_data_key]['contacted'] = true;
                } */

                //$post[$post_data_key]['contacted'] = false;
                $post[$post_data_key]['viewed'] = false;
                $flatcontact_data = CpCustomersFlatsView::find()->where('post_id="' . $post_data_val['id'] . '" AND sm_cp_id="' . $sm_cp_id . '"  ')->orderBy(['created_on' => SORT_DESC])->one();
                if (!empty($flatcontact_data)) {
                    /* $post[$post_data_key]['contacted'] = true; */
                    $post[$post_data_key]['viewed'] = true;
                    $post[$post_data_key]['viewed_on'] = $flatcontact_data->created_on;
                } else {
                    $post[$post_data_key]['cp_name'] = null;
                    $post[$post_data_key]['cp_company_name'] = null;
                    $post[$post_data_key]['cp_contact'] = null;
                }



                /* else {
                    $flatview_data = CpCustomersFlatsView::find()->where('post_id="' . $post_data_val['id'] . '" AND sm_cp_id="' . $sm_cp_id . '" ')->orderBy(['created_on' => SORT_DESC])->one();
                    if (!empty($flatview_data)) {
                        $post[$post_data_key]['viewed'] = true;
                    }
                } */
            }
        }
        /* $poststat = [];
        $post_view_data = $this->getpostinglimit($querydata['post_id'], $sm_cp_id);
        if (!empty($post_view_data)) {
            $poststat['view_count'] = (string) $post_view_data['view_count'];
            $poststat['limit_count'] = (string) $post_view_data['limit_count'];
            $poststat['available_count'] = (string) $post_view_data['available_count'];
            $poststat['others_view_count'] = (string) $post_view_data['others_view_count'];
        } */


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $post_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $post_arr['post'] = $post;
        //$post_arr['stat'] = $poststat;
        $post_arr['pagination'] = $pagination;

        return $post_arr;
    }

    public function getotherpostlist($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        $post_arr = null;

        $post = null;
        /*  echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';

        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;

        $get_members_txt = implode(",", $get_members);
        $get_orderby = "";

        $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
        $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
        $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
        $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');
        $post_id = (!empty($querydata['post_id']) ? $querydata['post_id'] : '');


        if (!empty($querydata['sort_name'])) {
            $get_sort = trim($querydata['sort_name']);
            if ($get_sort == 'created_on') {
                $get_orderby = "cs.created_on";
            } elseif ($get_sort == 'budget') {
                $get_orderby = "cs.budget";
            } elseif ($get_sort == 'rent') {
                $get_orderby = "cs.monthly_rent";
            } elseif ($get_sort == 'carpet') {
                $get_orderby = "cs.carpet";
            }
        }

        $order_name = $get_orderby;
        //$order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'cs.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        //can see others posts
        $where_sql = 'cs.sm_cp_id NOT IN(' . $get_members_txt . ')  ';
        $where_sql = "cs.status IN(1)";

        $where_sql .= ' AND cs.post_for IN(' . $post_post_for . ')';

        if ($post_post_for == 1) {
            if (!empty($post_type)) {
                $where_sql .= ' AND cs.type IN(' . $post_type . ')';
            }
        } else {
            if (!empty($post_rental_type)) {
                $where_sql .= ' AND cs.rental_type IN(' . $post_rental_type . ')';
            }
        }

        //$where_sql .= ' AND cs.type="' . $post_type . '"';

        /*  if (!empty($post_flat_type_id)) {
            $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
        }
        if (!empty($post_flat_property_type)) {
            $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
        } */

        $where_sql .= ' AND cs.location_id IN (' . $post_location_id . ')';
        if (!empty($post_id)) {
            $where_sql .= ' AND cs.id NOT IN (' . $post_id . ')';
        }




        //Not show spam marked posts
        $get_spam_arr = $this->getspampost($sm_cp_id);
        if (!empty($get_spam_arr)) {
            $get_spam_arr_txt = implode(",", $get_spam_arr);
            $where_sql .= ' AND cs.id NOT IN(' . $get_spam_arr_txt . ')';
        }

        //Only for Live
        $where_sql .= ' AND sm_cp.is_test=0';

        //$where_sql .= ' AND cs.status IN(1)';

        /* echo $where_sql;
        exit; */

        if (empty($order_name)) {
            //$sort_text = new Expression("FIELD(projects.location_id, " . $cp_location . ") DESC");
            //$sort_text = $order_name . ' ' . $order_type;
            $sort_text = "cs.rank DESC,cs.id DESC";
        } else {
            $sort_text = $order_name . ' ' . $order_type;
        }

        //sm_cp.name as cp_name,cp.company_name as cp_company_name,sm_cp.contact as cp_contact,s.name as verifiedby

        $post_query = (new \yii\db\Query())
            ->select('cs.id,cs.post_id,cs.title,cs.description,cs.type,cs.budget,cs.flat_type_id,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,cs.location_id,l.name as location_name,cs.sm_cp_id,cs.post_for,cs.deposit,cs.monthly_rent,cs.landmark,cs.rental_type')
            ->from('cp_customers_flats cs')
            ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
            ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
            ->leftJoin("channelpartner cp", 'sm_cp.channelpartner_id=cp.id')
            ->leftJoin("staff s", 'cs.verified_by=s.id')

            ->where($where_sql)
            ->orderBy($sort_text);
        $post_count = $post_query->count();
        /* echo $proj_count;
                exit; */
        $post_data = $post_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
        echo $post_data;
        exit; */
            ->queryAll();



        if (!empty($post_data)) {
            foreach ($post_data as $post_data_key => $post_data_val) {
                $post[$post_data_key] = $post_data_val;
                $post[$post_data_key]['post_id'] = $querydata['post_id'];

                $post[$post_data_key]['post_for_text'] = $this->post_post_for[$post_data_val['post_for']];
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                    unset($post[$post_data_key]['rental_type']);
                } else {
                    $post[$post_data_key]['rental_type_text'] = $this->post_rental_type[$post_data_val['rental_type']];
                    unset($post[$post_data_key]['type']);
                }

                $post[$post_data_key]['cp_name'] = null;
                $post[$post_data_key]['cp_company_name'] = null;
                $post[$post_data_key]['cp_contact'] = null;
                $post[$post_data_key]['verifiedby'] = null;

                $post[$post_data_key]['flat_property_type_text'] = null;
                if (!empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type_text'] = $this->flat_property_type[$post_data_val['flat_property_type']];
                } else {
                    $post[$post_data_key]['flat_property_type_text'] = null;
                }
                if (!isset($post_data_val['flat_property_type']) || empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type'] = 1;
                }
                if ($post_data_val['flat_property_type'] == 1) {
                    if (!empty($post_data_val['flat_type_id'])) {
                        $post[$post_data_key]['flat_type_id'] = (string) $post_data_val['flat_type_id'];
                        $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                    } else {
                        $post[$post_data_key]['flat_type_id'] = null;
                    }
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                }

                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budgetinwords'] = null;
                    if (!empty($post_data_val['budget'])) {
                        $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                        $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                    } else {
                        $post[$post_data_key]['budget'] = null;
                    }
                } else {
                    $post[$post_data_key]['depositinwords'] = null;
                    $post[$post_data_key]['monthly_rentinwords'] = null;
                    if (!empty($post_data_val['deposit'])) {
                        $post[$post_data_key]['deposit'] = (string) $post_data_val['deposit'];
                        $post[$post_data_key]['depositinwords'] = $this->AmountInWords($post_data_val['deposit']);
                    } else {
                        $post[$post_data_key]['deposit'] = null;
                    }
                    if (!empty($post_data_val['monthly_rent'])) {
                        $post[$post_data_key]['monthly_rent'] = (string) $post_data_val['monthly_rent'];
                        $post[$post_data_key]['monthly_rentinwords'] = $this->AmountInWords($post_data_val['monthly_rent']);
                    } else {
                        $post[$post_data_key]['monthly_rent'] = null;
                    }
                }


                $post[$post_data_key]['self_post'] = "0";
                if (in_array($post_data_val['sm_cp_id'], $get_members)) {
                    $post[$post_data_key]['self_post'] = "1";
                }

                $post[$post_data_key]['bookmark'] = 'false';
                $getbookmark = PostingBookmark::findOne([
                    'sm_cp_id' => $sm_cp_id,
                    'posting_id' => $post_data_val['id'],
                ]);
                if (!empty($getbookmark)) {
                    $post[$post_data_key]['bookmark'] = 'true';
                }


                $post[$post_data_key]['status'] = $post_data_val['status'];
                $post[$post_data_key]['statusText'] = $this->post_status[$post_data_val['status']];

                /* $post[$post_data_key]['contacted'] = false;
                //check if posting is viewed
                $postview_model = CpCustomersFlatsView::find()->where(['sm_cp_id' => $sm_cp_id, 'post_id' => $post_data_val['id']])->one();
                if (!empty($postview_model)) {
                    $post[$post_data_key]['contacted'] = true;
                } */

                //$post[$post_data_key]['contacted'] = false;
                $post[$post_data_key]['viewed'] = false;
                $flatcontact_data = CpCustomersFlatsView::find()->where('post_id="' . $post_data_val['id'] . '" AND sm_cp_id="' . $sm_cp_id . '"  ')->orderBy(['created_on' => SORT_DESC])->one();
                if (!empty($flatcontact_data)) {
                    /* $post[$post_data_key]['contacted'] = true; */
                    $post[$post_data_key]['viewed'] = true;
                    $post[$post_data_key]['viewed_on'] = $flatcontact_data->created_on;
                } else {
                    $post[$post_data_key]['cp_name'] = null;
                    $post[$post_data_key]['cp_company_name'] = null;
                    $post[$post_data_key]['cp_contact'] = null;
                }
            }
        }
        /* $poststat = [];
        $post_view_data = $this->getpostinglimit($querydata['post_id'], $sm_cp_id);
        if (!empty($post_view_data)) {
            $poststat['view_count'] = (string) $post_view_data['view_count'];
            $poststat['limit_count'] = (string) $post_view_data['limit_count'];
            $poststat['available_count'] = (string) $post_view_data['available_count'];
            $poststat['others_view_count'] = (string) $post_view_data['others_view_count'];
        } */


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $post_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $post_arr['post'] = $post;
        //$post_arr['stat'] = $poststat;
        $post_arr['pagination'] = $pagination;

        return $post_arr;
    }

    public function getviewedpostlist($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        $post_arr = null;

        $post = null;
        /*  echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';

        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;

        $get_members_txt = implode(",", $get_members);
        $get_orderby = "";

        $post_post_for = (!empty($querydata['post_for']) ? $querydata['post_for'] : '1');
        $post_type = (!empty($querydata['type']) ? $querydata['type'] : '');
        $post_rental_type = (!empty($querydata['rental_type']) ? $querydata['rental_type'] : '');
        $post_location_id = (!empty($querydata['location_id']) ? $querydata['location_id'] : '');



        if (!empty($querydata['sort_name'])) {
            $get_sort = trim($querydata['sort_name']);
            if ($get_sort == 'created_on') {
                $get_orderby = "v.created_on";
            } elseif ($get_sort == 'budget') {
                $get_orderby = "cs.budget";
            } elseif ($get_sort == 'rent') {
                $get_orderby = "cs.monthly_rent";
            } elseif ($get_sort == 'carpet') {
                $get_orderby = "cs.carpet";
            }
        }

        $order_name = $get_orderby;
        //$order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'cs.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        //can see others posts
        //$where_sql = 'cs.sm_cp_id NOT IN(' . $get_members_txt . ')  ';
        $where_sql = "cs.status IN(1)";

        $where_sql .= ' AND cs.post_for IN(' . $post_post_for . ')';

        if ($post_post_for == 1) {
            if (!empty($post_type)) {
                $where_sql .= ' AND cs.type IN(' . $post_type . ')';
            }
        } else {
            if (!empty($post_rental_type)) {
                $where_sql .= ' AND cs.rental_type IN(' . $post_rental_type . ')';
            }
        }

        //$where_sql .= ' AND cs.type="' . $post_type . '"';

        /*  if (!empty($post_flat_type_id)) {
            $where_sql .= ' AND cs.flat_type_id IN(' . $post_flat_type_id . ')';
        }
        if (!empty($post_flat_property_type)) {
            $where_sql .= ' AND cs.flat_property_type IN(' . $post_flat_property_type . ')';
        } */
        if (!empty($post_location_id)) {
            $where_sql .= ' AND cs.location_id IN (' . $post_location_id . ')';
        }
        if (!empty($post_id)) {
            $where_sql .= ' AND cs.id NOT IN (' . $post_id . ')';
        }




        //Not show spam marked posts
        $get_spam_arr = $this->getspampost($sm_cp_id);
        if (!empty($get_spam_arr)) {
            $get_spam_arr_txt = implode(",", $get_spam_arr);
            $where_sql .= ' AND cs.id NOT IN(' . $get_spam_arr_txt . ')';
        }

        //Only for Live
        $where_sql .= ' AND sm_cp.is_test=0';

        $where_sql .= ' AND v.sm_cp_id IN(' . $sm_cp_id . ')';

        /* echo $where_sql;
        exit; */

        if (empty($order_name)) {
            //$sort_text = new Expression("FIELD(projects.location_id, " . $cp_location . ") DESC");
            //$sort_text = $order_name . ' ' . $order_type;
            $sort_text = "v.created_on DESC";
        } else {
            $sort_text = $order_name . ' ' . $order_type;
        }

        //sm_cp.name as cp_name,cp.company_name as cp_company_name,sm_cp.contact as cp_contact,s.name as verifiedby

        $post_query = (new \yii\db\Query())
            ->select('v.created_on as viewed_on,cs.id,cs.post_id,cs.title,cs.description,cs.type,cs.budget,cs.flat_type_id,cs.flat_property_type,cs.carpet,cs.created_on,cs.modified_on,cs.status,cs.location_id,l.name as location_name,cs.sm_cp_id,cs.post_for,cs.deposit,cs.monthly_rent,cs.landmark,cs.rental_type,sm_cp.name as cp_name,cp.company_name as cp_company_name,sm_cp.contact as cp_contact,s.name as verifiedby')
            ->from('cp_customers_flats_view v')
            ->leftJoin('cp_customers_flats cs', 'v.post_id=cs.id')
            ->leftJoin("location l", 'cs.location_id=l.id AND l.status=1')
            ->leftJoin("sm_cp", 'cs.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
            ->leftJoin("channelpartner cp", 'sm_cp.channelpartner_id=cp.id')
            ->leftJoin("staff s", 'cs.verified_by=s.id')

            ->where($where_sql)
            ->orderBy($sort_text);
        $post_count = $post_query->count();
        /* echo $proj_count;
                exit; */
        $post_data = $post_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
        echo $post_data;
        exit; */
            ->queryAll();



        if (!empty($post_data)) {
            foreach ($post_data as $post_data_key => $post_data_val) {
                $post[$post_data_key] = $post_data_val;


                $post[$post_data_key]['post_for_text'] = $this->post_post_for[$post_data_val['post_for']];
                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['type_text'] = $this->post_type[$post_data_val['type']];
                    unset($post[$post_data_key]['rental_type']);
                } else {
                    $post[$post_data_key]['rental_type_text'] = $this->post_rental_type[$post_data_val['rental_type']];
                    unset($post[$post_data_key]['type']);
                }

                $post[$post_data_key]['flat_property_type_text'] = null;
                if (!empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type_text'] = $this->flat_property_type[$post_data_val['flat_property_type']];
                } else {
                    $post[$post_data_key]['flat_property_type_text'] = null;
                }
                if (!isset($post_data_val['flat_property_type']) || empty($post_data_val['flat_property_type'])) {
                    $post[$post_data_key]['flat_property_type'] = 1;
                }
                if ($post_data_val['flat_property_type'] == 1) {
                    if (!empty($post_data_val['flat_type_id'])) {
                        $post[$post_data_key]['flat_type_id'] = (string) $post_data_val['flat_type_id'];
                        $post[$post_data_key]['flat_type_text'] = $this->flat_type_id[$post_data_val['flat_type_id']];
                    } else {
                        $post[$post_data_key]['flat_type_id'] = null;
                    }
                } else {
                    $post[$post_data_key]['flat_type_id'] = null;
                }

                if ($post_data_val['post_for'] == 1) {
                    $post[$post_data_key]['budgetinwords'] = null;
                    if (!empty($post_data_val['budget'])) {
                        $post[$post_data_key]['budget'] = (string) $post_data_val['budget'];
                        $post[$post_data_key]['budgetinwords'] = $this->AmountInWords($post_data_val['budget']);
                    } else {
                        $post[$post_data_key]['budget'] = null;
                    }
                } else {
                    $post[$post_data_key]['depositinwords'] = null;
                    $post[$post_data_key]['monthly_rentinwords'] = null;
                    if (!empty($post_data_val['deposit'])) {
                        $post[$post_data_key]['deposit'] = (string) $post_data_val['deposit'];
                        $post[$post_data_key]['depositinwords'] = $this->AmountInWords($post_data_val['deposit']);
                    } else {
                        $post[$post_data_key]['deposit'] = null;
                    }
                    if (!empty($post_data_val['monthly_rent'])) {
                        $post[$post_data_key]['monthly_rent'] = (string) $post_data_val['monthly_rent'];
                        $post[$post_data_key]['monthly_rentinwords'] = $this->AmountInWords($post_data_val['monthly_rent']);
                    } else {
                        $post[$post_data_key]['monthly_rent'] = null;
                    }
                }


                $post[$post_data_key]['self_post'] = "0";
                if (in_array($post_data_val['sm_cp_id'], $get_members)) {
                    $post[$post_data_key]['self_post'] = "1";
                }

                $post[$post_data_key]['bookmark'] = 'false';
                $getbookmark = PostingBookmark::findOne([
                    'sm_cp_id' => $sm_cp_id,
                    'posting_id' => $post_data_val['id'],
                ]);
                if (!empty($getbookmark)) {
                    $post[$post_data_key]['bookmark'] = 'true';
                }


                $post[$post_data_key]['status'] = $post_data_val['status'];
                $post[$post_data_key]['statusText'] = $this->post_status[$post_data_val['status']];

                /* $post[$post_data_key]['contacted'] = false;
                //check if posting is viewed
                $postview_model = CpCustomersFlatsView::find()->where(['sm_cp_id' => $sm_cp_id, 'post_id' => $post_data_val['id']])->one();
                if (!empty($postview_model)) {
                    $post[$post_data_key]['contacted'] = true;
                } */

                //$post[$post_data_key]['contacted'] = false;
                /*  $post[$post_data_key]['viewed'] = false;
                $flatcontact_data = CpCustomersFlatsView::find()->where('post_id="' . $post_data_val['id'] . '" AND sm_cp_id="' . $sm_cp_id . '"  ')->orderBy(['created_on' => SORT_DESC])->one();
                if (!empty($flatcontact_data)) {
                    $post[$post_data_key]['viewed'] = true;
                    $post[$post_data_key]['viewed_on'] = $flatcontact_data->created_on;
                } else {
                    $post[$post_data_key]['cp_name'] = null;
                    $post[$post_data_key]['cp_company_name'] = null;
                    $post[$post_data_key]['cp_contact'] = null;
                } */
                $post[$post_data_key]['viewed'] = true;
                $post[$post_data_key]['viewed_on'] = $post_data_val['viewed_on'];
            }
        }
        /* $poststat = [];
        $post_view_data = $this->getpostinglimit($querydata['post_id'], $sm_cp_id);
        if (!empty($post_view_data)) {
            $poststat['view_count'] = (string) $post_view_data['view_count'];
            $poststat['limit_count'] = (string) $post_view_data['limit_count'];
            $poststat['available_count'] = (string) $post_view_data['available_count'];
            $poststat['others_view_count'] = (string) $post_view_data['others_view_count'];
        } */


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $post_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $post_arr['post'] = $post;
        //$post_arr['stat'] = $poststat;
        $post_arr['pagination'] = $pagination;

        return $post_arr;
    }



    public function gettagshortapi($tag_id, $tag_data, $show_feed = '')
    {
        $tag_arr = null;
        $tag = null;
        if (empty($tag_data)) {
            $tag_data = Taggingmaster::find()->select('id,lead_id,tagging_id,tag_name,tag_phone,tag_email,sm_cp_id,project_id,budget,customer_type,appointment_date,appointment_time,status,created_by,created_on,modified_by,modified_on,visit_notvisit_clash_date,lead_convert_date,lead_dead_date,lead_registered_date,retag_limit,is_cancelled,cancelled_by,cancelled_on,flat_type_id,flat_property_type,cp_id')->where(['id' => $tag_id, 'is_deleted' => 0])->one();
            $tag = $tag_data->toArray();
        } else {
            $tag = $tag_data->toArray();
            unset($tag['is_deleted'], $tag['deleted_on'], $tag['deleted_by'], $tag['created_from'], $tag['is_accepted']);
        }

        if (!empty($tag_data)) {

            $lead_data = Leadmaster::find()->select('id,lead_id,name,flat_type_id,flat_property_type')->where(['id' => $tag['lead_id'], 'is_deleted' => 0])->one();
            if (!empty($lead_data)) {
                $tag['lead_id'] = $lead_data->lead_id;
            }
            $tag['id'] = (string) $tag['id'];
            if (!empty($tag['tag_name'])) {
                $tag['name'] = $tag['tag_name'];
                unset($tag['tag_name']);
            }
            if (!empty($tag['tag_phone'])) {
                $tag['contact'] = $tag['tag_phone'];
                unset($tag['tag_phone']);
            }
            if (!empty($tag['tag_email'])) {
                $tag['email'] = $tag['tag_email'];
                unset($tag['tag_email']);
            } else {
                $tag['email'] = null;
            }
            $tag['flat_type_text'] = null;
            $tag['flat_type_id'] = null;
            if (!empty($lead_data)) {
                $tag['flat_property_type'] = $lead_data->flat_property_type;
                $tag['flat_property_type_text'] = $this->flat_property_type[$lead_data->flat_property_type];
                if ($lead_data->flat_property_type == 1) {
                    if (!empty($lead_data->flat_type_id)) {
                        $tag['flat_type_id'] = (string) $lead_data->flat_type_id;
                        $tag['flat_type_text'] = $this->flat_type_id[$lead_data->flat_type_id];
                    }
                }
            } else {
                $tag['flat_property_type_text'] = $this->flat_property_type[$tag['flat_property_type']];
                if ($tag['flat_property_type'] == 1) {
                    if (!empty($tag['flat_type_id'])) {
                        $tag['flat_type_id'] = (string) $tag['flat_type_id'];
                        $tag['flat_type_text'] = $this->flat_type_id[$tag['flat_type_id']];
                    }
                }
            }
            $tag['budgetinwords'] = null;
            if (!empty($tag['budget'])) {
                $tag['budget'] = (string) $tag['budget'];
                $tag['budgetinwords'] = $this->AmountInWords($tag['budget']);
            } else {
                $tag['budget'] = null;
            }


            if (!empty($tag['customer_type'])) {
                $tag['customer_type'] = $this->customer_type[$tag['customer_type']];
            } else {
                $tag['customer_type'] = null;
            }
            if (!empty($tag['status'])) {
                $tag['statusText'] = $this->tag_status[$tag['status']];
                if ($tag['status'] == 1) {
                    $tag['visited_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 3) {
                    $tag['clashed_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 7) {
                    $tag['rejected_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['status'] == 4) {
                    $tag['booked_on'] = $tag['lead_convert_date'];
                } else if ($tag['status'] == 5) {
                    $tag['lead_dead_on'] = $tag['lead_dead_date'];
                } else if ($tag['status'] == 6) {
                    $tag['registered_on'] = $tag['lead_registered_date'];
                }
                /* if ($tag['statusText'] == 'Visited') {
                    $tag['visited_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['statusText'] == 'Clashed') {
                    $tag['clash_on'] = $tag['visit_notvisit_clash_date'];
                } else if ($tag['statusText'] == 'Lead Converted') {
                    $tag['lead_convert_on'] = $tag['lead_convert_date'];
                } else if ($tag['statusText'] == 'Lead Dead') {
                    $tag['lead_dead_on'] = $tag['lead_dead_date'];
                } else if ($tag['statusText'] == 'Lead Registered') {
                    $tag['lead_registered_on'] = $tag['lead_registered_date'];
                } */
            } else {
                $tag['statusText'] = 'In Progress';
            }
            unset($tag['visit_notvisit_clash_date'], $tag['lead_convert_date'], $tag['lead_dead_date'], $tag['lead_registered_date']);

            if (!empty($tag['project_id'])) {
                $project_model = Projects::find()->where(['id' => $tag['project_id']])->one();
                $tag['project_id'] = $project_model->name;
            }
            if (!empty($tag['sm_cp_id'])) {
                $sourcing_model = SmCp::find()->where(['sm_cp_id' => $tag['sm_cp_id'], 'staff_type' => 1, 'is_deleted' => 0])->one();
                $tag['sourcing_id'] = $sourcing_model->name;
                unset($tag['sm_cp_id']);
            }

            if (!empty($tag['created_by'])) {
                $created_by_model = SmCp::find()->where(['sm_cp_id' => $tag['created_by'], 'is_deleted' => 0])->one();
                $tag['created_by'] = $created_by_model->name;
                $tag['cp_name'] = $created_by_model->name;
                $tag['cp_contact'] = $created_by_model->contact;
            } else {
                $tag['created_by'] = null;
            }

            if (!empty($tag['cp_id'])) {
                $cp_model = Channelpartner::find()->where(['id' => $tag['cp_id']])->one();
                $tag['cp_company_name'] = $cp_model->company_name;
            }


            if (!empty($tag['modified_by'])) {
                $modified_by_model = SmCp::find()->where(['sm_cp_id' => $tag['modified_by']])->one();
                $tag['modified_by'] = $modified_by_model->name;
            } else {
                $tag['modified_by'] = null;
            }

            $tag_arr['tagging'] = $tag;
            if (!empty($show_feed)) {
                //get lead feedback
                $feedData = (new \yii\db\Query())
                    ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                    ->from('tagging_feedback fd')
                    ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id')
                    ->where('fd.tagging_id="' . $tag_id . '"')
                    ->orderBy('fd.id DESC')
                    ->limit(5)  //show last 5 feedback
                    ->createCommand()
                    ->queryAll();
                $feedback = null;
                if (!empty($feedData)) {
                    $f_count = 0;
                    foreach ($feedData as $feedData_val) {
                        //$feedback[$f_count]['id'] = $feedData_val['id'];
                        $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                        $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                        //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                        $feedback[$f_count]['created_by'] = $feedData_val['name'];
                        //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                        $f_count++;
                    }
                }
                $tag_arr['tagging']['feedback'] = $feedback;
            }

            if (!empty($tag['status']) && in_array($tag['status'], [4, 6])) {
                if (!empty($tag['is_cancelled'])) {
                    $cancelled_staff_model = SmCp::find()->where(['sm_cp_id' => $tag['cancelled_by']])->one();
                    $tag['booking_cancelled'] = "Yes";
                    $tag['cancelled_staff'] = !empty($cancelled_staff_model->name) ? $cancelled_staff_model->name : "";
                } else {
                    $tag['booking_cancelled'] = "No";
                }
            }



            /* if (!empty($show_feed)) {
                $tag_arr['flat_type'] = $this->flat_type_id;
                $tag_arr['customer_type'] = $this->customer_type;
                $tag_arr['status'] = $this->tag_status;
            } */
        }

        $tag_limit_set = intval($tag_arr['tagging']['retag_limit']);
        $tag_available = intval(\Yii::$app->params['RETAG_MAX']) - $tag_limit_set;
        $tag_arr['tagging']['retag_attempt_left'] = (string) $tag_available;

        return $tag_arr;
    }

    public function getticketlistapi($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $ticket_arr = null;

        $ticket = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        $ticket_type = 1;

        if (!empty($querydata)) {
            $ticket_contact = (!empty($querydata['contact']) ? trim($querydata['contact']) : '');
            $ticket_ticketid = (!empty($querydata['ticketid']) ? trim($querydata['ticketid']) : '');

            $ticket_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
            $ticket_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : '');

            $ticket_status = (!empty($querydata['status']) ? trim($querydata['status']) : '');
        }
        if (!empty($querydata['type']) && $querydata['type'] == 2) {
            $ticket_type = 2;
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'ticket.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = '1 ';

        if (!empty($ticket_ticketid)) {
            $where_sql .= ' AND ticket.ticketid="' . $ticket_ticketid . '"';
        }


        if (!empty($ticket_start_created_on_date)) {
            $where_sql .= ' AND DATE(ticket.created_on)>="' . $ticket_start_created_on_date . '"';
        }
        if (!empty($ticket_end_created_on_date)) {
            $where_sql .= ' AND DATE(ticket.created_on)<="' . $ticket_end_created_on_date . '"';
        }

        if (!empty($ticket_contact)) {
            $where_sql .= ' AND ticket.contact="' . $ticket_contact . '"';
        }

        if (!empty($ticket_status)) {
            $where_sql .= ' AND ticket.status="' . $ticket_status . '"';
        }

        if ($ticket_type == 2) {
            $where_sql .= ' AND ticket.issue_type IN(7)';
        } else {
            $where_sql .= ' AND ticket.issue_type NOT IN(7)';
        }



        $ticket_query = (new \yii\db\Query())
            ->select('contact,issue_type,message,created_on,modified_on,status,ticketid,feedback')
            ->from('ticket')
            ->where($where_sql)
            ->orderBy($order_name . ' ' . $order_type);
        $ticket_count = $ticket_query->count();
        /* echo $proj_count;
                exit; */
        $ticket_data = $ticket_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
                echo $proj_data;
                exit; */
            ->queryAll();



        if (!empty($ticket_data)) {
            foreach ($ticket_data as $ticket_data_key => $ticket_data_val) {
                $ticket[$ticket_data_key] = $ticket_data_val;
                $ticket[$ticket_data_key]['status'] = $this->ticket_status[$ticket_data_val['status']];
                if (!empty($ticket_data_val['issue_type'])) {
                    $ticket[$ticket_data_key]['issue_type'] = $this->ticket_issue_type[$ticket_data_val['issue_type']];
                } else {
                    $ticket[$ticket_data_key]['issue_type'] = null;
                }
            }
        }


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $ticket_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $ticket_arr['ticket'] = $ticket;
        $ticket_arr['pagination'] = $pagination;

        return $ticket_arr;
    }

    public function getticketapi($ticket_id, $ticket_data)
    {
        $ticket_arr = null;
        $ticket = null;
        if (empty($ticket_data)) {
            $ticket_data = Ticket::find()->select('id,contact,issue_type,message,created_on,modified_on,status,ticketid,feedback')->where(['id' => $ticket_id])->one();
            $ticket = $ticket_data->toArray();
        } else {
            $ticket = $ticket_data->toArray();
        }

        if (!empty($ticket_data)) {

            if (!empty($ticket['issue_type'])) {
                $ticket['issue_type'] = $this->ticket_issue_type[$ticket['issue_type']];
            }

            if (!empty($ticket['status'])) {
                $ticket['status'] = $this->ticket_status[$ticket['status']];
            }
            unset($ticket['created_by'], $ticket['ip_address'], $ticket['modified_by']);


            /* if (!empty($tag['modified_by'])) {
                $modified_by_model = SmCp::find()->where(['sm_cp_id' => $tag['modified_by']])->one();
                $tag['modified_by'] = $modified_by_model->name;
            } */

            $ticket_arr['ticket'] = $ticket;
        }
        return $ticket_arr;
    }

    public function getfaqlistapi($get_user, $querydata, $faqtype = 1)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $faq_arr = null;

        $faq = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */

        if (!empty($querydata)) {
            $faq_search = (!empty($querydata['search']) ? trim($querydata['search']) : '');
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'faqmaster.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = 'faqmaster.status=1 ';
        if ($faqtype == 1) {
            $where_sql .= ' AND faqmaster.type IN(1,3)';
        } else {
            $where_sql .= ' AND faqmaster.type IN(2,3)';
        }

        if (!empty($faq_search)) {
            $where_sql .= ' AND ((faqmaster.question LIKE "%' . $faq_search . '%") OR (faqmaster.answer LIKE "%' . $faq_search . '%"))';
        }

        $faq_query = (new \yii\db\Query())
            ->select('question,id,answer,created_on,modified_on,id')
            ->from('faqmaster')
            ->where($where_sql)
            ->orderBy($order_name . ' ' . $order_type);
        $faq_count = $faq_query->count();
        /* echo $proj_count;
                exit; */
        $faq_data = $faq_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
                echo $proj_data;
                exit; */
            ->queryAll();



        if (!empty($faq_data)) {
            foreach ($faq_data as $faq_data_key => $faq_data_val) {
                $faq[$faq_data_key] = $faq_data_val;
            }
        }


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $faq_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $faq_arr['faq'] = $faq;
        $faq_arr['pagination'] = $pagination;

        return $faq_arr;
    }

    public function getfaqapi($faq_id, $faq_data)
    {
        $faq_arr = null;
        $faq = null;
        if (empty($faq_data)) {
            $faq_data = Faqmaster::find()->select('id,question,answer,created_on,modified_on,id')->where(['id' => $faq_id])->one();
            $faq = $faq_data->toArray();
        } else {
            $faq = $faq_data->toArray();
        }

        if (!empty($faq_data)) {

            unset($faq['created_by'], $faq['modified_by'], $faq['type'], $faq['status']);
            $faq_arr['faq'] = $faq;
        }
        return $faq_arr;
    }



    public function getleadstatsapi($sm_cp_id, $cp_id)
    {
        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $statData_arr = null;


        $get_members_txt = implode(",", $get_members);
        $where_sql = " leadmaster.created_by IN(" . $get_members_txt . ") AND leadmaster.is_deleted=0 ";
        $get_date = date('Y-m-d');


        $statData = Yii::$app->db->createCommand("SELECT SUM(IF(1, 1, 0)) AS total, SUM(IF((leadmaster.followup_date>='" . $get_date . "'), 1, 0)) AS followup,SUM(IF((leadmaster.followup_date='" . $get_date . "' ), 1, 0)) AS today,SUM(IF((leadmaster.followup_date<'" . $get_date . "'), 1, 0)) AS missed,SUM(IF((DATE(leadmaster.created_on)='" . $get_date . "' ), 1, 0)) AS fresh FROM leadmaster where " . $where_sql)->queryAll();

        if (!empty($statData)) {
            $statData_arr['stats'] = $statData[0];
        }

        //get cp lead stats
        $cp_model = Channelpartner::find()->where(['id' => $cp_id])->one();


        $lead_query = (new \yii\db\Query())
            ->select('leadmaster.id')
            ->from('leadmaster')
            ->where("cp_id='" . $cp_id . "'");
        $lead_count = intval($lead_query->count());

        //get credit count
        $members = $this->getsmcpteam($cp_id, 1);
        $members_txt = implode(",", $members);

        /* $ref_query = (new \yii\db\Query())
            ->select('cp_refer.id')
            ->from('cp_refer')
            ->where("sm_cp_id IN(" . $members_txt . ") AND status=2");
        $ref_count = $ref_query->count(); */
        $ref_count = 0;

        $lead_per_credit = 5;
        $credit_leads = $lead_per_credit * $ref_count;
        $allowed_leads = intval($cp_model->credits);
        $total_allowed_leads = $allowed_leads + $credit_leads;
        $balance_leads = $total_allowed_leads - $lead_count;

        $cpstats['cpName'] = $cp_model->company_name;
        $cpstats['allowed_leads'] = $allowed_leads;
        $cpstats['referal_credit_leads'] = $credit_leads;
        $cpstats['total_allowed_leads'] = $total_allowed_leads;
        $cpstats['used_leads'] = $lead_count;
        $cpstats['balance_leads'] = $balance_leads;

        $cpstats['stat_note'] = "";
        //get stats message
        if ($balance_leads <= 25) {
            $cpstats['stat_note'] = "Your lead balance is only " . $balance_leads . ". Please delete old leads for increasing balance or contact support";
        }

        $statData_arr['cpleadstats'] = $cpstats;

        return $statData_arr;
    }

    public function getleadlistapi($get_user, $querydata, $list_type = '')
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $lead_arr = null;
        if (empty($list_type)) {
            $pagination = null;
        }
        $lead = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */

        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;


        $get_members_txt = implode(",", $get_members);
        if (!empty($querydata)) {
            $lead_name = (!empty($querydata['name']) ? trim($querydata['name']) : '');
            $lead_lead_id = (!empty($querydata['lead_id']) ? trim($querydata['lead_id']) : '');
            $lead_start_followup_date = (!empty($querydata['start_followup_date']) ? trim($querydata['start_followup_date']) : '');
            $lead_end_followup_date = (!empty($querydata['end_followup_date']) ? trim($querydata['end_followup_date']) : '');
            $lead_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
            $lead_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : '');
            $lead_customer_type = (!empty($querydata['customer_type']) ? trim($querydata['customer_type']) : '');

            $lead_start_budget = (!empty($querydata['min_price']) ? trim($querydata['min_price']) : '');
            $lead_end_budget = (!empty($querydata['max_price']) ? trim($querydata['max_price']) : '');
            $lead_flat_type_id = (!empty($querydata['config']) ? trim($querydata['config']) : '');

            $lead_start_carpet = (!empty($querydata['min_carpet']) ? trim($querydata['min_carpet']) : '');
            $lead_end_carpet = (!empty($querydata['max_carpet']) ? trim($querydata['max_carpet']) : '');

            $lead_contact = (!empty($querydata['contact']) ? trim($querydata['contact']) : '');
            $lead_created_by = (!empty($querydata['created_by']) ? trim($querydata['created_by']) : '');

            $lead_status = (!empty($querydata['status']) ? trim($querydata['status']) : '');
            $lead_type = (!empty($querydata['type']) ? trim($querydata['type']) : '');
            $lead_flat_property_type = (!empty($querydata['flat_property_type']) ? trim($querydata['flat_property_type']) : '');
            $lead_location_id = (!empty($querydata['location_id']) ? trim($querydata['location_id']) : '');
            $lead_location_subtype_id = (!empty($querydata['location_subtype_id']) ? trim($querydata['location_subtype_id']) : '');
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'leadmaster.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }

        $where_sql = 'leadmaster.created_by IN(' . $get_members_txt . ') AND leadmaster.is_deleted=0 ';

        if (
            !empty($lead_name) &&
            empty($lead_contact)
        ) {
            $where_sql .= ' AND ((leadmaster.name like "%' . $lead_name . '%") OR (leadmaster.contact like "%' . $lead_name . '%"))';
        } else {
            if (!empty($lead_name)) {
                $where_sql .= ' AND leadmaster.name like "%' . $lead_name . '%"';
            }
            if (!empty($lead_contact)) {
                $where_sql .= ' AND leadmaster.contact like "%' . $lead_contact . '%"';
            }
        }





        /* if (!empty($lead_name)) {
            $where_sql .= ' AND leadmaster.name like "%' . $lead_name . '%"';
        } */
        if (!empty($lead_lead_id)) {
            $where_sql .= ' AND leadmaster.lead_id like "%' . $lead_lead_id . '%"';
        }
        if (!empty($lead_start_followup_date)) {
            $where_sql .= ' AND leadmaster.followup_date>="' . $lead_start_followup_date . '"';
        }
        if (!empty($lead_end_followup_date)) {
            $where_sql .= ' AND leadmaster.followup_date<="' . $lead_end_followup_date . '"';
        }

        //added on 1-7-24
        if (!empty($lead_start_budget)) {
            $where_sql .= ' AND leadmaster.budget>="' . $lead_start_budget . '"';
        }
        if (!empty($lead_end_budget)) {
            $where_sql .= ' AND leadmaster.budget<="' . $lead_end_budget . '"';
        }
        if (!empty($lead_flat_type_id)) {
            $where_sql .= ' AND leadmaster.flat_type_id IN(' . $lead_flat_type_id . ')';
        }

        if (!empty($lead_start_carpet)) {
            $where_sql .= ' AND leadmaster.carpet>="' . $lead_start_carpet . '"';
        }
        if (!empty($lead_end_carpet)) {
            $where_sql .= ' AND leadmaster.carpet<="' . $lead_end_carpet . '"';
        }
        if (!empty($lead_location_id) || !empty($lead_location_subtype_id)) {
            if (!empty($lead_location_subtype_id) && empty($lead_location_id)) {
                //get loc array
                $get_loc_arr = $this->getlocfromsubtype($lead_location_subtype_id);
                if (!empty($get_loc_arr)) {
                    /* $get_loc_arr_txt = implode(",", $get_loc_arr);
                    $where_sql .= ' AND leadmaster.location_id IN(' . $get_loc_arr_txt . ')'; */
                    $loc_sql = "";
                    foreach ($get_loc_arr as $get_loc_arr_v) {
                        if (empty($loc_sql)) {
                            $loc_sql .= ' FIND_IN_SET("' . (int) $get_loc_arr_v . '",leadmaster.location_id)';
                        } else {
                            $loc_sql .= ' OR FIND_IN_SET("' . (int) $get_loc_arr_v . '",leadmaster.location_id)';
                        }
                    }
                    $where_sql .= ' AND (' . $loc_sql . ') ';
                }
            } else {
                if (!empty($lead_location_id)) {
                    $get_loc_arr = explode(",", $lead_location_id);
                    if (!empty($get_loc_arr)) {
                        /* $get_loc_arr_txt = implode(",", $get_loc_arr);
                        $where_sql .= ' AND leadmaster.location_id IN(' . $get_loc_arr_txt . ')'; */
                        $loc_sql = "";
                        foreach ($get_loc_arr as $get_loc_arr_v) {
                            if (empty($loc_sql)) {
                                $loc_sql .= ' FIND_IN_SET("' . (int) $get_loc_arr_v . '",leadmaster.location_id)';
                            } else {
                                $loc_sql .= ' OR FIND_IN_SET("' . (int) $get_loc_arr_v . '",leadmaster.location_id)';
                            }
                        }
                        $where_sql .= ' AND (' . $loc_sql . ') ';
                    }
                }
            }
        }

        if (!empty($lead_flat_property_type)) {
            $where_sql .= ' AND leadmaster.flat_property_type IN(' . $lead_flat_property_type . ')';
        }


        if (!empty($lead_start_created_on_date)) {
            $where_sql .= ' AND DATE(leadmaster.created_on)>="' . $lead_start_created_on_date . '"';
        }
        if (!empty($lead_end_created_on_date)) {
            $where_sql .= ' AND DATE(leadmaster.created_on)<="' . $lead_end_created_on_date . '"';
        }
        if (!empty($lead_customer_type)) {
            $where_sql .= ' AND leadmaster.customer_type IN(' . $lead_customer_type . ')';
        }
        /* if (!empty($lead_contact)) {
            $where_sql .=
                ' AND leadmaster.contact like "%' . $lead_contact . '%"';
        } */
        if (!empty($lead_created_by)) {
            $where_sql .= ' AND leadmaster.created_by="' . $lead_created_by . '"';
        }
        if (isset($querydata['tagged']) && $querydata['tagged'] == 'true') {
            $where_sql .= ' AND tag.tag_count is not null';
        } else if (isset($querydata['tagged']) && $querydata['tagged'] == 'false') {
            $where_sql .= ' AND tag.tag_count is null';
        }

        if (!empty($lead_status)) {
            $where_sql .= ' AND leadmaster.status="' . $lead_status . '"';
        }

        if (!empty($lead_type)) {
            if ($lead_type == 1) {
                //followup - leads with followup today and later
                $where_sql .= ' AND leadmaster.followup_date>="' . date('Y-m-d') . '"  ';
            } else if ($lead_type == 2) {
                //today - leads with followup as today
                $where_sql .= ' AND leadmaster.followup_date="' . date('Y-m-d') . '" ';
            } else if ($lead_type == 3) {
                //missed - leads with followup less than today
                $where_sql .= ' AND leadmaster.followup_date<"' . date('Y-m-d') . '" ';
            } else if ($lead_type == 4) {
                //fresh - leads with created_on as today
                $where_sql .= ' AND DATE(leadmaster.created_on)="' . date('Y-m-d') . '" ';
            }
        }



        if (empty($list_type)) {
            $lead_query = (new \yii\db\Query())
                ->select('leadmaster.id,leadmaster.name,leadmaster.lead_id,leadmaster.email,leadmaster.flat_type_id,leadmaster.contact,leadmaster.budget,leadmaster.customer_type,leadmaster.followup_date,leadmaster.followup_time,leadmaster.status,leadmaster.tagging,tag.tag_count,leadmaster.created_on,leadmaster.modified_on,creator.name as createdby,modifier.name as modifiedby,leadmaster.carpet,leadmaster.location_id,leadmaster.flat_property_type,leadmaster.lead_type')
                ->from('leadmaster')
                ->leftJoin("(select count(t.id) as tag_count,t.lead_id from taggingmaster t group by t.lead_id ) tag", 'tag.lead_id=leadmaster.id ')
                ->leftJoin("sm_cp as creator", 'leadmaster.created_by=creator.sm_cp_id AND creator.is_deleted=0')
                ->leftJoin("sm_cp as modifier", 'leadmaster.modified_by=modifier.sm_cp_id ')
                ->where($where_sql)
                ->orderBy($order_name . ' ' . $order_type);
            $lead_count = $lead_query->count();
            /* echo $proj_count;
                exit; */
            $lead_data = $lead_query->limit($page_count)->offset($offset)->createCommand()
                /* ->getRawsql();
            echo $lead_data;
            exit; */
                ->queryAll();
        } else {
            $lead_query = (new \yii\db\Query())
                ->select('leadmaster.id,leadmaster.contact,leadmaster.name,leadmaster.lead_id')
                ->from('leadmaster')
                ->leftJoin("(select count(t.id) as tag_count,t.lead_id from taggingmaster t group by t.lead_id ) tag", 'tag.lead_id=leadmaster.id')
                ->where($where_sql)
                ->orderBy($order_name . ' ' . $order_type);

            $lead_data = $lead_query->createCommand()
                ->queryAll();
        }


        if (!empty($lead_data)) {
            foreach ($lead_data as $lead_data_key => $lead_data_val) {
                $lead[$lead_data_key] = $lead_data_val;

                if (empty($list_type)) {

                    $lead[$lead_data_key]['carpet'] = $lead_data_val['carpet'];
                    $lead[$lead_data_key]['flat_property_type_text'] = null;
                    if (!empty($lead_data_val['flat_property_type'])) {
                        $lead[$lead_data_key]['flat_property_type_text'] = $this->flat_property_type[$lead_data_val['flat_property_type']];
                    } else {
                        $lead[$lead_data_key]['flat_property_type_text'] = null;
                    }

                    $lead[$lead_data_key]['flat_type_text'] = null;
                    $lead[$lead_data_key]['flat_type_id'] = null;
                    if ($lead_data_val['flat_property_type'] == 1) {
                        if (!empty($lead_data_val['flat_type_id'])) {
                            $lead[$lead_data_key]['flat_type_id'] = $lead_data_val['flat_type_id'];
                            $lead[$lead_data_key]['flat_type_text'] = $this->flat_type_id[$lead_data_val['flat_type_id']];
                        } else {
                            $lead[$lead_data_key]['flat_type_id'] = null;
                        }
                    }

                    $location_arr = null;
                    $loc_text = "";
                    if (!empty($lead_data_val['location_id'])) {
                        $locData = (new \yii\db\Query())
                            ->select('loc.name')
                            ->from('location loc')
                            ->where('loc.id IN(' . $lead_data_val['location_id'] . ') AND loc.status=1')
                            ->createCommand()
                            ->queryAll();

                        if (!empty($locData)) {
                            foreach ($locData as $locData_val) {
                                $location_arr[] = $locData_val['name'];
                            }
                        }
                        if (!empty($location_arr)) {
                            $loc_text = implode(",", $location_arr);
                        }
                    }

                    $lead[$lead_data_key]['location_text'] = $loc_text;








                    $lead[$lead_data_key]['budgetinwords'] = null;
                    if (!empty($lead_data_val['budget'])) {
                        $lead[$lead_data_key]['budget'] = (string) $lead_data_val['budget'];
                        $lead[$lead_data_key]['budgetinwords'] = $this->AmountInWords($lead_data_val['budget']);
                    } else {
                        $lead[$lead_data_key]['budget'] = null;
                    }

                    if (!empty($lead_data_val['customer_type'])) {
                        $lead[$lead_data_key]['customer_type'] = $this->customer_type[$lead_data_val['customer_type']];
                    } else {
                        $lead[$lead_data_key]['customer_type'] = null;
                    }

                    //lead type
                    if (!empty($lead_data_val['lead_type'])) {
                        $lead[$lead_data_key]['lead_type_text'] = $this->lead_type_arr[$lead_data_val['lead_type']];
                    } else {
                        $lead[$lead_data_key]['lead_type_text'] = null;
                    }

                    $lead[$lead_data_key]['status'] = $this->lead_status[$lead_data_val['status']];
                    //$lead[$lead_data_key]['tagging'] = $this->tagging_done[$lead_data_val['tagging']];
                    if (!empty($lead_data_val['tag_count'])) {
                        $lead[$lead_data_key]['tag_count'] = $lead_data_val['tag_count'];
                        $lead[$lead_data_key]['tagging'] = 'True';
                    } else {
                        $lead[$lead_data_key]['tagging'] = 'False';
                        $lead[$lead_data_key]['tag_count'] = null;
                        //unset($lead[$lead_data_key]['tag_count']);
                    }

                    //get lead feedback
                    $feedData = (new \yii\db\Query())
                        ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                        ->from('lead_feedback fd')
                        ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id AND sm.is_deleted=0')
                        ->where('fd.lead_id="' . $lead_data_val['id'] . '"')
                        ->orderBy('fd.id DESC')
                        ->limit(5)
                        ->createCommand()
                        ->queryAll();
                    $feedback = null;
                    if (!empty($feedData)) {
                        $f_count = 0;
                        foreach ($feedData as $feedData_val) {
                            //$feedback[$f_count]['id'] = $feedData_val['id'];
                            $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                            $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                            //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                            $feedback[$f_count]['created_by'] = $feedData_val['name'];
                            //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                            $f_count++;
                        }
                    }
                    $lead[$lead_data_key]['feedback'] = $feedback;

                    $lead[$lead_data_key]['created_by'] = $lead_data_val['createdby'];
                    $lead[$lead_data_key]['modified_by'] = $lead_data_val['modifiedby'];
                    unset($lead[$lead_data_key]['createdby'], $lead[$lead_data_key]['modifiedby']);
                }
            }
        }

        if (empty($list_type)) {
            //pagination code start
            $pgdata['page'] = $page;
            $pgdata['content_count'] = $lead_count;
            $pgdata['page_count'] = $page_count;
            $pagination = $this->getpagination($pgdata);
            //pagination code end
        }

        $lead_arr['lead'] = $lead;
        if (empty($list_type)) {
            $lead_arr['pagination'] = $pagination;
            $lead_arr['total_count'] = $lead_count;
        }

        return $lead_arr;
    }

    public function gettaglistapi($get_user, $querydata, $list_type = '')
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;

        $staff_type = $get_user->staff_type;

        $get_builder_id = $get_user->builder_id;

        $is_sm = false;
        $is_cp = false;
        $is_staff = false;
        if (!empty($get_cp_id)) {
            $is_cp = true;
        }
        if (!empty($get_builder_id) && $staff_type == 1) {
            $is_sm = true;
        }
        if (!empty($get_builder_id) && $staff_type == 2) {
            $is_staff = true;
        }


        $tag_arr = null;
        if (empty($list_type)) {
            $pagination = null;
        }
        $tag = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        $get_members_txt = '';
        if ($staff_type == 1) {
            $get_members = $this->getaccessmembers($sm_cp_id);
            $get_members[] = $sm_cp_id;

            $get_members_txt = implode(",", $get_members);
        }
        $tag_status = "";
        if (!empty($querydata)) {
            $tag_project_id = (!empty($querydata['project_id']) ? $querydata['project_id'] : '');
            $tag_builder_id = (!empty($querydata['builder_id']) ? $querydata['builder_id'] : '');
            $tag_name = (!empty($querydata['name']) ? trim($querydata['name']) : '');
            $tag_id = (!empty($querydata['id']) ? trim($querydata['id']) : '');
            $tag_tag_id = (!empty($querydata['tag_id']) ? trim($querydata['tag_id']) : '');
            $tag_contact = (!empty($querydata['contact']) ? trim($querydata['contact']) : '');
            $tag_tag_code = (!empty($querydata['tag_code']) ? trim($querydata['tag_code']) : '');
            $tag_start_appointment_date = (!empty($querydata['start_appointment_date']) ? trim($querydata['start_appointment_date']) : '');
            $tag_end_appointment_date = (!empty($querydata['end_appointment_date']) ? trim($querydata['end_appointment_date']) : '');
            $tag_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
            $tag_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : '');
            $tag_customer_type = (!empty($querydata['customer_type']) ? trim($querydata['customer_type']) : '');
            $tag_archive = (!empty($querydata['archive']) ? trim($querydata['archive']) : '');
            $tag_cancel = (!empty($querydata['is_cancelled']) ? trim($querydata['is_cancelled']) : '');

            $tag_start_budget = (!empty($querydata['min_price']) ? trim($querydata['min_price']) : '');
            $tag_end_budget = (!empty($querydata['max_price']) ? trim($querydata['max_price']) : '');
            $tag_flat_type_id = (!empty($querydata['config']) ? trim($querydata['config']) : '');
            $tag_sm_cp_id = (!empty($querydata['sm_cp_id']) ? trim($querydata['sm_cp_id']) : '');

            $tag_status = (isset($querydata['status']) ? trim($querydata['status']) : '');
        }

        if (!empty($get_builder_id)) {
            $tag_builder_id = $get_builder_id;
            $tag_cp_id = (!empty($querydata['cp_id']) ? $querydata['cp_id'] : '');
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'taggingmaster.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }
        if (!empty($get_builder_id)) {
            if (!empty($get_members_txt)) {
                $where_sql = 'taggingmaster.sm_cp_id IN(' . $get_members_txt . ') AND taggingmaster.is_deleted=0 ';
            } else {
                $where_sql = 'taggingmaster.is_deleted=0 ';
            }
        } else {
            $where_sql = 'taggingmaster.created_by IN(' . $get_members_txt . ') AND taggingmaster.is_deleted=0 ';
        }

        if (
            !empty($tag_name) &&
            empty($tag_contact) &&
            empty($tag_tag_code)
        ) {
            $where_sql .= ' AND ((taggingmaster.tag_name like "%' . $tag_name . '%") OR (taggingmaster.tag_phone like "%' . $tag_name . '%") OR (taggingmaster.tag_code like "%' . $tag_name . '%"))';
        } else {
            if (!empty($tag_name)) {
                $where_sql .= ' AND taggingmaster.tag_name like "%' . $tag_name . '%"';
            }
            if (!empty($tag_contact)) {
                $where_sql .= ' AND taggingmaster.tag_phone like "%' . $tag_contact . '%"';
            }
            if (!empty($tag_tag_code)) {
                $where_sql .= ' AND taggingmaster.tag_code like "%' . $tag_tag_code . '%"';
            }
        }
        if (!empty($tag_start_appointment_date)) {
            $where_sql .= ' AND taggingmaster.appointment_date>="' . $tag_start_appointment_date . '"';
        }
        if (!empty($tag_end_appointment_date)) {
            $where_sql .= ' AND taggingmaster.appointment_date<="' . $tag_end_appointment_date . '"';
        }

        //added on 1-7-24
        if (!empty($tag_start_budget)) {
            $where_sql .= ' AND taggingmaster.budget>="' . $tag_start_budget . '"';
        }
        if (!empty($tag_end_budget)) {
            $where_sql .= ' AND taggingmaster.budget<="' . $tag_end_budget . '"';
        }
        if (!empty($tag_flat_type_id)) {
            $where_sql .= ' AND taggingmaster.flat_type_id IN(' . $tag_flat_type_id . ')';
        }
        if (!empty($tag_sm_cp_id)) {
            $where_sql .= ' AND taggingmaster.sm_cp_id IN(' . $tag_sm_cp_id . ')';
        }

        //archive query
        /* $prev_mon_date = date("Y-m-d", strtotime("-1 month"));
        if (!empty($tag_archive)) {
            $where_sql .= ' AND (taggingmaster.appointment_date <"' . $prev_mon_date . '" AND taggingmaster.status=2)';
        } else {
            $where_sql .= ' AND taggingmaster.id NOT IN( SELECT id from taggingmaster where appointment_date < "' . $prev_mon_date . '" AND status=2)';
        } */

        if (!empty($tag_start_created_on_date)) {
            $where_sql .= ' AND DATE(taggingmaster.created_on)>="' . $tag_start_created_on_date . '"';
        }
        if (!empty($tag_end_created_on_date)) {
            $where_sql .= ' AND DATE(taggingmaster.created_on)<="' . $tag_end_created_on_date . '"';
        }
        if (!empty($tag_customer_type)) {
            $where_sql .= ' AND taggingmaster.customer_type="' . $tag_customer_type . '"';
        }



        if (!empty($tag_project_id)) {
            $where_sql .= ' AND taggingmaster.project_id IN(' . $tag_project_id . ')';
        } else {
            if ($staff_type == 2) {
                $get_sm[0] = $sm_cp_id;
                $get_proj = $this->getprojofmultism($get_sm);
                if (!empty($get_proj)) {
                    $get_proj_txt = implode(",", $get_proj);
                    $where_sql .= ' AND taggingmaster.project_id IN(' . $get_proj_txt . ')';
                }
            }
        }
        if (!empty($tag_builder_id)) {
            $where_sql .= ' AND projects.builder_id IN(' . $tag_builder_id . ')';
        }

        if (!empty($tag_cp_id)) {
            $where_sql .= ' AND taggingmaster.cp_id IN(' . $tag_cp_id . ') ';
        }

        if (isset($tag_status) && $tag_status != "") {
            $where_sql .= ' AND taggingmaster.status IN(' . $tag_status . ')';
        }

        if (isset($tag_cancel) && $tag_cancel != "") {
            $where_sql .= ' AND taggingmaster.is_cancelled=1';
        }

        if (!empty($tag_id)) {
            $where_sql .= ' AND taggingmaster.id="' . $tag_id . '"';
        }
        if (!empty($tag_tag_id)) {
            $where_sql .= ' AND taggingmaster.tagging_id="' . $tag_tag_id . '"';
        }


        /* echo $where_sql;
        exit; */
        if (empty($list_type)) {
            $tag_query = (new \yii\db\Query())
                ->select('taggingmaster.id,taggingmaster.tag_code,taggingmaster.retag_limit,taggingmaster.tag_name,taggingmaster.tag_phone,taggingmaster.tagging_id,taggingmaster.lead_id,taggingmaster.tag_email,leadmaster.flat_type_id,taggingmaster.budget,taggingmaster.customer_type,taggingmaster.appointment_date,taggingmaster.appointment_time,taggingmaster.status,taggingmaster.created_on,taggingmaster.created_by,taggingmaster.modified_on,taggingmaster.modified_by,taggingmaster.visit_notvisit_clash_date,taggingmaster.lead_convert_date,taggingmaster.lead_dead_date,taggingmaster.lead_registered_date,sm_cp.name as sourcing_id,leadmaster.lead_id,leadmaster.flat_property_type,creator.name as createdby,creator.contact as cp_contact,creator.sm_cp_id as creatorid,modifier.name as modifiedby,taggingmaster.sm_cp_id,taggingmaster.project_id,cp.company_name as cp_company_name,taggingmaster.visited_by,taggingmaster.booked_by,taggingmaster.registered_by,taggingmaster.is_cancelled,taggingmaster.cancelled_by,taggingmaster.cancelled_on,taggingmaster.flat_type_id as tag_flat_type_id,taggingmaster.flat_property_type as tag_flat_property_type')
                ->from('taggingmaster')
                ->leftJoin("projects", 'taggingmaster.project_id=projects.id')
                ->leftJoin("sm_cp", 'taggingmaster.sm_cp_id=sm_cp.sm_cp_id AND sm_cp.is_deleted=0')
                ->leftJoin("channelpartner as cp", 'taggingmaster.cp_id=cp.id')
                ->leftJoin("leadmaster", 'taggingmaster.lead_id=leadmaster.id AND leadmaster.is_deleted=0')
                ->leftJoin("sm_cp as creator", 'taggingmaster.created_by=creator.sm_cp_id AND creator.is_deleted=0')
                ->leftJoin("sm_cp as modifier", 'taggingmaster.modified_by=modifier.sm_cp_id')
                ->where($where_sql)
                ->orderBy($order_name . ' ' . $order_type);
            $tag_count = $tag_query->count();
            /* echo $proj_count;
                exit; */
            $tag_data = $tag_query->limit($page_count)->offset($offset)->createCommand()
                /* ->getRawsql();
                echo $proj_data;
                exit; */
                ->queryAll();
        } else {
            $tag_query = (new \yii\db\Query())
                ->select('taggingmaster.id,taggingmaster.tag_phone,taggingmaster.tag_name,taggingmaster.tagging_id,taggingmaster.retag_limit')
                ->from('taggingmaster')
                ->where($where_sql)
                ->orderBy($order_name . ' ' . $order_type);

            $tag_data = $tag_query->createCommand()
                ->queryAll();
        }


        if (!empty($tag_data)) {
            foreach ($tag_data as $tag_data_key => $tag_data_val) {
                $tag[$tag_data_key] = $tag_data_val;

                $tag_limit_set = intval($tag_data_val['retag_limit']);
                $tag_available = intval(\Yii::$app->params['RETAG_MAX']) - $tag_limit_set;
                $tag[$tag_data_key]['retag_attempt_left'] = (string) $tag_available;

                if (empty($list_type)) {
                    $tag[$tag_data_key]['name'] = $tag_data_val['tag_name'];
                    $tag[$tag_data_key]['contact'] = $tag_data_val['tag_phone'];
                    $tag[$tag_data_key]['email'] = $tag_data_val['tag_email'];

                    $tag[$tag_data_key]['flat_type_id'] = null;
                    $tag[$tag_data_key]['flat_type_text'] = null;
                    if (empty($tag_data_val['flat_property_type'])) {
                        $tag_data_val['flat_property_type'] = $tag_data_val['tag_flat_property_type'];
                    }
                    if (empty($tag_data_val['flat_type_id'])) {
                        $tag_data_val['flat_type_id'] = $tag_data_val['tag_flat_type_id'];
                    }
                    $tag[$tag_data_key]['flat_property_type'] = (string) $tag_data_val['flat_property_type'];
                    $tag[$tag_data_key]['flat_property_type_text'] = null;
                    if (!empty($tag_data_val['flat_property_type'])) {
                        $tag[$tag_data_key]['flat_property_type_text'] = $this->flat_property_type[$tag_data_val['flat_property_type']];
                    }
                    if ($tag_data_val['flat_property_type'] == 1) {
                        if (!empty($tag_data_val['flat_type_id'])) {
                            $tag[$tag_data_key]['flat_type_id'] = (string) $tag_data_val['flat_type_id'];
                            $tag[$tag_data_key]['flat_type_text'] = $this->flat_type_id[$tag_data_val['flat_type_id']];
                        } else {
                            $tag[$tag_data_key]['flat_type_id'] = null;
                        }
                    }




                    /* $tag[$tag_data_key]['flat_type_text'] = null;
                    if (!empty($tag_data_val['flat_type_id'])) {
                        $tag[$tag_data_key]['flat_type_text'] = $this->flat_type_id[$tag_data_val['flat_type_id']];
                    } else {
                        $tag[$tag_data_key]['flat_type_id'] = null;
                    } */

                    $tag[$tag_data_key]['budgetinwords'] = null;
                    if (!empty($tag_data_val['budget'])) {
                        $tag[$tag_data_key]['budget'] = (string) $tag_data_val['budget'];
                        $tag[$tag_data_key]['budgetinwords'] = $this->AmountInWords($tag_data_val['budget']);
                    } else {
                        $tag[$tag_data_key]['budget'] = null;
                    }

                    if (!empty($tag_data_val['customer_type'])) {
                        $tag[$tag_data_key]['customer_type'] = $this->customer_type[$tag_data_val['customer_type']];
                    } else {
                        $tag[$tag_data_key]['customer_type'] = null;
                    }
                    $tag[$tag_data_key]['status'] = $tag_data_val['status'];
                    $tag[$tag_data_key]['statusText'] = $this->tag_status[$tag_data_val['status']];
                    if ($tag_data_val['status'] == 1) {
                        $tag[$tag_data_key]['visited_on'] = $tag_data_val['visit_notvisit_clash_date'];
                    } else if ($tag_data_val['status'] == 3) {
                        $tag[$tag_data_key]['clashed_on'] = $tag_data_val['visit_notvisit_clash_date'];
                    } else if ($tag_data_val['status'] == 7) {
                        $tag[$tag_data_key]['visited_on'] = $tag_data_val['visit_notvisit_clash_date'];
                    } else if ($tag_data_val['status'] == 4) {
                        $tag[$tag_data_key]['booked_on'] = $tag_data_val['lead_convert_date'];
                    } else if ($tag_data_val['status'] == 5) {
                        $tag[$tag_data_key]['lead_dead_on'] = $tag_data_val['lead_dead_date'];
                    } else if ($tag_data_val['status'] == 6) {
                        $tag[$tag_data_key]['registered_on'] = $tag_data_val['lead_registered_date'];
                    }

                    $show_edit = false;
                    $show_tag_date = false;
                    $show_call = false;
                    $show_share = false;
                    $show_delete = false;
                    if ($is_cp) {
                        if ($tag_data_val['status'] == 0) {
                            $show_edit = true;
                            $show_tag_date = true;
                            $show_call = true;
                            $show_share = true;
                            $show_delete = true;
                        } else if ($tag_data_val['status'] == 1) {
                            $show_edit = true;
                            $show_call = true;
                        } else if ($tag_data_val['status'] == 2) {
                            $show_edit = true;
                            $show_tag_date = true;
                            $show_call = true;
                        } else if ($tag_data_val['status'] == 4) {
                            $show_edit = true;
                            $show_call = true;
                        } else if ($tag_data_val['status'] == 6) {
                            $show_edit = true;
                            $show_call = true;
                        }
                    }
                    if ($is_sm || $is_staff) {
                        $show_edit = true;
                    }
                    $tag[$tag_data_key]['show_edit'] = $show_edit;
                    $tag[$tag_data_key]['show_tag_date'] = $show_tag_date;
                    $tag[$tag_data_key]['show_call'] = $show_call;
                    $tag[$tag_data_key]['show_share'] = $show_share;
                    $tag[$tag_data_key]['show_delete'] = $show_delete;

                    //to be uncommented later
                    /* $tag[$tag_data_key]['cp_name'] = !empty($tag_data_val['createdby']) ? $tag_data_val['createdby'] : null; */
                    //to be commented later
                    $tag[$tag_data_key]['cp_name'] = !empty($tag_data_val['cp_company_name']) ? $tag_data_val['cp_company_name'] : null;


                    $tag[$tag_data_key]['created_by'] = !empty($tag_data_val['createdby']) ? $tag_data_val['createdby'] : null;

                    $tag[$tag_data_key]['last_updated_by'] = null;
                    if (!empty($tag_data_val['visited_by'])) {
                        $visit_staff_model = SmCp::find()->where(['sm_cp_id' => $tag_data_val['visited_by'], 'status' => 1, 'is_deleted' => 0])->one();
                        //$tag['visited_staff'] = $visit_staff_model->name;
                        $tag[$tag_data_key]['last_updated_by'] = !empty($visit_staff_model->name) ? $visit_staff_model->name : "";
                    }
                    if (!empty($tag_data_val['booked_by'])) {
                        $book_staff_model = SmCp::find()->where(['sm_cp_id' => $tag_data_val['booked_by'], 'status' => 1, 'is_deleted' => 0])->one();
                        //$tag['booked_staff'] = $book_staff_model->name;
                        $tag[$tag_data_key]['last_updated_by'] = !empty($book_staff_model->name) ? $book_staff_model->name : "";
                    }
                    if (!empty($tag_data_val['registered_by'])) {
                        $reg_staff_model = SmCp::find()->where(['sm_cp_id' => $tag_data_val['registered_by'], 'status' => 1, 'is_deleted' => 0])->one();
                        //$tag['reg_staff'] = $reg_staff_model->name;
                        $tag[$tag_data_key]['last_updated_by'] = !empty($reg_staff_model->name) ? $reg_staff_model->name : "";
                    }

                    if (!empty($tag_data_val['status']) && in_array($tag_data_val['status'], [4, 6])) {
                        if (!empty($tag_data_val['is_cancelled'])) {
                            $cancelled_staff_model = SmCp::find()->where(['sm_cp_id' => $tag_data_val['cancelled_by']])->one();
                            $tag[$tag_data_key]['booking_cancelled'] = "Yes";
                            $tag[$tag_data_key]['cancelled_staff'] = !empty($cancelled_staff_model->name) ? $cancelled_staff_model->name : "";
                        } else {
                            $tag[$tag_data_key]['booking_cancelled'] = "No";
                        }
                    }


                    /* $tag[$tag_data_key]['modified_by'] = !empty($tag_data_val['modifiedby']) ? $tag_data_val['modifiedby'] : null; */

                    $tag[$tag_data_key]['tag_code_content'] = null;
                    $project_model = Projects::find()->where(['id' => $tag_data_val['project_id']])->one();
                    $code_project_name = !empty($project_model) ? $project_model->name : "";
                    $code_google_link = !empty($project_model) ? $project_model->sale_address : "";
                    $tag[$tag_data_key]['project_id'] = $code_project_name;
                    if (!empty($tag_data_val['tag_code'])) {
                        $sourcing_model = SmCp::find()->where(['sm_cp_id' => $tag_data_val['creatorid'], 'is_deleted' => 0])->one();
                        $get_cp_name = !empty($sourcing_model) ? $sourcing_model->name : "";
                        $get_cp_contact = !empty($sourcing_model) ? $sourcing_model->contact : "";

                        $tag_code_content = "";

                        $tag_code_content = "Hello Sir," . PHP_EOL . "Your appointment has been scheduled at " . $code_project_name . "." . PHP_EOL . "Please Showcase appointment code *" . $tag_data_val['tag_code'] . "* at reception once you arrive." . PHP_EOL . PHP_EOL . "*SALES OFFICE ADDRESS:*" . "" . PHP_EOL . $code_google_link . "" .  PHP_EOL . PHP_EOL .  "In case of any help required to reach the project, you can contact *" . $get_cp_name . "* on *" . $get_cp_contact . "*." . PHP_EOL . PHP_EOL . "Regards,";

                        /* $tag_code_content = "Hello Sir," . PHP_EOL . "Your appointment has been scheduled at " . $code_project_name . "." . PHP_EOL . "Please Showcase appointment code *" . $tag_data_val['tag_code'] . "* at reception once you arrive." . PHP_EOL . PHP_EOL . "*ADITYARAJ SALES OFFICE ADDRESS:*" . "" . PHP_EOL . $code_google_link . "" . PHP_EOL . PHP_EOL . "In case of any help required to reach the project, you can contact *" . $get_cp_name . "* on *" . $get_cp_contact . "*." . PHP_EOL . PHP_EOL . "Regards,"; */
                        //$tag_code_content = trim(preg_replace('/\s+/', ' ', $tag_code_content));
                        $tag[$tag_data_key]['tag_code_content'] = $tag_code_content;
                    }



                    //get lead feedback
                    $feedData = (new \yii\db\Query())
                        ->select('fd.id,fd.feedback,fd.created_on,sm.sm_cp_id,sm.name,sm.role')
                        ->from('tagging_feedback fd')
                        ->leftJoin("sm_cp as sm", 'fd.created_by = sm.sm_cp_id AND sm.is_deleted=0')
                        ->where('fd.tagging_id="' . $tag_data_val['id'] . '"')
                        ->orderBy('fd.id DESC')
                        ->limit(5)  //show last 5 feedback
                        ->createCommand()
                        ->queryAll();
                    $feedback = null;
                    if (!empty($feedData)) {
                        $f_count = 0;
                        foreach ($feedData as $feedData_val) {
                            //$feedback[$f_count]['id'] = $feedData_val['id'];
                            $feedback[$f_count]['feedback'] = $feedData_val['feedback'];
                            $feedback[$f_count]['created_on'] = $feedData_val['created_on'];
                            //$feedback[$f_count]['sm_cp_id'] = $feedData_val['sm_cp_id'];
                            $feedback[$f_count]['created_by'] = $feedData_val['name'];
                            //$feedback[$f_count]['role'] = $this->role[$feedData_val['role']];
                            $f_count++;
                        }
                    }
                    $tag[$tag_data_key]['feedback'] = $feedback;
                    unset($tag[$tag_data_key]['tag_name'], $tag[$tag_data_key]['tag_phone'], $tag[$tag_data_key]['tag_email'], $tag[$tag_data_key]['visit_notvisit_clash_date'], $tag[$tag_data_key]['lead_convert_date'], $tag[$tag_data_key]['lead_dead_date'], $tag[$tag_data_key]['lead_registered_date'], $tag[$tag_data_key]['created_by']);
                } else {
                    $tag[$tag_data_key]['name'] = $tag_data_val['tag_name'];
                    $tag[$tag_data_key]['contact'] = $tag_data_val['tag_phone'];
                    unset($tag[$tag_data_key]['tag_name'], $tag[$tag_data_key]['tag_phone']);
                }
            }
        }
        /* echo "<pre>";
        print_r($tag);
        exit; */

        if (empty($list_type)) {
            //pagination code start
            $pgdata['page'] = $page;
            $pgdata['content_count'] = $tag_count;
            $pgdata['page_count'] = $page_count;
            $pagination = $this->getpagination($pgdata);
            //pagination code end
        }

        $tag_arr['tag'] = $tag;
        if (empty($list_type)) {
            $tag_arr['pagination'] = $pagination;
            $tag_arr['total_count'] = $tag_count;
        }

        return $tag_arr;
    }

    public function getreflistapi($get_user, $querydata)
    {
        $staff_type = $get_user->staff_type;
        $sm_cp_id = $get_user->sm_cp_id;

        $get_builder_id = $get_user->builder_id;
        $get_cp_id = $get_user->channelpartner_id;

        /* $get_members_txt = '';
        if ($staff_type == 1) {
            $get_members = $this->getaccessmembers($sm_cp_id);
            $get_members[] = $sm_cp_id;

            $get_members_txt = implode(",", $get_members);
        } */

        $ref_arr = null;

        $ref = null;


        if (!empty($querydata)) {
            $ref_rera_no = (!empty($querydata['rera_no']) ? $querydata['rera_no'] : '');
            $ref_firm_name = (!empty($querydata['firm_name']) ? $querydata['firm_name'] : '');
            $ref_contact = (!empty($querydata['contact']) ? trim($querydata['contact']) : '');

            $ref_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
            $ref_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : '');

            $ref_status = (!empty($querydata['status']) ? trim($querydata['status']) : '');
        }

        $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'cp_refer.id');
        $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');


        $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
        $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
        if ($page == 1) {
            $offset = 0;
        } else {
            $offset = (($page - 1) * $page_count);
        }
        $where_sql = 'cp_refer.sm_cp_id IN(' . $sm_cp_id . ') ';

        if (!empty($ref_rera_no)) {
            $where_sql .= ' AND cp_refer.rera_no like "%' . $ref_rera_no . '%"';
        }
        if (!empty($ref_firm_name)) {
            $where_sql .= ' AND cp_refer.firm_name like "%' . $ref_firm_name . '%"';
        }
        if (!empty($ref_contact)) {
            $where_sql .= ' AND cp_refer.contact like "%' . $ref_contact . '%"';
        }


        if (!empty($ref_start_created_on_date)) {
            $where_sql .= ' AND DATE(cp_refer.created_on)>="' . $ref_start_created_on_date . '"';
        }
        if (!empty($ref_end_created_on_date)) {
            $where_sql .= ' AND DATE(cp_refer.created_on)<="' . $ref_end_created_on_date . '"';
        }


        //if ($ref_status != "") {
        if (!empty($ref_status)) {
            $where_sql .= ' AND cp_refer.status IN(' . $ref_status . ')';
        }




        $ref_query = (new \yii\db\Query())
            ->select('cp_refer.id,cp_refer.rera_no,cp_refer.firm_name,cp_refer.contact,cp_refer.status,cp_refer.created_on,cp_refer.modified_on,cp_refer.expired_on,cp_refer.sm_cp_id,cp_refer.sm_name,cp_refer.refer_type')
            ->from('cp_refer')
            ->where($where_sql)
            ->orderBy($order_name . ' ' . $order_type);
        $ref_count = $ref_query->count();
        /* echo $proj_count;
                exit; */
        $ref_data = $ref_query->limit($page_count)->offset($offset)->createCommand()
            /* ->getRawsql();
                echo $proj_data;
                exit; */
            ->queryAll();



        if (!empty($ref_data)) {
            foreach ($ref_data as $ref_data_key => $ref_data_val) {
                $ref[$ref_data_key] = $ref_data_val;

                $ref[$ref_data_key]['statusText'] = $this->ref_status[$ref_data_val['status']];

                if ($ref_data_val['refer_type'] == 1) {
                    $ref[$ref_data_key]['refertypeText'] = "CP";
                    $ref[$ref_data_key]['sm_name'] = null;
                } else {
                    $ref[$ref_data_key]['refertypeText'] = "Builder";
                    $ref[$ref_data_key]['rera_no'] = null;
                }

                $ref[$ref_data_key]['hoursLeft'] = null;
                $ref[$ref_data_key]['daysLeft'] = null;
                if (!empty($ref_data_val['expired_on']) && $ref_data_val['status'] == 1) {
                    $futureDate = new DateTime($ref_data_val['expired_on']);

                    // Get the current date and time
                    $currentDate = new DateTime();
                    if ($futureDate > $currentDate) {
                        // Calculate the difference
                        $interval = $currentDate->diff($futureDate);

                        // Convert the difference to hours
                        $hoursLeft = ($interval->days * 24) + $interval->h;
                        $daysLeft = $interval->days;
                    } else {
                        $hoursLeft = 0;
                        $daysLeft = 0;
                    }
                    $ref[$ref_data_key]['hoursLeft'] = $hoursLeft;
                    $ref[$ref_data_key]['daysLeft'] = $daysLeft;
                }


                if (!empty($ref_data_val['sm_cp_id'])) {
                    $sourcing_model = SmCp::find()->where(['sm_cp_id' => $ref_data_val['sm_cp_id'], 'staff_type' => 1, 'is_deleted' => 0])->one();
                    $ref[$ref_data_key]['createdBy'] = $sourcing_model->name;
                }

                $ref[$ref_data_key]['refer_content'] = null;

                $firm_name = "";
                if (!empty($ref_data_val['firm_name'])) {
                    $firm_name = $ref_data_val['firm_name'];
                }

                $refer_content = "Hello " . $firm_name . "," . PHP_EOL . "Your friend " . $sourcing_model->name . " has referred you for installing CP Broadcast mobile application. CP Broadcast is designed to meet the evolving demands of today’s real estate market with lot of features like Lead Management and Digital Tagging. " . PHP_EOL . "Please click on link - https://play.google.com/store/apps/details?id=com.salespro.cpnetwork to install the application." . PHP_EOL . PHP_EOL . "Regards,";


                $ref[$ref_data_key]['refer_content'] = $refer_content;
            }
        }


        //pagination code start
        $pgdata['page'] = $page;
        $pgdata['content_count'] = $ref_count;
        $pgdata['page_count'] = $page_count;
        $pagination = $this->getpagination($pgdata);
        //pagination code end


        $ref_arr['ref'] = $ref;

        $ref_arr['pagination'] = $pagination;


        return $ref_arr;
    }

    public function getreferapi($refer_id, $refer_data, $apk_type = 1)
    {
        $refer_arr = null;
        $refer = null;
        if (empty($refer_data)) {
            $refer_data = CpRefer::find()->where(['id' => $refer_id])->one();
            $refer = $refer_data->toArray();
        } else {
            $refer = $refer_data->toArray();
        }

        if (!empty($refer_data)) {

            $refer['id'] = (string) $refer['id'];
            if (!empty($refer['status'])) {
                $refer['statusText'] = $this->ref_status[$refer['status']];
            } else {
                $refer['statusText'] = 'In Progress';
            }

            if ($refer['refer_type'] == 1) {
                unset($refer['sm_name']);
                $refer['refertypeText'] = 'CP';
            } else {
                unset($refer['rera_no']);
                $refer['refertypeText'] = 'Builder';
            }

            $refer['hoursLeft'] = null;
            $refer['daysLeft'] = null;

            if (!empty($refer['expired_on']) && $refer['status'] == 1) {
                $futureDate = new DateTime($refer['expired_on']);

                // Get the current date and time
                $currentDate = new DateTime();
                if ($futureDate > $currentDate) {
                    // Calculate the difference
                    $interval = $currentDate->diff($futureDate);

                    // Convert the difference to hours
                    $hoursLeft = ($interval->days * 24) + $interval->h;
                    $daysLeft = $interval->days;
                } else {
                    $hoursLeft = 0;
                    $daysLeft = 0;
                }

                $refer['hoursLeft'] = $hoursLeft;
                $refer['daysLeft'] = $daysLeft;
            }

            if (!empty($refer['sm_cp_id'])) {
                $sourcing_model = SmCp::find()->where(['sm_cp_id' => $refer['sm_cp_id'], 'staff_type' => 1, 'is_deleted' => 0])->one();
                $refer['createdBy'] = $sourcing_model->name;
            }

            $firm_name = "";
            if (!empty($refer['firm_name'])) {
                $firm_name = $refer['firm_name'];
            }

            $refer['refer_content'] = null;
            $get_link = "https://play.google.com/store/apps/details?id=com.salespro.cpnetwork";
            if ($apk_type == 1) {
                $get_link = "https://play.google.com/store/apps/details?id=com.salespro.cpnetwork";
            } else if ($apk_type == 2) {
                $get_link = "https://apps.apple.com/in/app/cp-broadcast/id6739004166";
            }


            $refer_content = "Hello " . $firm_name . "," . PHP_EOL . "Your friend " . $sourcing_model->name . " has referred you for installing CP Broadcast mobile application. CP Broadcast is designed to meet the evolving demands of today's real estate market with lot of features like Lead Management and Digital Tagging. " . PHP_EOL . "Please click on link - " . $get_link . " to install the application." . PHP_EOL . PHP_EOL . "Regards,";


            $refer['refer_content'] = $refer_content;


            $refer_arr['refer'] = $refer;
        }
        return $refer_arr;
    }

    public function gettagstatsapi($sm_cp_id, $get_type = 'cp')
    {
        $get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $statData_arr = null;


        $get_members_txt = implode(",", $get_members);
        if ($get_type == 'cp') {
            $where_sql = " taggingmaster.created_by IN(" . $get_members_txt . ") AND taggingmaster.is_deleted=0 ";
        } else if ($get_type == 'staff') {
            $get_sm[0] = $sm_cp_id;
            if (!empty($get_sm)) {
                $get_proj_txt = "-1";
                $get_proj = $this->getprojofmultism($get_sm);
                if (!empty($get_proj)) {
                    $get_proj_txt = implode(",", $get_proj);
                }
                $where_sql = " taggingmaster.project_id IN(" . $get_proj_txt . ") AND taggingmaster.is_deleted=0 ";
            }
        } else {
            $where_sql = " taggingmaster.sm_cp_id IN(" . $get_members_txt . ") AND taggingmaster.is_deleted=0 ";
        }

        $prev_mon_date = date("Y-m-d", strtotime("-1 month"));

        $where_sql .= ' AND taggingmaster.id NOT IN( SELECT id from taggingmaster where appointment_date < "' . $prev_mon_date . '" AND status=2)';

        /* $get_date = date('Y-m-d');
        $statData = [];
        $total_where_sql = $where_sql;
        $total_query = (new \yii\db\Query())
            ->select('taggingmaster.id')
            ->from('taggingmaster')
            ->where($total_where_sql);
        $total_count = $total_query->count();
        $statData['total'] = $total_count;

        $appointment_where_sql = $where_sql . " AND taggingmaster.status=0";
        $appointment_query = (new \yii\db\Query())
            ->select('taggingmaster.id')
            ->from('taggingmaster')
            ->where($appointment_where_sql);
        $appointment_count = $appointment_query->count();
        $statData['appointment'] = $appointment_count; */

        $statData = Yii::$app->db->createCommand("SELECT IFNULL(SUM(IF((taggingmaster.id!=''), 1, 0)), 0) AS total, IFNULL(SUM(IF((taggingmaster.status=0), 1, 0)), 0) AS appointment,IFNULL(SUM(IF((taggingmaster.status=1 OR taggingmaster.status=3), 1, 0)), 0) AS visited,IFNULL(SUM(IF((taggingmaster.status=2), 1, 0)), 0) AS notvisited,IFNULL(SUM(IF((taggingmaster.status=7), 1, 0)), 0) AS physical_visit,IFNULL(SUM(IF((taggingmaster.status=6 OR taggingmaster.status=4), 1, 0)), 0) AS booked FROM taggingmaster where " . $where_sql)->queryAll();

        if (!empty($statData)) {
            $statData_arr['stats'] = $statData[0];
        }
        return $statData_arr;
    }

    public function getpoststatsapi($sm_cp_id, $post_for = '1')
    {
        //No need to show team postings
        //$get_members = $this->getaccessmembers($sm_cp_id);
        $get_members[] = $sm_cp_id;
        $statData_arr = null;

        $get_members_txt = implode(",", $get_members);

        $where_sql = "cp_customers_flats.post_for='" . $post_for . "' ";
        $where_sql .= " AND cp_customers_flats.sm_cp_id IN(" . $get_members_txt . ") ";

        $where_post_sql = "cp_customers_flats.post_for='" . $post_for . "' ";
        $where_post_sql .= " AND cp_customers_flats.sm_cp_id IN(" . $sm_cp_id . ") ";


        if ($post_for == 1) {
            $sql_select = " ,IFNULL(SUM(IF((cp_customers_flats.type=1), 1, 0)), 0) AS buyer,IFNULL(SUM(IF((cp_customers_flats.type=2), 1, 0)), 0) AS seller ";
        } else {
            $sql_select = " ,IFNULL(SUM(IF((cp_customers_flats.rental_type=1), 1, 0)), 0) AS owner,IFNULL(SUM(IF((cp_customers_flats.rental_type=2), 1, 0)), 0) AS tenant ";
        }
        $statData = Yii::$app->db->createCommand("SELECT IFNULL(SUM(IF(cp_customers_flats.id != '', 1, 0)), 0) AS total,IFNULL(SUM(IF(cp_customers_flats.status = 0, 1, 0)), 0) AS in_progress,IFNULL(SUM(IF(cp_customers_flats.status = 1, 1, 0)), 0) AS active,IFNULL(SUM(IF(cp_customers_flats.status = 2, 1, 0)), 0) AS expired,IFNULL(SUM(IF(cp_customers_flats.status = 3, 1, 0)), 0) AS blocked,IFNULL(SUM(IF(cp_customers_flats.status = 4, 1, 0)), 0) AS deal_closed " . $sql_select . " FROM cp_customers_flats where " . $where_sql)->queryAll();

        $post_viewed = 0;

        $get_spam_arr = $this->getspampost($sm_cp_id);
        if (!empty($get_spam_arr)) {
            $get_spam_arr_txt = implode(",", $get_spam_arr);
            $where_post_sql .= ' AND cp_customers_flats.id NOT IN(' . $get_spam_arr_txt . ')';
        }


        $statviewData = Yii::$app->db->createCommand("SELECT count(v.id) as post_viewed FROM cp_customers_flats_view v where v.my_post_id IN(select id from cp_customers_flats where " . $where_post_sql . ")")->queryAll();

        if (!empty($statData)) {
            $statData_arr['stats'] = $statData[0];
        }
        if (!empty($statviewData)) {
            $statData_arr['stats']['post_viewed'] = $statviewData[0]['post_viewed'];
        }
        return $statData_arr;
    }

    public function gettagstatsmonthlyapi($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;
        $staff_type = $get_user->staff_type;
        $tag_arr = null;

        $tag = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */

        if ($staff_type == 1) {
            $get_members = $this->getaccessmembers($sm_cp_id);
            $get_members[] = $sm_cp_id;
            $get_members_txt = implode(",", $get_members);
        } else {
            $get_sm[0] = $sm_cp_id;
            $get_proj_txt = "-1";
            $get_proj = $this->getprojofmultism($get_sm);
            if (!empty($get_proj)) {
                $get_proj_txt = implode(",", $get_proj);
            }
        }



        $tag_year = date('Y');
        if (!empty($querydata)) {

            $tag_year = (!empty($querydata['year']) ? trim($querydata['year']) : date('Y'));
        }

        if ($staff_type == 1) {
            if (!empty($get_cp_id)) {
                $where_sql = 'taggingmaster.created_by IN(' . $get_members_txt . ') AND taggingmaster.is_deleted=0 ';
            } else {
                $where_sql = 'taggingmaster.sm_cp_id IN(' . $get_members_txt . ') AND taggingmaster.is_deleted=0 ';
            }
        } else {
            $where_sql = 'taggingmaster.project_id IN(' . $get_proj_txt . ') AND taggingmaster.is_deleted=0 ';
        }
        if (!empty($tag_year)) {
            $where_sql .= ' AND YEAR(taggingmaster.created_on)="' . $tag_year . '"';
        }

        /* $prev_mon_date = date("Y-m-d", strtotime("-1 month"));
        $where_sql .= ' AND taggingmaster.id NOT IN( SELECT id from taggingmaster where appointment_date < "' . $prev_mon_date . '" AND status=2)'; */



        $tag_query = (new \yii\db\Query())
            ->select('YEAR(created_on) AS y, MONTH(created_on) AS m, COUNT(id) as val')
            ->from('taggingmaster')
            ->where($where_sql)
            ->groupBy('y,m')
            ->orderBy('y DESC');
        $tag_data = $tag_query->createCommand()->queryAll();

        if (!empty($tag_data)) {
            foreach ($tag_data as $tag_data_key => $tag_data_val) {
                $tag[$tag_data_key]['name'] = $this->month[$tag_data_val['m']];
                $tag[$tag_data_key]['count'] = $tag_data_val['val'];

                $get_date = $tag_data_val['y'] . '-' . $tag_data_val['m'] . '-' . '01';
                $date = new DateTime($get_date);
                $date->modify('last day of this month');
                $get_last_day = $date->format('Y-m-d');

                $tag[$tag_data_key]['start_created_on_date'] = $get_date;
                $tag[$tag_data_key]['end_created_on_date'] = $get_last_day;
            }
        }

        $tag_arr['stats']['monthwise'] = $tag;

        return $tag_arr;
    }

    public function getleadstatsmonthlyapi($get_user, $querydata)
    {
        $sm_cp_id = $get_user->sm_cp_id;
        $get_cp_id = $get_user->channelpartner_id;
        $staff_type = $get_user->staff_type;
        $tag_arr = null;

        $tag = null;
        /* echo "<pre>";
        print_r($querydata);
        exit; */

        if ($staff_type == 1) {
            $get_members = $this->getaccessmembers($sm_cp_id);
            $get_members[] = $sm_cp_id;
            $get_members_txt = implode(",", $get_members);
        }



        $tag_year = date('Y');
        if (!empty($querydata)) {

            $tag_year = (!empty($querydata['year']) ? trim($querydata['year']) : date('Y'));
        }

        if ($staff_type == 1) {
            if (!empty($get_cp_id)) {
                $where_sql = 'leadmaster.created_by IN(' . $get_members_txt . ') AND leadmaster.is_deleted=0 ';
            } else {
                $where_sql = 'leadmaster.sm_cp_id IN(' . $get_members_txt . ') AND leadmaster.is_deleted=0 ';
            }
        }
        if (!empty($tag_year)) {
            $where_sql .= ' AND YEAR(leadmaster.created_on)="' . $tag_year . '"';
        }

        /* $prev_mon_date = date("Y-m-d", strtotime("-1 month"));
        $where_sql .= ' AND taggingmaster.id NOT IN( SELECT id from taggingmaster where appointment_date < "' . $prev_mon_date . '" AND status=2)'; */



        $tag_query = (new \yii\db\Query())
            ->select('YEAR(created_on) AS y, MONTH(created_on) AS m, COUNT(id) as val')
            ->from('leadmaster')
            ->where($where_sql)
            ->groupBy('y,m')
            ->orderBy('y DESC');
        $tag_data = $tag_query->createCommand()->queryAll();

        if (!empty($tag_data)) {
            foreach ($tag_data as $tag_data_key => $tag_data_val) {
                $tag[$tag_data_key]['name'] = $this->month[$tag_data_val['m']];
                $tag[$tag_data_key]['count'] = $tag_data_val['val'];

                $get_date = $tag_data_val['y'] . '-' . $tag_data_val['m'] . '-' . '01';
                $date = new DateTime($get_date);
                $date->modify('last day of this month');
                $get_last_day = $date->format('Y-m-d');

                $tag[$tag_data_key]['start_created_on_date'] = $get_date;
                $tag[$tag_data_key]['end_created_on_date'] = $get_last_day;
            }
        }

        $tag_arr['stats']['monthwise'] = $tag;

        return $tag_arr;
    }

    public function getmarketlistapi($get_user, $querydata)
    {
        $cp_id = $get_user->channelpartner_id;
        $is_mgmt = $get_user->mgmt;
        $builder_id = $get_user->builder_id;
        $sm_cp_id = $get_user->sm_cp_id;
        $market_arr = null;
        $app_features = 1;
        if (!$is_mgmt && !empty($cp_id)) {
            $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
            $is_mgmt = $get_cp_data->mgmt;
            //Don't show Offers if App Features shown is CP Connect.
            //$app_features = $get_cp_data->app_features;
        }

        $pagination = null;
        $market = null;

        //Offer to be shown only for All Features in CP
        if ($app_features == 1) {

            $get_proj = array();

            if (!empty($cp_id)) {
                $get_sm = $this->getsmofcp($cp_id);
                if (!empty($get_sm)) {
                    $get_proj = $this->getprojofmultism($get_sm);
                }
            }


            /* if (!empty($get_proj)) {

            $get_proj_txt = implode(",", $get_proj);
            } */
            $market_start_campaign_date = '';
            $market_end_campaign_date = '';
            if (!empty($querydata)) {

                $market_name = (!empty($querydata['name']) ? trim($querydata['name']) : '');
                $market_project_id = (!empty($querydata['project_id']) ? implode(",", $querydata['project_id']) : []);
                /* $market_start_campaign_date = (!empty($querydata['start_campaign_date']) ? trim($querydata['start_campaign_date']) : '');
            $market_end_campaign_date = (!empty($querydata['end_campaign_date']) ? trim($querydata['end_campaign_date']) : '');
            $market_start_created_on_date = (!empty($querydata['start_created_on_date']) ? trim($querydata['start_created_on_date']) : '');
            $market_end_created_on_date = (!empty($querydata['end_created_on_date']) ? trim($querydata['end_created_on_date']) : ''); */
            }

            $order_name = (isset($querydata['sort_name']) ? 'marketing_schedule.' . trim($querydata['sort_name']) : 'marketing_schedule.modified_on');
            $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'DESC');

            /*  $order_name = (isset($querydata['sort_name']) ? 'marketing_schedule.' . trim($querydata['sort_name']) : 'RAND()');
            $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : ''); */



            $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
            $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
            if ($page == 1) {
                $offset = 0;
            } else {
                $offset = (($page - 1) * $page_count);
            }

            /* $where_sql = 'marketing_schedule.project_id IN(' . $get_proj_txt . ') AND marketing_schedule.status=1 AND marketing_campaign.status=1'; */
            $where_sql = 'marketing_schedule.status=1 AND marketing_campaign.status=1';
            if (!empty($market_name)) {
                $where_sql .= ' AND marketing_schedule.name like "%' . $market_name . '%"';
            }
            if ($is_mgmt) {
                $where_sql .= ' AND projects.builder_id IN(3)';
            } else {
                if (!empty($market_project_id)) {
                    $where_sql .= ' AND marketing_campaign.project_id IN(' . $market_project_id . ')';
                }
            }

            if (!empty($builder_id)) {
                $where_sql .= ' AND projects.builder_id IN(' . $builder_id . ')';
            }

            /* if (!empty($market_start_campaign_date)) {
            $where_sql .= ' AND marketing_schedule.start_date>="' . $market_start_campaign_date . '"';
            }
            if (!empty($market_end_campaign_date)) {
                $where_sql .= ' AND marketing_schedule.start_date<="' . $market_end_campaign_date . '"';
            }

            if (!empty($market_start_created_on_date)) {
                $where_sql .= ' AND DATE(marketing_schedule.created_on)>="' . $market_start_created_on_date . '"';
            }
            if (!empty($market_end_created_on_date)) {
                $where_sql .= ' AND DATE(marketing_schedule.created_on)<="' . $market_end_created_on_date . '"';
            } */

            $where_sql .= ' AND DATE("' . date('Y-m-d') . '") BETWEEN marketing_campaign.start_date AND marketing_campaign.end_date';



            $market_query = (new \yii\db\Query())
                ->select(
                    'marketing_schedule.id,marketing_schedule.campaign_id,projects.name as projectname,marketing_campaign.project_id,marketing_campaign.start_date,marketing_campaign.end_date,marketing_schedule.created_on,marketing_schedule.website,marketing_schedule.name as title,marketing_schedule.brief as schedule_brief,marketing_campaign.feedback as campaign_feedback,location.name as location_name'
                )
                ->from('marketing_schedule')
                ->leftJoin("marketing_campaign", 'marketing_schedule.campaign_id=marketing_campaign.id')
                ->leftJoin("projects", 'marketing_campaign.project_id=projects.id')
                ->leftJoin("location", 'projects.location_id=location.id')
                //->leftJoin("sm_cp as creator", 'marketing.created_by=creator.sm_cp_id')
                //->leftJoin("sm_cp as modifier", 'marketing.modified_by=modifier.sm_cp_id')
                ->where($where_sql)
                ->orderBy($order_name . ' ' . $order_type);
            $market_count = $market_query->count();
            /* echo $proj_count;
                    exit; */
            $market_data = $market_query->limit($page_count)->offset($offset)->createCommand()
                /* ->getRawsql();
                    echo $market_data;
                    exit; */
                ->queryAll();

            if (!empty($market_data)) {
                foreach ($market_data as $market_data_key => $market_data_val) {
                    $market[$market_data_key] = $market_data_val;
                    $databrief = '';
                    if (!empty($market_data_val['schedule_brief'])) {
                        $databrief = $market_data_val['schedule_brief'];
                    }
                    if (empty($databrief)) {
                        if (!empty($market_data_val['campaign_feedback'])) {
                            $databrief = $market_data_val['campaign_feedback'];
                        }
                    }



                    $sm_connected = 'false';
                    if (!empty($get_proj)) {
                        if (in_array($market_data_val['project_id'], $get_proj)) {
                            $sm_connected = 'true';
                        }
                    }
                    $market[$market_data_key]['sm_connected'] = $sm_connected;



                    if (!empty($databrief)) {
                        $get_camp_brief = trim(preg_replace('/\s+/', ' ', $databrief));
                        $market[$market_data_key]['brief'] = $get_camp_brief;
                    } else {
                        $market[$market_data_key]['brief'] = null;
                    }

                    $get_campaign_content_arr = null;
                    $get_campaign_content_data = MarketingCampaignContent::find()->select('content')->where(['schedule_id' => $market_data_val['id']])->asArray()->all();
                    if (!empty($get_campaign_content_data)) {
                        $c_count = 0;
                        foreach ($get_campaign_content_data as $get_campaign_content_data_val) {
                            $get_campaign_content_arr[$c_count]['link'] = \Yii::$app->params['web_path'] . 'files/marketing/' . $get_campaign_content_data_val['content'];
                            $c_count++;
                        }
                        $market[$market_data_key]['content'] = $get_campaign_content_arr;
                    }

                    //get sourcing
                    $sourcingData = (new \yii\db\Query())
                        ->select('sm.sm_cp_id,sm.name,sm.role,sm.contact')
                        ->from('sm_projects sp')
                        ->leftJoin("sm_cp as sm", 'sp.sm_cp_id = sm.sm_cp_id AND sm.is_deleted=0')
                        ->where('FIND_IN_SET("' . (int) $market_data_val['project_id'] . '",projects_id) AND sp.status=1 AND sm.status=1 AND sm.staff_type=1 AND sm.role is not null')->groupBy('sp.sm_cp_id')->createCommand()
                        ->queryAll();
                    $sourcing = null;
                    $sourcingbyrole = null;
                    $final_sourcing = null;
                    /* var_dump($sourcingData);
                exit; */
                    if (!empty($sourcingData)) {
                        if ($sm_connected == 'false') {
                            $s_count = 0;
                            foreach ($sourcingData as $sourcingData_val) {
                                $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                                $s_count++;
                            }
                            //Show executive first, then manager then Leader
                            if (isset($sourcingbyrole[3])) {
                                $final_sourcing[0] = $sourcingbyrole[3];
                            } else if (isset($sourcingbyrole[2])) {
                                $final_sourcing[0] = $sourcingbyrole[2];
                            } else if (isset($sourcingbyrole[1])) {
                                $final_sourcing[0] = $sourcingbyrole[1];
                            }
                            //$final_sourcing = $sourcing;
                        } else {
                            $s_count = 0;
                            foreach ($sourcingData as $sourcingData_val) {
                                if (in_array($sourcingData_val['sm_cp_id'], $get_sm)) {
                                    $sourcing[$s_count]['sm_cp_id'] = $sourcingData_val['sm_cp_id'];
                                    $sourcing[$s_count]['name'] = $sourcingData_val['name'];
                                    $sourcing[$s_count]['role'] = $this->role[$sourcingData_val['role']];
                                    $sourcing[$s_count]['contact'] = $sourcingData_val['contact'];
                                    $sourcingbyrole[$sourcingData_val['role']] = $sourcing[$s_count];
                                    $s_count++;
                                }
                            }
                            //Show executive first, then manager then Leader
                            /* if (isset($sourcingbyrole[3])) {
                            $final_sourcing[0] = $sourcingbyrole[3];
                        } else if (isset($sourcingbyrole[2])) {
                            $final_sourcing[0] = $sourcingbyrole[2];
                        } else if (isset($sourcingbyrole[1])) {
                            $final_sourcing[0] = $sourcingbyrole[1];
                        } */
                            $final_sourcing = $sourcing;
                        }
                    }
                    $market[$market_data_key]['sourcing'] = $final_sourcing;

                    /*  echo "<pre>";
                print_r($final_sourcing[0]['sm_cp_id']); */
                    if (isset($final_sourcing[0]['sm_cp_id'])) {
                        $get_final_sm = $final_sourcing[0]['sm_cp_id'];
                    } else {
                        $get_final_sm = $final_sourcing;
                    }
                    //exit;

                    //check if sm is connected
                    //$get_final_sm = $final_sourcing[0]['sm_cp_id'];
                    $sm_cpnetwork_data = SmCpNetwork::find()->where(['channelpartner_id' => $cp_id, 'sm_cp_id' => $get_final_sm])->one();

                    /* if (!empty($sm_cpnetwork_data)) {

                    $sm_cpnetwork_data_arr = $sm_cpnetwork_data->toArray();
                    echo $sm_cpnetwork_data_arr['status'];
                    echo "---------";
                    
                } */


                    /* echo $sm_cpnetwork_data->status;
                echo "---------"; */
                    if (!empty($sm_cpnetwork_data)) {
                        if ($sm_cpnetwork_data->status == 3) {
                            $market[$market_data_key]['connection_status'] = "1";
                            $market[$market_data_key]['connection_statustext'] = "Requested";
                        } else if ($sm_cpnetwork_data->status == 1) {
                            $market[$market_data_key]['connection_status'] = "2";
                            $market[$market_data_key]['connection_statustext'] = "Connected";
                        } else if ($sm_cpnetwork_data->status == 2) {
                            $market[$market_data_key]['connection_status'] = "3";
                            $market[$market_data_key]['connection_statustext'] = "Deactivated";
                        }
                    } else {
                        $market[$market_data_key]['connection_status'] = 0;
                        $market[$market_data_key]['connection_statustext'] = "Not Connected";
                    }



                    unset($market[$market_data_key]['campaign_id'], $market[$market_data_key]['schedule_brief'], $market[$market_data_key]['campaign_feedback']);
                }
            }

            /* echo "3334";
            exit; */

            //pagination code start
            $pgdata['page'] = $page;
            $pgdata['content_count'] = $market_count;
            $pgdata['page_count'] = $page_count;
            $pagination = $this->getpagination($pgdata);
            //pagination code end


            /* echo "<pre>";
                print_r($project);
            exit; */
        }
        //Offer to be shown only for All Features in CP


        $market_arr['marketing'] = $market;
        $market_arr['pagination'] = $pagination;


        return $market_arr;
    }

    public function getcpnetwork($get_user, $querydata, $showstatus = 1, $list_type = '')
    {
        $get_sm_cp_id = $get_user->sm_cp_id;
        $get_builder_id = $get_user->builder_id;

        $network_arr = null;
        if (empty($list_type)) {
            $pagination = null;
        }
        $network = null;
        $show_network = true;
        /* echo "<pre>";
        print_r($querydata);
        exit; */
        if (empty($get_builder_id)) {
            $show_network = false;
        }

        if ($show_network) {


            if (!empty($querydata)) {

                $cp_company_name = (!empty($querydata['company_name']) ? trim($querydata['company_name']) : '');
                $cp_rera = (!empty($querydata['rera_no']) ? trim($querydata['rera_no']) : '');
                $cp_contact = (!empty($querydata['contact']) ? trim($querydata['contact']) : '');
                $cp_status = (!empty($querydata['status']) ? trim($querydata['status']) : '');
            }

            $order_name = (isset($querydata['sort_name']) ? trim($querydata['sort_name']) : 'cp.company_name');
            $order_type = (isset($querydata['sort_type']) ? trim($querydata['sort_type']) : 'ASC');


            $page_count = (isset($querydata['page_count']) ? trim($querydata['page_count']) : 25);
            $page = (isset($querydata['page']) ? trim($querydata['page']) : 1);
            if ($page == 1) {
                $offset = 0;
            } else {
                $offset = (($page - 1) * $page_count);
            }

            if (empty($cp_status)) {
                $where_sql = 'sm_cp_network.status="' . $showstatus . '" ';
            } else {
                $where_sql = 'sm_cp_network.status="' . $cp_status . '" ';
            }

            $where_sql .= 'AND sm_cp_network.sm_cp_id="' . $get_sm_cp_id . '" AND cp.status=1 ';
            if (!empty($cp_company_name)) {
                $where_sql .= ' AND cp.company_name like "%' . $cp_company_name . '%"';
            }
            if (!empty($cp_contact)) {
                $where_sql .= ' AND cp.contact like "%' . $cp_contact . '%"';
            }
            if (!empty($cp_rera)) {
                $where_sql .= ' AND cp.rera_number="' . $cp_rera . '"';
            }
            //not show dummy cp and test cp
            $where_sql .= " AND (LOWER(cp.rera_number) NOT LIKE 'dummy%' AND cp.rera_number!='jobin') ";


            if (empty($list_type)) {


                $sort_text = $order_name . ' ' . $order_type;


                $network_query = (new \yii\db\Query())
                    ->select('sm_cp_network.network_id,sm_cp_network.request_sent,sm_cp_network.joined_date,sm_cp_network.channelpartner_id,cp.company_name,cp.contact,cp.name,cp.rera_number as rera_no')
                    ->from('sm_cp_network')
                    ->leftJoin("channelpartner as cp", 'sm_cp_network.channelpartner_id = cp.id')
                    ->where($where_sql)
                    ->orderBy($sort_text);
                $network_count = $network_query->count();
                /* echo $proj_count;
                exit; */
                $network_data = $network_query->limit($page_count)->offset($offset)->createCommand()
                    /* ->getRawsql();
                    echo $proj_data;
                    exit; */
                    ->queryAll();
            } else {
                $network_query = (new \yii\db\Query())
                    ->select('cp.id,cp.company_name,cp.contact,cp.name')
                    ->from('sm_cp_network')
                    ->leftJoin("channelpartner as cp", 'sm_cp_network.channelpartner_id = cp.id')
                    ->where($where_sql)
                    ->orderBy($order_name . ' ' . $order_type);

                $network_data = $network_query->createCommand()
                    ->queryAll();
            }

            /* echo "<pre>";
                print_r($proj_data);
                exit; */
            if (!empty($network_data)) {
                //$check_proj_count = 0;      //added for testing
                //$check_multi_count = 1;     //added for testing
                //while ($check_multi_count < 6) {    //added for testing
                foreach ($network_data as $network_data_key => $network_data_val) {
                    //$proj_data_key = $check_proj_count;     //added for testing
                    $network[$network_data_key] = $network_data_val;

                    if ($showstatus == 3) {
                        unset($network[$network_data_key]['joined_date']);
                    } else if ($showstatus == 1) {
                        unset($network[$network_data_key]['request_sent']);
                    }

                    /*  if (empty($list_type)) {
                        unset($project[$proj_data_key]['logo_name'], $project[$proj_data_key]['low_price'], $project[$proj_data_key]['builder_id'], $project[$proj_data_key]['flat_types'], $project[$proj_data_key]['flat_property_types'],  $project[$proj_data_key]['latlong']);
                    } */

                    //$check_proj_count++;    //added for testing
                }
                //$check_multi_count++;       //added for testing
                //}       //added for testing
            }

            /* echo "<pre>";
                print_r($project);
                exit; */

            if (empty($list_type)) {
                //pagination code start
                $pgdata['page'] = $page;
                //$pgdata['content_count'] = $proj_count * 5;     //added for testing
                $pgdata['content_count'] = $network_count;
                $pgdata['page_count'] = $page_count;
                $pagination = $this->getpagination($pgdata);
                //pagination code end
            }

            /* echo "<pre>";
                print_r($project);
                exit; */
            //}
        }

        $network_arr['network'] = $network;
        if (empty($list_type)) {
            $network_arr['pagination'] = $pagination;
        }

        return $network_arr;
    }

    public function checkmembercount($cp_id)
    {
        $check_query = (new \yii\db\Query())
            ->select('sm_cp.sm_cp_id')
            ->from('sm_cp')
            ->where("sm_cp.channelpartner_id='" . $cp_id . "' AND sm_cp.status=1");

        $user_count = $check_query->count();
        return $user_count;
    }

    public function getpostinglimit($post_id, $sm_cp_id)
    {
        $post_stat = [];
        $check_query = (new \yii\db\Query())
            ->select('id')
            ->from('cp_customers_flats_view')
            ->where("my_post_id='" . $post_id . "' AND sm_cp_id='" . $sm_cp_id . "'");

        $view_count = $check_query->count();
        $limit_count = intval(Yii::$app->params['POSTING_VIEW_MAX']);
        $available_count = $limit_count - $view_count;
        $post_stat['view_count'] = $view_count;
        $post_stat['limit_count'] = $limit_count;
        $post_stat['available_count'] = $available_count;

        $check_view_query = (new \yii\db\Query())
            ->select('id')
            ->from('cp_customers_flats_view')
            ->where("post_id='" . $post_id . "'");

        $others_view_count = $check_view_query->count();
        $post_stat['others_view_count'] = $others_view_count;


        return $post_stat;
    }


    function AmountInWords($get_amount)
    {
        $show_aount = '';
        if ($get_amount >= 1000000 && $get_amount < 10000000) {
            $get_digit = substr($get_amount, 0, 2);
            $get_inner_digit = intval(substr($get_amount, 2, 2));
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " L";
            } else {
                $show_aount = $get_digit . " L";
            }
        } else if ($get_amount >= 10000000 && $get_amount < 100000000) {
            $get_digit = substr($get_amount, 0, 1);
            $get_inner_digit = intval(substr($get_amount, 1, 2));
            if ($get_inner_digit < 10 && $get_inner_digit > 0) {
                $get_inner_digit = "0" . $get_inner_digit;
            }
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " Cr";
            } else {
                $show_aount = $get_digit . " Cr";
            }
        } else if ($get_amount >= 100000000 && $get_amount < 1000000000) {
            $get_digit = substr($get_amount, 0, 2);
            $get_inner_digit = intval(substr($get_amount, 2, 2));
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " Cr";
            } else {
                $show_aount = $get_digit . " Cr";
            }
        } else if ($get_amount >= 100000 && $get_amount < 1000000) {
            $get_digit = substr($get_amount, 0, 1);
            $get_inner_digit = intval(substr($get_amount, 1, 2));
            if ($get_inner_digit < 10 && $get_inner_digit > 0) {
                $get_inner_digit = "0" . $get_inner_digit;
            }
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " L";
            } else {
                $show_aount = $get_digit . " L";
            }
        } else if ($get_amount >= 10000 && $get_amount < 100000) {
            $get_digit = substr($get_amount, 0, 2);
            $get_inner_digit = intval(substr($get_amount, 2, 2));
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " K";
            } else {
                $show_aount = $get_digit . " K";
            }
        } else if ($get_amount >= 1000 && $get_amount < 10000) {
            $get_digit = substr($get_amount, 0, 1);
            $get_inner_digit = intval(substr($get_amount, 1, 2));
            if ($get_inner_digit < 10 && $get_inner_digit > 0) {
                $get_inner_digit = "0" . $get_inner_digit;
            }
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " K";
            } else {
                $show_aount = $get_digit . " K";
            }
        } else {
            $get_digit = substr($get_amount, 0, 3);
            $get_inner_digit = intval(substr($get_amount, 2, 2));
            if ($get_inner_digit > 0) {
                $show_aount = $get_digit . "." . $get_inner_digit . " Cr";
            } else {
                $show_aount = $get_digit . " Cr";
            }
        }
        return $show_aount;
    }

    // Create a function for converting the amount in words
    function AmountInWordsfull($amount)
    {
        $num = $amount;
        $amt_hundred = null;
        $count_length = strlen($num);
        $x = 0;
        $string = array();
        $change_words = array(
            0 => '',
            1 => 'One',
            2 => 'Two',
            3 => 'Three',
            4 => 'Four',
            5 => 'Five',
            6 => 'Six',
            7 => 'Seven',
            8 => 'Eight',
            9 => 'Nine',
            10 => 'Ten',
            11 => 'Eleven',
            12 => 'Twelve',
            13 => 'Thirteen',
            14 => 'Fourteen',
            15 => 'Fifteen',
            16 => 'Sixteen',
            17 => 'Seventeen',
            18 => 'Eighteen',
            19 => 'Nineteen',
            20 => 'Twenty',
            30 => 'Thirty',
            40 => 'Forty',
            50 => 'Fifty',
            60 => 'Sixty',
            70 => 'Seventy',
            80 => 'Eighty',
            90 => 'Ninety'
        );
        $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($x < $count_length) {
            $get_divider = ($x == 2) ? 10 : 100;
            $amount = floor($num % $get_divider);
            $num = floor($num / $get_divider);
            $x += $get_divider == 10 ? 1 : 2;
            if ($amount) {
                $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
                $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
                $string[] = ($amount < 21) ? $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred : $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . ' ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
            } else $string[] = null;
        }
        $implode_to_Rupees = implode('', array_reverse($string));
        return ($implode_to_Rupees ? trim($implode_to_Rupees) : '');
    }

    function encryptId($id)
    {
        $secret_key = "cproshan";
        $key = hash('sha256', $secret_key, true);
        $cipher = 'AES-256-CBC';

        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($cipher));
        $encrypted = openssl_encrypt($id, $cipher, $key, 0, $iv);

        return rtrim(strtr(base64_encode($encrypted . '::' . $iv), '+/', '-_'), '=');
    }

    function decryptId($encryptedId)
    {
        $secret_key = "cproshan";
        $key = hash('sha256', $secret_key, true);
        $cipher = 'AES-256-CBC';

        $data = base64_decode(strtr($encryptedId, '-_', '+/'));
        list($encrypted, $iv) = explode('::', $data, 2);

        return openssl_decrypt($encrypted, $cipher, $key, 0, $iv);
    }
}
