<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cp_customers_flats".
 *
 * @property int $id
 * @property int $sm_cp_id
 * @property string $title
 * @property string|null $description
 * @property int $type 1-customer,2-flat
 * @property string|null $project_name
 * @property int $location_id
 * @property int $budget
 * @property int $flat_type_id
 * @property int $carpet
 * @property string|null $created_on
 * @property string|null $modified_on
 * @property int|null $verified_by
 * @property int|null $modified_by
 * @property int $status 0-In Progress,1-verified,2-expired
 * @property int|null $rank
 * @property int $flat_property_type
 * @property string|null $message
 * @property string|null $notify_date
 * @property int $post_for
 * @property int $deposit
 * @property int $monthly_rent
 * @property string|null $landmark
 * @property int $rental_type
 * @property string|null $post_id
 */
class CpCustomersFlats extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cp_customers_flats';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'location_id', 'carpet', 'title'], 'required'],
            [['sm_cp_id', 'type', 'location_id', 'budget', 'flat_type_id', 'flat_property_type', 'carpet', 'verified_by', 'modified_by', 'status', 'posting_type', 'post_for', 'deposit', 'monthly_rent', 'rental_type'], 'integer'],
            [['created_on', 'modified_on', 'description', 'rank', 'post_id'], 'safe'],
            [['landmark'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'sm_cp_id' => 'Sm Cp ID',
            'title' => 'Title',
            'description' => 'Description',
            'type' => 'Type',
            'location_id' => 'Location ID',
            'budget' => 'Budget',
            'flat_type_id' => 'Flat Type',
            'carpet' => 'Carpet',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'verified_by' => 'Verified By',
            'modified_by' => 'Modified By',
            'status' => 'Status',
            'posting_type' => 'Posting Type',
            'rank' => 'Rank',
            'flat_property_type' => 'Property Type',
            'message' => 'Message',
            'post_for' => 'Posting For',
            'deposit' => 'Deposit',
            'monthly_rent' => 'Monthly Rent',
            'landmark' => 'Landmark',
            'rental_type' => 'Rental Type',
            'post_id' => 'POST ID',
        ];
    }
}