<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "faqmaster".
 *
 * @property int $id
 * @property string $question
 * @property string $answer
 * @property string $created_on
 * @property int $created_by
 * @property string|null $modified_on
 * @property int|null $modified_by
 * @property int $status 1-Enabled,2-Disabled
 */
class Faqmaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'faqmaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['question', 'answer'], 'required'],
            [['question', 'answer'], 'string'],
            [['created_on', 'modified_on'], 'safe'],
            [['created_by', 'modified_by', 'status'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'question' => 'Question',
            'answer' => 'Answer',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'status' => 'Status',
        ];
    }
}