<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "flat".
 *
 * @property int $id
 * @property string $type
 * @property int $projects_id
 * @property int $properties_id
 * @property string $bathroom_count
 * @property string $balconies
 * @property string $transaction_type
 * @property int $flat_type_id
 * @property int $booking_amount
 * @property string $base_price
 * @property int $rate_per_sqft
 * @property string $gst
 * @property string $stampduty
 * @property string $registration
 * @property string $developement_charges
 * @property string $car_parking
 * @property string $other_charges
 * @property int $total_charge
 * @property string $door_facing_direction
 * @property string $carpet_area
 * @property string $builtup_area
 * @property string $construction
 * @property string $budget_threshold
 * @property string $note
 * @property int $status
 * @property string $created_on
 * @property string $modified_on
 */
class Flat extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'flat';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['type', 'projects_id', 'properties_id', 'bathroom_count', 'balconies', 'transaction_type', 'flat_type_id', 'booking_amount', 'base_price', 'rate_per_sqft', 'gst', 'stampduty', 'registration', 'developement_charges', 'car_parking', 'other_charges', 'total_charge', 'door_facing_direction', 'carpet_area', 'builtup_area', 'construction', 'budget_threshold', 'note', 'status', 'created_on', 'modified_on'], 'required'],
            [['projects_id', 'properties_id', 'flat_type_id', 'booking_amount', 'rate_per_sqft', 'total_charge', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['type', 'balconies', 'stampduty'], 'string', 'max' => 150],
            [['bathroom_count', 'base_price', 'gst', 'carpet_area', 'builtup_area', 'construction', 'budget_threshold'], 'string', 'max' => 100],
            [['transaction_type', 'registration', 'car_parking', 'door_facing_direction'], 'string', 'max' => 120],
            [['developement_charges', 'other_charges'], 'string', 'max' => 125],
            [['note'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'type' => 'Type',
            'projects_id' => 'Projects ID',
            'properties_id' => 'Properties ID',
            'bathroom_count' => 'Bathroom Count',
            'balconies' => 'Balconies',
            'transaction_type' => 'Transaction Type',
            'flat_type_id' => 'Flat Type ID',
            'booking_amount' => 'Booking Amount',
            'base_price' => 'Base Price',
            'rate_per_sqft' => 'Rate Per Sqft',
            'gst' => 'Gst',
            'stampduty' => 'Stampduty',
            'registration' => 'Registration',
            'developement_charges' => 'Developement Charges',
            'car_parking' => 'Car Parking',
            'other_charges' => 'Other Charges',
            'total_charge' => 'Total Charge',
            'door_facing_direction' => 'Door Facing Direction',
            'carpet_area' => 'Carpet Area',
            'builtup_area' => 'Builtup Area',
            'construction' => 'Construction',
            'budget_threshold' => 'Budget Threshold',
            'note' => 'Note',
            'status' => 'Status',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
        ];
    }
}
