<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "leadmaster".
 *
 * @property int $id
 * @property int $cp_id
 * @property string $name
 * @property string $email
 * @property string $contact
 * @property int $budget
 * @property string|null $followup_date
 * @property int $status 1=>visited,2=>Inactive
 * @property int|null $flat_type_id 1->1BHK,2->1.5BHK,3->2BHK,4->2.5BHK,5->3BHK
 * @property string|null $feedback
 * @property int|null $customer_type 1-> Hot, 2-> Warm, 3-> Cold
 * @property int $tagging
 * @property string $lead_id
 * @property int $created_by
 * @property string $created_on
 * @property int $modified_by
 * @property string $modified_on
 * @property int $created_from 1->mobile app, 2-> crm
 * @property int $carpet
 * @property string $location_id
 * @property int $flat_property_type
 * @property int $lead_type
 * @property int $is_deleted
 * @property string|null $followup_time
 */
class Leadmaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'leadmaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cp_id', 'name', 'contact', 'budget'], 'required'],
            [['cp_id', 'budget', 'status', 'flat_type_id', 'customer_type', 'tagging', 'created_by', 'modified_by', 'created_from', 'is_deleted', 'carpet', 'flat_property_type', 'lead_type'], 'integer'],
            [['followup_date', 'created_on', 'modified_on', 'followup_time'], 'safe'],
            [['feedback', 'location_id'], 'string'],
            [['name', 'email'], 'string', 'max' => 300],
            [['contact'], 'string', 'max' => 15],
            [['lead_id'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cp_id' => 'Cp ID',
            'name' => 'Name',
            'email' => 'Email',
            'contact' => 'Contact',
            'budget' => 'Budget',
            'followup_date' => 'Followup Date',
            'status' => 'Status',
            'flat_type_id' => 'Flat Type ID',
            'feedback' => 'Feedback',
            'customer_type' => 'Customer Type',
            'tagging' => 'Tagging',
            'lead_id' => 'Lead ID',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
            'created_from' => 'Created From',
            'carpet' => 'Carpet',
            'location_id' => 'Preferred Location',
            'flat_property_type' => 'Flat Type',
            'lead_type' => 'Lead Type',
            'followup_time' => 'Followup Time'
        ];
    }
}
