<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "login_list".
 *
 * @property int $id
 * @property string $contact
 * @property int|null $status 1-success,2-failed
 * @property string $last_login
 * @property int $login_tries
 * @property int $sm_cp_id
 * @property string $feedback
 */
class LoginList extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'login_list';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['contact', 'last_login', 'login_tries', 'feedback'], 'required'],
            [['status', 'login_tries', 'sm_cp_id'], 'integer'],
            [['last_login'], 'safe'],
            [['contact'], 'string', 'max' => 12],
            [['feedback'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'contact' => 'Contact',
            'status' => 'Status',
            'last_login' => 'Last Login',
            'login_tries' => 'Login Tries',
            'sm_cp_id' => 'Sm Cp ID',
            'feedback' => 'Feedback',
        ];
    }
}
