<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "notification_master".
 *
 * @property int $id
 * @property int|null $cp_id
 * @property int $sent_type 1-All,2-Single CP 
 * @property string $title
 * @property string $message
 * @property string|null $link
 * @property string $created_on
 * @property string|null $modified_on
 * @property int $status 1-created,2-listed,3-executed,4-cancelled 
 * @property string|null $info
 */
class NotificationMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'notification_master';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cp_id', 'sent_type', 'status'], 'integer'],
            [['title', 'message', 'created_on'], 'required'],
            [['title', 'message', 'link', 'info'], 'string'],
            [['created_on', 'modified_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cp_id' => 'Cp ID',
            'sent_type' => 'Sent Type',
            'title' => 'Title',
            'message' => 'Message',
            'link' => 'Link',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'status' => 'Status',
            'info' => 'Info',
        ];
    }
}
