<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "package_banners".
 *
 * @property int $id
 * @property string $name
 * @property string $banner
 * @property int $status 1-active,2-inactive
 * @property int $created_by
 * @property string $created_on
 */
class PackageBanners extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'package_banners';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'banner', 'created_by', 'created_on'], 'required'],
            [['name'], 'string'],
            [['status', 'created_by'], 'integer'],
            [['created_on'], 'safe'],
            [['banner'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'banner' => 'Banner',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
        ];
    }
}
