<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "sm_projects".
 *
 * @property int $id
 * @property int $sm_cp_id
 * @property string $projects_id
 * @property string $created_on
 * @property int $created_by
 * @property string $modified_on
 * @property int $modified_by
 * @property int $status 0->inactive,1->active
 */
class SmProjects extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sm_projects';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'projects_id'], 'required'],
            [['sm_cp_id', 'created_by', 'modified_by', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['projects_id'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'sm_cp_id' => 'Sm Cp ID',
            'projects_id' => 'Projects ID',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'status' => 'Status',
        ];
    }
}
