<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "smcp_feedback".
 *
 * @property int $id
 * @property int $sm_cp_id
 * @property string $feedback
 * @property string $created_on
 * @property int $created_by
 */
class SmcpFeedback extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'smcp_feedback';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'feedback', 'created_on', 'created_by'], 'required'],
            [['sm_cp_id', 'created_by'], 'integer'],
            [['feedback'], 'string'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'sm_cp_id' => 'Sm Cp ID',
            'feedback' => 'Feedback',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
        ];
    }
}
