<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "ticket".
 *
 * @property int $id
 * @property string $data_available
 * @property int $issue_type 1-CP Registration,2-Login,3-Profile Changes,4-Leads,5-Tagging
 * @property string $message
 * @property string $ip_address
 * @property string $created_on
 * @property string $modified_on
 * @property int $modified_by
 * @property int $status 1->received,2->in progress,3->resolved
 */
class Ticket extends \yii\db\ActiveRecord
{
    public $type;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'ticket';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['contact', 'issue_type', 'message'], 'required'],
            [['contact', 'message'], 'string'],
            [['issue_type', 'modified_by', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['ip_address'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'contact' => 'Contact',
            'issue_type' => 'Issue Type',
            'message' => 'Message',
            'ip_address' => 'Ip Address',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'status' => 'Status',
        ];
    }
}
