<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "amenities".
 *
 * @property int $id
 * @property string $type
 * @property int $projects_id
 * @property int $properties_id
 * @property string $name
 * @property string|null $icon
 * @property string $value
 * @property string $order
 * @property string $use_type
 * @property int $status
 * @property string $created_by
 * @property string $modified_by
 * @property string $created_on
 * @property string $modified_on
 */
class Amenities extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'amenities';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['type', 'projects_id', 'properties_id', 'name', 'value', 'order', 'use_type', 'status', 'created_by', 'modified_by', 'created_on', 'modified_on'], 'required'],
            [['projects_id', 'properties_id', 'status'], 'integer'],
            [['value'], 'string'],
            [['created_on', 'modified_on'], 'safe'],
            [['type', 'icon', 'created_by', 'modified_by'], 'string', 'max' => 100],
            [['name', 'order', 'use_type'], 'string', 'max' => 120],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'type' => 'Type',
            'projects_id' => 'Projects ID',
            'properties_id' => 'Properties ID',
            'name' => 'Name',
            'icon' => 'Icon',
            'value' => 'Value',
            'order' => 'Order',
            'use_type' => 'Use Type',
            'status' => 'Status',
            'created_by' => 'Created By',
            'modified_by' => 'Modified By',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
        ];
    }
}
