<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cp_customers_flats_view".
 *
 * @property int $id
 * @property int $my_post_id
 * @property int $post_id
 * @property int $sm_cp_id
 * @property string $created_on
 * @property int $view_type
 */
class CpCustomersFlatsView extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cp_customers_flats_view';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['post_id', 'sm_cp_id', 'created_on'], 'required'],
            [['my_post_id', 'post_id', 'sm_cp_id', 'view_type'], 'integer'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'my_post_id' => 'My Post',
            'post_id' => 'Viewed Post',
            'sm_cp_id' => 'Sm Cp ID',
            'created_on' => 'Created On',
            'view_type' => 'View Type'
        ];
    }
}
