<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "lead_feedback".
 *
 * @property int $id
 * @property int $lead_id
 * @property string $feedback
 * @property string $created_on
 * @property int $created_by
 */
class LeadFeedback extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'lead_feedback';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['lead_id', 'feedback', 'created_on', 'created_by'], 'required'],
            [['lead_id', 'created_by'], 'integer'],
            [['feedback'], 'string'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'lead_id' => 'Lead ID',
            'feedback' => 'Feedback',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
        ];
    }
}
