<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "location".
 *
 * @property int $id
 * @property string $name
 * @property int $status
 * @property string $created_on
 * @property string $modified_on
 */
class Location extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'location';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'status', 'created_on', 'modified_on'], 'required'],
            [['status'], 'integer'],
            [['created_on', 'modified_on', 'subtype_id', 'near_locs'], 'safe'],
            [['name'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'status' => 'Status',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'subtype_id' => 'Location Subtype',
            'latlong' => 'Location Lat & Long',
            'dist_range' => 'Distance Range',
            'near_locs' => 'Near Locations',
            'latitude' => 'Latitude',
            'longitude' => 'Longitude',
            'next_update' => 'Next Update',
        ];
    }
}
