<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "location_subtype".
 *
 * @property int $id
 * @property string $name
 * @property string|null $created_on
 * @property int $status 1-active,2-inactive
 */
class LocationSubtype extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'location_subtype';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['created_on'], 'safe'],
            [['status'], 'integer'],
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'created_on' => 'Created On',
            'status' => 'Status',
        ];
    }
}
