<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "marketing".
 *
 * @property int $id
 * @property string $name
 * @property int $project_id
 * @property string $campaign
 * @property string $start_date
 * @property string $end_date
 * @property int $visit_count
 * @property int $created_by
 * @property string $created_on
 * @property int $modified_by
 * @property string $modified_on
 * @property int $status 1->Active,2->Inactive
 */
class Marketing extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'marketing';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'project_id', 'campaign', 'start_date', 'end_date'], 'required'],
            [['project_id', 'visit_count', 'created_by', 'modified_by', 'status'], 'integer'],
            [['start_date', 'end_date', 'created_on', 'modified_on'], 'safe'],
            [['name'], 'string', 'max' => 150],
            [['campaign'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'project_id' => 'Project ID',
            'campaign' => 'Campaign',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'visit_count' => 'Visit Count',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
            'status' => 'Status',
        ];
    }
}
