<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "marketing_schedule".
 *
 * @property int $id
 * @property string $name
 * @property int $campaign_id
 * @property string $brief
 * @property int $impression_count
 * @property int $visit_count
 * @property int $created_by
 * @property string $created_on
 * @property int $modified_by
 * @property string $modified_on
 * @property int $status 1->Active,2->Inactive
 * @property string $website
 */
class MarketingSchedule extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'marketing_schedule';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'campaign_id'], 'required'],
            [['campaign_id', 'visit_count', 'created_by', 'modified_by', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['name'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'campaign_id' => 'Campaign ID',
            'brief' => 'Brief',
            'impression_count' => 'Impression Count',
            'visit_count' => 'Visit Count',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
            'status' => 'Status',
            'website' => 'Website',
        ];
    }
}
