<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "notification_list".
 *
 * @property int $id
 * @property int $notification_id
 * @property int $sm_cp_id
 * @property string $title
 * @property string $message
 * @property string|null $link
 * @property string $created_on
 * @property string|null $modified_on
 * @property int $status 1-listed,2-sent,3-read 
 * @property string|null $response
 * @property int $success 1-success,2-failure
 * @property string $read_on
 */
class NotificationList extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'notification_list';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['notification_id', 'sm_cp_id', 'title', 'message', 'created_on'], 'required'],
            [['notification_id', 'sm_cp_id', 'status', 'success'], 'integer'],
            [['title', 'message', 'link', 'response'], 'string'],
            [['created_on', 'modified_on', 'read_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'notification_id' => 'Notification ID',
            'sm_cp_id' => 'Sm Cp ID',
            'title' => 'Title',
            'message' => 'Message',
            'link' => 'Link',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'status' => 'Status',
            'response' => 'Response',
            'success' => 'Success',
            'read_on' => 'Read On'
        ];
    }
}
