<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "package".
 *
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property int $amountpermonth
 * @property int $type 1-SM User,2-CP User
 * @property string $config_values
 * @property string|null $created_on
 * @property int|null $created_by
 * @property string|null $modified_on
 * @property int|null $modified_by
 * @property int $status 1-Enabled,2-Disabled
 */
class Package extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'package';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'amountpermonth', 'config_values'], 'required'],
            [['description', 'config_values'], 'string'],
            [['amountpermonth', 'type', 'created_by', 'modified_by', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['name'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'description' => 'Description',
            'amountpermonth' => 'Amountpermonth',
            'type' => 'Type',
            'config_values' => 'Config Values',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'status' => 'Status',
        ];
    }
}
