<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "posting_content".
 *
 * @property int $id
 * @property int $post_id
 * @property string $content
 * @property string $created_on
 * @property int $created_by
 */
class PostingContent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'posting_content';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['post_id', 'content', 'created_on', 'created_by'], 'required'],
            [['post_id', 'created_by'], 'integer'],
            [['created_on'], 'safe'],
            [['content'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'post_id' => 'Post ID',
            'content' => 'Content',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
        ];
    }
}
