<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "snse_dooits_photo".
 *
 * @property int $photo_video_id
 * @property int|null $add_dooits_id it is project id
 * @property int $add_project_id
 * @property string $name
 * @property string $docs_name
 * @property string|null $file_type
 * @property string|null $highlights
 * @property int $default
 * @property int $status
 * @property int $projects_id
 * @property int $photo_category 1=>'Other',2=>'Elevation',3=>'Floor Plan',4=>'Unit Plan',5=>'Amenites'
 * @property int $booking_id
 * @property int $created_by
 * @property int $modified_by
 * @property string $created_on
 * @property string $modified_on
 */
class SnseDooitsPhoto extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'snse_dooits_photo';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['add_dooits_id', 'add_project_id', 'default', 'status', 'projects_id', 'photo_category', 'booking_id', 'created_by', 'modified_by'], 'integer'],
            [['add_project_id', 'name', 'docs_name', 'projects_id', 'booking_id', 'created_by', 'modified_by', 'created_on', 'modified_on'], 'required'],
            [['created_on', 'modified_on'], 'safe'],
            [['name'], 'string', 'max' => 150],
            [['docs_name'], 'string', 'max' => 100],
            [['file_type'], 'string', 'max' => 50],
            [['highlights'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'photo_video_id' => 'Photo Video ID',
            'add_dooits_id' => 'Add Dooits ID',
            'add_project_id' => 'Add Project ID',
            'name' => 'Name',
            'docs_name' => 'Docs Name',
            'file_type' => 'File Type',
            'highlights' => 'Highlights',
            'default' => 'Default',
            'status' => 'Status',
            'projects_id' => 'Projects ID',
            'photo_category' => 'Photo Category',
            'booking_id' => 'Booking ID',
            'created_by' => 'Created By',
            'modified_by' => 'Modified By',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
        ];
    }
}
