<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "posting_bookmark".
 *
 * @property int $id
 * @property int $sm_cp_id
 * @property int $posting_id
 * @property string $created_on
 */
class PostingBookmark extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'posting_bookmark';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'posting_id', 'created_on'], 'required'],
            [['sm_cp_id', 'posting_id'], 'integer'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'sm_cp_id' => 'Sm Cp ID',
            'posting_id' => 'Posting ID',
            'created_on' => 'Created On',
        ];
    }
}
