<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "sm_cp_bookmark".
 *
 * @property int $id
 * @property int $sm_cp_id
 * @property int $projects_id
 * @property int|null $created_on
 */
class SmCpBookmark extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sm_cp_bookmark';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'projects_id'], 'required'],
            [['sm_cp_id', 'projects_id'], 'integer'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'sm_cp_id' => 'Sm Cp ID',
            'projects_id' => 'Projects ID',
            'created_on' => 'Created On',
        ];
    }
}
