<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "sm_cp_network".
 *
 * @property int $network_id
 * @property int $channelpartner_id
 * @property string $request_sent
 * @property string $joined_date
 * @property string $modified_date
 * @property int|null $created_by
 * @property int|null $modified_by
 * @property int $status 1=>active,2=>Inactive
 * @property int $sm_cp_id
 */
class SmCpNetwork extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sm_cp_network';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['channelpartner_id', 'sm_cp_id'], 'required'],
            [['channelpartner_id', 'created_by', 'modified_by', 'status', 'sm_cp_id'], 'integer'],
            [['request_sent', 'joined_date', 'modified_date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'network_id' => 'Network ID',
            'channelpartner_id' => 'Channelpartner ID',
            'request_sent' => 'Request Sent',
            'joined_date' => 'Joined Date',
            'modified_date' => 'Modified Date',
            'created_by' => 'Created By',
            'modified_by' => 'Modified By',
            'status' => 'Status',
            'sm_cp_id' => 'Sm Cp ID',
        ];
    }
}
