<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "staff".
 *
 * @property int $id
 * @property int|null $consultant_id 1 for self
 * @property int|null $builder_id
 * @property int $entities 1-consultant,2-builder,3-saleprosys
 * @property string $name
 * @property string $smsname
 * @property string $employee_id
 * @property string $password
 * @property string $email_id
 * @property string $address_for_communication
 * @property string $permanent_address
 * @property int $staff_contact
 * @property int|null $personal_contact This will not use for sms,email
 * @property int $uid
 * @property string $pan_number
 * @property string $designation_management
 * @property string $qualification
 * @property int $experience
 * @property string $date_of_joining
 * @property string $date_of_termination
 * @property int $role
 * @property string $role_name it is value from role select
 * @property string $department
 * @property string $responsibility
 * @property string $job_description
 * @property string $dob
 * @property int $salary
 * @property string $blood_group
 * @property string $previous_company_name_and_address
 * @property int $projects_id
 * @property int $status
 * @property string $created_on
 * @property string $modified_on
 */
class Staff extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'staff';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['consultant_id', 'builder_id', 'entities', 'staff_contact', 'personal_contact', 'uid', 'experience', 'role', 'salary', 'projects_id', 'status'], 'integer'],
            [['name', 'smsname', 'employee_id', 'password', 'email_id', 'address_for_communication', 'permanent_address', 'staff_contact', 'uid', 'pan_number', 'designation_management', 'qualification', 'experience', 'date_of_joining', 'date_of_termination', 'role', 'role_name', 'department', 'responsibility', 'job_description', 'dob', 'salary', 'blood_group', 'previous_company_name_and_address', 'projects_id', 'status', 'created_on', 'modified_on'], 'required'],
            [['address_for_communication', 'permanent_address', 'previous_company_name_and_address'], 'string'],
            [['date_of_joining', 'date_of_termination', 'dob', 'created_on', 'modified_on'], 'safe'],
            [['name', 'password', 'qualification'], 'string', 'max' => 50],
            [['smsname'], 'string', 'max' => 6],
            [['employee_id', 'blood_group'], 'string', 'max' => 20],
            [['email_id', 'job_description'], 'string', 'max' => 200],
            [['pan_number'], 'string', 'max' => 30],
            [['designation_management', 'department', 'responsibility'], 'string', 'max' => 10],
            [['role_name'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'consultant_id' => 'Consultant ID',
            'builder_id' => 'Builder ID',
            'entities' => 'Entities',
            'name' => 'Name',
            'smsname' => 'Smsname',
            'employee_id' => 'Employee ID',
            'password' => 'Password',
            'email_id' => 'Email ID',
            'address_for_communication' => 'Address For Communication',
            'permanent_address' => 'Permanent Address',
            'staff_contact' => 'Staff Contact',
            'personal_contact' => 'Personal Contact',
            'uid' => 'Uid',
            'pan_number' => 'Pan Number',
            'designation_management' => 'Designation Management',
            'qualification' => 'Qualification',
            'experience' => 'Experience',
            'date_of_joining' => 'Date Of Joining',
            'date_of_termination' => 'Date Of Termination',
            'role' => 'Role',
            'role_name' => 'Role Name',
            'department' => 'Department',
            'responsibility' => 'Responsibility',
            'job_description' => 'Job Description',
            'dob' => 'Dob',
            'salary' => 'Salary',
            'blood_group' => 'Blood Group',
            'previous_company_name_and_address' => 'Previous Company Name And Address',
            'projects_id' => 'Projects ID',
            'status' => 'Status',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
        ];
    }
}
