<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tagging_feedback".
 *
 * @property int $id
 * @property int $tagging_id
 * @property string $feedback
 * @property string $created_on
 * @property int $created_by
 */
class TaggingFeedback extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tagging_feedback';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['tagging_id', 'feedback', 'created_on', 'created_by'], 'required'],
            [['tagging_id', 'created_by'], 'integer'],
            [['feedback'], 'string'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'tagging_id' => 'Tagging ID',
            'feedback' => 'Feedback',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
        ];
    }
}
