<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cp_refer".
 *
 * @property int $id
 * @property int $sm_cp_id
 * @property string $rera_no
 * @property string $firm_name
 * @property string $contact
 * @property int $status 1-created,2-credited,3-no credit
 * @property string|null $created_on
 * @property string|null $modified_on
 * @property string|null $expired_on
 * @property int $ref_count
 * @property string|null $sm_name
 * @property int $refer_type
 */
class CpRefer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cp_refer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'contact'], 'required'],
            [['sm_cp_id', 'status', 'refer_type'], 'integer'],
            [['created_on', 'modified_on', 'expired_on', 'refer_type'], 'safe'],
            [['rera_no'], 'string', 'max' => 30],
            [['firm_name', 'sm_name'], 'string', 'max' => 250],
            [['contact'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'sm_cp_id' => 'Sm Cp ID',
            'rera_no' => 'Rera No',
            'firm_name' => 'Firm Name',
            'contact' => 'Contact',
            'status' => 'Status',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'expired_on' => 'Expired On',
            'ref_count' => 'Referal Count',
            'sm_name' => 'SM Name',
            'refer_type' => 'Referal Type',
        ];
    }
}
