<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "guidelinesmaster".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $filename
 * @property int $rank
 * @property string|null $created_on
 * @property int|null $created_by
 * @property int $status 1-Active,2-InActive
 */
class Guidelinesmaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'guidelinesmaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['rank', 'created_by', 'status'], 'integer'],
            [['created_on'], 'safe'],
            [['name', 'filename'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'filename' => 'Filename',
            'rank' => 'Rank',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'status' => 'Status',
        ];
    }
}
