<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invoice".
 *
 * @property int $id
 * @property string|null $invoice_code
 * @property string $order_ids
 * @property string|null $created_on
 * @property int|null $created_by
 * @property string|null $modified_on
 * @property int|null $modified_by
 * @property int $status 1->Invoice created,2->Partial Payment received,3->Full payment received
 * @property int $builder_id
 * @property int $channelpartner_id
 * @property int $final_amount
 * @property string|null $note
 */
class Invoice extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'invoice';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_ids', 'final_amount'], 'required'],
            [['created_on', 'modified_on'], 'safe'],
            [['created_by', 'modified_by', 'status', 'builder_id', 'channelpartner_id', 'final_amount'], 'integer'],
            [['note'], 'string'],
            [['invoice_code'], 'string', 'max' => 100],
            [['order_ids'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invoice_code' => 'Invoice Code',
            'order_ids' => 'Order Ids',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'status' => 'Status',
            'builder_id' => 'Builder ID',
            'channelpartner_id' => 'Channelpartner ID',
            'final_amount' => 'Final Amount',
            'note' => 'Note',
        ];
    }
}
