<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "log_api".
 *
 * @property int $id
 * @property string $link
 * @property int $type
 * @property string $passed_params
 * @property int|null $sm_cp_id
 * @property string|null $created_on
 * @property string|null $headers
 */
class LogApi extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'log_api';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['link', 'type', 'passed_params'], 'required'],
            [['link', 'passed_params', 'headers'], 'string'],
            [['type', 'sm_cp_id'], 'integer'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'link' => 'Link',
            'type' => 'Type',
            'passed_params' => 'Passed Params',
            'sm_cp_id' => 'Sm Cp ID',
            'created_on' => 'Created On',
            'headers' => 'Headers',
        ];
    }
}
