<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "notifications".
 *
 * @property int $id
 * @property int $type 3-project,4-announcement
 * @property int|null $builder_id
 * @property int|null $project_id
 * @property int $sent_type 1-All,2-Connected CP 
 * @property string $title
 * @property string $message
 * @property string $created_on
 * @property int|null $created_by
 * @property int|null $created_by_sm
 * @property int $status 1-created,2-listed,3-executed,4-cancelled 	
 * @property string|null $modified_on
 * @property string $notification_date
 * @property string $link
 */
class Notifications extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'notifications';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['type', 'title', 'message', 'created_on', 'notification_date'], 'required'],
            [['type', 'builder_id', 'project_id', 'sent_type', 'created_by', 'created_by_sm', 'status'], 'integer'],
            [['title', 'message'], 'string'],
            [['created_on', 'modified_on', 'notification_date', 'link'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'type' => 'Type',
            'builder_id' => 'Builder ID',
            'project_id' => 'Project ID',
            'sent_type' => 'Sent Type',
            'title' => 'Title',
            'message' => 'Message',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'created_by_sm' => 'Created By Sm',
            'status' => 'Status',
            'modified_on' => 'Modified On',
            'notification_date' => 'Notification Date',
            'link' => 'Link',
        ];
    }
}
