<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "package_enquiry".
 *
 * @property int $id
 * @property int $package_id
 * @property int $month
 * @property int $sm_cp_id
 * @property string $created_on
 * @property int $status 1-In Progress,2-Ringing,3-Not Interested,4-Will do later,5-Package purchased
 * @property int|null $rm
 */
class PackageEnquiry extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'package_enquiry';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['package_id', 'sm_cp_id'], 'required'],
            [['package_id', 'month', 'sm_cp_id', 'status', 'rm'], 'integer'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'package_id' => 'Package ID',
            'month' => 'Month',
            'sm_cp_id' => 'Sm Cp ID',
            'created_on' => 'Created On',
            'status' => 'Status',
            'rm' => 'Rm',
        ];
    }
}
