<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "package_enquiry_feedback".
 *
 * @property int $id
 * @property int $enquiry_id
 * @property string $feedback
 * @property string $created_on
 * @property int $created_by
 */
class PackageEnquiryFeedback extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'package_enquiry_feedback';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['enquiry_id', 'feedback', 'created_on', 'created_by'], 'required'],
            [['enquiry_id', 'created_by'], 'integer'],
            [['feedback'], 'string'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'enquiry_id' => 'Enquiry ID',
            'feedback' => 'Feedback',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
        ];
    }
}
