<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "package_order".
 *
 * @property int $order_id
 * @property string|null $order_code
 * @property int $builder_id
 * @property int $channelpartner_id
 * @property string $projects_id
 * @property int $package_id
 * @property int $package_amount
 * @property int|null $month
 * @property int|null $inventory
 * @property int|null $total_amount
 * @property int $discount_amount
 * @property int $final_amount
 * @property string|null $note
 * @property int|null $status 1->Order created,2->Payment received,3->order extended,4->order rejected
 * @property int $created_by
 * @property string $created_on
 * @property int $modified_by
 * @property string $modified_on
 */
class PackageOrder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'package_order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['builder_id', 'channelpartner_id', 'package_id', 'package_amount', 'month', 'inventory', 'total_amount', 'discount_amount', 'final_amount', 'status', 'created_by', 'modified_by'], 'integer'],
            [['projects_id', 'package_id', 'package_amount', 'discount_amount', 'final_amount', 'created_by', 'created_on', 'modified_by', 'modified_on'], 'required'],
            [['note'], 'string'],
            [['created_on', 'modified_on'], 'safe'],
            [['order_code'], 'string', 'max' => 20],
            [['projects_id'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'order_id' => 'Order ID',
            'order_code' => 'Order Code',
            'builder_id' => 'Builder ID',
            'channelpartner_id' => 'Channelpartner ID',
            'projects_id' => 'Projects ID',
            'package_id' => 'Package ID',
            'package_amount' => 'Package Amount',
            'month' => 'Month',
            'inventory' => 'Inventory',
            'total_amount' => 'Total Amount',
            'discount_amount' => 'Discount Amount',
            'final_amount' => 'Final Amount',
            'note' => 'Note',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
        ];
    }
}
