<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "report_offers".
 *
 * @property int $id
 * @property int $offer_id
 * @property int $sm_cp_id
 * @property int $cp_id
 * @property int $click_type 1-offer click,2-connect request,3-call sm
 * @property string $created_on
 */
class ReportOffers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'report_offers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sm_cp_id', 'cp_id'], 'required'],
            [['offer_id', 'sm_cp_id', 'cp_id', 'click_type'], 'integer'],
            [['created_on', 'project_id'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'offer_id' => 'Offer ID',
            'sm_cp_id' => 'Sm Cp ID',
            'cp_id' => 'Cp ID',
            'click_type' => 'Click Type',
            'created_on' => 'Created On',
            'project_id' => 'Project',
        ];
    }
}
