<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "report_projects".
 *
 * @property int $id
 * @property int $project_id
 * @property int $sm_cp_id
 * @property int $cp_id
 * @property string|null $created_on
 * @property int $click_type 1-click on website
 */
class ReportProjects extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'report_projects';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['project_id', 'sm_cp_id', 'cp_id'], 'required'],
            [['project_id', 'sm_cp_id', 'cp_id', 'click_type'], 'integer'],
            [['created_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'project_id' => 'Project ID',
            'sm_cp_id' => 'Sm Cp ID',
            'cp_id' => 'Cp ID',
            'created_on' => 'Created On',
            'click_type' => 'Click Type',
        ];
    }
}
