<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "taggingmaster".
 *
 * @property int $id
 * @property int $cp_id
 * @property int $project_id
 * @property string $tag_name
 * @property string $tag_email
 * @property string $tag_phone
 * @property int $sm_cp_id
 * @property int $budget
 * @property string|null $appointment_date
 * @property string|null $appointment_time
 * @property int $status 1=>visited,2=>not visited,3=>clash,4=>lead converted,5=>lead dead,6=>lead registered,7=>lead rejected
 * @property int|null $flat_type_id 1->1BHK,2->1.5BHK,3->2BHK,4->2.5BHK,5->3BHK
 * @property int $is_accepted 1 - accepted
 0 - not-accepted
 * @property string|null $visit_notvisit_clash_date
 * @property string|null $lead_convert_date
 * @property string|null $lead_dead_date
 * @property string|null $lead_registered_date
 * @property string|null $feedback
 * @property int $created_by
 * @property string $created_on
 * @property int $modified_by
 * @property string $modified_on
 * @property int $created_from 1->mobile app, 2-> crm
 * @property int|null $lead_id
 * @property string $tagging_id
 * @property int $is_deleted 1->deleted
 * @property string|null $deleted_on
 * @property int|null $deleted_by
 * @property int retag_limit
 * @property string|null $tag_code
 * @property int is_deleted
 * @property int visited_by
 * @property int booked_by
 * @property int registered_by
 * @property int is_cancelled
 * @property int cancelled_by
 * @property string $cancelled_on
 */
class Taggingmaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'taggingmaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cp_id', 'project_id', 'sm_cp_id', 'appointment_date', 'appointment_time', 'created_by', 'lead_id'], 'required'],
            [['cp_id', 'project_id', 'customer_type', 'sm_cp_id', 'budget', 'status', 'flat_type_id', 'is_accepted', 'created_by', 'modified_by', 'created_from', 'lead_id', 'is_deleted', 'visited_by', 'booked_by', 'registered_by', 'is_cancelled', 'cancelled_by'], 'integer'],
            [['appointment_date', 'appointment_time', 'visit_notvisit_clash_date', 'lead_convert_date', 'lead_dead_date', 'lead_registered_date', 'created_on', 'modified_on', 'retag_limit', 'tag_code', 'cancelled_on'], 'safe'],
            [['feedback', 'tag_code'], 'string'],
            [['tag_name', 'tag_email'], 'string', 'max' => 300],
            [['tag_phone'], 'string', 'max' => 15],
            [['tagging_id'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'tagging_id' => 'Tagging ID',
            'cp_id' => 'Cp ID',
            'project_id' => 'Project ID',
            'tag_name' => 'Tag Name',
            'tag_email' => 'Tag Email',
            'tag_phone' => 'Tag Phone',
            'sm_cp_id' => 'Sm Cp ID',
            'budget' => 'Budget',
            'appointment_date' => 'Appointment Date',
            'appointment_time' => 'Appointment Time',
            'status' => 'Status',
            'flat_type_id' => 'Flat Type ID',
            'is_accepted' => 'Is Accepted',
            'visit_notvisit_clash_date' => 'Visit Notvisit Clash Date',
            'lead_convert_date' => 'Lead Convert Date',
            'lead_dead_date' => 'Lead Dead Date',
            'lead_registered_date' => 'Lead Registered Date',
            'feedback' => 'Feedback',
            'customer_type' => 'Customer Type',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
            'created_from' => 'Created From',
            'lead_id' => 'Lead ID',
            'retag_limit' => 'ReTag Limit',
            'tag_code' => 'Tag Code',
            'is_deleted' => 'Deleted',
            'visitedBy' => 'Visited By',
            'bookedBy' => 'Booked By',
            'registeredBy' => 'Registered By',
            'is_cancelled' => 'Is Cancelled',
            'cancelled_by' => 'Cancelled By',
            'cancelled_on' => 'Cancelled On'
        ];
    }
}