<?php

namespace app\modules\api\controllers;

use app\models\Admin;
use app\models\Channelpartner;
use app\models\Location;
use app\models\LocationSubtype;
use app\models\LogError;
use app\models\SmCp;
use DateTime;
use Exception;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;

/**
 * Default controller for the `api` module
 */
class ChannelpartnerController extends Controller
{
    public $company_type = array('1' => 'Sole Proprietorship', '2' => 'Partnership', '3' => 'Private Limited', '4' => 'Public Limited', '5' => 'Individual');
    public $nature_business = array('1' => 'Residential Sales', '2' => 'Commercial Sales', '3' => 'Land sourcing for Developers', '4' => 'Agricultural Land Sales', '5' => 'Industrial Sales', '6' => 'Project Consultancy');
    public $status = array('1' => 'Active', '0' => 'Inactive', '2' => 'Pending');

    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'getbyrera' => ['GET'],
                        'createcp' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['getbyrera', 'createcp'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    /**
     * Renders the index view for the module
     * @return string
     */
    public function actionGetbyrera()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $get_rera = (!empty($_REQUEST['rera_no']) ? trim($_REQUEST['rera_no']) : '');

        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;
        $get_loc_data = Location::find()->select('id, name')->where(['status' => 1])->asArray()->all();
        if (!empty($get_rera)) {

            $location_arr = Location::findAll([
                'status' => 1
            ]);
            foreach ($location_arr as $location_arr_val) {
                $locations[$location_arr_val->id] = $location_arr_val->name;
            }

            $get_cp_data = Channelpartner::find()->select('id, name,email_id,contact,company_name,address,company_type,location_id,rera_number,pan_number,website,status')->where(['rera_number' => $get_rera])->andWhere(['in', 'status', [0, 1, 2]])->one();
            $get_cp = null;
            if (!empty($get_cp_data)) {
                $get_cp = $get_cp_data->toArray();
            }
            /* echo "<pre>";
            print_r($get_cp);
            exit; */

            if (!empty($get_cp)) {

                $get_data = null;
                $get_data = $get_cp;
                $get_data['company_type'] = $this->company_type[$get_cp['company_type']];
                //$get_data['status'] = $this->status[$get_cp['status']];
                $get_data['contact'] = (!empty($get_cp['contact'])) ? substr($get_cp['contact'], 0, 6) . '****' : '';
                if ($get_cp['status'] == 1) {
                    //get team leader details
                    $get_leader_data = SmCp::findOne([
                        'channelpartner_id' => $get_cp['id'],
                        'status' => 1,
                        'role' => 1
                    ]);
                    $get_leader = null;
                    if (!empty($get_leader_data)) {
                        $get_leader = $get_leader_data->toArray();
                        $get_data['team'] = 'Yes';
                        $get_data['leader_name'] = $get_leader['name'];
                        $get_data['leader_contact'] = substr($get_leader['contact'], 0, 6) . '****';

                        $data['success']['cpStatus'] = 2;
                        $data['success']['code'] = 'CP_REGISTERED_ACTIVE_LOGIN';
                        $data['success']['message'] = str_replace("%", $get_data['leader_contact'], \Yii::$app->params['CP_REGISTERED_ACTIVE_LOGIN_message']);
                    } else {
                        /* //create an smcp account
                        $smcp_model = new SmCp();
                        $formsmcpdata['SmCp'] = null;
                        $formsmcpdata['SmCp']['channelpartner_id'] = $get_cp['id'];
                        $formsmcpdata['SmCp']['name'] = $get_cp['name'];
                        $formsmcpdata['SmCp']['email'] = $get_cp['email_id'];
                        $formsmcpdata['SmCp']['contact'] = $get_cp['contact'];
                        $formsmcpdata['SmCp']['role'] = 1;
                        $formsmcpdata['SmCp']['status'] = 1;
                        $formsmcpdata['SmCp']['created_on'] = date('Y-m-d H:i:s');
                        $formsmcpdata['SmCp']['modified_on'] = date('Y-m-d H:i:s');
                        if ($smcp_model->load($formsmcpdata)) {
                            if ($smcp_model->save()) {
                            } else {
                                $formerrordata['post_data'] = "error while searching rera and saving new sm_cp " . json_encode($formsmcpdata);
                                $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                Yii::$app->common->addlog($formerrordata);
                            }
                        } else {
                            $formerrordata['post_data'] = "error while searching rera and loading new sm_cp " . json_encode($formsmcpdata);
                            $formerrordata['error'] = json_encode($smcp_model->getErrors());
                            Yii::$app->common->addlog($formerrordata);
                        }

                        $data['success']['cpStatus'] = 2;
                        $data['success']['code'] = 'CP_REGISTERED_ACTIVE_LOGIN';
                        $data['success']['message'] = str_replace("%", $get_data['contact'], \Yii::$app->params['CP_REGISTERED_ACTIVE_LOGIN_message']); */

                        $data['success']['cpStatus'] = 3;
                        $data['success']['code'] = 'CP_REGISTERED_PENDING';
                        $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_PENDING_message'];
                    }
                } else if ($get_cp['status'] == 2) {
                    $data['success']['cpStatus'] = 3;
                    $data['success']['code'] = 'CP_REGISTERED_PENDING';
                    $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_PENDING_message'];
                } else {
                    $data['success']['cpStatus'] = 4;
                    $data['success']['code'] = 'CP_DEACTIVATED';
                    $data['success']['message'] = \Yii::$app->params['CP_DEACTIVATED_message'];
                }
            } else {
                $data['success']['cpStatus'] = 1;
                $data['success']['code'] = 'CP_NOT_REGISTERED';
                $data['success']['message'] = str_replace("%", $get_rera, \Yii::$app->params['CP_NOT_REGISTERED_message']);
                //return json_encode($error);
            }
        } else {
            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
            $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            //$this->header('HTTP/1.1 400: BAD REQUEST');
            //return json_encode($error);
        }
        $data['data']['location'] = $get_loc_data;
        return $data;
    }

    public function actionCreatecp()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $location_arr = Location::findAll([
            'status' => 1
        ]);
        foreach ($location_arr as $location_arr_val) {
            $locations[$location_arr_val->id] = $location_arr_val->name;
        }

        $location_subtype_arr = LocationSubtype::findAll([
            'status' => 1
        ]);
        foreach ($location_subtype_arr as $location_subtype_arr_val) {
            $location_subtype[$location_subtype_arr_val->id] = $location_subtype_arr_val->name;
        }

        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;
        $formdata['Channelpartner'] = null;
        try {
            if (!empty($this->request->post())) {
                $formdata['Channelpartner'] = $this->request->post();
                if (
                    empty($formdata['Channelpartner']['rera_number']) ||
                    empty($formdata['Channelpartner']['name']) ||
                    empty($formdata['Channelpartner']['pan_number']) ||
                    empty($formdata['Channelpartner']['contact']) ||
                    empty($formdata['Channelpartner']['company_name']) ||
                    empty($formdata['Channelpartner']['address'])
                ) {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                } else {
                    $get_rera = $formdata['Channelpartner']['rera_number'];
                    $get_contact = $formdata['Channelpartner']['contact'];
                    $get_cp_data = Channelpartner::find()->select('id')->where(['rera_number' => $get_rera])->andWhere(['in', 'status', [0, 1, 2]])->orWhere(['contact' => $get_contact])->one();

                    if (!empty($get_cp_data)) {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['CP_ALREADY_EXIST_code'];
                        $error_data['message'] = str_replace("%", $get_rera, \Yii::$app->params['CP_ALREADY_EXIST_message']);
                        $error_data['message'] = str_replace("&", $get_contact, $error_data['message']);
                        //$error['error'] = $error_data;
                        $data['error'] = $error_data;
                    } else {
                        $formdata['Channelpartner']['cp_code'] = substr($formdata['Channelpartner']['company_name'], 0, 5) . time();
                        $get_loc_id = !empty($formdata['Channelpartner']['location_id']) ? $formdata['Channelpartner']['location_id'] : '';
                        $final_loc_id = '';
                        if (!empty($get_loc_id)) {
                            //$final_loc_id = implode(",", $get_loc_id);
                            $get_loc_id = trim($get_loc_id, ",");
                            $final_loc_id = $get_loc_id;
                        }
                        $get_loc_subtype_id = !empty($formdata['Channelpartner']['location_subtype_id']) ? $formdata['Channelpartner']['location_subtype_id'] : '';
                        $final_loc_subtype_id = '';
                        if (!empty($get_loc_subtype_id)) {
                            $get_loc_subtype_id = trim($get_loc_subtype_id, ",");
                            $final_loc_subtype_id = $get_loc_subtype_id;
                        } else {
                            if (!empty($final_loc_id)) {
                                $locData = (new \yii\db\Query())
                                    ->select('DISTINCT(subtype_id) as getsub')
                                    ->from('location')
                                    ->where('id IN(' . $final_loc_id . ') AND subtype_id IS NOT NULL')->createCommand()
                                    ->queryAll();
                                if (!empty($locData)) {
                                    $count = 0;
                                    foreach ($locData as $locData_k => $locData_v) {
                                        $locsub[] = $locData_v['getsub'];
                                    }
                                    if (!empty($locsub)) {
                                        $final_loc_subtype_id = implode(",", $locsub);
                                    }
                                }
                            }
                        }
                        $formdata['Channelpartner']['location_id'] = $final_loc_id;
                        $formdata['Channelpartner']['location_subtype_id'] = $final_loc_subtype_id;
                        $formdata['Channelpartner']['status'] = 2; //status in pending
                        $formdata['Channelpartner']['crm'] = 2;
                        $formdata['Channelpartner']['added_by'] = 2; //added from app
                        $formdata['Channelpartner']['created_on'] = date('Y-m-d H:i:s');
                        $formdata['Channelpartner']['modified_on'] = date('Y-m-d H:i:s');

                        $channelpartner_model = new Channelpartner();
                        if ($channelpartner_model->load($formdata)) {
                            if ($channelpartner_model->save()) {
                                //add team leader details here
                                $cp_id = $channelpartner_model->id;

                                $smcp_model = new SmCp();
                                $formsmcpdata['SmCp'] = null;
                                $formsmcpdata['SmCp']['channelpartner_id'] = $cp_id;
                                $formsmcpdata['SmCp']['name'] = $formdata['Channelpartner']['name'];
                                $formsmcpdata['SmCp']['email'] = !empty($formdata['Channelpartner']['email_id']) ? $formdata['Channelpartner']['email_id'] : "";
                                $formsmcpdata['SmCp']['contact'] = $formdata['Channelpartner']['contact'];
                                $formsmcpdata['SmCp']['location_id'] = $final_loc_id;
                                $formsmcpdata['SmCp']['location_subtype_id'] = $final_loc_subtype_id;
                                $formsmcpdata['SmCp']['role'] = 1;
                                $formsmcpdata['SmCp']['status'] = 1;
                                $formsmcpdata['SmCp']['created_on'] = date('Y-m-d H:i:s');
                                $formsmcpdata['SmCp']['modified_on'] = date('Y-m-d H:i:s');

                                //add package of complimentary

                                //add complimentary package for all by default with 1 month validity
                                /* $formsmcpdata['SmCp']['package_id'] = 5;

                                $final_date = new DateTime(); // today
                                $final_date->modify('+2 months');
                                $mobile_expiry_date = $final_date->format('Y-m-d');

                                $formsmcpdata['SmCp']['mobile_view_expiry'] = $mobile_expiry_date; */

                                $formsmcpdata['SmCp']['package_id'] = 4;
                                $formsmcpdata['SmCp']['mobile_view_expiry'] = null;


                                if ($smcp_model->load($formsmcpdata)) {
                                    if ($smcp_model->save()) {
                                        $sm_cp_id = $smcp_model->sm_cp_id;
                                        //add details in snse_admin table
                                        $admin_model = new Admin();
                                        $formadmindata['Admin'] = null;
                                        $formadmindata['Admin']['sm_cp_id'] = $sm_cp_id;
                                        $formadmindata['Admin']['username'] = $formsmcpdata['SmCp']['email'];
                                        $formadmindata['Admin']['password'] = md5($formsmcpdata['SmCp']['name'] . "@123");
                                        $formadmindata['Admin']['email'] = !empty($formsmcpdata['SmCp']['email']) ? $formsmcpdata['SmCp']['email'] : "";
                                        $formadmindata['Admin']['role'] = 1;
                                        $formadmindata['Admin']['create_at'] = date('Y-m-d H:i:s');
                                        $formadmindata['Admin']['status'] = 1;

                                        if ($admin_model->load($formadmindata)) {
                                            if ($admin_model->save()) {
                                                //registration successful
                                                $final_data = null;
                                                $final_data['Channelpartner'] = $channelpartner_model->toArray();
                                                if (!empty($final_data['Channelpartner']['location_id'])) {
                                                    $get_loc_set = explode(",", $final_data['Channelpartner']['location_id']);
                                                    $loc_final_val = '';
                                                    foreach ($get_loc_set as $get_loc_set_val) {
                                                        if (empty($loc_final_val)) {
                                                            $loc_final_val = $locations[$get_loc_set_val];
                                                        } else {
                                                            $loc_final_val .= ", " . $locations[$get_loc_set_val];
                                                        }
                                                    }
                                                    $final_data['Channelpartner']['location_id'] = $loc_final_val;
                                                }
                                                if (!empty($final_data['Channelpartner']['location_subtype_id'])) {
                                                    $get_loc_subtype_set = explode(",", $final_data['Channelpartner']['location_subtype_id']);
                                                    $loc_subtype_final_val = '';
                                                    foreach ($get_loc_subtype_set as $get_loc_subtype_set_val) {
                                                        if (empty($loc_subtype_final_val)) {
                                                            $loc_subtype_final_val = $location_subtype[$get_loc_subtype_set_val];
                                                        } else {
                                                            $loc_subtype_final_val .= ", " . $location_subtype[$get_loc_subtype_set_val];
                                                        }
                                                    }
                                                    $final_data['Channelpartner']['location_subtype_id'] = $loc_subtype_final_val;
                                                }
                                                if (!empty($final_data['Channelpartner']['company_type'])) {
                                                    $final_data['Channelpartner']['company_type'] = $this->company_type[$final_data['Channelpartner']['company_type']];
                                                }
                                                if (!empty($final_data['Channelpartner']['nature_business'])) {
                                                    $final_data['Channelpartner']['nature_business'] = $this->nature_business[$final_data['Channelpartner']['nature_business']];
                                                }
                                                $final_data['Channelpartner']['status'] = 'Pending';

                                                $final_data['Leader'] = $smcp_model->toArray();
                                                $final_data['Leader']['role'] = 'Team Lead';
                                                unset($final_data['Channelpartner']['crm'], $final_data['Channelpartner']['added_by'], $final_data['Channelpartner']['cp_code']);
                                                $data['data'] = $final_data;
                                                $data['success']['code'] = 'CP_REGISTERED_SUCCESSFULLY';
                                                $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_SUCCESSFULLY_message'];
                                            } else {
                                                $formerrordata['post_data'] = "error while saving data in snse_admin " . json_encode($formadmindata);
                                                $formerrordata['error'] = json_encode($admin_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $formerrordata['post_data'] = "error while loading data in snse_admin " . json_encode($formadmindata);
                                            $formerrordata['error'] = json_encode($admin_model->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $formerrordata['post_data'] = "error while saving data in sm_cp " . json_encode($formsmcpdata);
                                        $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        Yii::$app->response->statusCode = 500;
                                    }
                                } else {
                                    $formerrordata['post_data'] = "error while loading data in sm_cp " . json_encode($formsmcpdata);
                                    $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            } else {
                                $formerrordata['post_data'] = "error while saving data in channelpartner " . json_encode($formdata);
                                $formerrordata['error'] = json_encode($channelpartner_model->getErrors());
                                Yii::$app->common->addlog($formerrordata);

                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                Yii::$app->response->statusCode = 500;
                            }
                        } else {
                            $formerrordata['post_data'] = "error while loading data in channelpartner " . json_encode($formdata);
                            $formerrordata['error'] = json_encode($channelpartner_model->getErrors());
                            Yii::$app->common->addlog($formerrordata);

                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            Yii::$app->response->statusCode = 500;
                        }
                    }
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while posting data in channelpartner " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while posting data in channelpartner " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while posting data in channelpartner " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while posting data in channelpartner " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}
