<?php

namespace app\modules\api\controllers;


use app\models\Location;

use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class LocationController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'list' => ['GET'],
                        'locationlist' => ['GET'],
                        'subtypelist' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['list', 'subtypelist', 'locationlist'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }




    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;

        $querydata = $this->request->get();
        $where_txt = "l.status=1";
        if (!empty($querydata['active'])) {
            $where_txt .= " AND l.id IN(select distinct(location_id) as dlid from projects where status=2)";
        }
        if (!empty($querydata['location_subtype_id'])) {
            $subtype_id = trim($querydata['location_subtype_id'], ",");
            $where_txt .= " AND l.subtype_id IN(" . $subtype_id . ")";
        }

        $locData = (new \yii\db\Query())
            ->select('l.id,l.name')
            ->from('location l')
            ->where($where_txt)
            ->orderBy('l.name ASC')
            ->createCommand()
            ->queryAll();
        $get_loc_data = null;
        if (!empty($locData)) {
            $s_count = 0;
            foreach ($locData as $locData_val) {
                $get_loc_data[$s_count]['id'] = $locData_val['id'];
                $get_loc_data[$s_count]['name'] = $locData_val['name'];
                $s_count++;
            }
        }


        //$get_loc_data = Location::find()->select('id, name')->where(['status' => 1])->asArray()->all();
        /*  echo "<pre>";
        print_r($get_loc_data);
        exit; */

        if (!empty($get_loc_data)) {
            $data['data']['location'] = $get_loc_data;
            $data['success']['code'] = 'LOCATION_LISTED_SUCCESSFULLY';
            $data['success']['message'] = \Yii::$app->params['LOCATION_LISTED_SUCCESSFULLY_message'];
        } else {
            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['LOCATION_NOT_FOUND_code'];
            $error_data['message'] = \Yii::$app->params['LOCATION_NOT_FOUND_message'];
            //$error['error'] = $error_data;
            $data['error'] = $error_data;
            //return json_encode($error);
        }
        return $data;
    }

    public function actionLocationlist()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;

        $where_sub_txt = "l.status=1";
        $querydata = $this->request->get();
        if (!empty($querydata['location_subtype_id'])) {
            $getsubtype_id = trim($querydata['location_subtype_id'], ",");
            $where_sub_txt .= " AND l.id IN(" . $getsubtype_id . ")";
        }

        $sublocData = (new \yii\db\Query())
            ->select('l.id,l.name')
            ->from('location_subtype l')
            ->where($where_sub_txt)
            ->orderBy('l.name ASC')
            ->createCommand()
            ->queryAll();
        $get_loc_sub_data = null;
        if (!empty($sublocData)) {
            $s_count = 0;
            foreach ($sublocData as $sublocData_val) {
                $get_loc_sub_data[$s_count]['id'] = $sublocData_val['id'];
                $get_loc_sub_data[$s_count]['name'] = $sublocData_val['name'];
                $subtype_id = $sublocData_val['id'];
                $where_txt = "l.status=1 AND l.subtype_id='" . $subtype_id . "'";
                if (!empty($querydata['active'])) {
                    $where_txt .= " AND l.id IN(select distinct(location_id) as dlid from projects where status=2)";
                }

                $locData = (new \yii\db\Query())
                    ->select('l.id,l.name,l.subtype_id')
                    ->from('location l')
                    ->where($where_txt)
                    ->orderBy('l.name ASC')
                    ->createCommand()
                    ->queryAll();
                $get_loc_data = null;
                if (!empty($locData)) {
                    $l_count = 0;
                    foreach ($locData as $locData_val) {
                        $get_loc_data[$l_count]['id'] = $locData_val['id'];
                        $get_loc_data[$l_count]['name'] = $locData_val['name'];
                        //$get_loc_data[$locData_val['id']]['name'] = $locData_val['name'];
                        $l_count++;
                    }
                }
                $get_loc_sub_data[$s_count]['locations'] = $get_loc_data;


                $s_count++;
            }
        }




        //$get_loc_data = Location::find()->select('id, name')->where(['status' => 1])->asArray()->all();
        /*  echo "<pre>";
        print_r($get_loc_data);
        exit; */

        if (!empty($get_loc_sub_data)) {
            $data['data']['sublocation'] = $get_loc_sub_data;
            $data['success']['code'] = 'LOCATION_LISTED_SUCCESSFULLY';
            $data['success']['message'] = \Yii::$app->params['LOCATION_LISTED_SUCCESSFULLY_message'];
        } else {
            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['LOCATION_NOT_FOUND_code'];
            $error_data['message'] = \Yii::$app->params['LOCATION_NOT_FOUND_message'];
            //$error['error'] = $error_data;
            $data['error'] = $error_data;
            //return json_encode($error);
        }
        return $data;
    }

    public function actionSubtypelist()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;

        $querydata = $this->request->get();
        $where_txt = "l.status=1";


        $locData = (new \yii\db\Query())
            ->select('l.id,l.name')
            ->from('location_subtype l')
            ->where($where_txt)
            ->orderBy('l.name ASC')
            ->createCommand()
            ->queryAll();
        $get_loc_data = null;
        if (!empty($locData)) {
            $s_count = 0;
            foreach ($locData as $locData_val) {
                $get_loc_data[$s_count]['id'] = $locData_val['id'];
                $get_loc_data[$s_count]['name'] = $locData_val['name'];
                $s_count++;
            }
        }


        //$get_loc_data = Location::find()->select('id, name')->where(['status' => 1])->asArray()->all();
        /*  echo "<pre>";
        print_r($get_loc_data);
        exit; */

        if (!empty($get_loc_data)) {
            $data['data']['location'] = $get_loc_data;
            $data['success']['code'] = 'LOCATION_SUBTYPE_LISTED_SUCCESSFULLY';
            $data['success']['message'] = \Yii::$app->params['LOCATION_SUBTYPE_LISTED_SUCCESSFULLY'];
        } else {
            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['LOCATION_NOT_FOUND_code'];
            $error_data['message'] = \Yii::$app->params['LOCATION_NOT_FOUND_message'];
            //$error['error'] = $error_data;
            $data['error'] = $error_data;
            //return json_encode($error);
        }
        return $data;
    }
}
