<?php

namespace app\modules\api\controllers;

use app\models\Channelpartner;
use app\models\Common;
use app\models\LeadFeedback;
use app\models\Leadmaster;
use app\models\Location;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class LeadController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'create' => ['POST'],
                        'detail' => ['GET'],
                        'stats' => ['GET'],
                        'monthly' => ['GET'],
                        'list' => ['GET'],
                        'listname' => ['GET'],
                        'update' => ['PUT'],
                        'delete' => ['DELETE'],
                        'feedback' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['create', 'detail', 'stats', 'list', 'update', 'delete', 'listname', 'feedback', 'monthly'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }

    public function actionDetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                //check if project exist
                $lead_data = Leadmaster::find()->where(['id' => $id, 'is_deleted' => 0])->one();
                if (!empty($lead_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;

                        $common_model = new Common();
                        //check if cp has access to lead
                        $check_access = $common_model->checkcpleadaccess($sm_cp_id, $id);
                        if ($check_access && !empty($cp_id)) {
                            $data['success']['code'] = 'LEAD_DETAIL_SUCCESSFUL';
                            $data['success']['message'] = \Yii::$app->params['LEAD_DETAIL_SUCCESSFUL'];
                            $get_lead_details = $common_model->getleadapi($id, $lead_data, 1);
                            $data['data'] = $get_lead_details;
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'LEAD_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['LEAD_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting lead detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionFeedback($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                //check if project exist
                $lead_data = Leadmaster::find()->where(['id' => $id, 'is_deleted' => 0])->one();
                if (!empty($lead_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;

                        $common_model = new Common();
                        //check if cp has access to lead
                        $check_access = $common_model->checkcpleadaccess($sm_cp_id, $id);
                        if ($check_access && !empty($cp_id)) {
                            $data['success']['code'] = 'FEEDBACK_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['FEEDBACK_DISPLAYED_SUCCESSFULLY'];
                            $get_feedback_details = $common_model->getfeedbackapi($id, 2);
                            $data['data'] = $get_feedback_details;
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'LEAD_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['LEAD_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead feedback";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead feedback";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead feedback";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting lead feedback";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionStats()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;


                if (!empty($cp_id)) {
                    $common_model = new Common();

                    $data['success']['code'] = 'LEAD_STATS_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['LEAD_STATS_DISPLAYED_SUCCESSFULLY'];
                    $get_lead_stats = $common_model->getleadstatsapi($sm_cp_id, $cp_id);
                    $data['data'] = $get_lead_stats;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting lead stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMonthly()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();
                $tag_year = date('Y');
                if (!empty($querydata)) {

                    $tag_year = (!empty($querydata['year']) ? trim($querydata['year']) : date('Y'));
                }
                if ($tag_year > date('Y') || $tag_year < 2023) {
                    $data['status'] = 2;
                    $error_data['code'] = 'INVALID_YEAR';
                    $error_data['message'] = \Yii::$app->params['INVALID_YEAR'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                } else {

                    $data['success']['code'] = 'LEAD_STATS_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['LEAD_STATS_DISPLAYED_SUCCESSFULLY'];

                    $get_lead_list = $common_model->getleadstatsmonthlyapi($get_user, $querydata);
                    $data['data'] = $get_lead_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            $common_model = new Common();

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($cp_id)) {

                    $where_sql = 'is_deleted=0 ';
                    $where_sql .= ' AND cp_id="' . $cp_id . '"';
                    //$where_sql .= ' AND DATE(created_on)>="' . date('Y-m-01') . '"';


                    $lead_query = (new \yii\db\Query())
                        ->select('id')
                        ->from('leadmaster')
                        ->where($where_sql);
                    $lead_count = $lead_query->count();

                    //get cp lead stats
                    $cp_model = Channelpartner::find()->where(['id' => $cp_id])->one();

                    //get credit count
                    $members = $common_model->getsmcpteam($cp_id, 1);
                    $members_txt = implode(",", $members);

                    /* $ref_query = (new \yii\db\Query())
                        ->select('cp_refer.id')
                        ->from('cp_refer')
                        ->where("sm_cp_id IN(" . $members_txt . ") AND status=2");
                    $ref_count = $ref_query->count(); */
                    $ref_count = 0;

                    $lead_per_credit = 5;
                    $credit_leads = $lead_per_credit * $ref_count;
                    $allowed_leads = intval($cp_model->credits);
                    $total_allowed_leads = $allowed_leads + $credit_leads;
                    $balance_leads = $total_allowed_leads - $lead_count;


                    if ($balance_leads > 0) {
                        //if ($lead_count < intval(\Yii::$app->params['LEAD_PER_CP_MAX'])) {


                        if (!empty($this->request->post())) {
                            $formdata['Leadmaster'] = $this->request->post();
                            if (
                                empty($formdata['Leadmaster']['name']) ||
                                empty($formdata['Leadmaster']['contact']) ||
                                empty($formdata['Leadmaster']['budget']) ||
                                empty($formdata['Leadmaster']['followup_date'])
                            ) {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                $data['error'] = $error_data;
                            } else if ($formdata['Leadmaster']['followup_date'] < date('Y-m-d')) {
                                $data['status'] = 2;
                                $error_data['code'] = 'FOLLOWUP_DATE_AFTER_TODAY';
                                $error_data['message'] = \Yii::$app->params['FOLLOWUP_DATE_AFTER_TODAY'];
                                $data['error'] = $error_data;
                            } else {
                                if (empty($formdata['Leadmaster']['status'])) {
                                    $formdata['Leadmaster']['status'] = 1;
                                }
                                if (!empty($formdata['Leadmaster']['followup_time'])) {
                                    $formdata['Leadmaster']['notify'] = 0;
                                }
                                $formdata['Leadmaster']['created_by'] = $sm_cp_id;
                                $formdata['Leadmaster']['cp_id'] = $cp_id;
                                $formdata['Leadmaster']['created_on'] = date('Y-m-d H:i:s');
                                $formdata['Leadmaster']['modified_by'] = $sm_cp_id;
                                $formdata['Leadmaster']['modified_on'] = date('Y-m-d H:i:s');
                                //$formdata['Leadmaster']['lead_id'] = "L".date('d').date('m').date('y');
                                if (!empty($formdata['Leadmaster']['location_id'])) {
                                    $formdata['Leadmaster']['location_id'] = trim($formdata['Leadmaster']['location_id'], ",");
                                }

                                //check entries of that contact
                                $sql_check = "SELECT id FROM leadmaster WHERE contact='" . $formdata['Leadmaster']['contact'] . "' AND name='" . $formdata['Leadmaster']['name'] . "' AND cp_id='" . $cp_id . "' AND is_deleted=0 ";
                                $user_count = Leadmaster::findBySql($sql_check)->count();
                                if ($user_count == 0) {
                                    $lead_model = new Leadmaster();
                                    if ($lead_model->load($formdata)) {
                                        if ($lead_model->save()) {

                                            $l_id = $lead_model->id;
                                            //update lead id and get lead details
                                            $lead_model->lead_id = "L" . date('d') . date('m') . date('y') . $l_id;
                                            $lead_model->save();

                                            if (!empty($formdata['Leadmaster']['feedback'])) {
                                                //Add entry in feedback table
                                                $lead_feedback_model = new LeadFeedback();
                                                $lead_feedback_model->lead_id = $l_id;
                                                $lead_feedback_model->feedback = $formdata['Leadmaster']['feedback'];
                                                $lead_feedback_model->created_on = date('Y-m-d H:i:s');
                                                $lead_feedback_model->created_by = $sm_cp_id;
                                                $lead_feedback_model->save();
                                            }



                                            $data['success']['code'] = 'LEAD_CREATED_SUCCESSFULLY';
                                            $data['success']['message'] = \Yii::$app->params['LEAD_CREATED_SUCCESSFULLY'];

                                            $get_lead = $common_model->getleadapi($l_id, $lead_model, 1);
                                            $data['data'] = $get_lead;
                                        } else {

                                            $formerrordata['post_data'] = "error while adding data in leadmaster " . json_encode($formdata);
                                            $formerrordata['error'] = json_encode($lead_model->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $formerrordata['post_data'] = "error while loading data in leadmaster " . json_encode($formdata);
                                        $formerrordata['error'] = json_encode($lead_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        Yii::$app->response->statusCode = 500;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = 'LEAD_ALREADY_EXIST';
                                    $error_data['message'] = str_replace("%", $formdata['Leadmaster']['contact'], \Yii::$app->params['LEAD_ALREADY_EXIST']);
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                            $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'LEAD_CP_EXCEEDED';
                        $error_data['message'] = \Yii::$app->params['LEAD_CP_EXCEEDED'];
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating lead";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating lead";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating lead";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating lead";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionUpdate($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;

                if (!empty($cp_id)) {

                    if (!empty($id)) {

                        //check if member has access over the lead
                        $get_access_smcp = $common_model->checkcpleadaccess($sm_cp_id, $id);
                        if (!$get_access_smcp) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                        //check if lead is not tagged.
                        $update_lead_model = Leadmaster::findOne(['id' => $id, 'is_deleted' => 0]);
                        if (!empty($update_lead_model)) {
                            //lead can be updated even if tagged
                            /* if ($update_lead_model->tagging == 1) {
                            $data['status'] = 2;
                            $error_data['code'] = 'LEAD_ALREADY_TAGGED';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['LEAD_ALREADY_TAGGED']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        } */
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'LEAD_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['LEAD_NOT_EXIST']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                        $update_success = false;
                    }

                    if ($update_success) {
                        if (!empty($this->request->post())) {
                            $formdata['Leadmaster'] = $this->request->post();
                            if (
                                empty($formdata['Leadmaster'])
                            ) {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                $data['error'] = $error_data;
                            } else if (!empty($formdata['Leadmaster']['followup_date']) && $formdata['Leadmaster']['followup_date'] < date('Y-m-d')) {
                                $data['status'] = 2;
                                $error_data['code'] = 'FOLLOWUP_DATE_AFTER_TODAY';
                                $error_data['message'] = \Yii::$app->params['FOLLOWUP_DATE_AFTER_TODAY'];
                                $data['error'] = $error_data;
                            } else {

                                $formdata['Leadmaster']['modified_on'] = date('Y-m-d H:i:s');
                                $formdata['Leadmaster']['modified_by'] = $get_user->sm_cp_id;

                                if (!empty($formdata['Leadmaster']['contact']) && !empty($formdata['Leadmaster']['name'])) {
                                    //check if lead already exist
                                    $sql_check = "SELECT id FROM leadmaster WHERE contact='" . $formdata['Leadmaster']['contact'] . "' AND name='" . $formdata['Leadmaster']['name'] . "' AND cp_id='" . $cp_id . "' AND id!='" . $id . "' AND is_deleted=0 ";
                                    $lead_count = Leadmaster::findBySql($sql_check)->count();
                                    if ($lead_count != 0) {
                                        $data['status'] = 2;
                                        $error_data['code'] = 'LEAD_ALREADY_EXIST';
                                        $error_data['message'] = str_replace("%", $formdata['Leadmaster']['contact'], \Yii::$app->params['LEAD_ALREADY_EXIST']);
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        $update_success = false;
                                    }
                                }

                                if ($update_success) {

                                    foreach ($formdata['Leadmaster'] as $formdata_key => $formdata_val) {
                                        if (in_array($formdata_key, ['name', 'contact', 'email', 'flat_type_id', 'budget', 'customer_type', 'followup_date', 'followup_time', 'feedback', 'carpet', 'location_id', 'flat_property_type', 'lead_type', 'status'])) {
                                            $update_lead_model->$formdata_key = $formdata_val;
                                        }
                                    }
                                    if (!empty($formdata['Leadmaster']['followup_time'])) {
                                        $update_lead_model->notify = 0;
                                    }
                                    if (!empty($formdata['Leadmaster']['location_id'])) {
                                        $update_lead_model->location_id = trim($formdata['Leadmaster']['location_id'], ",");
                                    }
                                    if ($update_lead_model->save()) {

                                        if (!empty($formdata['Leadmaster']['feedback'])) {
                                            //Add entry in feedback table
                                            $lead_feedback_model = new LeadFeedback();
                                            $lead_feedback_model->lead_id = $id;
                                            $lead_feedback_model->feedback = $formdata['Leadmaster']['feedback'];
                                            $lead_feedback_model->created_on = date('Y-m-d H:i:s');
                                            $lead_feedback_model->created_by = $sm_cp_id;
                                            $lead_feedback_model->save();
                                        }

                                        $data['success']['code'] = 'LEAD_UPDATED_SUCCESSFULLY';
                                        $data['success']['message'] = \Yii::$app->params['LEAD_UPDATED_SUCCESSFULLY'];
                                        $get_lead = $common_model->getleadshortapi($id, $update_lead_model, 1);
                                        $data['data'] = $get_lead;
                                    } else {
                                        $formerrordata['post_data'] = "error while updating lead " . json_encode($formdata);
                                        $formerrordata['error'] = json_encode($update_lead_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        Yii::$app->response->statusCode = 500;
                                    }
                                }
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                            $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDelete($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($cp_id)) {

                    $update_success = true;
                    if (!empty($id)) {

                        //check if member has access over the lead
                        $get_access_smcp = $common_model->checkcpleadaccess($sm_cp_id, $id);
                        if (!$get_access_smcp) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                        //check if lead is not tagged.
                        $update_lead_model = Leadmaster::findOne(['id' => $id, 'is_deleted' => 0]);
                        if (empty($update_lead_model)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'LEAD_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['LEAD_NOT_EXIST']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                        $update_success = false;
                    }

                    if ($update_success) {

                        if ($update_lead_model->delete()) {
                            //delete feedback
                            $del_feed_data = LeadFeedback::deleteAll(['lead_id' => $id]);
                            $data['success']['code'] = 'LEAD_DELETED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['LEAD_DELETED_SUCCESSFULLY'];
                        } else {
                            $formerrordata['post_data'] = "error while deleting lead " . json_encode($formdata);
                            $formerrordata['error'] = json_encode($update_lead_model->getErrors());
                            Yii::$app->common->addlog($formerrordata);

                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            Yii::$app->response->statusCode = 500;
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while deleting lead " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (empty($get_user_data['sm_cp_data'])) {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            } else {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($cp_id)) {

                    $common_model = new Common();
                    /* $querydata = $this->request->get();
                unset($querydata['r']); */
                    $querydata = $this->request->get();

                    $data['success']['code'] = 'LEADS_LISTED_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['LEADS_LISTED_SUCCESSFULY'];

                    $get_lead_list = $common_model->getleadlistapi($get_user, $querydata);
                    $data['data'] = $get_lead_list;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListname()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($cp_id)) {

                    $common_model = new Common();
                    /* $querydata = $this->request->get();
                unset($querydata['r']); */
                    $querydata = $this->request->get();

                    $data['success']['code'] = 'LEADS_LISTED_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['LEADS_LISTED_SUCCESSFULY'];

                    $get_lead_list = $common_model->getleadlistapi($get_user, $querydata, 1);
                    $data['data'] = $get_lead_list;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting lead list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}