<?php

namespace app\modules\api\controllers;

use app\models\Channelpartner;
use app\models\Common;
use app\models\CpRefer;
use app\models\SmCp;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class ReferController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'list' => ['GET'],
                        'create' => ['POST'],
                        'detail' => ['GET'],
                        'updatestatus' => ['PUT'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['list', 'create', 'detail', 'updatestatus'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            $common_model = new Common();

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $apk_type = !empty($get_user->apk_type) ? $get_user->apk_type : 1;

                if (empty($cp_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    if (!empty($this->request->post())) {
                        $formdata['CpRefer'] = $this->request->post();
                        if (
                            empty($formdata['CpRefer']['rera_no']) ||
                            empty($formdata['CpRefer']['contact'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {

                            $stop_ref = true;
                            $cpbyrera = false;
                            $cpbycontact = false;
                            $cp_model = Channelpartner::findOne(['rera_number' => trim($formdata['CpRefer']['rera_no'])]);
                            if (!empty($cp_model)) {
                                $sm_model = SmCp::findOne(['channelpartner_id' => $cp_model->id]);
                                if (!empty($sm_model)) {
                                    $stop_ref = true;
                                    $cpbyrera = true;
                                } else {
                                    $stop_ref = false;
                                }
                            } else {
                                $sm_model = SmCp::findOne(['contact' => trim($formdata['CpRefer']['contact'])]);
                                if (!empty($sm_model)) {
                                    $stop_ref = true;
                                    $cpbycontact = true;
                                } else {
                                    $stop_ref = false;
                                }
                                //$stop_ref = false;
                            }

                            if ($stop_ref) {
                                $data['status'] = 2;
                                $error_data['code'] = 'CP_ALREADY_EXIST';
                                if ($cpbyrera) {
                                    $error_data['message'] = str_replace("%", $formdata['CpRefer']['rera_no'], \Yii::$app->params['CP_ALREADY_EXIST_message_rera']);
                                }
                                if ($cpbycontact) {
                                    $error_data['message'] = str_replace("%", $formdata['CpRefer']['contact'], \Yii::$app->params['CP_ALREADY_EXIST_message_contact']);
                                }
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            } else {

                                //check if already referal exist
                                $cpcheck_model = CpRefer::findOne(['contact' => trim($formdata['CpRefer']['contact']), 'status' => 1]);
                                if (empty($cpcheck_model)) {

                                    $formdata['CpRefer']['sm_cp_id'] = $sm_cp_id;
                                    $formdata['CpRefer']['status'] = 1;
                                    $formdata['CpRefer']['created_on'] = date('Y-m-d H:i:s');
                                    $formdata['CpRefer']['modified_on'] = date('Y-m-d H:i:s');
                                    $formdata['CpRefer']['expired_on'] = date('Y-m-d H:i:s', strtotime('+30 days'));

                                    $refer_model = new CpRefer();

                                    //check if already same referral is in progress
                                    $sql_check_exist = "SELECT id FROM cp_refer WHERE rera_no='" . $formdata['CpRefer']['rera_no'] . "' AND sm_cp_id='" . $sm_cp_id . "' ";
                                    $user_count_check = CpRefer::findBySql($sql_check_exist)->count();

                                    if ($user_count_check == 0) {

                                        if ($refer_model->load($formdata)) {

                                            if ($refer_model->save()) {

                                                $refer_id = $refer_model->id;


                                                $data['success']['code'] = 'REFERAL_CREATED_SUCCESSFULLY';
                                                $data['success']['message'] = \Yii::$app->params['REFERAL_CREATED_SUCCESSFULLY'];

                                                $get_refer = $common_model->getreferapi($refer_id, $refer_model, $apk_type);
                                                $get_refer['refer']['hoursLeft'] = 47;
                                                $get_refer['refer']['daysLeft'] = 30;
                                                $data['data'] = $get_refer;
                                            } else {

                                                $formerrordata['post_data'] = "error while adding data in cp refer " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($refer_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $formerrordata['post_data'] = "error while loading data in cp refer " . json_encode($formdata);
                                            $formerrordata['error'] = json_encode($refer_model->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = 'REFERAL_ALREADY_EXIST';
                                        $error_data['message'] = \Yii::$app->params['REFERAL_ALREADY_EXIST'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = 'REFERAL_ALREADY_EXIST';
                                    $error_data['message'] = \Yii::$app->params['REFERAL_ALREADY_EXIST'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating Referral";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating Referral";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating Referral";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating Referral";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                $refer_data = CpRefer::find()->where('id="' . $id . '" ')->one();
                if (!empty($refer_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;
                        $apk_type = !empty($get_user->apk_type) ? $get_user->apk_type : 1;

                        if (empty($cp_id)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            //$update_success = false;
                        } else {

                            $common_model = new Common();
                            //check if cp has access to refer
                            $check_access = $common_model->checkreferaccess($sm_cp_id, $id);

                            if ($check_access) {
                                $data['success']['code'] = 'REFERAL_DETAIL_DISPLAYED_SUCCESSFULLY';
                                $data['success']['message'] = \Yii::$app->params['REFERAL_DETAIL_DISPLAYED_SUCCESSFULLY'];
                                $get_refer_details = $common_model->getreferapi($id, $refer_data, $apk_type);
                                $data['data'] = $get_refer_details;
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'REFERAL_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['REFERAL_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting referal detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting referal detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting referal detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting referal detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionUpdatestatus($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['CpRefer'] = null;
        $refer_status = array('1' => 'In Progress', '2' => 'Credited', '3' => 'Expired');
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $apk_type = !empty($get_user->apk_type) ? $get_user->apk_type : 1;

                $update_success = true;
                if (!empty($id)) {

                    $refer_data = CpRefer::find()->where('id="' . $id . '" ')->one();
                    if (!empty($refer_data)) {

                        if (empty($cp_id)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        } else if ($refer_data->ref_count >= 3) {
                            $data['status'] = 2;
                            $error_data['code'] = 'REREFERRAL_LIMIT_EXHAUSTED';
                            $error_data['message'] = \Yii::$app->params['REREFERRAL_LIMIT_EXHAUSTED'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        } else {

                            $common_model = new Common();
                            //check if cp has access to refer
                            $check_access = $common_model->checkreferaccess($sm_cp_id, $id);

                            if ($check_access) {

                                if (!empty($this->request->post())) {
                                    $formdata['CpRefer'] = $this->request->post();
                                    if (!empty($formdata['CpRefer']['status'])) {
                                        $rec_status = $formdata['CpRefer']['status'];
                                        $exis_status = $refer_data->status;
                                        if ($rec_status == $exis_status) {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'REFERRAL_STATUS_SAME';
                                            $error_data['message'] = \Yii::$app->params['REFERRAL_STATUS_SAME'];
                                            $data['error'] = $error_data;
                                            $update_success = false;
                                        } else if ($rec_status != 1 || in_array($exis_status, [1, 2])) {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'INCORRECT_REFERRAL_STATUS';
                                            $error_data['message'] = \Yii::$app->params['INCORRECT_REFERRAL_STATUS'];
                                            $data['error'] = $error_data;
                                            $update_success = false;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                        $data['error'] = $error_data;
                                        $update_success = false;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    $update_success = false;
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                $update_success = false;
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'REFERAL_NOT_EXIST';
                        $error_data['message'] = str_replace("%", $id, \Yii::$app->params['REFERAL_NOT_EXIST']);
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $update_success = false;
                }

                if ($update_success) {

                    $formdata['CpRefer']['modified_on'] = date('Y-m-d H:i:s');

                    $refer_data->status = $formdata['CpRefer']['status'];
                    $refer_data->expired_on = date('Y-m-d H:i:s', strtotime('+2 days'));

                    $get_old_count = $refer_data->ref_count;
                    $new_count = $get_old_count + 1;
                    $refer_data->ref_count = $new_count;

                    if ($refer_data->save()) {

                        $data['success']['code'] = 'REFERRAL_UPDATED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['REFERRAL_UPDATED_SUCCESSFULLY'];

                        $get_refer_details = $common_model->getreferapi($id, $refer_data, $apk_type);
                        $get_refer_details['refer']['hoursLeft'] = 47;
                        $data['data'] = $get_refer_details;
                    } else {
                        $formerrordata['post_data'] = "error while updating referral " . json_encode($formdata);
                        $formerrordata['error'] = json_encode($refer_data->getErrors());
                        Yii::$app->common->addlog($formerrordata);

                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        Yii::$app->response->statusCode = 500;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update referral " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update referral " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update referral " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update referral " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }






    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (empty($cp_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    $common_model = new Common();
                    /* $querydata = $this->request->get();
                unset($querydata['r']); */
                    $querydata = $this->request->get();

                    $data['success']['code'] = 'REFERAL_LIST_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['REFERAL_LIST_DISPLAYED_SUCCESSFULLY'];
                    //$get_proj = $this->getprojofmultism($get_sm);
                    $get_ref_list = $common_model->getreflistapi($get_user, $querydata);
                    $data['data'] = $get_ref_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting referal list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting referal list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting referal list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting referal list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}
