<?php

namespace app\modules\api\controllers;

use app\models\Builder;
use app\models\Channelpartner;
use app\models\Common;
use app\models\Location;
use app\models\LogError;
use app\models\SmCp;
use app\models\SmCpOtp;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class UserController extends Controller
{
    public $role = array('1' => 'Team Lead', '2' => 'Manager', '3' => 'Executive');
    public $status = array('1' => 'Active', '2' => 'Pending', '0' => 'InActive');
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'verifycontact' => ['POST'],
                        'otprequest' => ['POST'],
                        'verifyotp' => ['POST'],
                        'logout' => ['POST'],
                        'userconfig' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['verifycontact', 'otprequest', 'verifyotp', 'logout', 'userconfig'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionVerifycontact()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';
            $apk_check = false; //change to true when app is in playstore
            $get_apk_type = !empty($formdata['apk_type']) ? trim($formdata['apk_type']) : '';
            $get_apk_version = !empty($formdata['apk_version']) ? trim($formdata['apk_version']) : '';
            $apk_matching = true;
            if ($apk_check) {
                if ($get_apk_type == 1) {
                    if (\Yii::$app->params['latest_android_version'] != trim($get_apk_version)) {
                        $apk_matching = false;
                    }
                } else if ($get_apk_type == 2) {
                    if (\Yii::$app->params['latest_ios_version'] != trim($get_apk_version)) {
                        $apk_matching = false;
                    }
                }
            }

            if ($apk_matching) {
                if (!empty($get_contact)) {


                    //for cp
                    $query = SmCp::find()
                        ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.builder_id,b.status AS bstatus,sm_cp.staff_type,cp.app_features,cp.mgmt')
                        ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                        ->leftJoin("builder as b", 'sm_cp.builder_id = b.id')
                        ->where(['sm_cp.contact' => $get_contact, 'sm_cp.is_deleted' => 0]);
                    $get_data = $query->asArray()->all();
                    $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                    if (!empty($get_smcp_data)) {
                        $data['user_type'] = "1";
                        if (!empty($get_smcp_data['channelpartner_id']) && $get_smcp_data['cpstatus'] == 1) {
                            $data['user_type'] = "1";
                            if ($get_smcp_data['mgmt'] == 1) {
                                $data['cpConnectFeatureEnable'] = false;
                                $data['showSubscription'] = false;
                            } else {
                                if ($get_smcp_data['app_features'] == 1) {
                                    $data['cpConnectFeatureEnable'] = true;
                                    $data['showSubscription'] = true;
                                } else {
                                    $data['cpConnectFeatureEnable'] = false;
                                    $data['showSubscription'] = false;
                                }
                            }
                        } else if (!empty($get_smcp_data['builder_id']) && $get_smcp_data['bstatus'] == 1) {
                            $data['cpConnectFeatureEnable'] = false;
                            $data['showSubscription'] = false;
                            if ($get_smcp_data['staff_type'] == 1) {
                                $data['user_type'] = "2";
                            } else {
                                $data['user_type'] = "3";
                            }
                        }

                        if ($data['user_type'] == "1") {
                            if ($get_smcp_data['smcpstatus'] == 1) {
                                if ($get_smcp_data['cpstatus'] == 1) {
                                    $data['success']['cpStatus'] = 2;
                                    $data['success']['code'] = 'CP_REGISTERED_ACTIVE';
                                    $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_ACTIVE'];
                                } else if ($get_smcp_data['cpstatus'] == 2) {
                                    $data['success']['cpStatus'] = 3;
                                    $data['success']['code'] = 'CP_REGISTERED_PENDING';
                                    $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_PENDING_message'];
                                } else {
                                    $data['success']['cpStatus'] = 4;
                                    $data['success']['code'] = 'CP_DEACTIVATED';
                                    $data['success']['message'] = \Yii::$app->params['CP_DEACTIVATED_message'];
                                }
                            } else {
                                $data['success']['cpStatus'] = 4;
                                $data['success']['code'] = 'CP_DEACTIVATED';
                                $data['success']['message'] = \Yii::$app->params['CP_DEACTIVATED_message'];
                            }
                        } else {
                            if ($get_smcp_data['smcpstatus'] == 1) {
                                if ($get_smcp_data['bstatus'] == 1) {
                                    $data['success']['cpStatus'] = 2;
                                    $data['success']['code'] = 'SM_REGISTERED_ACTIVE';
                                    $data['success']['message'] = \Yii::$app->params['SM_REGISTERED_ACTIVE'];
                                } else {
                                    $data['success']['cpStatus'] = 3;
                                    $data['success']['code'] = 'SM_DEACTIVATED';
                                    $data['success']['message'] = \Yii::$app->params['SM_DEACTIVATED'];
                                }
                            } else {
                                $data['success']['cpStatus'] = 3;
                                $data['success']['code'] = 'SM_DEACTIVATED';
                                $data['success']['message'] = \Yii::$app->params['SM_DEACTIVATED'];
                            }
                        }
                    } else {
                        $data['success']['cpStatus'] = 1;
                        $data['success']['code'] = 'CP_UNREGISTERED';
                        $data['success']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_UNREGISTERED']);
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$this->header('HTTP/1.1 400: BAD REQUEST');
                    //return json_encode($error);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = 'UPDATE_APK';
                $error_data['message'] = \Yii::$app->params['UPDATE_APK'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }

        return $data;
    }

    public function actionOtprequest()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';
            //$get_user_type = !empty($formdata['user_type']) ? trim($formdata['user_type']) : '1';

            if (!empty($get_contact)) {

                $query = SmCp::find()
                    ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.builder_id,b.status AS bstatus,cp.rera_number,sm_cp.is_test,sm_cp.staff_type')
                    ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                    ->leftJoin("builder as b", 'sm_cp.builder_id = b.id')
                    ->where(['sm_cp.contact' => $get_contact, 'sm_cp.is_deleted' => 0]);
                $get_data = $query->asArray()->all();
                $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];
                $send_otp = false;
                if (!empty($get_smcp_data)) {
                    if (!empty($get_smcp_data['channelpartner_id']) && $get_smcp_data['cpstatus'] == 1 && $get_smcp_data['smcpstatus'] == 1) {
                        $send_otp = true;
                    } else if (!empty($get_smcp_data['builder_id']) && $get_smcp_data['bstatus'] == 1 && $get_smcp_data['smcpstatus'] == 1) {
                        $send_otp = true;
                    }

                    if ($send_otp) {
                        if ($get_smcp_data['is_test'] == 1) {
                            $data['success']['code'] = 'OTP_REQUEST_SUCCESSFUL';
                            $data['success']['message'] = str_replace("%", $get_contact, \Yii::$app->params['OTP_REQUEST_SUCCESSFUL']);
                        } else {

                            //check entries of otp for that contact
                            $sql_check = "SELECT id FROM sm_cp_otp WHERE created_on between '" . date('Y-m-d 00:00:00') . "' AND '" . date('Y-m-d 23:59:59') . "' AND contact='" . $get_contact . "' ";
                            $otp_count = SmCpOtp::findBySql($sql_check)->count();

                            if ($otp_count < intval(\Yii::$app->params['OTP_MAX'])) {
                                //$send_sms = true;
                                //Don't send sms on UAT
                                $send_sms = Yii::$app->common->send_sms('otp', $get_contact);
                                if ($send_sms) {
                                    $data['success']['code'] = 'OTP_REQUEST_SUCCESSFUL';
                                    $data['success']['message'] = str_replace("%", $get_contact, \Yii::$app->params['OTP_REQUEST_SUCCESSFUL']);
                                } else {
                                    $data['status'] = 2;
                                    $data['error']['code'] = 'OTP_REQUEST_FAILED';
                                    $data['error']['message'] = \Yii::$app->params['OTP_REQUEST_FAILED'];
                                }
                            } else {
                                $data['status'] = 2;
                                $data['error']['code'] = 'OTP_SENDING_EXCEEDED';
                                $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['OTP_SENDING_EXCEEDED']);
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error']['code'] = 'OTP_REQUEST_FAILED';
                        $data['error']['message'] = \Yii::$app->params['OTP_REQUEST_FAILED'];
                    }
                } else {
                    $data['status'] = 2;
                    $data['error']['code'] = 'CP_NOT_EXIST';
                    $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
                //$this->header('HTTP/1.1 400: BAD REQUEST');
                //return json_encode($error);
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }

        return $data;
    }

    public function actionVerifyotp()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();
        $common_model = new Common();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';
            $get_type = !empty($formdata['type']) ? trim($formdata['type']) : '';
            $get_otp = !empty($formdata['otp']) ? trim($formdata['otp']) : '';
            $get_fire_token = !empty($formdata['fire_token']) ? trim($formdata['fire_token']) : '';
            //$get_user_type = !empty($formdata['user_type']) ? trim($formdata['user_type']) : '1';

            if (!empty($get_contact) && !empty($get_type) && !empty($get_otp)) {

                $query_smcpotp = SmCpOtp::find()
                    ->select('id')
                    ->where('contact="' . $get_contact . '" AND otp="' . $get_otp . '" AND expiry_at > "' . date('Y-m-d H:i:s') . '"')->orderBy('id DESC')->limit(1);

                $get_data_smcpotp = $query_smcpotp->asArray()->all();
                $get_otp_data = !empty($get_data_smcpotp[0]) ? $get_data_smcpotp[0] : [];


                $queryforcp = SmCp::find()
                    ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.builder_id,b.status AS bstatus,cp.rera_number,sm_cp.is_test,sm_cp.staff_type,cp.app_features,cp.mgmt')
                    ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                    ->leftJoin("builder as b", 'sm_cp.builder_id = b.id')
                    ->where(['sm_cp.contact' => $get_contact, 'sm_cp.is_deleted' => 0]);




                $get_dataforcp = $queryforcp->asArray()->all();
                $get_smcp_dataforcp = !empty($get_dataforcp[0]) ? $get_dataforcp[0] : [];
                /* echo "<pre>";
                print_r($get_smcp_dataforcp);
                exit; */
                if (!empty($get_smcp_dataforcp)) {

                    //code for bypass otp start
                    if ($get_smcp_dataforcp['is_test'] == 1) {
                        $get_otp_data = 1234;
                    }
                    //code for bypass otp end

                    $cpConnectFeatureEnable = false;
                    $showSubscription = false;


                    if (!empty($get_smcp_dataforcp['channelpartner_id']) && $get_smcp_dataforcp['cpstatus'] == 1 && $get_smcp_dataforcp['smcpstatus'] == 1) {
                        $user_type = "1";
                        if ($get_smcp_dataforcp['mgmt'] == 1) {
                            $cpConnectFeatureEnable = false;
                            $showSubscription = false;
                        } else {
                            if ($get_smcp_dataforcp['app_features'] == 1) {
                                $cpConnectFeatureEnable = true;
                                $showSubscription = true;
                            }
                        }
                    } else if (!empty($get_smcp_dataforcp['builder_id']) && $get_smcp_dataforcp['bstatus'] == 1 && $get_smcp_dataforcp['smcpstatus'] == 1) {
                        if ($get_smcp_dataforcp['staff_type'] == 1) {
                            $user_type = "2";
                        } else {
                            $user_type = "3";
                        }
                    }
                }



                //$get_otp_data = 1234;
                if (!empty($get_otp_data)) {
                    if ($get_type == 2) {
                        $data['success']['code'] = 'OTP_VERIFICATION_SUCCESSFUL';
                        $data['success']['message'] = Yii::$app->params['OTP_VERIFICATION_SUCCESSFUL'];
                    } else {

                        if ($user_type == 1) {
                            $query = SmCp::find()
                                ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.name,sm_cp.email,sm_cp.contact,sm_cp.role,sm_cp.created_on,sm_cp.modified_on,sm_cp.sm_cp_id,sm_cp.package_id,sm_cp.mobile_view_expiry,sm_cp.is_test')
                                ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                                ->where(['sm_cp.contact' => $get_contact, 'is_deleted' => 0, 'sm_cp.status' => 1, 'cp.status' => 1]);
                            $get_data = $query->asArray()->all();
                            $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                            if (!empty($get_smcp_data)) {
                                if ($get_smcp_data['smcpstatus'] == 1) {
                                    if ($get_smcp_data['cpstatus'] == 1) {
                                        //active cp user


                                        //generate API key and update logged in
                                        $key_data = $get_smcp_data['sm_cp_id'] . time();
                                        $apikey = md5($key_data);

                                        if ($get_smcp_data['rera_number'] == 'jobin') {
                                            $apikey = $get_smcp_data['contact'];
                                        }

                                        $smcpmodel = SmCp::find()->where(['sm_cp_id' => $get_smcp_data['sm_cp_id'], 'is_deleted' => 0])->one();
                                        $smcpmodel->apikey = $apikey;
                                        $smcpmodel->is_logged = 1;
                                        $smcpmodel->login_at = date('Y-m-d H:i:s');
                                        $smcpmodel->fire_token = $get_fire_token;
                                        if ($smcpmodel->save()) {
                                            $data['success']['code'] = 'OTP_VERIFICATION_SUCCESSFUL';
                                            $data['success']['message'] = Yii::$app->params['OTP_VERIFICATION_SUCCESSFUL'];

                                            //get package details of cp user
                                            $package_name = "Silver";
                                            $package_expiry = null;
                                            if (!empty($get_smcp_data['mobile_view_expiry']) && $get_smcp_data['mobile_view_expiry'] != "0000-00-00") {
                                                $package_expiry = date('d M Y', strtotime($get_smcp_data['mobile_view_expiry']));
                                            }


                                            //below features list
                                            $view_posting_cp = true;
                                            //$search_exclusive_posting = false;

                                            if ($get_smcp_data['package_id'] == 6) {
                                                //no expiry for silver package
                                                $package_expiry = null;
                                            } else {

                                                $get_package_details = $common_model->getpackage($get_smcp_data['package_id']);
                                                if (!empty($get_package_details)) {
                                                    if (isset($get_package_details['name'])) {
                                                        $package_name = $get_package_details['name'];
                                                    }
                                                    if (isset($get_package_details['view_posting_cp'])) {
                                                        if ($get_package_details['view_posting_cp'] == 1) {
                                                            //$view_posting_cp = true;
                                                        }
                                                    }
                                                    /* if (isset($get_package_details['search_exclusive_posting'])) {
                                                        if ($get_package_details['search_exclusive_posting'] == 1) {
                                                            $search_exclusive_posting = true;
                                                        }
                                                    } */
                                                }
                                            }
                                            $loggedUser['subscriptionName'] = $package_name;
                                            $loggedUser['subscriptionExpiry'] = $package_expiry;
                                            $loggedUser['viewPostingCp'] = $view_posting_cp;
                                            /* $loggedUser['search_exclusive_posting'] = $search_exclusive_posting; */


                                            $loggedUser['channelpartner_id'] = $get_smcp_data['channelpartner_id'];
                                            $loggedUser['usertype'] = $user_type;
                                            $loggedUser['name'] = $get_smcp_data['name'];
                                            $loggedUser['email'] = $get_smcp_data['email'];
                                            $loggedUser['contact'] = $get_smcp_data['contact'];

                                            $loggedUser['role'] = $this->role[$get_smcp_data['role']];
                                            $loggedUser['roleId'] = $get_smcp_data['role'];
                                            $loggedUser['cpConnectFeatureEnable'] = $cpConnectFeatureEnable;
                                            $loggedUser['showSubscription'] = $showSubscription;
                                            $loggedUser['status'] = $this->status[$get_smcp_data['smcpstatus']];
                                            $loggedUser['created_on'] = $get_smcp_data['created_on'];
                                            $loggedUser['modified_on'] = $get_smcp_data['modified_on'];
                                            $loggedUser['sm_cp_id'] = $get_smcp_data['sm_cp_id'];
                                            $loggedUser['apikey'] = $apikey;
                                            $data['data']['loggedUser'] = $loggedUser;

                                            //Send sms on every login
                                            //Don't send sms on UAT
                                            if ($get_smcp_data['is_test'] != 1) {
                                                $cont_arr['cp_name'] = $get_smcp_data['name'];
                                                $send_sms = Yii::$app->common->send_sms('onboard', $get_smcp_data['contact'], $cont_arr);
                                            }

                                            if ($get_smcp_data['role'] == 1 || $get_smcp_data['role'] == 2) {
                                                //get members list
                                                $common_model = new Common();
                                                $get_members = $common_model->getmembersapi($get_smcp_data['sm_cp_id']);
                                                if (!empty($get_members)) {
                                                    $data['data']['members'] = $get_members;
                                                }
                                            }
                                        } else {
                                            $formerrordata['post_data'] = "error while updating apikey " . json_encode($get_smcp_data);
                                            $formerrordata['error'] = json_encode($smcpmodel->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $data['error']['code'] = 'CP_NOT_EXIST';
                                        $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $data['error']['code'] = 'CP_NOT_EXIST';
                                    $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                                }
                            } else {
                                $data['status'] = 2;
                                $data['error']['code'] = 'CP_NOT_EXIST';
                                $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                            }
                        } else {
                            $query = SmCp::find()
                                ->select('sm_cp.status AS smcpstatus,b.status AS bstatus,sm_cp.builder_id,sm_cp.name,sm_cp.email,sm_cp.contact,sm_cp.role,sm_cp.created_on,sm_cp.modified_on,sm_cp.sm_cp_id')
                                ->leftJoin("builder as b", 'sm_cp.builder_id = b.id')
                                ->where(['sm_cp.contact' => $get_contact, 'is_deleted' => 0, 'sm_cp.status' => 1, 'b.status' => 1]);
                            $get_data = $query->asArray()->all();
                            $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                            if (!empty($get_smcp_data)) {
                                if ($get_smcp_data['smcpstatus'] == 1) {
                                    if ($get_smcp_data['bstatus'] == 1) {
                                        //active cp user


                                        //generate API key and update logged in
                                        $key_data = $get_smcp_data['sm_cp_id'] . time();
                                        $apikey = md5($key_data);

                                        if ($get_smcp_data['builder_id'] == '100') {
                                            $apikey = $get_smcp_data['contact'];
                                        }

                                        $smcpmodel = SmCp::find()->where(['sm_cp_id' => $get_smcp_data['sm_cp_id'], 'is_deleted' => 0])->one();
                                        $smcpmodel->apikey = $apikey;
                                        $smcpmodel->is_logged = 1;
                                        $smcpmodel->login_at = date('Y-m-d H:i:s');
                                        $smcpmodel->fire_token = $get_fire_token;
                                        if ($smcpmodel->save()) {
                                            $data['success']['code'] = 'OTP_VERIFICATION_SUCCESSFUL';
                                            $data['success']['message'] = Yii::$app->params['OTP_VERIFICATION_SUCCESSFUL'];

                                            $loggedUser['builder_id'] = $get_smcp_data['builder_id'];
                                            $loggedUser['usertype'] = $user_type;
                                            $loggedUser['name'] = $get_smcp_data['name'];
                                            $loggedUser['email'] = $get_smcp_data['email'];
                                            $loggedUser['contact'] = $get_smcp_data['contact'];

                                            $loggedUser['role'] = $this->role[$get_smcp_data['role']];
                                            $loggedUser['roleId'] = $get_smcp_data['role'];

                                            $loggedUser['status'] = $this->status[$get_smcp_data['smcpstatus']];
                                            $loggedUser['created_on'] = $get_smcp_data['created_on'];
                                            $loggedUser['modified_on'] = $get_smcp_data['modified_on'];
                                            $loggedUser['sm_cp_id'] = $get_smcp_data['sm_cp_id'];
                                            $loggedUser['apikey'] = $apikey;
                                            $data['data']['loggedUser'] = $loggedUser;

                                            //Send sms on every login
                                            //Don't send sms on UAT
                                            $cont_arr['cp_name'] = $get_smcp_data['name'];
                                            $send_sms = Yii::$app->common->send_sms('onboard', $get_smcp_data['contact'], $cont_arr);


                                            if ($get_smcp_data['role'] == 1 || $get_smcp_data['role'] == 2) {
                                                //get members list
                                                $common_model = new Common();
                                                $get_members = $common_model->getmembersapi($get_smcp_data['sm_cp_id']);
                                                if (!empty($get_members)) {
                                                    $data['data']['members'] = $get_members;
                                                }
                                            }
                                        } else {
                                            $formerrordata['post_data'] = "error while updating apikey " . json_encode($get_smcp_data);
                                            $formerrordata['error'] = json_encode($smcpmodel->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $data['error']['code'] = 'SM_NOT_EXIST';
                                        $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['SM_NOT_EXIST']);
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $data['error']['code'] = 'SM_NOT_EXIST';
                                    $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['SM_NOT_EXIST']);
                                }
                            } else {
                                $data['status'] = 2;
                                $data['error']['code'] = 'SM_NOT_EXIST';
                                $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['SM_NOT_EXIST']);
                            }
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $data['error']['code'] = 'INVALID_OTP';
                    $data['error']['message'] = str_replace("%", $get_otp, \Yii::$app->params['INVALID_OTP']);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
                //$this->header('HTTP/1.1 400: BAD REQUEST');
                //return json_encode($error);
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {

            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);


            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }

        return $data;
    }

    public function actionUserconfig()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            $common_model = new Common();
            $get_contact = "";
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $get_contact = $get_user->contact;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }


            //$get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';

            if (!empty($get_contact)) {

                $queryforcp = SmCp::find()
                    ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.builder_id,b.status AS bstatus,cp.rera_number,sm_cp.is_test,sm_cp.staff_type,cp.app_features,cp.mgmt')
                    ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                    ->leftJoin("builder as b", 'sm_cp.builder_id = b.id')
                    ->where(['sm_cp.contact' => $get_contact, 'sm_cp.is_deleted' => 0]);

                $get_dataforcp = $queryforcp->asArray()->all();
                $get_smcp_dataforcp = !empty($get_dataforcp[0]) ? $get_dataforcp[0] : [];
                /* echo "<pre>";
                print_r($get_smcp_dataforcp);
                exit; */
                if (!empty($get_smcp_dataforcp)) {

                    $cpConnectFeatureEnable = false;
                    $showSubscription = false;

                    if (!empty($get_smcp_dataforcp['channelpartner_id']) && $get_smcp_dataforcp['cpstatus'] == 1 && $get_smcp_dataforcp['smcpstatus'] == 1) {
                        $user_type = "1";
                        if ($get_smcp_dataforcp['mgmt'] == 1) {
                            $cpConnectFeatureEnable = false;
                            $showSubscription = false;
                        } else {
                            if ($get_smcp_dataforcp['app_features'] == 1) {
                                $cpConnectFeatureEnable = true;
                                $showSubscription = true;
                            }
                        }
                    } else if (!empty($get_smcp_dataforcp['builder_id']) && $get_smcp_dataforcp['bstatus'] == 1 && $get_smcp_dataforcp['smcpstatus'] == 1) {
                        if ($get_smcp_dataforcp['staff_type'] == 1) {
                            $user_type = "2";
                        } else {
                            $user_type = "3";
                        }
                    }
                }




                if ($user_type == 1) {
                    $query = SmCp::find()
                        ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.name,sm_cp.email,sm_cp.contact,sm_cp.role,sm_cp.created_on,sm_cp.modified_on,sm_cp.sm_cp_id,sm_cp.apikey,sm_cp.mobile_view_expiry,sm_cp.package_id')
                        ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                        ->where(['sm_cp.contact' => $get_contact, 'is_deleted' => 0, 'sm_cp.status' => 1, 'cp.status' => 1]);
                    $get_data = $query->asArray()->all();
                    $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                    if (!empty($get_smcp_data)) {
                        if ($get_smcp_data['smcpstatus'] == 1) {
                            if ($get_smcp_data['cpstatus'] == 1) {
                                //active cp user

                                $data['success']['code'] = 'USER_CONFIG_SHARED_SUCCESSFULLY';
                                $data['success']['message'] = Yii::$app->params['USER_CONFIG_SHARED_SUCCESSFULLY'];

                                //get user package details
                                $current_package_info = null;
                                $previous_package_info = null;
                                if (!empty($get_user->package_id)) {
                                    $current_package_info['subscription_id'] = (string) $get_user->package_id;
                                    $get_package_details = $common_model->getpackage($get_user->package_id);
                                    if (!empty($get_package_details)) {
                                        if (isset($get_package_details['name'])) {
                                            $package_name = $get_package_details['name'];
                                            $current_package_info['subscription_name'] = $package_name;
                                        }
                                    }
                                    if (!empty($get_user->mobile_view_expiry) && $get_user->mobile_view_expiry != "0000-00-00") {
                                        $current_package_info['subscription_expiry'] = $get_user->mobile_view_expiry;
                                    } else {
                                        $current_package_info['subscription_expiry'] = null;
                                    }
                                }
                                if (!empty($get_user->previous_package_id)) {
                                    $previous_package_info['subscription_id'] = (string) $get_user->previous_package_id;
                                    $get_prev_package_details = $common_model->getpackage($get_user->previous_package_id);
                                    if (!empty($get_prev_package_details)) {
                                        if (isset($get_prev_package_details['name'])) {
                                            $prev_package_name = $get_prev_package_details['name'];
                                            $previous_package_info['subscription_name'] = $prev_package_name;
                                        }
                                    }
                                    if (!empty($get_user->previous_expiry) && $get_user->previous_expiry != "0000-00-00") {
                                        $previous_package_info['subscription_expiry'] = $get_user->previous_expiry;
                                    } else {
                                        $previous_package_info['subscription_expiry'] = null;
                                    }
                                }





                                //get package details of cp user
                                $package_name = "Silver";
                                $package_expiry = null;
                                if (!empty($get_smcp_data['mobile_view_expiry']) && $get_smcp_data['mobile_view_expiry'] != "0000-00-00") {
                                    $package_expiry = date('d M Y', strtotime($get_smcp_data['mobile_view_expiry']));
                                }

                                //below features list
                                $view_posting_cp = true;
                                //$search_exclusive_posting = false;

                                if ($get_smcp_data['package_id'] == 6) {
                                    //no expiry for silver package
                                    $package_expiry = null;
                                } else {

                                    $get_package_details = $common_model->getpackage($get_smcp_data['package_id']);
                                    if (!empty($get_package_details)) {
                                        if (isset($get_package_details['name'])) {
                                            $package_name = $get_package_details['name'];
                                        }
                                        if (isset($get_package_details['view_posting_cp'])) {
                                            if ($get_package_details['view_posting_cp'] == 1) {
                                                //$view_posting_cp = true;
                                            }
                                        }
                                        /* if (isset($get_package_details['search_exclusive_posting'])) {
                                                        if ($get_package_details['search_exclusive_posting'] == 1) {
                                                            $search_exclusive_posting = true;
                                                        }
                                                    } */
                                    }
                                }
                                /* $loggedUser['subscriptionName'] = $package_name;
                                $loggedUser['subscriptionExpiry'] = $package_expiry; */
                                $loggedUser['viewPostingCp'] = $view_posting_cp;
                                /* $loggedUser['search_exclusive_posting'] = $search_exclusive_posting; */

                                $loggedUser['current_subscription'] = $current_package_info;
                                $loggedUser['previous_subscription'] = $previous_package_info;


                                $loggedUser['channelpartner_id'] = $get_smcp_data['channelpartner_id'];
                                $loggedUser['usertype'] = $user_type;
                                $loggedUser['name'] = $get_smcp_data['name'];
                                $loggedUser['email'] = $get_smcp_data['email'];
                                $loggedUser['contact'] = $get_smcp_data['contact'];

                                $loggedUser['role'] = $this->role[$get_smcp_data['role']];
                                $loggedUser['roleId'] = $get_smcp_data['role'];
                                $loggedUser['cpConnectFeatureEnable'] = $cpConnectFeatureEnable;
                                $loggedUser['showSubscription'] = $showSubscription;
                                $loggedUser['status'] = $this->status[$get_smcp_data['smcpstatus']];
                                $loggedUser['created_on'] = $get_smcp_data['created_on'];
                                $loggedUser['modified_on'] = $get_smcp_data['modified_on'];
                                $loggedUser['sm_cp_id'] = $get_smcp_data['sm_cp_id'];
                                $loggedUser['apikey'] = $get_smcp_data['apikey'];
                                $data['data']['loggedUser'] = $loggedUser;
                            } else {
                                $data['status'] = 2;
                                $data['error']['code'] = 'CP_NOT_EXIST';
                                $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                            }
                        } else {
                            $data['status'] = 2;
                            $data['error']['code'] = 'CP_NOT_EXIST';
                            $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error']['code'] = 'CP_NOT_EXIST';
                        $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                    }

                    /* //For testing sms
                    $cont_arr['cp_name'] = "James";
                    $send_sms = Yii::$app->common->send_sms('onboard', "8898180250", $cont_arr); */
                } else {
                    $query = SmCp::find()
                        ->select('sm_cp.status AS smcpstatus,b.status AS bstatus,sm_cp.builder_id,sm_cp.name,sm_cp.email,sm_cp.contact,sm_cp.role,sm_cp.created_on,sm_cp.modified_on,sm_cp.sm_cp_id,sm_cp.apikey')
                        ->leftJoin("builder as b", 'sm_cp.builder_id = b.id')
                        ->where(['sm_cp.contact' => $get_contact, 'is_deleted' => 0, 'sm_cp.status' => 1, 'b.status' => 1]);
                    $get_data = $query->asArray()->all();
                    $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                    if (!empty($get_smcp_data)) {
                        if ($get_smcp_data['smcpstatus'] == 1) {
                            if ($get_smcp_data['bstatus'] == 1) {
                                //active cp user



                                $data['success']['code'] = 'USER_CONFIG_SHARED_SUCCESSFULLY';
                                $data['success']['message'] = Yii::$app->params['USER_CONFIG_SHARED_SUCCESSFULLY'];

                                $loggedUser['builder_id'] = $get_smcp_data['builder_id'];
                                $loggedUser['usertype'] = $user_type;
                                $loggedUser['name'] = $get_smcp_data['name'];
                                $loggedUser['email'] = $get_smcp_data['email'];
                                $loggedUser['contact'] = $get_smcp_data['contact'];

                                $loggedUser['role'] = $this->role[$get_smcp_data['role']];
                                $loggedUser['roleId'] = $get_smcp_data['role'];

                                $loggedUser['status'] = $this->status[$get_smcp_data['smcpstatus']];
                                $loggedUser['created_on'] = $get_smcp_data['created_on'];
                                $loggedUser['modified_on'] = $get_smcp_data['modified_on'];
                                $loggedUser['sm_cp_id'] = $get_smcp_data['sm_cp_id'];
                                $loggedUser['apikey'] = $get_smcp_data['apikey'];
                                $data['data']['loggedUser'] = $loggedUser;
                            } else {
                                $data['status'] = 2;
                                $data['error']['code'] = 'SM_NOT_EXIST';
                                $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['SM_NOT_EXIST']);
                            }
                        } else {
                            $data['status'] = 2;
                            $data['error']['code'] = 'SM_NOT_EXIST';
                            $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['SM_NOT_EXIST']);
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error']['code'] = 'SM_NOT_EXIST';
                        $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['SM_NOT_EXIST']);
                    }
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
                //$this->header('HTTP/1.1 400: BAD REQUEST');
                //return json_encode($error);
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {

            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);


            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }

        return $data;
    }

    public function actionLogout()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $headers = $this->request->headers;
        $apikey = '';
        if (!empty($headers)) {
            $apikey = $headers->get('apikey');
        }

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $get_user->apikey = null;
                $get_user->fire_token = null;
                $get_user->is_logged = 0;
                $get_user->logout_at = date('Y-m-d H:i:s');
                if ($get_user->save()) {
                    $data['success']['code'] = 'LOGOUT_SUCCESSFUL';
                    $data['success']['message'] = \Yii::$app->params['LOGOUT_SUCCESSFUL'];
                } else {
                    $formerrordata['post_data'] = "error while updating logout " . json_encode($this->request->headers);
                    $formerrordata['error'] = json_encode($get_user->getErrors());
                    Yii::$app->common->addlog($formerrordata);

                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }

        return $data;
    }
}
