<?php

namespace app\modules\api\controllers;

use app\models\Admin;
use app\models\Channelpartner;
use app\models\Common;
use app\models\Location;
use app\models\NotificationList;
use app\models\PackageEnquiry;
use app\models\SmCp;
use app\models\SmCpNetwork;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class SmcpController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'create' => ['POST'],
                        'update' => ['PUT'],
                        'list' => ['GET'],
                        'profile' => ['GET'],
                        'member' => ['GET'],
                        'manager' => ['GET'],
                        'listname' => ['GET'],
                        'delete' => ['DELETE'],
                        'listnotification' => ['GET'],
                        'listnotificationproject' => ['GET'],
                        'getnotification' => ['GET'],
                        'getnotificationcount' => ['GET'],
                        'readnotification' => ['POST'],
                        'listnetwork' => ['GET'],
                        'listnetworkname' => ['GET'],
                        'listapprovals' => ['GET'],
                        'updatenetwork' => ['PUT'],
                        'listpackage' => ['GET'],
                        'enquirypackage' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['create', 'update', 'list', 'profile', 'member', 'manager', 'listname', 'delete', 'listnotification', 'getnotification', 'readnotification', 'listnetwork', 'listnetworkname', 'listapprovals', 'updatenetwork', 'getnotificationcount', 'listnotificationproject', 'listpackage', 'enquirypackage'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionUpdate($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $builder_id = $get_user->builder_id;
                $update_success = true;

                if (!empty($id) && in_array($get_user->role, [1, 2])) {

                    //check if member has access over the smcp
                    $get_access_smcp = $common_model->getaccessmembers($sm_cp_id);
                    if (empty($get_access_smcp) || empty($cp_id)) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    } else {
                        if (!empty($get_access_smcp) && !in_array($id, $get_access_smcp)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    }
                }

                if ($update_success) {
                    if (!empty($this->request->post())) {
                        $formdata['SmCp'] = $this->request->post();
                        if (
                            empty($formdata['SmCp'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = 'REQUIRED_PARAMS_MISSING_code';
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {

                            $formdata['SmCp']['modified_on'] = date('Y-m-d H:i:s');
                            $formdata['SmCp']['modified_by'] = $get_user->sm_cp_id;


                            //if user trying to update contact check if already exist.
                            if (!empty($formdata['SmCp']['contact'])) {
                                if (!empty($id)) {
                                    $sql_check = "SELECT sm_cp_id FROM sm_cp WHERE contact='" . $formdata['SmCp']['contact'] . "' and sm_cp_id != '" . $id . "' AND is_deleted=0 ";
                                } else {
                                    $sql_check = "SELECT sm_cp_id FROM sm_cp WHERE contact='" . $formdata['SmCp']['contact'] . "' and sm_cp_id != '" . $sm_cp_id . "' AND is_deleted=0 ";
                                }
                                $user_count = SmCp::findBySql($sql_check)->count();
                                if ($user_count != 0) {
                                    $update_success = false;
                                    $data['status'] = 2;
                                    $error_data['code'] = 'MEMBER_ALREADY_EXIST';
                                    $error_data['message'] = str_replace("%", $formdata['SmCp']['contact'], \Yii::$app->params['MEMBER_ALREADY_EXIST']);
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }

                            if (!empty($id)) {
                                $update_smcp_model = SmCp::findOne(['sm_cp_id' => $id, 'is_deleted' => 0]);
                            } else {
                                $update_smcp_model = SmCp::findOne(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0]);
                            }

                            if (!empty($formdata['SmCp']['parent_id'])) {
                                if (!empty($formdata['SmCp']['role'])) {
                                    $get_user_role = $formdata['SmCp']['role'];
                                } else {
                                    $get_user_role = $update_smcp_model->role;
                                }
                                $getparent_smcp_model = SmCp::findOne(['sm_cp_id' => $formdata['SmCp']['parent_id'], 'is_deleted' => 0]);
                                if ((intval($get_user_role) <= intval($getparent_smcp_model->role)) || intval($getparent_smcp_model->role) == 3) {
                                    //unset($formdata['SmCp']['parent_id']);
                                    $update_success = false;
                                    $data['status'] = 2;
                                    $error_data['code'] = 'PARENT_ROLE_LESS';
                                    $error_data['message'] = \Yii::$app->params['PARENT_ROLE_LESS'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }


                            if ($update_success) {


                                if (!empty($id)) {
                                    /* if (!empty($formdata['SmCp']['role'])) {
                                        if (intval($get_user->role) >= intval($formdata['SmCp']['role'])) {
                                            unset($formdata['SmCp']['role']);
                                            if (!empty($formdata['SmCp']['parent_id'])) {
                                                unset($formdata['SmCp']['parent_id']);
                                            }
                                        }
                                    } */
                                    if (!empty($formdata['SmCp']['parent_id'])) {
                                        if (!empty($formdata['SmCp']['role'])) {
                                            $get_user_role = $formdata['SmCp']['role'];
                                        } else {
                                            $get_user_role = $update_smcp_model->role;
                                        }
                                        $getparent_smcp_model = SmCp::findOne(['sm_cp_id' => $formdata['SmCp']['parent_id'], 'is_deleted' => 0]);
                                        if (intval($get_user_role) < intval($getparent_smcp_model->role)) {
                                            unset($formdata['SmCp']['parent_id']);
                                        }
                                    }
                                } else {
                                    if (!empty($formdata['SmCp']['role'])) {
                                        unset($formdata['SmCp']['role']);
                                    }
                                    if (!empty($formdata['SmCp']['parent_id'])) {
                                        unset($formdata['SmCp']['parent_id']);
                                    }
                                }

                                if (!empty($id)) {
                                    foreach ($formdata['SmCp'] as $formdata_key => $formdata_val) {
                                        if (in_array($formdata_key, ['name', 'email', 'contact', 'role', 'parent_id'])) {
                                            $update_smcp_model->$formdata_key = $formdata_val;
                                        }
                                    }
                                } else {
                                    foreach ($formdata['SmCp'] as $formdata_key => $formdata_val) {
                                        if (in_array($formdata_key, ['email', 'contact'])) {
                                            $update_smcp_model->$formdata_key = $formdata_val;
                                        }
                                    }
                                }
                                //all can update preferred locations
                                $get_loc_id = !empty($formdata['SmCp']['location_id']) ? $formdata['SmCp']['location_id'] : '';
                                if (!empty($get_loc_id)) {
                                    $get_loc_id = trim($get_loc_id, ",");
                                    $update_smcp_model->location_id = $get_loc_id;
                                }
                                $get_loc_subtype_id = !empty($formdata['SmCp']['location_subtype_id']) ? $formdata['SmCp']['location_subtype_id'] : '';
                                if (!empty($get_loc_subtype_id)) {
                                    $get_loc_subtype_id = trim($get_loc_subtype_id, ",");
                                    $update_smcp_model->location_subtype_id = $get_loc_subtype_id;
                                }
                                if ($update_smcp_model->save()) {
                                    if (!empty($update_smcp_model->channelpartner_id)) {
                                        $update_cp_model = Channelpartner::findOne(['id' => $cp_id]);
                                        if ($update_smcp_model->role == 1) {
                                            //If team leader updates his name or contact or email then it should be updated in CP table also.
                                            if (
                                                !empty($formdata['SmCp']['name']) ||
                                                !empty($formdata['SmCp']['contact']) ||
                                                !empty($formdata['SmCp']['address']) ||
                                                !empty($formdata['SmCp']['email'])
                                            ) {
                                                //update in channel partner table

                                                if (!empty($formdata['SmCp']['name'])) {
                                                    $update_cp_model->name = $formdata['SmCp']['name'];
                                                }
                                                if (!empty($formdata['SmCp']['contact'])) {
                                                    $update_cp_model->contact = $formdata['SmCp']['contact'];
                                                }
                                                if (!empty($formdata['SmCp']['email'])) {
                                                    $update_cp_model->email_id = $formdata['SmCp']['email'];
                                                }

                                                if (!empty($formdata['SmCp']['address'])) {
                                                    $update_cp_model->address = $formdata['SmCp']['address'];
                                                }

                                                /* //team leader can update preferred locations
                                                $get_loc_id = !empty($formdata['SmCp']['location_id']) ? $formdata['SmCp']['location_id'] : '';
                                                if (!empty($get_loc_id)) {
                                                    $get_loc_id = trim($get_loc_id, ",");
                                                    $update_cp_model->location_id = $get_loc_id;
                                                } */


                                                $update_cp_model->save();
                                            }
                                        }


                                        if (!empty($update_smcp_model->location_id) && !empty($update_cp_model->location_id)) {

                                            // Convert strings to arrays
                                            $arraysm = explode(",", $update_smcp_model->location_id);
                                            $arraycp = explode(",", $update_cp_model->location_id);

                                            // Merge the arrays
                                            $mergedArrayloc = array_merge($arraysm, $arraycp);

                                            // Remove duplicates and sort
                                            $uniquearr_loc = array_unique($mergedArrayloc);
                                            sort($uniquearr_loc);

                                            // Convert back to a string
                                            $result_loc = implode(",", $uniquearr_loc);
                                            $update_cp_model->location_id = $result_loc;
                                            $update_cp_model->save();
                                        }
                                        if (!empty($update_smcp_model->location_subtype_id) && !empty($update_cp_model->location_subtype_id)) {

                                            // Convert strings to arrays
                                            $arraysm_subtype = explode(",", $update_smcp_model->location_subtype_id);
                                            $arraycp_subtype = explode(",", $update_cp_model->location_subtype_id);

                                            // Merge the arrays
                                            $mergedArrayloc_subtype = array_merge($arraysm_subtype, $arraycp_subtype);

                                            // Remove duplicates and sort
                                            $uniquearr_loc_subtype = array_unique($mergedArrayloc_subtype);
                                            sort($uniquearr_loc_subtype);

                                            // Convert back to a string
                                            $result_loc_subtype = implode(",", $uniquearr_loc_subtype);
                                            $update_cp_model->location_subtype_id = $result_loc_subtype;
                                            $update_cp_model->save();
                                        }
                                    }

                                    if (!empty($id)) {
                                        $data['success']['code'] = 'MEMBER_UPDATED_SUCCESSFUL';
                                        $data['success']['message'] = \Yii::$app->params['MEMBER_UPDATED_SUCCESSFUL'];
                                        //get member details
                                        $get_member = $common_model->getsinglesmcpapi($id);
                                        if (!empty($get_member)) {
                                            $data['data']['member'] = $get_member;
                                        }
                                    } else {
                                        $data['success']['code'] = 'PROFILE_UPDATED_SUCCESSFUL';
                                        $data['success']['message'] = \Yii::$app->params['PROFILE_UPDATED_SUCCESSFUL'];
                                        //get member details
                                        $get_member = $common_model->getsinglesmcpapi($sm_cp_id);
                                        if (!empty($get_member)) {
                                            $data['data']['profile'] = $get_member;
                                        }
                                    }
                                } else {
                                    $formerrordata['post_data'] = "error while updating member " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($update_smcp_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDelete($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            //if (!empty($id)) {

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;

                if (!empty($id)) {
                    /* $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false; */

                    if (in_array($get_user->role, [1])) {
                        //check if member has access over the smcp
                        $get_access_smcp = $common_model->getaccessmembers($sm_cp_id);
                        if (empty($get_access_smcp) || empty($cp_id)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        } else {
                            if (!empty($get_access_smcp) && !in_array($id, $get_access_smcp)) {
                                $data['status'] = 2;
                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                $update_success = false;
                            }
                        }
                    }
                }


                if (!empty($id)) {
                    $update_smcp_model = SmCp::findOne(['sm_cp_id' => $id, 'is_deleted' => 0]);
                } else {
                    $update_smcp_model = SmCp::findOne(['sm_cp_id' => $sm_cp_id, 'is_deleted' => 0]);
                }


                //update leads and tagging of this user
                //update other users if manager or leader is deleted


                if ($update_success) {

                    if (!empty($this->request->post())) {
                        $post_data = $this->request->post();
                        $update_smcp_model->deleted_reason = !empty($post_data['deleted_reason']) ? $post_data['deleted_reason'] : '';
                    }
                    $update_smcp_model->is_deleted = 1;
                    $update_smcp_model->status = 2;

                    if ($update_smcp_model->save()) {
                        $data['success']['code'] = 'MEMBER_DELETED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['MEMBER_DELETED_SUCCESSFULLY'];
                    } else {
                        $formerrordata['post_data'] = "error while deleting member " . json_encode($formdata);
                        $formerrordata['error'] = json_encode($update_smcp_model->getErrors());
                        Yii::$app->common->addlog($formerrordata);

                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        Yii::$app->response->statusCode = 500;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
            //}
            /* else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            } */
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while delete smcp ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while delete smcp ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while delete smcp ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while delete smcp ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMember($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $get_success = true;
                if (empty($id)) {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $get_success = false;
                }
                if (!empty($id) && in_array($get_user->status, [1, 2])) {

                    //check if member has access over the smcp
                    $common_model = new Common();
                    $get_access_smcp = $common_model->getaccessmembers($sm_cp_id);
                    if (!in_array($id, $get_access_smcp)) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $get_success = false;
                    }
                }

                if ($get_success) {
                    //get member details
                    $get_member = $common_model->getsinglesmcpapi($id);
                    if (!empty($get_member)) {
                        $data['success']['code'] = 'MEMBER_DISPLAYED_SUCCESSFULY';
                        $data['success']['message'] = \Yii::$app->params['MEMBER_DISPLAYED_SUCCESSFULY'];
                        $data['data']['member'] = $get_member;
                    } else {
                        $data['status'] = 2;
                        $data['error']['code'] = 'MEMBER_NOT_EXIST';
                        $data['error']['message'] = str_replace("%", $id, \Yii::$app->params['MEMBER_NOT_EXIST']);
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionManager()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $get_success = true;

                if ($get_user->role != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $get_success = false;
                }

                if ($get_success) {
                    //get manager details
                    $get_manager = $common_model->getmanagers($get_user);
                    if (!empty($get_manager)) {
                        $data['success']['code'] = 'MANAGERS_DISPLAYED_SUCCESSFULY';
                        $data['success']['message'] = \Yii::$app->params['MANAGERS_DISPLAYED_SUCCESSFULY'];
                        $data['data']['team'] = $get_manager;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListname()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $get_success = true;

                if ($get_user->role == 3) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $get_success = false;
                }

                if ($get_success) {
                    //get manager details
                    $get_members = $common_model->getaccessmemberswithname($sm_cp_id);
                    if (!empty($get_members)) {
                        $data['success']['code'] = 'MEMBERS_DISPLAYED_SUCCESSFULY';
                        $data['success']['message'] = \Yii::$app->params['MEMBERS_DISPLAYED_SUCCESSFULY'];
                        $data['data']['members'] = $get_members;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $cp_id = $get_user->channelpartner_id;
                $common_model = new Common();
                $get_user_count = $common_model->checkmembercount($cp_id);
                if ($get_user_count < 5) {

                    if (!empty($cp_id)) {
                        if (in_array($get_user->status, [1])) {
                            if (!empty($this->request->post())) {
                                $formdata['SmCp'] = $this->request->post();
                                if (
                                    empty($formdata['SmCp']['name']) ||
                                    empty($formdata['SmCp']['contact']) ||
                                    empty($formdata['SmCp']['role'])
                                ) {
                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                    $data['error'] = $error_data;
                                } else {
                                    $formdata['SmCp']['status'] = 1;
                                    if (empty($formdata['SmCp']['parent_id'])) {
                                        $formdata['SmCp']['parent_id'] = $get_user->sm_cp_id;
                                    }
                                    /*  if ($get_user->role == 1) {
                                if ($formdata['SmCp']['role'] == 1) {
                                    $formdata['SmCp']['role'] = 2;
                                    $formdata['SmCp']['parent_id'] = $get_user->sm_cp_id;
                                }
                            } else if ($get_user->role == 2) {
                                if ($formdata['SmCp']['role'] == 1 || $formdata['SmCp']['role'] == 2) {
                                    $formdata['SmCp']['role'] = 3;
                                    $formdata['SmCp']['parent_id'] = $get_user->sm_cp_id;
                                }
                            } */
                                    if (!empty($get_user->channelpartner_id)) {
                                        $formdata['SmCp']['channelpartner_id'] = $get_user->channelpartner_id;
                                    }
                                    if (!empty($get_user->builder_id)) {
                                        $formdata['SmCp']['builder_id'] = $get_user->builder_id;
                                    }
                                    $formdata['SmCp']['created_on'] = date('Y-m-d H:i:s');
                                    $formdata['SmCp']['modified_on'] = date('Y-m-d H:i:s');
                                    //Adding location and location subtype of logged user
                                    $formdata['SmCp']['location_id'] = $get_user->location_id;
                                    $formdata['SmCp']['location_subtype_id'] = $get_user->location_subtype_id;

                                    if (!empty($get_user->channelpartner_id)) {

                                        $smcp_data = SmCp::find()->where(['channelpartner_id' => $get_user->channelpartner_id, 'role' => 1])->one();
                                        if (!empty($smcp_data)) {
                                            $get_package = $smcp_data->package_id;

                                            if (!in_array($get_package, [7, 8])) {
                                                $formdata['SmCp']['package_id'] = $get_package;
                                                if (!empty($leader_package['mobile_view_expiry'])) {
                                                    $formdata['SmCp']['mobile_view_expiry'] = $smcp_data->mobile_view_expiry;
                                                }
                                            } else {
                                                $formdata['SmCp']['package_id'] = 6;        //add silver package
                                            }
                                        }
                                    }

                                    $update_success = true;
                                    if (!empty($formdata['SmCp']['parent_id'])) {
                                        if (!empty($formdata['SmCp']['role'])) {
                                            $get_user_role = $formdata['SmCp']['role'];
                                        }
                                        $getparent_smcp_model = SmCp::findOne(['sm_cp_id' => $formdata['SmCp']['parent_id'], 'is_deleted' => 0]);
                                        if ((intval($get_user_role) <= intval($getparent_smcp_model->role)) || intval($getparent_smcp_model->role) == 3) {
                                            //unset($formdata['SmCp']['parent_id']);
                                            $update_success = false;
                                            $data['status'] = 2;
                                            $error_data['code'] = 'PARENT_ROLE_LESS';
                                            $error_data['message'] = \Yii::$app->params['PARENT_ROLE_LESS'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                        }
                                    }

                                    if ($update_success) {
                                        //check entries of that contact
                                        $sql_check = "SELECT sm_cp_id FROM sm_cp WHERE contact='" . $formdata['SmCp']['contact'] . "' AND is_deleted=0 ";
                                        $user_count = SmCp::findBySql($sql_check)->count();
                                        if ($user_count == 0) {

                                            //pending from here
                                            $smcp_model = new SmCp();
                                            if ($smcp_model->load($formdata)) {
                                                if ($smcp_model->save()) {

                                                    //save data in admin table
                                                    $sm_cp_id = $smcp_model->sm_cp_id;
                                                    //add details in snse_admin table
                                                    $admin_model = new Admin();
                                                    $formadmindata['Admin'] = null;
                                                    $formadmindata['Admin']['sm_cp_id'] = $sm_cp_id;

                                                    $getname = preg_replace('/\s+/', '', $formdata['SmCp']['name']);
                                                    $getname =    strtolower(substr($getname, 0, 5));
                                                    $getusername = $getname . '@' . rand(10001, 99999);

                                                    $get_pwd = rand(10001, 99999);


                                                    $admin_email = !empty($formdata['SmCp']['email']) ? $formdata['SmCp']['email'] : '';
                                                    $formadmindata['Admin']['username'] = $getusername;
                                                    $formadmindata['Admin']['password'] = md5($get_pwd);
                                                    $formadmindata['Admin']['email'] = $admin_email;
                                                    $formadmindata['Admin']['role'] = $formdata['SmCp']['role'];
                                                    $formadmindata['Admin']['create_at'] = date('Y-m-d H:i:s');
                                                    $formadmindata['Admin']['status'] = 1;

                                                    if ($admin_model->load($formadmindata)) {
                                                        if ($admin_model->save()) {
                                                            $data['success']['code'] = 'MEMBER_ADDED_SUCCESSFULY';
                                                            $data['success']['message'] = \Yii::$app->params['MEMBER_ADDED_SUCCESSFULY'];

                                                            //get member details
                                                            $common_model = new Common();
                                                            $get_member = $common_model->getsinglesmcpapi($sm_cp_id);
                                                            if (!empty($get_member)) {
                                                                $data['data']['member'] = $get_member;
                                                            }
                                                        } else {
                                                            $formerrordata['post_data'] = "error while saving data in snse_admin " . json_encode($formadmindata);
                                                            $formerrordata['error'] = json_encode($admin_model->getErrors());
                                                            Yii::$app->common->addlog($formerrordata);

                                                            $data['status'] = 2;
                                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                            //$error['error'] = $error;
                                                            $data['error'] = $error_data;
                                                            Yii::$app->response->statusCode = 500;
                                                        }
                                                    } else {
                                                        $formerrordata['post_data'] = "error while loading data in snse_admin " . json_encode($formadmindata);
                                                        $formerrordata['error'] = json_encode($admin_model->getErrors());
                                                        Yii::$app->common->addlog($formerrordata);

                                                        $data['status'] = 2;
                                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                        //$error['error'] = $error;
                                                        $data['error'] = $error_data;
                                                        Yii::$app->response->statusCode = 500;
                                                    }
                                                } else {
                                                    $formerrordata['post_data'] = "error while saving data in smcp " . json_encode($formdata);
                                                    $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                                    Yii::$app->common->addlog($formerrordata);

                                                    $data['status'] = 2;
                                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                    //$error['error'] = $error;
                                                    $data['error'] = $error_data;
                                                    Yii::$app->response->statusCode = 500;
                                                }
                                            } else {
                                                $formerrordata['post_data'] = "error while loading data in smcp " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'MEMBER_ALREADY_EXIST';
                                            $error_data['message'] = str_replace("%", $formdata['SmCp']['contact'], \Yii::$app->params['MEMBER_ALREADY_EXIST']);
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                        }
                                    }
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'TEAM_LIMIT_EXHAUSTED';
                    $error_data['message'] = \Yii::$app->params['TEAM_LIMIT_EXHAUSTED'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                if (in_array($get_user->status, [1, 2])) {
                    $sm_cp_id = $get_user->sm_cp_id;
                    //get members list
                    $common_model = new Common();
                    $get_members = $common_model->getmembersapi($sm_cp_id);

                    $data['success']['code'] = 'MEMBER_LISTED_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['MEMBER_LISTED_SUCCESSFULY'];
                    $data['data']['members'] = $get_members;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionProfile()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $data['success']['code'] = 'USER_PROFILE_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['USER_PROFILE_LISTED_SUCCESSFULY'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $builder_id = $get_user->builder_id;

                $common_model = new Common();
                if (!empty($cp_id)) {
                    //get cp details
                    $get_cp = $common_model->getcp($cp_id);
                    $data['data']['channelPartner'] = $get_cp;
                }
                if (!empty($builder_id)) {
                    //get cp details
                    $get_builder = $common_model->getbuilder($builder_id);
                    $data['data']['builder'] = $get_builder;
                }
                //get logged details
                $get_logged = $common_model->getloggeduser($get_user);
                $data['data']['loggedUser'] = $get_logged;
                //get members list
                $get_members = $common_model->getmembersapi($sm_cp_id);
                $data['data']['members'] = $get_members;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListnotification()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $querydata = $this->request->get();

                //get manager details
                $get_notification = $common_model->getnotification($sm_cp_id, $querydata);
                //if (!empty($get_notification)) {
                $data['success']['code'] = 'NOTIFICATIONS_DISPLAYED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['NOTIFICATIONS_DISPLAYED_SUCCESSFULY'];
                $data['data'] = $get_notification;

                $cur_time = date('Y-m-d H:i:s');
                //project id is passed then mark messgaees as read also for announcemnets
                if (!empty($querydata['type'])) {
                    if (in_array($querydata['type'], [1, 2, 3, 4])) {
                        if (!empty($querydata['project_id'])) {
                            $get_project_id = $querydata['project_id'];
                            Yii::$app->db->createCommand("UPDATE notification_list nl LEFT JOIN notification_master nm ON nl.notification_id = nm.id SET nl.status = 3,nl.read_on='" . $cur_time . "' WHERE nl.project_id = '" . $get_project_id . "' AND nl.sm_cp_id='" . $sm_cp_id . "' AND nl.status!=3 AND nm.notify_type IN(1,2,3,4)")->execute();

                            Yii::$app->db->createCommand("UPDATE notification_list nl LEFT JOIN notification_master nm ON nl.notification_id = nm.id SET nl.status = 3,nl.read_on='" . $cur_time . "' WHERE nl.sm_cp_id='" . $sm_cp_id . "' AND nl.status!=3 AND nm.notify_type IN(1,2,3,4)")->execute();
                        }
                    } else if (in_array($querydata['type'], [6])) {
                        Yii::$app->db->createCommand("UPDATE notification_list nl LEFT JOIN notification_master nm ON nl.notification_id = nm.id SET nl.status = 3,nl.read_on='" . $cur_time . "' WHERE nl.sm_cp_id='" . $sm_cp_id . "' AND nl.status!=3 AND nm.notify_type IN(6)")->execute();
                    }
                } else {
                    if (!empty($querydata['project_id'])) {
                        $get_project_id = $querydata['project_id'];
                        Yii::$app->db->createCommand("UPDATE notification_list nl LEFT JOIN notification_master nm ON nl.notification_id = nm.id SET nl.status = 3,nl.read_on='" . $cur_time . "' WHERE nl.project_id = '" . $get_project_id . "' AND nl.sm_cp_id='" . $sm_cp_id . "' AND nl.status!=3 AND nm.notify_type IN(1,2,3,4)")->execute();

                        Yii::$app->db->createCommand("UPDATE notification_list nl LEFT JOIN notification_master nm ON nl.notification_id = nm.id SET nl.status = 3,nl.read_on='" . $cur_time . "' WHERE nl.sm_cp_id='" . $sm_cp_id . "' AND nl.status!=3 AND nm.notify_type IN(1,2,3,4)")->execute();
                    }
                }


                //} 
                /* else {
                    $data['status'] = 2;
                    $error_data['code'] = 'NO_NOTIFICATIONS_AVAILABLE';
                    $error_data['message'] = \Yii::$app->params['NO_NOTIFICATIONS_AVAILABLE'];
                    //$error['error'] = $error_data;
                    $data['error'] = $error_data;
                    //return json_encode($error);
                } */
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListpackage()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $package_id = $get_user->package_id;

                $querydata = $this->request->get();

                if (empty($cp_id)) {
                    $usertype = 1;
                } else {
                    $usertype = 2;
                }

                //get package details
                $get_package = $common_model->getpackages($get_user, $usertype);
                //if (!empty($get_notification)) {
                $data['success']['code'] = 'PACKAGES_DISPLAYED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['PACKAGES_DISPLAYED_SUCCESSFULY'];
                $data['data'] = $get_package;
                //} 
                /* else {
                    $data['status'] = 2;
                    $error_data['code'] = 'NO_NOTIFICATIONS_AVAILABLE';
                    $error_data['message'] = \Yii::$app->params['NO_NOTIFICATIONS_AVAILABLE'];
                    //$error['error'] = $error_data;
                    $data['error'] = $error_data;
                    //return json_encode($error);
                } */
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting list packages ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting list packages ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting list packages";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting list packages";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListnotificationproject()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $querydata = $this->request->get();

                //get manager details
                $get_notification = $common_model->getnotificationproject($sm_cp_id, $querydata);
                //if (!empty($get_notification)) {
                $data['success']['code'] = 'NOTIFICATIONS_DISPLAYED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['NOTIFICATIONS_DISPLAYED_SUCCESSFULY'];
                $data['data'] = $get_notification;
                //} 
                /* else {
                    $data['status'] = 2;
                    $error_data['code'] = 'NO_NOTIFICATIONS_AVAILABLE';
                    $error_data['message'] = \Yii::$app->params['NO_NOTIFICATIONS_AVAILABLE'];
                    //$error['error'] = $error_data;
                    $data['error'] = $error_data;
                    //return json_encode($error);
                } */
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification projects ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification projects ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification projects";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting notification projects";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionGetnotification($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                /* $querydata = $this->request->get();

                //get manager details
                $get_notification = $common_model->getnotification($sm_cp_id, $querydata);
                //if (!empty($get_notification)) {
                $data['success']['code'] = 'NOTIFICATIONS_DISPLAYED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['NOTIFICATIONS_DISPLAYED_SUCCESSFULY'];
                $data['data'] = $get_notification; */


                if (!empty($id)) {

                    //check if notification exist
                    $notification_data = NotificationList::find()->where(['id' => $id])->one();
                    if (!empty($notification_data)) {

                        if (!empty($cp_id) && $notification_data->sm_cp_id == $sm_cp_id) {
                            $data['success']['code'] = 'NOTIFICATION_DETAIL_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['NOTIFICATION_DETAIL_DISPLAYED_SUCCESSFULLY'];
                            $get_notify_details = $common_model->getnotificationdetail($id);
                            $data['data'] = $get_notify_details;

                            //mark notification as read
                            if ($notification_data->status != 3) {
                                $notification_data->status = 3;
                                $notification_data->read_on = date('Y-m-d H:i:s');
                                $notification_data->save();
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'NOTIFICATION_NOT_EXIST';
                        $error_data['message'] = str_replace(
                            "%",
                            $id,
                            \Yii::$app->params['NOTIFICATION_NOT_EXIST']
                        );
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification detail ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification detail ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification detail ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting notification detail ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionGetnotificationcount()
    {
        //pending from here
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $querydata = $this->request->get();

                if (!empty($cp_id)) {
                    $data['success']['code'] = 'NOTIFICATION_DETAIL_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['NOTIFICATION_DETAIL_DISPLAYED_SUCCESSFULLY'];
                    $get_notify_details = $common_model->getnotificationcount($sm_cp_id, $querydata);
                    $data['data']['count'] = $get_notify_details;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification unread count.";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification unread count.";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting notification unread count.";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting notification unread count.";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    /* public function actionReadnotification123($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; 
        $formdata['NotificationList'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;

                $cp_id = $get_user->channelpartner_id;
                $get_success = true;
                if (empty($id)) {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $get_success = false;
                }

                $update_nl_model = NotificationList::findOne(['id' => $id]);
                if (empty($update_nl_model) || $update_nl_model->sm_cp_id != $sm_cp_id) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $get_success = false;
                }


                if ($get_success) {
                    //update notification
                    if ($update_nl_model->status != 3) {
                        $update_nl_model->status = 3;
                        $update_nl_model->read_on = date('Y-m-d H:i:s');
                        $update_nl_model->save();
                    }

                    $data['success']['code'] = 'NOTIFICATION_READ_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['NOTIFICATION_READ_SUCCESSFULY'];
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    } */

    public function actionReadnotification()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['NotificationList'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;

                if (!empty($this->request->post())) {
                    $formdata['NotificationList'] = $this->request->post();

                    if (!empty($formdata['NotificationList']['id'])) {

                        $get_success = true;

                        $update_nl_model = NotificationList::findOne(['id' => $formdata['NotificationList']['id']]);
                        if (empty($update_nl_model) || $update_nl_model->sm_cp_id != $sm_cp_id) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $get_success = false;
                        } else {
                            //update notification
                            if ($update_nl_model->status != 3) {
                                $update_nl_model->status = 3;
                                $update_nl_model->read_on = date('Y-m-d H:i:s');
                                $update_nl_model->save();
                            }
                        }
                        if ($get_success) {
                            $data['success']['code'] = 'NOTIFICATION_READ_SUCCESSFULY';
                            $data['success']['message'] = \Yii::$app->params['NOTIFICATION_READ_SUCCESSFULY'];
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while read notification ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListnetwork()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $builder_id = $get_user->builder_id;

                $update_success = true;

                if (empty($builder_id) || !in_array($get_user->role, [1])) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                }

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();
                /* echo "<pre>";
                print_r($querydata);
                exit; */

                $data['success']['code'] = 'CP_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['CP_LISTED_SUCCESSFULY'];

                $get_proj_list = $common_model->getcpnetwork($get_user, $querydata, 1);
                $data['data'] = $get_proj_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListnetworkname()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $builder_id = $get_user->builder_id;

                $update_success = true;

                if (empty($builder_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                }



                $common_model = new Common();

                if (!in_array($get_user->role, [1])) {
                    $get_user = $common_model->getleader($sm_cp_id);
                }
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();
                /* echo "<pre>";
                print_r($querydata);
                exit; */

                $data['success']['code'] = 'CP_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['CP_LISTED_SUCCESSFULY'];

                $get_proj_list = $common_model->getcpnetwork($get_user, $querydata, 1, 1);
                $data['data'] = $get_proj_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting sm cp network list name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListapprovals()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $builder_id = $get_user->builder_id;

                $update_success = true;

                if (empty($builder_id) || !in_array($get_user->role, [1])) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                }

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();
                /* echo "<pre>";
                print_r($querydata);
                exit; */

                $data['success']['code'] = 'CP_NETWORK_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['CP_NETWORK_LISTED_SUCCESSFULY'];

                $get_proj_list = $common_model->getcpnetwork($get_user, $querydata, 3);
                $data['data'] = $get_proj_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp approval list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp approval list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting sm cp approval list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting sm cp approval list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionUpdatenetwork($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        $network_status = array('1' => 'Enabled', '2' => 'Disabled');
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;

                $update_success = true;
                if (!empty($id)) {

                    $update_network_model = SmCpNetwork::findOne(['network_id' => $id]);
                    if (empty($update_network_model)) {
                        $data['status'] = 2;
                        $error_data['code'] = 'CP_NETWORK_NOT_EXIST';
                        $error_data['message'] = str_replace("%", $id, \Yii::$app->params['CP_NETWORK_NOT_EXIST']);
                        $data['error'] = $error_data;
                        $update_success = false;
                    } else {
                        $get_sm_cp_id = $update_network_model->sm_cp_id;
                        $check_access = true;
                        //check if cp has access to lead
                        if (empty($get_sm_cp_id) || ($get_sm_cp_id != $sm_cp_id)) {
                            $check_access = false;
                        }
                        if (!$check_access) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    }

                    if ($update_success) {
                        if (!empty($this->request->post())) {
                            $formdata['SmCpNetwork'] = $this->request->post();
                            if (!empty($formdata['SmCpNetwork']['status'])) {
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                $data['error'] = $error_data;
                                $update_success = false;
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                            $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $update_success = false;
                }

                if ($update_success) {
                    $formdata['SmCpNetwork']['modified_date'] = date('Y-m-d H:i:s');
                    if (isset($network_status[$formdata['SmCpNetwork']['status']])) {
                        $update_network_model->status = $formdata['SmCpNetwork']['status'];
                    }
                    if ($update_network_model->save()) {
                        $data['success']['code'] = 'CP_NETWORK_UPDATED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['CP_NETWORK_UPDATED_SUCCESSFULLY'];
                    } else {
                        $formerrordata['post_data'] = "error while updating cp network " . json_encode($formdata);
                        $formerrordata['error'] = json_encode($update_network_model->getErrors());
                        Yii::$app->common->addlog($formerrordata);

                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        Yii::$app->response->statusCode = 500;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while updating cp network " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while updating cp network " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while updating cp network " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while updating cp network " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionEnquirypackage()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($this->request->post())) {

                    $formdata['PackageEnquiry'] = $this->request->post();

                    if (!empty($formdata['PackageEnquiry'])) {

                        $package_id = !empty($formdata['PackageEnquiry']['subscription_id']) ? $formdata['PackageEnquiry']['subscription_id'] : "";
                        $month = !empty($formdata['PackageEnquiry']['month']) ? $formdata['PackageEnquiry']['month'] : "";
                        $feedback = !empty($formdata['PackageEnquiry']['feedback']) ? $formdata['PackageEnquiry']['feedback'] : "";
                        $todaysdate = date('Y-m-d');

                        $enquiry_data = PackageEnquiry::find()->where('package_id="' . $package_id . '" AND sm_cp_id="' . $sm_cp_id . '" AND DATE(created_on)="' . $todaysdate . '"')->one();

                        if (empty($enquiry_data)) {

                            $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                            $app_features = 0;
                            if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                                $app_features = $get_cp_data->app_features;
                            }

                            if (empty($cp_id) || $app_features != 1) {
                                $data['status'] = 2;
                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                //$update_success = false;
                            } else {


                                $enquirymodel = new PackageEnquiry();
                                $enquirymodel->package_id = $package_id;
                                $enquirymodel->sm_cp_id = $sm_cp_id;
                                $enquirymodel->feedback = $feedback;
                                $enquirymodel->month = $month;
                                $enquirymodel->created_on = date('Y-m-d H:i:s');
                                $enquirymodel->save();


                                $data['success']['code'] = 'PACKAGE_ENQUIRY_CREATED';
                                $data['success']['message'] = \Yii::$app->params['PACKAGE_ENQUIRY_CREATED'];
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'PACKAGE_ENQUIRY_ALREADY_EXISTS';
                            $error_data['message'] = \Yii::$app->params['PACKAGE_ENQUIRY_ALREADY_EXISTS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating package enquiry";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating package enquiry";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating package enquiry";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating package enquiry";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}
