<?php

namespace app\modules\api\controllers;

use app\models\Channelpartner;
use app\models\Common;
use app\models\LeadFeedback;
use app\models\Leadmaster;
use app\models\Location;
use app\models\NotificationMaster;
use app\models\Projects;
use app\models\TaggingFeedback;
use app\models\Taggingmaster;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class TaggingController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'create' => ['POST'],
                        'direct' => ['POST'],
                        'createmultiple' => ['POST'],
                        'detail' => ['GET'],
                        'update' => ['PUT'],
                        'updatestatus' => ['PUT'],
                        'stats' => ['GET'],
                        'monthly' => ['GET'],
                        'delete' => ['DELETE'],
                        'list' => ['GET'],
                        'addfeed' => ['PUT'],
                        'feedback' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['create', 'direct', 'createmultiple', 'detail', 'stats', 'update', 'delete', 'list', 'monthly', 'updatestatus', 'addfeed', 'feedback'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            $common_model = new Common();

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (empty($cp_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    if (!empty($this->request->post())) {
                        $formdata['Taggingmaster'] = $this->request->post();
                        $lead_model = Leadmaster::findOne(['id' => $formdata['Taggingmaster']['lead_id'], 'is_deleted' => 0]);
                        if (empty($lead_model)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'LEAD_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['lead_id'], \Yii::$app->params['LEAD_NOT_EXIST']);
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        } else {
                            $formdata['Taggingmaster']['tag_name'] = $lead_model->name;
                            $formdata['Taggingmaster']['tag_email'] = $lead_model->email;
                            $formdata['Taggingmaster']['tag_phone'] = $lead_model->contact;
                            $formdata['Taggingmaster']['budget'] = $lead_model->budget;
                            $formdata['Taggingmaster']['followup_date'] = $lead_model->followup_date;
                            $formdata['Taggingmaster']['customer_type'] = $lead_model->customer_type;
                            $formdata['Taggingmaster']['flat_type_id'] = $lead_model->flat_type_id;
                            $formdata['Taggingmaster']['flat_property_type'] = $lead_model->flat_property_type;

                            $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                            if (
                                empty($formdata['Taggingmaster']['lead_id']) ||
                                empty($formdata['Taggingmaster']['project_id']) ||
                                empty($formdata['Taggingmaster']['appointment_date']) ||
                                empty($formdata['Taggingmaster']['sm_cp_id']) ||
                                empty($formdata['Taggingmaster']['appointment_time'])
                            ) {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                $data['error'] = $error_data;
                            } else if ($formdata['Taggingmaster']['appointment_date'] != date('Y-m-d')) {
                                /* else if (($formdata['Taggingmaster']['appointment_date'] < date('Y-m-d')) || ($formdata['Taggingmaster']['appointment_date'] > $twodate)) { */
                                $data['status'] = 2;
                                $error_data['code'] = 'APPOINTMENT_DATE_TODAY_ONLY';
                                $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_TODAY_ONLY'];
                                $data['error'] = $error_data;
                            } else {
                                $formdata['Taggingmaster']['created_by'] = $sm_cp_id;
                                $formdata['Taggingmaster']['cp_id'] = $cp_id;
                                $formdata['Taggingmaster']['created_on'] = date('Y-m-d H:i:s');
                                $formdata['Taggingmaster']['modified_by'] = $sm_cp_id;
                                $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');


                                //create tag code
                                $getcp_data = $common_model->getcp($cp_id);
                                $getcp_compname = $getcp_data['company_name'];
                                $getcp_compname = preg_replace('/\s+/', '', $getcp_compname);
                                $get_sb_cp = substr($getcp_compname, 0, 6);
                                $str_result = '0123456789';
                                $num_code =    substr(str_shuffle($str_result), 0, 4) . date('dmy');
                                //$formdata['Taggingmaster']['tag_code'] = $get_sb_cp . "@" . $num_code;
                                $formdata['Taggingmaster']['tag_code'] = "APC@" . $num_code;

                                //set 60 days lead dead date
                                $app_date = $formdata['Taggingmaster']['appointment_date'];
                                $get_lead_dead_date = date('Y-m-d', strtotime($app_date . ' + 60 days'));
                                $formdata['Taggingmaster']['lead_dead_date'] = $get_lead_dead_date;

                                //check if already same tagging is in progress
                                $sql_check_exist = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND cp_id='" . $cp_id . "' AND status=0 AND is_deleted=0 AND appointment_date='" . date('Y-m-d') . "' ";
                                $user_count_check = Taggingmaster::findBySql($sql_check_exist)->count();

                                if ($user_count_check == 0) {

                                    //check entries of that contact for project.
                                    //only 4 times allowed for per customer with same project per month.


                                    $sql_check = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND cp_id='" . $cp_id . "' AND is_deleted=0 AND appointment_date BETWEEN '" . date('Y-m-01') . "' AND '" . date('Y-m-d') . "' ";
                                    $user_count = Taggingmaster::findBySql($sql_check)->count();
                                    if ($user_count <= intval(\Yii::$app->params['TAG_SAME_CUST_MONTH_MAX'])) {
                                        $tagging_model = new Taggingmaster();


                                        if ($tagging_model->load($formdata)) {

                                            if ($tagging_model->save()) {

                                                $tag_id = $tagging_model->id;
                                                //update lead id and get lead details
                                                $tagging_model->tagging_id = "TAG" . date('d') . date('m') . date('y') . $tag_id;
                                                $tagging_model->save();

                                                $lead_model->tagging = 1;
                                                $lead_model->save();

                                                if (!empty($formdata['Taggingmaster']['feedback'])) {
                                                    //Add entry in feedback table
                                                    $tag_feedback_model = new TaggingFeedback();
                                                    $tag_feedback_model->tagging_id = $tag_id;
                                                    $tag_feedback_model->feedback = $formdata['Taggingmaster']['feedback'];
                                                    $tag_feedback_model->created_on = date('Y-m-d H:i:s');
                                                    $tag_feedback_model->created_by = $sm_cp_id;
                                                    $tag_feedback_model->save();
                                                }


                                                $data['success']['code'] = 'TAGGING_CREATED_SUCCESSFULLY';
                                                $data['success']['message'] = \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY'];

                                                $get_tag = $common_model->gettagapi($tag_id, $tagging_model, 1);
                                                $data['data'] = $get_tag;
                                            } else {

                                                $formerrordata['post_data'] = "error while adding data in taggingmaster " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $formerrordata['post_data'] = "error while loading data in taggingmaster " . json_encode($formdata);
                                            $formerrordata['error'] = json_encode($lead_model->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = 'TAG_SAME_CUST_MONTH_MAX_EXHAUSTED';
                                        $error_data['message'] = \Yii::$app->params['TAG_SAME_CUST_MONTH_MAX_EXHAUSTED'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = 'TAGGING_ALREADY_EXIST';
                                    $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['tag_phone'], \Yii::$app->params['LEAD_ALREADY_EXIST']);
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDirect()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $common_model = new Common();
                if (empty($cp_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    if (!empty($this->request->post())) {
                        //$formdata['Taggingmaster'] = $this->request->post();

                        $posted_data = $this->request->post();
                        $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                        if (
                            empty($posted_data['name']) ||
                            empty($posted_data['contact']) ||
                            empty($posted_data['budget']) ||
                            empty($posted_data['project_id']) ||
                            empty($posted_data['appointment_date']) ||
                            empty($posted_data['appointment_time']) ||
                            empty($posted_data['sm_cp_id'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else if ($posted_data['appointment_date'] != date('Y-m-d')) {
                            /* else if (($posted_data['appointment_date'] < date('Y-m-d')) || ($posted_data['appointment_date'] > $twodate)) { */
                            $data['status'] = 2;
                            $error_data['code'] = 'APPOINTMENT_DATE_TODAY_ONLY';
                            $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_TODAY_ONLY'];
                            $data['error'] = $error_data;
                        } else {

                            //check if already same tagging is in progress
                            $sql_check_exist = "SELECT id FROM taggingmaster WHERE project_id='" . $posted_data['project_id'] . "' AND cp_id='" . $cp_id . "' AND tag_name='" . $posted_data['name'] . "' AND tag_phone='" . $posted_data['contact'] . "' AND is_deleted=0 AND status=0 AND appointment_date='" . date('Y-m-d') . "' ";
                            $user_count_check = Taggingmaster::findBySql($sql_check_exist)->count();
                            if ($user_count_check == 0) {

                                //only 4 times allowed for per customer with same project per month.
                                $sql_check = "SELECT id FROM taggingmaster WHERE project_id='" . $posted_data['project_id'] . "' AND cp_id='" . $cp_id . "' AND tag_name='" . $posted_data['name'] . "' AND tag_phone='" . $posted_data['contact'] . "' AND is_deleted=0 AND appointment_date BETWEEN '" . date('Y-m-01') . "' AND '" . date('Y-m-d') . "'  ";
                                $user_count = Taggingmaster::findBySql($sql_check)->count();
                                if ($user_count <= intval(\Yii::$app->params['TAG_SAME_CUST_MONTH_MAX'])) {

                                    //create lead first
                                    $formdata['Leadmaster']['name'] = $posted_data['name'];
                                    $formdata['Leadmaster']['contact'] = $posted_data['contact'];
                                    $formdata['Leadmaster']['email'] = !empty($posted_data['email']) ? $posted_data['email'] : '';
                                    $formdata['Leadmaster']['flat_property_type'] = !empty($posted_data['flat_property_type']) ? $posted_data['flat_property_type'] : '1';
                                    $formdata['Leadmaster']['flat_type_id'] = !empty($posted_data['flat_type_id']) ? $posted_data['flat_type_id'] : '';
                                    $formdata['Leadmaster']['budget'] = $posted_data['budget'];
                                    $formdata['Leadmaster']['customer_type'] = !empty($posted_data['customer_type']) ? $posted_data['customer_type'] : '';
                                    $formdata['Leadmaster']['feedback'] = !empty($posted_data['feedback']) ? $posted_data['feedback'] : '';
                                    $formdata['Leadmaster']['followup_date'] = $posted_data['appointment_date'];
                                    $formdata['Leadmaster']['tagging'] = 1;

                                    $formdata['Leadmaster']['status'] = 1;
                                    $formdata['Leadmaster']['created_by'] = $sm_cp_id;
                                    $formdata['Leadmaster']['cp_id'] = $cp_id;
                                    $formdata['Leadmaster']['created_on'] = date('Y-m-d H:i:s');
                                    $formdata['Leadmaster']['modified_by'] = $sm_cp_id;
                                    $formdata['Leadmaster']['modified_on'] = date('Y-m-d H:i:s');
                                    //$formdata['Leadmaster']['lead_id'] = "L".date('d').date('m').date('y');

                                    //check entries of that contact
                                    $sql_check = "SELECT id FROM leadmaster WHERE contact='" . $formdata['Leadmaster']['contact'] . "' AND is_deleted=0 AND name='" . $formdata['Leadmaster']['name'] . "' AND cp_id='" . $cp_id . "' ";
                                    $user_count = Leadmaster::findBySql($sql_check)->count();
                                    if ($user_count == 0) {
                                        $lead_model = new Leadmaster();

                                        $lead_check_pass = true;
                                        //check lead limit exceed
                                        $where_sql_check = 'is_deleted=0 ';
                                        $where_sql_check .= ' AND cp_id="' . $cp_id . '"';
                                        //$where_sql .= ' AND DATE(created_on)>="' . date('Y-m-01') . '"';


                                        $lead_query_check = (new \yii\db\Query())
                                            ->select('id')
                                            ->from('leadmaster')
                                            ->where($where_sql_check);
                                        $lead_count = $lead_query_check->count();


                                        //get cp lead stats
                                        $cp_model = Channelpartner::find()->where(['id' => $cp_id])->one();

                                        //get credit count
                                        $members = $common_model->getsmcpteam($cp_id, 1);
                                        $members_txt = implode(",", $members);

                                        /* $ref_query = (new \yii\db\Query())
                                            ->select('cp_refer.id')
                                            ->from('cp_refer')
                                            ->where("sm_cp_id IN(" . $members_txt . ") AND status=2");
                                        $ref_count = $ref_query->count(); */
                                        $ref_count = 0;

                                        $lead_per_credit = 5;
                                        $credit_leads = $lead_per_credit * $ref_count;
                                        $allowed_leads = intval($cp_model->credits);
                                        $total_allowed_leads = $allowed_leads + $credit_leads;
                                        $balance_leads = $total_allowed_leads - $lead_count;
                                        if ($balance_leads <= 0) {
                                            $lead_check_pass = false;
                                        }



                                        if ($lead_check_pass) {
                                            if ($lead_model->load($formdata)) {
                                                if ($lead_model->save()) {

                                                    $l_id = $lead_model->id;
                                                    //update lead id and get lead details
                                                    $lead_model->lead_id = "L" . date('d') . date('m') . date('y') . $l_id;
                                                    $lead_model->save();

                                                    if (!empty($formdata['Leadmaster']['feedback'])) {
                                                        //Add entry in feedback table
                                                        $lead_feedback_model = new LeadFeedback();
                                                        $lead_feedback_model->lead_id = $l_id;
                                                        $lead_feedback_model->feedback = $formdata['Leadmaster']['feedback'];
                                                        $lead_feedback_model->created_on = date('Y-m-d H:i:s');
                                                        $lead_feedback_model->created_by = $sm_cp_id;
                                                        $lead_feedback_model->save();
                                                    }


                                                    $data['success']['code'] = 'LEAD_CREATED_SUCCESSFULLY';
                                                    $data['success']['message'] = \Yii::$app->params['LEAD_CREATED_SUCCESSFULLY'];



                                                    //create tag here
                                                    $formdata['Taggingmaster']['tag_name'] = $lead_model->name;
                                                    $formdata['Taggingmaster']['tag_email'] = $lead_model->email;
                                                    $formdata['Taggingmaster']['tag_phone'] = $lead_model->contact;
                                                    $formdata['Taggingmaster']['budget'] = $lead_model->budget;
                                                    $formdata['Taggingmaster']['followup_date'] = $lead_model->followup_date;
                                                    $formdata['Taggingmaster']['customer_type'] = $lead_model->customer_type;
                                                    $formdata['Taggingmaster']['flat_type_id'] = $lead_model->flat_type_id;
                                                    $formdata['Taggingmaster']['flat_property_type'] = $lead_model->flat_property_type;
                                                    $formdata['Taggingmaster']['lead_id'] = $l_id;
                                                    $formdata['Taggingmaster']['project_id'] = $posted_data['project_id'];
                                                    $formdata['Taggingmaster']['appointment_date'] = $posted_data['appointment_date'];
                                                    $formdata['Taggingmaster']['appointment_time'] = $posted_data['appointment_time'];
                                                    $formdata['Taggingmaster']['sm_cp_id'] = $posted_data['sm_cp_id'];
                                                    $formdata['Taggingmaster']['feedback'] = !empty($posted_data['feedback']) ? $posted_data['feedback'] : '';


                                                    $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                                                    if (
                                                        empty($formdata['Taggingmaster']['lead_id']) ||
                                                        empty($formdata['Taggingmaster']['project_id']) ||
                                                        empty($formdata['Taggingmaster']['appointment_date']) ||
                                                        empty($formdata['Taggingmaster']['sm_cp_id']) ||
                                                        empty($formdata['Taggingmaster']['appointment_time'])
                                                    ) {
                                                        $data['status'] = 2;
                                                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                                        $data['error'] = $error_data;
                                                    } else if (($formdata['Taggingmaster']['appointment_date'] < date('Y-m-d')) || ($formdata['Taggingmaster']['appointment_date'] > $twodate)) {
                                                        $data['status'] = 2;
                                                        $error_data['code'] = 'APPOINTMENT_DATE_ONLY_TWO_DAYS';
                                                        $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_ONLY_TWO_DAYS'];
                                                        $data['error'] = $error_data;
                                                    } else {
                                                        $formdata['Taggingmaster']['created_by'] = $sm_cp_id;
                                                        $formdata['Taggingmaster']['cp_id'] = $cp_id;
                                                        $formdata['Taggingmaster']['created_on'] = date('Y-m-d H:i:s');
                                                        $formdata['Taggingmaster']['modified_by'] = $sm_cp_id;
                                                        $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');

                                                        //get tag code
                                                        $getcp_data = $common_model->getcp($cp_id);
                                                        $getcp_compname = $getcp_data['company_name'];
                                                        $getcp_compname = preg_replace('/\s+/', '', $getcp_compname);
                                                        $get_sb_cp = substr($getcp_compname, 0, 6);
                                                        $str_result = '0123456789';
                                                        $num_code =    substr(str_shuffle($str_result), 0, 4) . date('dmy');
                                                        //$formdata['Taggingmaster']['tag_code'] = $get_sb_cp . "@" . $num_code;
                                                        $formdata['Taggingmaster']['tag_code'] = "APC@" . $num_code;

                                                        //check entries of that contact for project
                                                        $sql_check = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND is_deleted=0 AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND cp_id='" . $cp_id . "' ";

                                                        $tagging_model = new Taggingmaster();


                                                        if ($tagging_model->load($formdata)) {
                                                            if ($tagging_model->save()) {

                                                                $tag_id = $tagging_model->id;
                                                                //update lead id and get lead details
                                                                $tagging_model->tagging_id = "TAG" . date('d') . date('m') . date('y') . $tag_id;
                                                                $tagging_model->save();

                                                                if (!empty($formdata['Taggingmaster']['feedback'])) {
                                                                    //Add entry in feedback table
                                                                    $tag_feedback_model = new TaggingFeedback();
                                                                    $tag_feedback_model->tagging_id = $tag_id;
                                                                    $tag_feedback_model->feedback = $formdata['Taggingmaster']['feedback'];
                                                                    $tag_feedback_model->created_on = date('Y-m-d H:i:s');
                                                                    $tag_feedback_model->created_by = $sm_cp_id;
                                                                    $tag_feedback_model->save();
                                                                }

                                                                $common_model = new Common();
                                                                $data['success']['code'] = 'TAGGING_CREATED_SUCCESSFULLY';
                                                                $data['success']['message'] = \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY'];

                                                                $get_tag = $common_model->gettagapi($tag_id, $tagging_model, 1);
                                                                $data['data'] = $get_tag;
                                                            } else {

                                                                $formerrordata['post_data'] = "error while adding data in taggingmaster " . json_encode($formdata);
                                                                $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                                Yii::$app->common->addlog($formerrordata);

                                                                $data['status'] = 2;
                                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                                //$error['error'] = $error;
                                                                $data['error'] = $error_data;
                                                                Yii::$app->response->statusCode = 500;
                                                            }
                                                        } else {
                                                            $formerrordata['post_data'] = "error while loading data in taggingmaster " . json_encode($formdata);
                                                            $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                            Yii::$app->common->addlog($formerrordata);

                                                            $data['status'] = 2;
                                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                            //$error['error'] = $error;
                                                            $data['error'] = $error_data;
                                                            Yii::$app->response->statusCode = 500;
                                                        }
                                                    }

                                                    //$get_lead = $common_model->getleadapi($l_id, $lead_model, '');
                                                    //$data['data'] = $get_lead;
                                                } else {

                                                    $formerrordata['post_data'] = "error while adding data in leadmaster " . json_encode($formdata);
                                                    $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                    Yii::$app->common->addlog($formerrordata);

                                                    $data['status'] = 2;
                                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                    //$error['error'] = $error;
                                                    $data['error'] = $error_data;
                                                    Yii::$app->response->statusCode = 500;
                                                }
                                            } else {
                                                $formerrordata['post_data'] = "error while loading data in leadmaster " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'LEAD_CP_EXCEEDED';
                                            $error_data['message'] = \Yii::$app->params['LEAD_CP_EXCEEDED'];
                                            $data['error'] = $error_data;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = 'LEAD_ALREADY_EXIST';
                                        $error_data['message'] = str_replace("%", $formdata['Leadmaster']['contact'], \Yii::$app->params['LEAD_ALREADY_EXIST']);
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = 'TAG_SAME_CUST_MONTH_MAX_EXHAUSTED';
                                    $error_data['message'] = \Yii::$app->params['TAG_SAME_CUST_MONTH_MAX_EXHAUSTED'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = 'TAGGING_ALREADY_EXIST';
                                $error_data['message'] = str_replace("%", $posted_data['contact'], \Yii::$app->params['LEAD_ALREADY_EXIST']);
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionUpdate($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;

                if (empty($cp_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                } else {

                    if (!empty($id)) {

                        //check if member has access over the lead
                        $get_access_smcp = $common_model->checkcptagaccess($sm_cp_id, $id);
                        if (!$get_access_smcp || empty($cp_id)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                        //check if tag is in status of 0,2.
                        $update_tag_model = Taggingmaster::findOne(['id' => $id, 'is_deleted' => 0]);
                        if (!empty($update_tag_model)) {
                            /* if (!in_array($update_tag_model->status, [0, 2])) {
                                $data['status'] = 2;
                                $error_data['code'] = 'TAGGING_ALREADY_PROCESSED';
                                $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_ALREADY_PROCESSED']);
                                $data['error'] = $error_data;
                                $update_success = false;
                            } */
                            /* if ($update_tag_model->retag_limit == \Yii::$app->params['RETAG_MAX']) {
                                $data['status'] = 2;
                                $error_data['code'] = 'RETAGGING_LIMIT_EXHAUSTED';
                                $error_data['message'] = \Yii::$app->params['RETAGGING_LIMIT_EXHAUSTED'];
                                $data['error'] = $error_data;
                                $update_success = false;
                            } */
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'TAGGING_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                }

                if ($update_success) {
                    if (!empty($this->request->post())) {
                        $formdata['Taggingmaster'] = $this->request->post();
                        $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                        if (
                            empty($formdata['Taggingmaster'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } /* else if ($formdata['Taggingmaster']['appointment_date'] != date('Y-m-d')) {
                            else if (($formdata['Taggingmaster']['appointment_date'] < date('Y-m-d')) || ($formdata['Taggingmaster']['appointment_date'] > $twodate)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'APPOINTMENT_DATE_TODAY_ONLY';
                            $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_TODAY_ONLY'];
                            $data['error'] = $error_data;
                        } */ else {

                            $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');
                            $formdata['Taggingmaster']['modified_by'] = $get_user->sm_cp_id;

                            if ($update_tag_model->status == 2) {
                                $update_tag_model->status = 0;
                                $update_tag_model->appointment_date = date('Y-m-d');
                            }

                            //update the retag limit only if date changed
                            /* if ($update_tag_model->appointment_date != $formdata['Taggingmaster']['appointment_date']) {
                                $gettag_limit = $update_tag_model->retag_limit;
                                $new_limit = $gettag_limit + 1;
                                $update_tag_model->retag_limit = $new_limit;
                            } */

                            if ($update_success) {

                                foreach ($formdata['Taggingmaster'] as $formdata_key => $formdata_val) {
                                    if (in_array($update_tag_model->status, [0, 2])) {
                                        if (in_array($formdata_key, ['appointment_time', 'feedback'])) {
                                            $update_tag_model->$formdata_key = $formdata_val;
                                        }
                                    } else {
                                        if (in_array($formdata_key, ['feedback'])) {
                                            $update_tag_model->$formdata_key = $formdata_val;
                                        }
                                    }
                                }
                                if ($update_tag_model->save()) {

                                    if (!empty($formdata['Taggingmaster']['feedback'])) {
                                        //Add entry in feedback table
                                        $tag_feedback_model = new TaggingFeedback();
                                        $tag_feedback_model->tagging_id = $id;
                                        $tag_feedback_model->feedback = $formdata['Taggingmaster']['feedback'];
                                        $tag_feedback_model->created_on = date('Y-m-d H:i:s');
                                        $tag_feedback_model->created_by = $sm_cp_id;
                                        $tag_feedback_model->save();
                                    }

                                    $data['success']['code'] = 'TAGGING_UPDATED_SUCCESSFULLY';
                                    $data['success']['message'] = \Yii::$app->params['TAGGING_UPDATED_SUCCESSFULLY'];
                                    $get_tag = $common_model->gettagshortapi($id, $update_tag_model, 1);
                                    $data['data'] = $get_tag;
                                } else {
                                    $formerrordata['post_data'] = "error while updating tag " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($update_tag_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionUpdatestatus($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        $tag_status = array('0' => 'In Progress', '1' => 'Visited', '2' => 'Not Visited', '3' => 'Clashed', '4' => 'Booked', '5' => 'Lead Dead', '6' => 'Registered', '7' => 'Lead Rejected');
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $staff_type = $get_user->staff_type;
                $update_success = true;
                if (!empty($id)) {

                    //check if cp has access to lead
                    if (!empty($cp_id)) {
                        $check_access = false;
                    } else {
                        if (empty($cp_id)) {
                            if ($staff_type == 1) {
                                $get_type = 'sm';
                            } else {
                                $get_type = 'staff';
                            }
                        }
                        $check_access = $common_model->checkcptagaccess($sm_cp_id, $id, $get_type);
                    }
                    if (!$check_access) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }

                    if ($update_success) {
                        //check if tag is in status of 0,2.
                        $update_tag_model = Taggingmaster::findOne(['id' => $id, 'is_deleted' => 0]);
                        if (!empty($update_tag_model)) {
                            if (!empty($this->request->post())) {
                                $formdata['Taggingmaster'] = $this->request->post();
                                if (!empty($formdata['Taggingmaster']['status']) || !empty($formdata['Taggingmaster']['is_cancelled'])) {
                                    if (!empty($formdata['Taggingmaster']['status'])) {
                                        $rec_status = $formdata['Taggingmaster']['status'];
                                        $exis_status = $update_tag_model->status;
                                        if ($rec_status == $exis_status) {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'TAGGING_STATUS_SAME';
                                            $error_data['message'] = \Yii::$app->params['TAGGING_STATUS_SAME'];
                                            $data['error'] = $error_data;
                                            $update_success = false;
                                        } else if ($rec_status != 1 && $rec_status < $exis_status) {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'TAGGING_STATUS_LESS';
                                            $error_data['message'] = \Yii::$app->params['TAGGING_STATUS_LESS'];
                                            $error_data['message'] = str_replace("#1", $tag_status[$rec_status], $error_data['message']);
                                            $error_data['message'] = str_replace("#2", $tag_status[$exis_status], $error_data['message']);
                                            $data['error'] = $error_data;
                                            $update_success = false;
                                        }
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                    $data['error'] = $error_data;
                                    $update_success = false;
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                $update_success = false;
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'TAGGING_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $update_success = false;
                }



                $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');
                if ($update_success) {
                    if (!empty($formdata['Taggingmaster']['status'])) {
                        $update_tag_model->status = $formdata['Taggingmaster']['status'];
                        if (in_array($formdata['Taggingmaster']['status'], [1, 2, 3, 7])) {
                            $update_tag_model->visit_notvisit_clash_date = date('Y-m-d H:i:s');
                            $update_tag_model->visited_by = $sm_cp_id;
                        } else if ($formdata['Taggingmaster']['status'] == 4) {
                            $update_tag_model->lead_convert_date = date('Y-m-d H:i:s');
                            $update_tag_model->booked_by = $sm_cp_id;
                        } else if ($formdata['Taggingmaster']['status'] == 5) {
                            $update_tag_model->lead_dead_date = date('Y-m-d H:i:s');
                        } else if ($formdata['Taggingmaster']['status'] == 6) {
                            $update_tag_model->lead_registered_date = date('Y-m-d H:i:s');
                            $update_tag_model->registered_by = $sm_cp_id;
                        }
                    }
                    if (!empty($formdata['Taggingmaster']['is_cancelled'])) {
                        $update_tag_model->is_cancelled = 1;
                        $update_tag_model->cancelled_on = date('Y-m-d H:i:s');
                        $update_tag_model->cancelled_by = $sm_cp_id;
                    }

                    //send notification code to be added here
                    $message = array();
                    $msg_body = '';
                    if (!empty($formdata['Taggingmaster']['status'])) {
                        if (in_array($formdata['Taggingmaster']['status'], [1, 2, 3, 7])) {
                            if (in_array($formdata['Taggingmaster']['status'], [1, 2])) {
                                if ($formdata['Taggingmaster']['status'] == 1) {
                                    $msg_body = 'Visited';
                                } else {
                                    $msg_body = 'Not Visited';
                                }
                            }
                        } else if ($formdata['Taggingmaster']['status'] == 4) {
                            $msg_body = 'Booked in';
                        } else if ($formdata['Taggingmaster']['status'] == 6) {
                            $msg_body = 'Registered in';
                        }
                    }
                    if (!empty($formdata['Taggingmaster']['is_cancelled'])) {
                        $msg_body = 'Cancelled Booking in';
                    }
                    if (!empty($msg_body)) {

                        if (!empty($update_tag_model->project_id)) {
                            $get_proj = Projects::findOne(['id' => $update_tag_model->project_id]);
                            $get_proj_name = $get_proj->name;
                        }

                        //send notification
                        $message['title'] = 'Tagging Update';
                        $message['body'] = 'Your tagging ' . $update_tag_model->tag_name . ' with contact ' . $update_tag_model->tag_phone . ' has ' . $msg_body . ' ' . $get_proj_name;
                        $message['link'] = '';
                        $info = array();
                        $info['type'] = 'tagging';
                        $info['id'] = $update_tag_model->id;

                        //add entry in notification master
                        $master_model = new NotificationMaster();
                        $master_model->cp_id = $update_tag_model->cp_id;
                        $master_model->sent_type = 2;
                        $master_model->notify_type = 1;
                        $master_model->title = $message['title'];
                        $master_model->message = $message['body'];
                        $master_model->link = $message['link'];
                        $master_model->info = json_encode($info);
                        $master_model->created_on = date('Y-m-d H:i:s');
                        $master_model->save();
                    }

                    if ($update_tag_model->save()) {

                        $data['success']['code'] = 'TAGGING_UPDATED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['TAGGING_UPDATED_SUCCESSFULLY'];
                        $get_tag = $common_model->gettagapi($id, $update_tag_model, 1);
                        $data['data'] = $get_tag;
                    } else {
                        $formerrordata['post_data'] = "error while updating tag " . json_encode($formdata);
                        $formerrordata['error'] = json_encode($update_tag_model->getErrors());
                        Yii::$app->common->addlog($formerrordata);

                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        Yii::$app->response->statusCode = 500;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionAddfeed($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;

                if (!empty($id)) {

                    $get_type = 'cp';
                    if (empty($cp_id)) {
                        $get_type = 'sm';
                    }
                    //check if member has access over the lead
                    $get_access_smcp = $common_model->checkcptagaccess($sm_cp_id, $id, $get_type);
                    if (!$get_access_smcp) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                    //check if tag is in status of 0,2.
                    $update_tag_model = Taggingmaster::findOne(['id' => $id, 'is_deleted' => 0]);
                    if (!empty($update_tag_model)) {
                        /* if (!in_array($update_tag_model->status, [0, 2])) {
                            $data['status'] = 2;
                            $error_data['code'] = 'TAGGING_ALREADY_PROCESSED';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_ALREADY_PROCESSED']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        } */
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'TAGGING_NOT_EXIST';
                        $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $update_success = false;
                }


                if ($update_success) {
                    if (!empty($this->request->post())) {
                        $formdata['Taggingmaster'] = $this->request->post();

                        if (
                            empty($formdata['Taggingmaster']['feedback'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {

                            $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');
                            $formdata['Taggingmaster']['modified_by'] = $get_user->sm_cp_id;

                            if ($update_success) {

                                foreach ($formdata['Taggingmaster'] as $formdata_key => $formdata_val) {
                                    if (in_array($formdata_key, ['feedback'])) {
                                        $update_tag_model->$formdata_key = $formdata_val;
                                    }
                                }
                                if ($update_tag_model->save()) {

                                    if (!empty($formdata['Taggingmaster']['feedback'])) {
                                        //Add entry in feedback table
                                        $tag_feedback_model = new TaggingFeedback();
                                        $tag_feedback_model->tagging_id = $id;
                                        $tag_feedback_model->feedback = $formdata['Taggingmaster']['feedback'];
                                        $tag_feedback_model->created_on = date('Y-m-d H:i:s');
                                        $tag_feedback_model->created_by = $sm_cp_id;
                                        $tag_feedback_model->save();
                                    }

                                    $data['success']['code'] = 'TAGGING_UPDATED_SUCCESSFULLY';
                                    $data['success']['message'] = \Yii::$app->params['TAGGING_UPDATED_SUCCESSFULLY'];
                                    $get_tag = $common_model->gettagshortapi($id, $update_tag_model, 1);
                                    $data['data'] = $get_tag;
                                } else {
                                    $formerrordata['post_data'] = "error while adding feedback " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($update_tag_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while adding feedback " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while adding feedback " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while adding feedback " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while adding feedback " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }



    public function actionDelete($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;

                if (empty($cp_id)) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                } else {

                    if (!empty($id)) {

                        //check if member has access over the lead
                        $get_access_smcp = $common_model->checkcptagaccess($sm_cp_id, $id);
                        if (!$get_access_smcp) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                        //check if tag is processed.
                        $update_tag_model = Taggingmaster::findOne(['id' => $id, 'is_deleted' => 0]);
                        if (empty($update_tag_model)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'TAGGING_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        } else {
                            if ($update_tag_model->status != 0) {
                                $data['status'] = 2;
                                $error_data['code'] = 'TAGGING_ALREADY_PROCESSED';
                                $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_ALREADY_PROCESSED']);
                                $data['error'] = $error_data;
                                $update_success = false;
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                }

                if ($update_success) {
                    if ($update_tag_model->delete()) {
                        //delete feedback
                        $del_feed_data = TaggingFeedback::deleteAll(['tagging_id' => $id]);
                        $data['success']['code'] = 'TAGGING_DELETED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['TAGGING_DELETED_SUCCESSFULLY'];
                    } else {
                        $formerrordata['post_data'] = "error while deleting tag " . json_encode($formdata);
                        $formerrordata['error'] = json_encode($update_tag_model->getErrors());
                        Yii::$app->common->addlog($formerrordata);

                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        Yii::$app->response->statusCode = 500;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                $tag_data = Taggingmaster::find()->where('id="' . $id . '" AND is_deleted=0 ')->one();
                if (!empty($tag_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;
                        $staff_type = $get_user->staff_type;

                        $common_model = new Common();
                        //check if cp has access to lead
                        $get_type = 'cp';
                        if (empty($cp_id)) {
                            $get_type = 'sm';
                        }
                        if ($staff_type == 2) {
                            $check_access = $common_model->checkcpprojaccessbysm($sm_cp_id, $tag_data->project_id);
                        } else {
                            $check_access = $common_model->checkcptagaccess($sm_cp_id, $id, $get_type);
                        }
                        if ($check_access) {
                            $data['success']['code'] = 'TAGGING_DETAIL_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['TAGGING_DETAIL_DISPLAYED_SUCCESSFULLY'];
                            $get_tag_details = $common_model->gettagapi($id, $tag_data, 1);
                            $data['data'] = $get_tag_details;
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'TAGGING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionFeedback($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                $tag_data = Taggingmaster::find()->where('id="' . $id . '" AND is_deleted=0 ')->one();
                if (!empty($tag_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;
                        $staff_type = $get_user->staff_type;

                        $common_model = new Common();
                        //check if cp has access to lead
                        $get_type = 'cp';
                        if (empty($cp_id)) {
                            $get_type = 'sm';
                        }
                        if ($staff_type == 2) {
                            $check_access = $common_model->checkcpprojaccessbysm($sm_cp_id, $tag_data->project_id);
                        } else {
                            $check_access = $common_model->checkcptagaccess($sm_cp_id, $id, $get_type);
                        }
                        if ($check_access) {
                            $data['success']['code'] = 'FEEDBACK_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['FEEDBACK_DISPLAYED_SUCCESSFULLY'];
                            $get_feedback_details = $common_model->getfeedbackapi($id, 1);
                            $data['data'] = $get_feedback_details;
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'TAGGING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging feedback list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging feedback list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging feedback list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tagging feedback list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();

                $data['success']['code'] = 'TAGGING_LIST_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['TAGGING_LIST_DISPLAYED_SUCCESSFULLY'];
                //$get_proj = $this->getprojofmultism($get_sm);
                $get_tag_list = $common_model->gettaglistapi($get_user, $querydata);
                $data['data'] = $get_tag_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionStats()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $staff_type = $get_user->staff_type;
                $get_type = 'cp';
                if (empty($cp_id)) {
                    if ($staff_type == 1) {
                        $get_type = 'sm';
                    } else {
                        $get_type = 'staff';
                    }
                }

                $common_model = new Common();

                $data['success']['code'] = 'TAGGING_STATS_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['TAGGING_STATS_DISPLAYED_SUCCESSFULLY'];
                $get_tag_stats = $common_model->gettagstatsapi($sm_cp_id, $get_type);
                $data['data'] = $get_tag_stats;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMonthly()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();

                if (!empty($querydata)) {

                    $tag_year = (!empty($querydata['year']) ? trim($querydata['year']) : date('Y'));
                }
                if ($tag_year > date('Y') || $tag_year < 2023) {
                    $data['status'] = 2;
                    $error_data['code'] = 'INVALID_YEAR';
                    $error_data['message'] = \Yii::$app->params['INVALID_YEAR'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                } else {

                    $data['success']['code'] = 'TAGGING_STATS_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['TAGGING_STATS_DISPLAYED_SUCCESSFULLY'];

                    $get_tag_list = $common_model->gettagstatsmonthlyapi($get_user, $querydata);
                    $data['data'] = $get_tag_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionCreatemultiple()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $tagging = null;

                if (!empty($cp_id)) {

                    if (!empty($this->request->post())) {
                        $postdata = $this->request->post();
                        foreach ($postdata['tagging'] as $postdata_key => $postdata_val) {

                            $formdata['Taggingmaster'] = $postdata_val;
                            $lead_model = Leadmaster::findOne(['id' => $formdata['Taggingmaster']['lead_id']]);
                            if (empty($lead_model)) {
                                //$data['status'] = 2;
                                $error_data['code'] = 'LEAD_NOT_EXIST';
                                $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['lead_id'], \Yii::$app->params['LEAD_NOT_EXIST']);
                                //$error['error'] = $error;
                                //$data['error'] = $error_data;
                                $tagging[$postdata_key]['error'] = $error_data;
                            } else {
                                $formdata['Taggingmaster']['tag_name'] = $lead_model->name;
                                $formdata['Taggingmaster']['tag_email'] = $lead_model->email;
                                $formdata['Taggingmaster']['tag_phone'] = $lead_model->contact;
                                $formdata['Taggingmaster']['budget'] = $lead_model->budget;
                                $formdata['Taggingmaster']['followup_date'] = $lead_model->followup_date;
                                $formdata['Taggingmaster']['customer_type'] = $lead_model->customer_type;
                                $formdata['Taggingmaster']['flat_type_id'] = $lead_model->flat_type_id;
                                $formdata['Taggingmaster']['flat_property_type'] = $lead_model->flat_property_type;

                                $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                                if (
                                    empty($formdata['Taggingmaster']['lead_id']) ||
                                    empty($formdata['Taggingmaster']['project_id']) ||
                                    empty($formdata['Taggingmaster']['appointment_date']) ||
                                    empty($formdata['Taggingmaster']['sm_cp_id']) ||
                                    empty($formdata['Taggingmaster']['appointment_time'])
                                ) {
                                    //$data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                    //$data['error'] = $error_data;
                                    $tagging[$postdata_key]['error'] = $error_data;
                                } else if ($formdata['Taggingmaster']['appointment_date'] != date('Y-m-d')) {
                                    /* else if (($formdata['Taggingmaster']['appointment_date'] < date('Y-m-d')) || ($formdata['Taggingmaster']['appointment_date'] > $twodate)) { */
                                    //$data['status'] = 2;
                                    $error_data['code'] = 'APPOINTMENT_DATE_TODAY_ONLY';
                                    $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_TODAY_ONLY'];
                                    //$data['error'] = $error_data;
                                    $tagging[$postdata_key]['error'] = $error_data;
                                } else {
                                    $formdata['Taggingmaster']['created_by'] = $sm_cp_id;
                                    $formdata['Taggingmaster']['cp_id'] = $cp_id;
                                    $formdata['Taggingmaster']['created_on'] = date('Y-m-d H:i:s');
                                    $formdata['Taggingmaster']['modified_by'] = $sm_cp_id;
                                    $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');

                                    $common_model = new Common();
                                    //get tag code
                                    $getcp_data = $common_model->getcp($cp_id);
                                    $getcp_compname = $getcp_data['company_name'];
                                    $getcp_compname = preg_replace('/\s+/', '', $getcp_compname);
                                    $get_sb_cp = substr($getcp_compname, 0, 6);
                                    $str_result = '0123456789';
                                    $num_code =    substr(str_shuffle($str_result), 0, 4) . date('dmy');
                                    //$formdata['Taggingmaster']['tag_code'] = $get_sb_cp . "@" . $num_code;
                                    $formdata['Taggingmaster']['tag_code'] = "APC@" . $num_code;

                                    //check if already same tagging is in progress
                                    $sql_check_exist = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND cp_id='" . $cp_id . "' AND status=0 AND is_deleted=0 AND appointment_date='" . date('Y-m-d') . "' ";
                                    $user_count_check = Taggingmaster::findBySql($sql_check_exist)->count();
                                    if ($user_count_check == 0) {

                                        //only 4 times allowed for per customer with same project per month.
                                        //check entries of that contact for project
                                        $sql_check = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND is_deleted=0 AND cp_id='" . $cp_id . "' AND appointment_date BETWEEN '" . date('Y-m-01') . "' AND '" . date('Y-m-d') . "' ";
                                        $user_count = Taggingmaster::findBySql($sql_check)->count();
                                        if ($user_count <= intval(\Yii::$app->params['TAG_SAME_CUST_MONTH_MAX'])) {
                                            $tagging_model = new Taggingmaster();


                                            if ($tagging_model->load($formdata)) {
                                                if ($tagging_model->save()) {

                                                    $tag_id = $tagging_model->id;
                                                    //update lead id and get lead details
                                                    $tagging_model->tagging_id = "TAG" . date('d') . date('m') . date('y') . $tag_id;
                                                    $tagging_model->save();

                                                    if (!empty($formdata['Taggingmaster']['feedback'])) {
                                                        //Add entry in feedback table
                                                        $tag_feedback_model = new TaggingFeedback();
                                                        $tag_feedback_model->tagging_id = $tag_id;
                                                        $tag_feedback_model->feedback = $formdata['Taggingmaster']['feedback'];
                                                        $tag_feedback_model->created_on = date('Y-m-d H:i:s');
                                                        $tag_feedback_model->created_by = $sm_cp_id;
                                                        $tag_feedback_model->save();
                                                    }


                                                    $lead_model->tagging = 1;
                                                    $lead_model->save();

                                                    $common_model = new Common();
                                                    /* $data['success']['code'] = 'TAGGING_CREATED_SUCCESSFULLY';
                                            $data['success']['message'] = \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY']; */

                                                    $get_tag = $common_model->gettagapi($tag_id, $tagging_model, 1);
                                                    //$data['data'] = $get_tag;
                                                    $tagging[$postdata_key]['success']['code'] =
                                                        'TAGGING_CREATED_SUCCESSFULLY';
                                                    $tagging[$postdata_key]['success']['message'] =
                                                        \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY'];
                                                    $tagging[$postdata_key]['tagginginfo'] = $get_tag['tagging'];
                                                } else {

                                                    $formerrordata['post_data'] = "error while adding data in taggingmaster " . json_encode($formdata);
                                                    $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                    Yii::$app->common->addlog($formerrordata);

                                                    //$data['status'] = 2;
                                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                    //$error['error'] = $error;
                                                    //$data['error'] = $error_data;
                                                    $tagging[$postdata_key]['error'] = $error_data;
                                                    Yii::$app->response->statusCode = 500;
                                                }
                                            } else {
                                                $formerrordata['post_data'] = "error while loading data in taggingmaster " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($lead_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                //$data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                //$data['error'] = $error_data;
                                                $tagging[$postdata_key]['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            //$data['status'] = 2;
                                            $error_data['code'] = 'TAG_SAME_CUST_MONTH_MAX_EXHAUSTED';
                                            $error_data['message'] = \Yii::$app->params['TAG_SAME_CUST_MONTH_MAX_EXHAUSTED'];
                                            //$error['error'] = $error;
                                            //$data['error'] = $error_data;
                                            $tagging[$postdata_key]['error'] = $error_data;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = 'TAGGING_ALREADY_EXIST';
                                        $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['tag_phone'], \Yii::$app->params['LEAD_ALREADY_EXIST']);
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                }
                            }
                        }
                        $data['data']['tagging'] = $tagging;
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}
