<?php

namespace app\modules\api\controllers;

use app\models\Channelpartner;
use app\models\Common;
use app\models\CpCustomersFlats;
use app\models\CpCustomersFlatsSpam;
use app\models\CpCustomersFlatsView;
use app\models\Location;
use app\models\NotificationMaster;
use app\models\PostingBookmark;
use app\models\SmCp;
use app\models\Staff;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class CpconnectController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'postdata' => ['POST'],
                        'mypostlist' => ['GET'],
                        'adslist' => ['GET'],
                        'mypostdetail' => ['GET'],
                        'mypostresults' => ['GET'],
                        'mypostlocresults' => ['GET'],
                        'postviewed' => ['GET'],
                        'bookmark' => ['POST'],
                        'bookmarklist' => ['GET'],
                        'detail' => ['GET'],
                        'spam' => ['POST'],
                        'update' => ['PUT'],
                        'markview' => ['POST'],
                        'listpost' => ['GET'],
                        'stats' => ['GET'],
                        'insight' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['postdata', 'mypostlist', 'listpost', 'mypostdetail', 'mypostresults', 'mypostlocresults', 'postviewed', 'update', 'detail', 'spam', 'markview', 'bookmark', 'bookmarklist', 'adslist', 'stats', 'insight'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionPostdata()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            $common_model = new Common();

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                if (empty($cp_id) || $app_features != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    if (!empty($this->request->post())) {
                        $formdata['CpCustomersFlats'] = $this->request->post();

                        if (
                            empty($formdata['CpCustomersFlats']['location_id']) ||
                            empty($formdata['CpCustomersFlats']['title']) ||
                            empty($formdata['CpCustomersFlats']['carpet'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {

                            $formdata['CpCustomersFlats']['sm_cp_id'] = $sm_cp_id;
                            $formdata['CpCustomersFlats']['created_on'] = date('Y-m-d H:i:s');
                            $formdata['CpCustomersFlats']['modified_by'] = $sm_cp_id;
                            $formdata['CpCustomersFlats']['modified_on'] = date('Y-m-d H:i:s');
                            $formdata['CpCustomersFlats']['status'] = "0";

                            if (
                                empty($formdata['CpCustomersFlats']['post_for']) ||
                                !isset($formdata['CpCustomersFlats']['post_for'])
                            ) {
                                $formdata['CpCustomersFlats']['post_for'] = 1;
                            }

                            if (
                                empty($formdata['CpCustomersFlats']['flat_property_type']) ||
                                !isset($formdata['CpCustomersFlats']['flat_property_type'])
                            ) {
                                $formdata['CpCustomersFlats']['flat_property_type'] = 1;
                            }
                            $posted_flat_type_id = null;
                            if ($formdata['CpCustomersFlats']['flat_property_type'] != 1) {
                                $formdata['CpCustomersFlats']['flat_type_id'] = null;
                            } else {
                                if (!empty($formdata['CpCustomersFlats']['flat_type_id'])) {
                                    $posted_flat_type_id = $formdata['CpCustomersFlats']['flat_type_id'];
                                }
                            }
                            /* echo "saaaeeee";
                            exit; */
                            //check if already same data already added

                            $carpet_txt = "";
                            $min_carpet_txt = intval($formdata['CpCustomersFlats']['carpet']) - 50;
                            $max_carpet_txt = intval($formdata['CpCustomersFlats']['carpet']) + 50;
                            $carpet_txt = " AND carpet BETWEEN " . $min_carpet_txt . " AND " . $max_carpet_txt;
                            if ($formdata['CpCustomersFlats']['post_for'] == 1) {
                                //for sales
                                $budget_txt = "";
                                $min_budget_txt = intval($formdata['CpCustomersFlats']['budget']) - 1000000;
                                $max_budget_txt = intval($formdata['CpCustomersFlats']['budget']) + 1000000;
                                $budget_txt = " AND budget BETWEEN " . $min_budget_txt . " AND " . $max_budget_txt;



                                $sql_check_exist = "SELECT id FROM cp_customers_flats WHERE location_id='" . $formdata['CpCustomersFlats']['location_id'] . "' AND type='" . $formdata['CpCustomersFlats']['type'] . "'" . $budget_txt . " AND flat_property_type='" . $formdata['CpCustomersFlats']['flat_property_type'] . "' AND flat_type_id='" . $posted_flat_type_id . "'" . $carpet_txt . " AND sm_cp_id='" . $sm_cp_id . "' AND status IN(0,1) ";
                            } else {

                                //for rental
                                $monthly_rent_txt = "";
                                $min_monthly_rent_txt = intval($formdata['CpCustomersFlats']['monthly_rent']) - 5000;
                                $max_monthly_rent_txt = intval($formdata['CpCustomersFlats']['monthly_rent']) + 5000;
                                $monthly_rent_txt = " AND monthly_rent BETWEEN " . $min_monthly_rent_txt . " AND " . $max_monthly_rent_txt;

                                $sql_check_exist = "SELECT id FROM cp_customers_flats WHERE location_id='" . $formdata['CpCustomersFlats']['location_id'] . "' AND rental_type='" . $formdata['CpCustomersFlats']['rental_type'] . "' " . $monthly_rent_txt . " AND deposit='" . $formdata['CpCustomersFlats']['deposit'] . "' AND flat_property_type='" . $formdata['CpCustomersFlats']['flat_property_type'] . "' AND flat_type_id='" . $posted_flat_type_id . "'" . $carpet_txt . " AND sm_cp_id='" . $sm_cp_id . "' AND status IN(0,1) ";
                            }
                            $post_count_check = CpCustomersFlats::findBySql($sql_check_exist)->count();
                            /* echo  $post_count_check;
                            exit; */

                            if ($post_count_check == 0) {

                                $cp_post_model = new CpCustomersFlats();

                                if ($cp_post_model->load($formdata)) {

                                    if ($cp_post_model->save()) {

                                        $post_id = $cp_post_model->id;

                                        $cp_post_model->post_id = "POST" . date('Y') . date('m') . $post_id;
                                        $cp_post_model->save();

                                        //$cp_post_model->save();
                                        if ($cp_post_model->post_for == 1) {
                                            if ($cp_post_model->type == 1) {
                                                $data['success']['code'] = 'BUYER_LISTED_SUCCESSFULY';
                                                $data['success']['message'] = \Yii::$app->params['BUYER_LISTED_SUCCESSFULY'];
                                            } else {
                                                $data['success']['code'] = 'SELLER_LISTED_SUCCESSFULY';
                                                $data['success']['message'] = \Yii::$app->params['SELLER_LISTED_SUCCESSFULY'];
                                            }
                                        } else {
                                            if ($cp_post_model->rental_type == 1) {
                                                $data['success']['code'] = 'OWNER_LISTED_SUCCESSFULY';
                                                $data['success']['message'] = \Yii::$app->params['OWNER_LISTED_SUCCESSFULY'];
                                            } else {
                                                $data['success']['code'] = 'TENANT_LISTED_SUCCESSFULY';
                                                $data['success']['message'] = \Yii::$app->params['TENANT_LISTED_SUCCESSFULY'];
                                            }
                                        }

                                        $get_post = $common_model->getpost($post_id, $cp_post_model, true);
                                        $data['data'] = $get_post;
                                    } else {

                                        $formerrordata['post_data'] = "error while creating posting " . json_encode($formdata);
                                        $formerrordata['error'] = json_encode($cp_post_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        Yii::$app->response->statusCode = 500;
                                    }
                                } else {
                                    $formerrordata['post_data'] = "error while creating posting " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($cp_post_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = 'POST_ALREADY_EXIST';
                                $error_data['message'] = \Yii::$app->params['POST_ALREADY_EXIST'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionBookmark($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /*  $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                //check if posting exist
                $pr_data = CpCustomersFlats::find()->select('title')->where(['id' => $id])->one();
                if (!empty($pr_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;
                        $builder_id = $get_user->builder_id;
                        $is_mgmt = $get_user->mgmt;

                        $common_model = new Common();

                        $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                        $app_features = 0;
                        if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                            $app_features = $get_cp_data->app_features;
                        }

                        if (empty($cp_id) || $app_features != 1) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            //$update_success = false;
                        } else {



                            if (!empty($this->request->post())) {
                                $formdata['PostingBookmark'] = $this->request->post();
                                if (empty($formdata['PostingBookmark']['bookmark'])) {
                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                    $data['error'] = $error_data;
                                } else {
                                    //check entries of that project
                                    $sql_check = "SELECT id FROM posting_bookmark WHERE sm_cp_id='" . $sm_cp_id . "' AND posting_id='" . $id . "' ";
                                    $bookmark_count = PostingBookmark::findBySql($sql_check)->count();

                                    /* //add entry in view table
                                    $post_view_model = new CpCustomersFlatsView();
                                    $post_view_model->sm_cp_id = $sm_cp_id;
                                    $post_view_model->post_id = $id;
                                    $post_view_model->view_type = 2;
                                    $post_view_model->created_on = date('Y-m-d H:i:s');
                                    $post_view_model->save(); */

                                    if ($formdata['PostingBookmark']['bookmark'] == 'true') {
                                        if ($bookmark_count == 0) {
                                            $formdata['PostingBookmark']['sm_cp_id'] = $sm_cp_id;
                                            $formdata['PostingBookmark']['posting_id'] = $id;
                                            $formdata['PostingBookmark']['created_on'] = date('Y-m-d H:i:s');

                                            $postbookmark_model = new PostingBookmark();
                                            if ($postbookmark_model->load($formdata)) {
                                                if ($postbookmark_model->save()) {
                                                    $data['success']['code'] = 'BOOKMARK_ADDED_SUCCESSFULY';
                                                    $data['success']['message'] = \Yii::$app->params['BOOKMARK_ADDED_SUCCESSFULY'];
                                                } else {
                                                    $formerrordata['post_data'] = "error while saving data in posting bookmark " . json_encode($formdata);
                                                    $formerrordata['error'] = json_encode($postbookmark_model->getErrors());
                                                    Yii::$app->common->addlog($formerrordata);

                                                    $data['status'] = 2;
                                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                    //$error['error'] = $error;
                                                    $data['error'] = $error_data;
                                                    Yii::$app->response->statusCode = 500;
                                                }
                                            } else {
                                                $formerrordata['post_data'] = "error while loading data in posting bookmark " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($postbookmark_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $data['success']['code'] = 'BOOKMARK_ADDED_SUCCESSFULY';
                                            $data['success']['message'] = \Yii::$app->params['BOOKMARK_ADDED_SUCCESSFULY'];
                                        }
                                    } else if ($formdata['PostingBookmark']['bookmark'] == 'false') {
                                        if ($bookmark_count == 0) {
                                            $data['success']['code'] = 'BOOKMARK_REMOVED_SUCCESSFULY';
                                            $data['success']['message'] = \Yii::$app->params['BOOKMARK_REMOVED_SUCCESSFULY'];
                                        } else {
                                            $data['success']['code'] = 'BOOKMARK_REMOVED_SUCCESSFULY';
                                            $data['success']['message'] = \Yii::$app->params['BOOKMARK_REMOVED_SUCCESSFULY'];
                                            $bookmark_delete = PostingBookmark::find()
                                                ->where(['sm_cp_id' => $sm_cp_id])
                                                ->andwhere(['posting_id' => $id])
                                                ->one()
                                                ->delete();
                                        }
                                    }
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        }


                        /* if ($data['status'] == 1) {
                                $get_proj_details = $common_model->getprojectapi($id, $sm_cp_id);
                                $data['data'] = $get_proj_details;
                            } */
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'POSTING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['POSTING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while posting bookmark posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while posting bookmark posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while posting bookmark posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while posting bookmark posting";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionMypostlist()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                if (empty($cp_id) || $app_features != 1) {

                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    $common_model = new Common();
                    /* $querydata = $this->request->get();
                    unset($querydata['r']); */
                    $querydata = $this->request->get();

                    $data['success']['code'] = 'POSTING_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['POSTING_DISPLAYED_SUCCESSFULLY'];
                    //$get_proj = $this->getprojofmultism($get_sm);
                    $get_tag_list = $common_model->getmypost($get_user, $querydata);
                    $data['data'] = $get_tag_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting my post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionBookmarklist()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                if (empty($cp_id) || $app_features != 1) {

                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {


                    /* $querydata = $this->request->get();
                    unset($querydata['r']); */
                    $querydata = $this->request->get();

                    $data['success']['code'] = 'POSTING_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['POSTING_DISPLAYED_SUCCESSFULLY'];

                    $get_proj_list = $common_model->getmypost($get_user, $querydata);
                    $data['data'] = $get_proj_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting posting bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }



    public function actionListpost()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                if (empty($cp_id) || $app_features != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    $common_model = new Common();
                    /* $querydata = $this->request->get();
                        unset($querydata['r']); */
                    $querydata = $this->request->get();

                    if (
                        empty($querydata['location_id']) ||
                        empty($querydata['budget']) ||
                        empty($querydata['carpet'])
                    ) {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                    } else {

                        $data['success']['code'] = 'POSTING_DISPLAYED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['POSTING_DISPLAYED_SUCCESSFULLY'];
                        //$get_proj = $this->getprojofmultism($get_sm);
                        $get_tag_list = $common_model->getlistpost($get_user, $querydata);
                        $data['data'] = $get_tag_list;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting search post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting search post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting search post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting search post list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionAdslist()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                if (empty($cp_id) || $app_features != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    $common_model = new Common();
                    /* $querydata = $this->request->get();
                        unset($querydata['r']); */
                    $querydata = $this->request->get();



                    $data['success']['code'] = 'POSTING_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['POSTING_DISPLAYED_SUCCESSFULLY'];
                    //$get_proj = $this->getprojofmultism($get_sm);
                    $get_tag_list = $common_model->getlistads($get_user, $querydata);
                    $data['data'] = $get_tag_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting ads list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting ads list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting ads list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting ads list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMypostdetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            if (!empty($id)) {

                $post_data = CpCustomersFlats::find()->where('id="' . $id . '" ')->one();

                if (!empty($post_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;
                        $show_post = "1";

                        $get_members = $common_model->getaccessmembers($sm_cp_id);

                        if ($post_data->sm_cp_id != $sm_cp_id) {
                            if (!in_array($post_data->sm_cp_id, $get_members)) {
                                $show_post = "";
                            }
                        }

                        $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                        $app_features = 0;
                        if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                            $app_features = $get_cp_data->app_features;
                        }

                        if (empty($cp_id) || empty($show_post) || $app_features != 1) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            //$update_success = false;
                        } else {

                            $data['success']['code'] = 'POSTING_DETAIL_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['POSTING_DETAIL_DISPLAYED_SUCCESSFULLY'];
                            $get_post_details = $common_model->getpost($id, $post_data, true);
                            $data['data'] = $get_post_details;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'POSTING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['POSTING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionInsight()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();

        $querydata = $this->request->get();
        //get location or subtype
        $loc_id = isset($querydata['location_id']) ? $querydata['location_id'] : "";
        $loc_subtype_id = isset($querydata['location_subtype_id']) ? $querydata['location_subtype_id'] : "";


        try {
            if (!empty($loc_id) || !empty($loc_subtype_id)) {

                $headers = $this->request->headers;
                $get_user_data = Yii::$app->common->apikey_verify($headers);
                if (!empty($get_user_data['sm_cp_data'])) {
                    $get_user = $get_user_data['sm_cp_data'];

                    $sm_cp_id = $get_user->sm_cp_id;
                    $cp_id = $get_user->channelpartner_id;


                    $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                    $app_features = 0;
                    if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                        $app_features = $get_cp_data->app_features;
                    }

                    if (empty($cp_id) || $app_features != 1) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        //$update_success = false;
                    } else {

                        $data['success']['code'] = 'INSIGHTS_DISPLAYED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['INSIGHTS_DISPLAYED_SUCCESSFULLY'];
                        //pending from here
                        $get_insight_details = $common_model->get_insight($querydata);
                        $data['data'] = $get_insight_details;
                    }
                } else {
                    $data['status'] = 2;
                    $data['error'] = $get_user_data['error'];
                    Yii::$app->response->statusCode = 401;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting insights";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting insights";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting insights";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting posting insights";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMypostresults($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            if (!empty($id)) {

                $post_data = CpCustomersFlats::find()->where('id="' . $id . '" ')->one();

                if (!empty($post_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;

                        $cp_id = $get_user->channelpartner_id;
                        $show_post = "1";

                        $get_members = $common_model->getaccessmembers($sm_cp_id);

                        if ($post_data->sm_cp_id != $sm_cp_id || $post_data->status != 1) {
                            if (!in_array($post_data->sm_cp_id, $get_members)) {
                                $show_post = "";
                            }
                        }

                        $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                        $app_features = 0;
                        if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                            $app_features = $get_cp_data->app_features;
                        }

                        if (empty($cp_id) || empty($show_post) || $app_features != 1) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            //$update_success = false;
                        } else {
                            $post_data_arr['post_for'] = $post_data->post_for;
                            if ($post_data->post_for == 1) {
                                if ($post_data->type == 1) {
                                    $data['success']['code'] = 'SELLER_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['SELLER_LISTED_SUCCESSFULY'];
                                    $find_type = 2;
                                } else {
                                    $data['success']['code'] = 'BUYER_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['BUYER_LISTED_SUCCESSFULY'];
                                    $find_type = 1;
                                }
                                $post_data_arr['type'] = $find_type;
                            } else {
                                if ($post_data->rental_type == 1) {
                                    $data['success']['code'] = 'TENANT_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['TENANT_LISTED_SUCCESSFULY'];
                                    $find_type = 2;
                                } else {
                                    $data['success']['code'] = 'OWNER_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['OWNER_LISTED_SUCCESSFULY'];
                                    $find_type = 1;
                                }
                                $post_data_arr['rental_type'] = $find_type;
                            }


                            $post_data_arr['flat_type_id'] = $post_data->flat_type_id;
                            $post_data_arr['flat_property_type'] = $post_data->flat_property_type;
                            $post_data_arr['carpet'] = $post_data->carpet;

                            $querydata = $this->request->get();
                            foreach ($querydata as $querydata_key => $querydata_val) {
                                $post_data_arr[$querydata_key] = $querydata_val;
                            }
                            if (!empty($querydata['searchBy'])) {
                                if ($post_data->post_for == 1) {
                                    if ($querydata['searchBy'] == 1) {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['budget'] = $post_data->budget;
                                        $post_data_arr['searchBy'] = 1;
                                    } elseif ($querydata['searchBy'] == 2) {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['searchBy'] = 2;
                                    } elseif ($querydata['searchBy'] == 3) {
                                        $post_data_arr['budget'] = $post_data->budget;
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['searchBy'] = 3;
                                    } elseif ($querydata['searchBy'] == 4) {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['budget'] = $post_data->budget;
                                        $post_data_arr['searchBy'] = 4;
                                    } else {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['budget'] = $post_data->budget;
                                        $post_data_arr['searchBy'] = 0;
                                    }
                                } else {
                                    if ($querydata['searchBy'] == 1) {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['rent'] = $post_data->monthly_rent;
                                        $post_data_arr['searchBy'] = 1;
                                    } elseif ($querydata['searchBy'] == 2) {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['searchBy'] = 2;
                                    } elseif ($querydata['searchBy'] == 3) {
                                        $post_data_arr['rent'] = $post_data->monthly_rent;
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['searchBy'] = 3;
                                    } elseif ($querydata['searchBy'] == 4) {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['rent'] = $post_data->monthly_rent;
                                        $post_data_arr['searchBy'] = 4;
                                    } else {
                                        $post_data_arr['location_id'] = $post_data->location_id;
                                        $post_data_arr['rent'] = $post_data->monthly_rent;
                                        $post_data_arr['searchBy'] = 0;
                                    }
                                }
                            } else {
                                $post_data_arr['location_id'] = $post_data->location_id;
                                $post_data_arr['budget'] = $post_data->budget;
                                $post_data_arr['rent'] = $post_data->monthly_rent;
                            }

                            $post_data_arr['post_id'] = $id;
                            if (!empty($querydata['viewBy'])) {
                                //$post_data_arr['viewBy'] = $querydata['viewBy'];
                                //$post_data_arr['sm_cp_id'] = $id;
                            }

                            /* echo "<pre>";
                            print_r($post_data_arr);
                            exit;
                            */
                            $get_post_details = $common_model->getmypostlist($get_user, $post_data_arr);

                            /* echo "<pre>";
                            print_r($get_post_details);
                            exit; */

                            $data['data'] = $get_post_details;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'POSTING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['POSTING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my posting list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my posting list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my posting list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting my posting list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMypostlocresults($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            if (!empty($id)) {

                $post_data = CpCustomersFlats::find()->where('id="' . $id . '" ')->one();

                if (!empty($post_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;

                        $cp_id = $get_user->channelpartner_id;
                        $show_post = "1";

                        $get_members = $common_model->getaccessmembers($sm_cp_id);

                        if ($post_data->sm_cp_id != $sm_cp_id || $post_data->status != 1) {
                            if (!in_array($post_data->sm_cp_id, $get_members)) {
                                $show_post = "";
                            }
                        }

                        $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                        $app_features = 0;
                        if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                            $app_features = $get_cp_data->app_features;
                        }

                        if (empty($cp_id) || empty($show_post) || $app_features != 1) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            //$update_success = false;
                        } else {

                            $get_loc = Location::find()->where(['id' => $post_data->location_id])->one();
                            $loc_name = $get_loc->name;

                            $post_data_arr['post_for'] = $post_data->post_for;
                            if ($post_data->post_for == 1) {

                                $post_data_arr['type'] = $post_data->type;
                                if ($post_data->type == 1) {
                                    $data['success']['code'] = 'OTHER_BUYER_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['OTHER_BUYER_LISTED_SUCCESSFULY'] . " " . $loc_name;
                                    $find_type = 2;
                                } else {
                                    $data['success']['code'] = 'OTHER_SELLER_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['OTHER_SELLER_LISTED_SUCCESSFULY'] . " " . $loc_name;
                                    $find_type = 1;
                                }
                            } else {
                                $post_data_arr['rental_type'] = $post_data->rental_type;
                                if ($post_data->rental_type == 1) {
                                    $data['success']['code'] = 'OTHER_OWNER_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['OTHER_OWNER_LISTED_SUCCESSFULY'] . " " . $loc_name;
                                    $find_type = 2;
                                } else {
                                    $data['success']['code'] = 'OTHER_TENANT_LISTED_SUCCESSFULY';
                                    $data['success']['message'] = \Yii::$app->params['OTHER_TENANT_LISTED_SUCCESSFULY'] . " " . $loc_name;
                                    $find_type = 1;
                                }
                            }


                            $post_data_arr['post_id'] = $id;
                            $post_data_arr['location_id'] = $post_data->location_id;







                            $get_post_details = $common_model->getotherpostlist($get_user, $post_data_arr);

                            /* echo "<pre>";
                            print_r($get_post_details);
                            exit; */

                            $data['data'] = $get_post_details;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'POSTING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['POSTING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my posting loc list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my posting loc list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting my posting loc list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting my posting loc list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionPostviewed()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {


            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;

                $cp_id = $get_user->channelpartner_id;
                $show_post = "1";

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                $querydata = $this->request->get();

                if (empty($cp_id) || empty($show_post) || $app_features != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    $data['success']['code'] = 'POSTING_VIEWED_LISTED_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['POSTING_VIEWED_LISTED_SUCCESSFULY'];


                    $get_post_details = $common_model->getviewedpostlist($get_user, $querydata);

                    $data['data'] = $get_post_details;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting post viewed list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting post viewed list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting post viewed list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting post viewed list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionUpdate($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['CpCustomersFlats'] = null;
        $connect_status = array('0' => 'In Progress', '1' => 'Verified', '2' => 'Expired', '3' => 'Blocked', '4' => 'Deal Closed');
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                if (empty($cp_id) || $app_features != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {

                    $update_success = true;
                    if (!empty($id)) {

                        $connect_data = CpCustomersFlats::find()->where('id="' . $id . '" ')->one();
                        if (!empty($connect_data)) {

                            if (empty($cp_id) || in_array($connect_data->status, [2, 4])) {
                                $data['status'] = 2;
                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                $update_success = false;
                            } else {

                                $common_model = new Common();
                                //check if cp has access to cp connect
                                $check_access = $common_model->checkconnectaccess($sm_cp_id, $id);

                                if ($check_access) {

                                    if (!empty($this->request->post())) {
                                        $formdata['CpCustomersFlats'] = $this->request->post();
                                        if (!empty($formdata['CpCustomersFlats'])) {

                                            foreach ($formdata['CpCustomersFlats'] as $formdata_key => $formdata_val) {
                                                if (in_array($connect_data->status, [1])) {
                                                    if (in_array($formdata_key, ['budget', 'status'])) {
                                                        $connect_data->$formdata_key = $formdata_val;
                                                    }
                                                } else {
                                                    $connect_data->$formdata_key = $formdata_val;
                                                }
                                            }
                                        } else {
                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                            $data['error'] = $error_data;
                                            $update_success = false;
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        $update_success = false;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    $update_success = false;
                                }
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'POSTING_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['POSTING_NOT_EXIST']);
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                        $data['error'] = $error_data;
                        $update_success = false;
                    }


                    if ($update_success) {
                        //check if duplicate
                        if ($connect_data->status == 0) {


                            //check if already same data already added

                            $carpet_txt = "";
                            $min_carpet_txt = intval($connect_data->carpet) - 50;
                            $max_carpet_txt = intval($connect_data->carpet) + 50;
                            $carpet_txt = " AND carpet BETWEEN " . $min_carpet_txt . " AND " . $max_carpet_txt;

                            $posted_flat_type_id = $connect_data->flat_type_id;

                            if ($connect_data->post_for == 1) {
                                //for sales
                                $budget_txt = "";
                                $min_budget_txt = intval($connect_data->budget) - 1000000;
                                $max_budget_txt = intval($connect_data->budget) + 1000000;
                                $budget_txt = " AND budget BETWEEN " . $min_budget_txt . " AND " . $max_budget_txt;



                                $sql_check_exist = "SELECT id FROM cp_customers_flats WHERE location_id='" . $connect_data->location_id . "' AND type='" . $$connect_data->type . "'" . $budget_txt . " AND flat_property_type='" . $connect_data->flat_property_type . "' AND flat_type_id='" . $posted_flat_type_id . "'" . $carpet_txt . " AND sm_cp_id='" . $sm_cp_id . "' AND status IN(0,1) AND id!='" . $id . "' ";
                            } else {

                                //for rental
                                $monthly_rent_txt = "";
                                $min_monthly_rent_txt = intval($connect_data->monthly_rent) - 5000;
                                $max_monthly_rent_txt = intval($connect_data->monthly_rent) + 5000;
                                $monthly_rent_txt = " AND monthly_rent BETWEEN " . $min_monthly_rent_txt . " AND " . $max_monthly_rent_txt;

                                $sql_check_exist = "SELECT id FROM cp_customers_flats WHERE location_id='" . $connect_data->location_id . "' AND rental_type='" . $connect_data->rental_type . "' " . $monthly_rent_txt . " AND deposit='" . $connect_data->deposit . "' AND flat_property_type='" . $connect_data->flat_property_type . "' AND flat_type_id='" . $posted_flat_type_id . "'" . $carpet_txt . " AND sm_cp_id='" . $sm_cp_id . "' AND status IN(0,1) AND id!='" . $id . "' ";
                            }
                            $post_count_check = CpCustomersFlats::findBySql($sql_check_exist)->count();

                            if (!empty($post_count_check)) {
                                $update_success = false;

                                $data['status'] = 2;
                                $error_data['code'] = 'POST_ALREADY_EXIST';
                                $error_data['message'] = \Yii::$app->params['POST_ALREADY_EXIST'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        }
                    }




                    if ($update_success) {

                        $connect_data->modified_on = date('Y-m-d H:i:s');
                        $connect_data->modified_by = $sm_cp_id;

                        //if posting is expired then update counts
                        if (in_array($connect_data->status, [2, 4])) {
                            $get_final_data = $common_model->getfinalpostcount($id);

                            if (!empty($get_final_data)) {
                                $connect_data->all_count =  $get_final_data['all_count'];
                                $connect_data->location_count =  $get_final_data['location_count'];
                                if ($connect_data->post_for == 1) {
                                    $connect_data->budget_count =  $get_final_data['budget_count'];
                                } else {
                                    $connect_data->budget_count =  $get_final_data['rent_count'];
                                }
                                $connect_data->combine_count =  $get_final_data['combine_count'];
                                $connect_data->view_count =  $get_final_data['view_count'];
                            }
                        }

                        if ($connect_data->save()) {

                            $data['success']['code'] = 'POSTING_UPDATED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['POSTING_UPDATED_SUCCESSFULLY'];

                            $get_post_details = $common_model->getpost($id, $connect_data, true);
                            $data['data'] = $get_post_details;
                        } else {
                            $formerrordata['post_data'] = "error while updating cpconnect post data " . json_encode($formdata);
                            $formerrordata['error'] = json_encode($connect_data->getErrors());
                            Yii::$app->common->addlog($formerrordata);

                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            Yii::$app->response->statusCode = 500;
                        }
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while updating cpconnect post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while updating cpconnect post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while updating cpconnect post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while updating cpconnect post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMarkview()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['CpCustomersFlatsView'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                //get rm data
                $get_rm = isset($get_cp_data->rm) ? $get_cp_data->rm : "";
                $get_rm_name = "";
                $get_rm_contact = "";
                if (!empty($get_rm)) {
                    $get_rm_data = Staff::find()->where(['id' => $get_cp_data->rm])->one();
                    $get_rm_name = isset($get_rm_data->name) ? $get_rm_data->name : "";
                    $get_rm_contact = isset($get_rm_data->staff_contact) ? $get_rm_data->staff_contact : "";
                }

                $supportcontact = "8855022798";
                //check if view access or not
                $view_posting_cp = false;
                $user_package_id = $get_user->package_id;
                $get_package_details = $common_model->getpackage($get_user->package_id);
                if (!empty($get_package_details)) {
                    if (isset($get_package_details['view_posting_cp'])) {
                        if ($get_package_details['view_posting_cp'] == 1) {
                            $view_posting_cp = true;
                        }
                    }
                }
                if ($view_posting_cp) {

                    $app_features = 0;
                    if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                        $app_features = $get_cp_data->app_features;
                    }

                    if (empty($cp_id) || $app_features != 1) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        //$update_success = false;
                    } else {

                        $common_model = new Common();
                        //check if cp has already viewed

                        if (!empty($this->request->post())) {
                            $formdata['CpCustomersFlatsView'] = $this->request->post();
                            if (!empty($formdata['CpCustomersFlatsView'])) {
                                $get_my_post_id = $formdata['CpCustomersFlatsView']['my_post_id'];

                                //check if view limit is available
                                $get_post_stat = $common_model->getpostinglimit($get_my_post_id, $sm_cp_id);
                                //for silver package only 5 visits allowed

                                if ($user_package_id == 6) {
                                    $limit_count = 5;
                                    $get_view_count = intval($get_post_stat['view_count']);
                                    $available_count = $limit_count - $get_view_count;
                                } else {
                                    $available_count = 5;
                                }
                                //$available_count = intval($get_post_stat['available_count']);
                                //for now give access to all

                                if ($available_count > 0) {


                                    $connect_data = CpCustomersFlats::find()->where('id="' . $get_my_post_id . '" ')->one();

                                    if (!empty($connect_data)) {

                                        if (empty($cp_id) || $connect_data->status == 3) {
                                            $data['status'] = 2;
                                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            $update_success = false;
                                        } else {

                                            //check if cp has access to cp connect
                                            $check_access = $common_model->checkconnectaccess($sm_cp_id, $get_my_post_id);

                                            if ($check_access) {

                                                $get_post_id = $formdata['CpCustomersFlatsView']['post_id'];
                                                $update_view_model = CpCustomersFlatsView::findOne(['my_post_id' => $get_my_post_id, 'post_id' => $get_post_id, 'sm_cp_id' => $sm_cp_id]);
                                                if (!empty($update_view_model)) {
                                                    $update_view_model->created_on = date('Y-m-d H:i:s');
                                                    $update_view_model->save();
                                                } else {
                                                    $update_view_model = new CpCustomersFlatsView();
                                                    $update_view_model->my_post_id = $get_my_post_id;
                                                    $update_view_model->post_id = $get_post_id;
                                                    $update_view_model->sm_cp_id = $sm_cp_id;
                                                    $update_view_model->created_on = date('Y-m-d H:i:s');
                                                    $update_view_model->save();
                                                }


                                                //send notification code to be added here
                                                $seen_post_model = CpCustomersFlats::findOne(['id' => $get_post_id]);
                                                $get_user = $seen_post_model->sm_cp_id;
                                                $get_smcp = SmCp::findOne(['sm_cp_id' => $get_user]);

                                                $message = array();
                                                $msg_body = 'Someone has seen your posting ' . $seen_post_model->title;
                                                if (!empty($msg_body)) {

                                                    //send notification
                                                    $message['title'] = 'CP Connect Posting Update';
                                                    $message['body'] = $msg_body;
                                                    $message['link'] = '';
                                                    $info = array();
                                                    $info['type'] = 'cpconnect';
                                                    $info['id'] = $get_post_id;

                                                    //add entry in notification master
                                                    $master_model = new NotificationMaster();
                                                    $master_model->cp_id = $get_smcp->channelpartner_id;
                                                    $master_model->sent_type = 2;
                                                    $master_model->notify_type = 6;
                                                    $master_model->title = $message['title'];
                                                    $master_model->message = $message['body'];
                                                    $master_model->link = $message['link'];
                                                    $master_model->info = json_encode($info);
                                                    $master_model->created_on = date('Y-m-d H:i:s');
                                                    $master_model->save();
                                                }


                                                $data['success']['code'] = 'POSTING_VIEWED_SUCCESSFULLY';
                                                $data['success']['message'] = \Yii::$app->params['POSTING_VIEWED_SUCCESSFULLY'];
                                            } else {
                                                $data['status'] = 2;
                                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                            }
                                        }
                                    } else {
                                        $data['status'] = 2;
                                        $error_data['code'] = 'POSTING_NOT_EXIST';
                                        $error_data['message'] = str_replace("%", $get_my_post_id, \Yii::$app->params['POSTING_NOT_EXIST']);
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    /*  $error_data['code'] = 'POSTING_VIEW_MAX_EXHAUSTED';
                                    $error_data['message'] = \Yii::$app->params['POSTING_VIEW_MAX_EXHAUSTED'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data; */

                                    $package_error['title'] = 'Subscription Error';
                                    $package_error['message'] = \Yii::$app->params['POSTING_VIEW_MAX_EXHAUSTED'];

                                    $package_error['errorType'] = 'subscription_contact_support';
                                    $package_error['supportContact'] = $supportcontact;
                                    //}

                                    $data['subscriptionError'] = $package_error;
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                $data['error'] = $error_data;
                                $update_success = false;
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    }
                } else {
                    $data['status'] = 2;


                    //show error message
                    $package_error['title'] = 'Subscription Error';
                    $package_error['message'] = \Yii::$app->params['UPGRADE_PACKAGE'];
                    /*  if (!empty($get_rm_name)) {
                        $package_error['errorType'] = 'subscription_renew';
                        $package_error['rmName'] = $get_rm_name;
                        $package_error['rmContact'] = $get_rm_contact;
                    } else { */
                    $package_error['errorType'] = 'subscription_contact_support';
                    $package_error['supportContact'] = $supportcontact;
                    //}

                    $data['subscriptionError'] = $package_error;
                    //Yii::$app->response->statusCode = 450;

                    /* $error_data['code'] = 'UPGRADE_PACKAGE';
                    $error_data['message'] = \Yii::$app->params['UPGRADE_PACKAGE'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data; */
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while mark view post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while mark view post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while mark view post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while mark view post data " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            if (!empty($id)) {

                $post_data = CpCustomersFlats::find()->where('id="' . $id . '" ')->one();

                if (!empty($post_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;
                        $show_post = "1";

                        $get_post_smcp_id = $post_data->sm_cp_id;

                        $get_members = $common_model->getaccessmembers($get_post_smcp_id);

                        $final_view = 1;
                        if (isset($_REQUEST['type'])) {
                            $get_type = $_REQUEST['type'];
                            if ($get_type == 1) {
                                $final_view = 1;
                            } else if ($get_type == 2) {
                                $final_view = 3;
                            } else if ($get_type == 3) {
                                $final_view = 4;    //3 is for bookmark
                            }
                        }

                        $my_post_id = "";
                        if (isset($_REQUEST['my_post_id'])) {
                            $my_post_id = $_REQUEST['my_post_id'];
                        }

                        //Don't show own post to team
                        /* if ($get_post_smcp_id == $sm_cp_id) {
                            $show_post = "";
                        }
                        if (!empty($get_members)) {
                            if (in_array($sm_cp_id, $get_members)) {
                                $show_post = "";
                            }
                        } */

                        $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                        $app_features = 0;
                        if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                            $app_features = $get_cp_data->app_features;
                        }

                        if (empty($cp_id) || empty($show_post) || $app_features != 1) {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                            //$update_success = false;
                        } else {

                            //add view entry in table
                            //also show if viewed or not

                            $data['success']['code'] = 'POSTING_DETAIL_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['POSTING_DETAIL_DISPLAYED_SUCCESSFULLY'];
                            $get_post_details = $common_model->getpost($id, $post_data, false);
                            $data['data'] = $get_post_details;

                            $data['data']['post']['spam'] = null;
                            //show if it is marked as spam...pending here
                            $spamview_data = CpCustomersFlatsSpam::find()->where('post_id="' . $id . '" AND sm_cp_id="' . $sm_cp_id . '" ')->one();
                            if (!empty($spamview_data)) {
                                $data['data']['post']['spam'] = true;
                            }

                            $my_post_sql = "";
                            if (!empty($my_post_id)) {
                                $my_post_sql = " AND my_post_id='" . $my_post_id . "'";
                            }

                            $flatview_data = CpCustomersFlatsView::find()->where('post_id="' . $id . '" AND sm_cp_id="' . $sm_cp_id . '" ' . $my_post_sql)->orderBy(['created_on' => SORT_DESC])->one();
                            $data['data']['post']['viewed'] = false;
                            $data['data']['post']['last_viewed'] = null;

                            if (!empty($flatview_data)) {
                                $get_created = $flatview_data->created_on;
                                $get_created = date("Y-m-d", strtotime($get_created));
                                $data['data']['post']['viewed'] = true;
                                $data['data']['post']['last_viewed'] = $flatview_data->created_on;
                                //$data['data']['post']['contacted'] = true;
                            } else {
                                //add entry in view table
                                /* $post_view_model = new CpCustomersFlatsView();
                                $post_view_model->sm_cp_id = $sm_cp_id;
                                if (!empty($my_post_id)) {
                                    $post_view_model->my_post_id = $my_post_id;
                                }
                                $post_view_model->post_id = $id;
                                $post_view_model->view_type = $final_view;
                                $post_view_model->created_on = date('Y-m-d H:i:s');
                                $post_view_model->save(); */
                                //$data['data']['post']['contacted'] = false;
                            }

                            /* if (empty($flatview_data) || ($get_created != date('Y-m-d'))) {
                                $flatviewmodel = new CpCustomersFlatsView();
                                $flatviewmodel->post_id = $id;
                                $flatviewmodel->sm_cp_id = $sm_cp_id;
                                $flatviewmodel->created_on = date('Y-m-d H:i:s');
                                $flatviewmodel->save();
                            } else {
                                $data['data']['post']['viewed'] = "1";
                                $data['data']['post']['last_viewed'] = $flatview_data->created_on;
                            } */
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'POSTING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['POSTING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting posting detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionStats()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                $app_features = 0;
                if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                    $app_features = $get_cp_data->app_features;
                }

                $querydata = $this->request->get();
                $post_for = 1;
                if (!empty($querydata)) {

                    $post_for = (!empty($querydata['post_for']) ? trim($querydata['post_for']) : 1);
                }

                if (empty($cp_id) || $app_features != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    //$update_success = false;
                } else {


                    $common_model = new Common();

                    $data['success']['code'] = 'POSTING_STATS_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['POSTING_STATS_DISPLAYED_SUCCESSFULLY'];
                    $get_post_stats = $common_model->getpoststatsapi($sm_cp_id, $post_for);
                    $data['data'] = $get_post_stats;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionSpam()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($this->request->post())) {

                    $formdata['CpCustomersFlatsSpam'] = $this->request->post();

                    if (!empty($formdata['CpCustomersFlatsSpam'])) {

                        $post_id = $formdata['CpCustomersFlatsSpam']['post_id'];
                        $message = "";
                        if (!empty($formdata['CpCustomersFlatsSpam']['message'])) {
                            $message = $formdata['CpCustomersFlatsSpam']['message'];
                        }

                        $post_data = CpCustomersFlats::find()->where('id="' . $post_id . '" ')->one();

                        if (!empty($post_data)) {
                            $show_post = "1";
                            $get_post_smcp_id = $post_data->sm_cp_id;

                            $get_members = $common_model->getaccessmembers($get_post_smcp_id);

                            if ($get_post_smcp_id == $sm_cp_id) {
                                $show_post = "";
                            }
                            if (!empty($get_members)) {
                                if (in_array($sm_cp_id, $get_members)) {
                                    $show_post = "";
                                }
                            }

                            $get_cp_data = Channelpartner::find()->where(['id' => $cp_id])->one();
                            $app_features = 0;
                            if (isset($get_cp_data->app_features) && !empty($get_cp_data->app_features)) {
                                $app_features = $get_cp_data->app_features;
                            }

                            if (empty($cp_id) || empty($show_post) || $app_features != 1) {
                                $data['status'] = 2;
                                $error_data['code'] = 'MEMBER_NO_ACCESS';
                                $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                //$update_success = false;
                            } else {

                                //add view entry in table
                                //also show if viewed or not

                                $data['success']['code'] = 'POSTING_DETAIL_MARKED_SPAM_SUCCESSFULLY';
                                $data['success']['message'] = \Yii::$app->params['POSTING_DETAIL_MARKED_SPAM_SUCCESSFULLY'];

                                $spamview_data = CpCustomersFlatsSpam::find()->where('post_id="' . $post_id . '" AND sm_cp_id="' . $sm_cp_id . '" ')->orderBy(['created_on' => SORT_DESC])->one();

                                if (empty($spamview_data)) {
                                    $spamviewmodel = new CpCustomersFlatsSpam();
                                    $spamviewmodel->post_id = $post_id;
                                    $spamviewmodel->message = $message;
                                    $spamviewmodel->sm_cp_id = $sm_cp_id;
                                    $spamviewmodel->created_on = date('Y-m-d H:i:s');
                                    $spamviewmodel->save();
                                }
                            }
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'POSTING_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $post_id, \Yii::$app->params['POSTING_NOT_EXIST']);
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $update_success = false;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while marking posting as spam";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while marking posting as spam";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while marking posting as spam";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while marking posting as spam";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}
