<?php

namespace app\modules\api\controllers;

use app\models\Common;
use app\models\Location;
use app\models\ReportOffers;
use app\models\SmCp;
use app\models\SmCpNetwork;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class MarketingController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'list' => ['GET'],
                        'connect' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['list', 'connect'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }

    public function actionConnect()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($this->request->post())) {
                    $formdata['SmCpNetwork'] = $this->request->post();

                    //check if sm_cp_id received is of team leader.
                    /* $get_sm_data = SmCp::findOne(['sm_cp_id' => $formdata['SmCpNetwork']['sm_cp_id']]);
                    if (!empty($get_sm_data)) {
                        $get_sm_data_role = $get_sm_data->role;
                        $get_sm_data_builder = $get_sm_data->builder_id;
                        if ($get_sm_data_role != 1) {
                            $get_sm_data_builder_data = SmCp::findOne(['builder_id' => $get_sm_data_builder, 'role' => 1, 'status' => 1]);
                            if (!empty($get_sm_data_builder_data)) {
                                $formdata['SmCpNetwork']['sm_cp_id'] = $get_sm_data_builder_data->sm_cp_id;
                            }
                        }
                    } */


                    //save offer clicks in table



                    if (!empty($cp_id)) {
                        $offer_id = null;
                        $project_id = null;
                        if (!empty($formdata['SmCpNetwork']['offer_id'])) {
                            $offer_id = $formdata['SmCpNetwork']['offer_id'];
                        }
                        if (!empty($formdata['SmCpNetwork']['project_id'])) {
                            $project_id = $formdata['SmCpNetwork']['project_id'];
                        }
                        $type = $formdata['SmCpNetwork']['type'];
                        if ($type == 1) {
                            $click_type = 2;
                        } else if ($type == 2) {
                            $click_type = 3;
                        } else {
                            $click_type = 2;
                        }
                        $report_offer_model = new ReportOffers();
                        $report_offer_model->sm_cp_id = $sm_cp_id;
                        $report_offer_model->cp_id = $cp_id;
                        $report_offer_model->offer_id = $offer_id;
                        $report_offer_model->project_id = $project_id;
                        $report_offer_model->click_type = $click_type;
                        $report_offer_model->created_on = date('Y-m-d H:i:s');
                        $report_offer_model->save();
                    }


                    $network_model = SmCpNetwork::findOne(['sm_cp_id' => $formdata['SmCpNetwork']['sm_cp_id'], 'channelpartner_id' => $cp_id]);
                    /* echo "<pre>";
                    var_dump($network_model);
                    exit; */
                    if (!empty($network_model)) {
                        $data['status'] = 2;
                        if ($network_model->status == 3) {
                            $error_data['code'] = 'CP_NETWORK_ALREADY_REQUESTED';
                        } else if ($network_model->status == 4) {
                            $error_data['code'] = 'CP_NETWORK_ALREADY_REQUESTED';
                        } else {
                            $error_data['code'] = 'CP_NETWORK_ALREADY_EXIST';
                        }

                        $error_data['message'] = \Yii::$app->params[$error_data['code']];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    } else {

                        $formdata['SmCpNetwork']['channelpartner_id'] = $cp_id;
                        if (
                            empty($formdata['SmCpNetwork']['sm_cp_id'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {
                            $formdata['SmCpNetwork']['request_sent'] = date('Y-m-d H:i:s');
                            $formdata['SmCpNetwork']['created_by'] = $sm_cp_id;
                            $formdata['SmCpNetwork']['status'] = 3;
                            $formdata['SmCpNetwork']['modified_date'] = date('Y-m-d H:i:s');


                            $smcpnetwork_model = new SmCpNetwork();


                            if ($smcpnetwork_model->load($formdata)) {
                                if ($smcpnetwork_model->save()) {

                                    $common_model = new Common();
                                    $data['success']['code'] = 'CONNECTION_REQUEST_SENT_SUCCESSFULLY';
                                    $data['success']['message'] = \Yii::$app->params['CONNECTION_REQUEST_SENT_SUCCESSFULLY'];
                                } else {

                                    $formerrordata['post_data'] = "error while adding cp sm connection from marketing " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($smcpnetwork_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            } else {
                                $formerrordata['post_data'] = "error while adding cp sm connection from marketing " . json_encode($formdata);
                                $formerrordata['error'] = json_encode($smcpnetwork_model->getErrors());
                                Yii::$app->common->addlog($formerrordata);

                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                                Yii::$app->response->statusCode = 500;
                            }
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while adding cp sm connection from marketing";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while adding cp sm connection from marketing";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while adding cp sm connection from marketing";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while adding cp sm connection from marketing";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                $querydata = $this->request->get();

                $data['success']['code'] = 'MARKETING_ITEMS_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['MARKETING_ITEMS_DISPLAYED_SUCCESSFULLY'];

                $get_market_list = $common_model->getmarketlistapi($get_user, $querydata);
                $data['data'] = $get_market_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}